#include "imageobj.h"

/////////////////////////////////////////////////////////////////
// ImageObj
/////////////////////////////////////////////////////////////////
ImageObj::ImageObj( QCanvas *canvas )
    : QCanvasRectangle( canvas )
{
//	cout << "Const ImageObj (canvas)\n";
    setZ(Z_ICON);	
	type=undef;
}

ImageObj::~ImageObj()
{
//   cout << "Destr ImageObj\n";
}

void ImageObj::copy(ImageObj* other)
{
	setSize (other->width(), other->height() );
	setVisibility (other->isVisible() );
	type=other->type;
//	if (type==qimage)
		image=other->image;
//	if (type==qpixmap)
		pixmap=other->pixmap;
}

void ImageObj::setVisibility (bool v)
{
	if (v)	
		show();
	else
		hide();
}

void ImageObj::save(const QString &fn, const char *format)
{
	switch (type)
	{
		case undef: qWarning("Warning: ImageObj::save() type=undef");break;
		case qimage: image.save (fn,format,-1);break;
		case qpixmap: pixmap.save (fn,format,-1);break;
	}
}

bool ImageObj::load (const QString &fn)
{
	if (!image.load( fn) )
		//cout << "Fatal Error in ImageObj::load ("<<fn<<")\n";
		return false;
    setSize( image.width(), image.height() );
	type=qimage;

#if !defined(Q_WS_QWS)
    pixmap.convertFromImage(image, OrderedAlphaDither);
#endif
	return true;
}

bool ImageObj::load (QPixmap pm)
{
#if !defined(Q_WS_QWS)
    //pixmap.convertFromImage(image, OrderedAlphaDither);
	type=qpixmap;
	pixmap=pm;
    setSize( pm.width(), pm.height() );
#else
	type=qimage;
	image=pm;
    setSize( image.width(), image.height() );
#endif
	return true;
}

void ImageObj::setImage(QImage img)
{
	type=qimage;
	image=img;
    pixmap.convertFromImage(image, OrderedAlphaDither);
}

QPixmap ImageObj::getPixmap()
{
	return pixmap;
}

void ImageObj::drawShape( QPainter &p )
{
// On Qt/Embedded, we can paint a QImage as fast as a QPixmap,
// but on other platforms, we need to use a QPixmap.
#if defined(Q_WS_QWS)
    p.drawImage( int(x()), int(y()), image, 0, 0, -1, -1, OrderedAlphaDither );
#else
    p.drawPixmap( int(x()), int(y()), pixmap );
#endif
}


