package org.apache.maven.wagon.providers.ssh;

/*
 * Copyright 2001-2005 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import org.codehaus.plexus.util.FileUtils;

import java.io.File;
import java.io.IOException;

/**
 * @author <a href="michal@codehaus.org">Michal Maczka</a>
 * @version $Id: TestData.java 485711 2006-12-11 15:27:47Z joakime $
 */
public class TestData
{
    public static String getTempDirectory()
    {
        return System.getProperty( "java.io.tmpdir", "/tmp" );
    }
    
    public static String getTestRepositoryUrl()
    {
        return "scp://" + getHostname() + getTempDirectory() + "/wagon-ssh-test/" + getUserName();
    }

    public static String getUserName()
    {
        return System.getProperty( "test.user", System.getProperty( "user.name" ) );
    }

    public static File getPrivateKey()
    {
        return new File( System.getProperty( "user.home" ), "/.ssh/id_dsa" );
    }

    public static String getHostname()
    {
        return System.getProperty( "test.host", "localhost" );
    }

    public static String getHostKey()
    {
        try
        {
            return FileUtils.fileRead( "/etc/ssh_host_rsa_key.pub" ).substring( "ssh-rsa".length() ).trim();
        }
        catch ( IOException e )
        {
            return null;
        }
    }
}
