#
# WAJIG - Debian Package Management Front End
#
# Copyright (c) Graham.Williams@csiro.au
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

#------------------------------------------------------------------------
#
# Standard python modules
#
#------------------------------------------------------------------------
import os

setroot = "/bin/su"
if os.path.exists("/usr/bin/sudo"):
    setroot = "/usr/bin/sudo"
    #
    # In case someone is using the non-default install of sudo on
    # Debian (the default install uses a default root path for sudo
    # which includes sbin) or have added this user to the sudo group
    # (which has the effect of also using the user's path rather than
    # the root path), add the sbin directories to the PATH.
    #
    os.environ['PATH'] = os.environ['PATH'] + ":/sbin:/usr/sbin"

#------------------------------------------------------------------------
#
# Interface Variables
#
#------------------------------------------------------------------------

quiet = ""

def set_quiet():
    quiet = "> /dev/null"

teaching = 0

def set_teaching_level(new_level):
    global teaching
    teaching = new_level

#------------------------------------------------------------------------
#
# concat
#
#------------------------------------------------------------------------
def concat(args):
    result = ""
    for a in args:
        result = result + "'" + a + "' "
    return result

#------------------------------------------------------------------------
#
# EXECUTE
#
#------------------------------------------------------------------------
def execute(command, root=0, noquiet=0):
    """Ask the operating system to perform the command

    Arguments:
    command	A string containing the command and command line options
    root	If non-zero then root access is required to execute command
    noquiet	Suppress the use of quiet (in case command has a redirect)

    Returns:
    Return status of the command"""

    if teaching > 0: print "Performing: " + command
    if root > 0:
	if setroot == "/usr/bin/sudo":
 	    command = setroot + " " + command
        else:
	    if quiet == "":
		print """
Using `su' but please consider installing `sudo' which is more secure.
With `sudo' users type their own password and do not need to know the
root password. Also, the password is remembered for a short while so
that you won't be asked for it again while interacting with wajig.
Have a look at the wajig documentation (wajig doc) for a quick guide
to configuring /etc/sudoers.
"""
            command = setroot + " -c \"" + command + "\""
    if noquiet > 0:
      command = command
    else:
      command = command + quiet
    command = "LC_ALL=C; export LC_ALL; set -o noglob; " + command
    return os.system(command)

