/* $Workfile: GTYPES.H $  $Date: 1/22/98 2:57p $  Copyright (C) 1996, 97, 98 by jbm Electronics, Inc.



                              REVISION HISTORY

ͻ
   WHEN    WHO                             WHAT                           
͹
 10/31/95  afs  Added BOOL type so Borlanders can use code from the OS/2  
                world.                                                    
Ķ
  2/16/96  afs  Fixed a DOS related bug in the definition of the BOOL     
                typedef.                                                  
Ķ
  3/18/96  jld  Fixed 'DOSisms' for far, huge, etc.                       
Ķ
  6/11/96  mlp  Added PSZ def as per Art suggest.                         
Ķ
   3/6/97  afs  Added a union of SHORT to BYTES, and LONG to BYTES.       
Ķ
  10/8/97  afs  Reversed the order of the components in unions uBORS &    
                uBORL so that that initializers don't have to be for the  
                byte arrays.                                              
Ķ
  1/16/98  afs  Removed BOOLEAN as it is (and should be) unused.  Made    
                BOOL an int type instead of a long in the interest of     
                efficiency.                                               
Ķ
  1/19/98  afs  Added section for Microchip 'PIC' microcontrollers for    
                use with the CCS PIC C compiler.                          
ͼ  */



#ifndef  __GTYPES_H
 #define __GTYPES_H

 /*------------------------------------------------------------------------*\
 |                                                                          |
 |  A 'BYTE'  is  8 bits.                                                   |
 |  A 'SHORT' is 16 bits.                                                   |
 |  A 'LONG'  is 32 bits.                                                   |
 |                                                                          |
 |  A 'WORD'  is any number of bits, 'the most efficient' and/or 'natural'  |
 |            representation of an int value for a given compiler/hardware  |
 |            platform.                                                     |
 |                                                                          |
 | So use BYTE, SHORT or LONG when you must, when you need a type whose     |
 | size matters.  Use WORD when you can.  These types won't solve your      |
 | "big endian/little endian" problems, but the unions uBORS and uBORL can  |
 | help.                                                                    |
 |                                                                          |
 \*------------------------------------------------------------------------*/


 #ifdef OS2

  #define far   // OS/2 don't need far.
  #define _FAR  // OS/2 don't need _FAR.
  #define huge  // OS/2 don't need huge.

 #endif


 #ifndef __BCPLUSPLUS__
  #ifndef PIC

  #define far   // OS/2 don't need far.
  #define _FAR  // OS/2 don't need _FAR.
  #define huge  // OS/2 don't need huge.

  #endif
 #endif


 #ifndef OS2
  #ifndef PIC

   typedef char *            PSZ;
   typedef unsigned char   UCHAR;
   typedef unsigned short   UINT;

   typedef long LONG;

   typedef short SHORT;

   #define FP_NORM(abnormal_ptr) MK_FP(FP_SEG(abnormal_ptr)+(FP_OFF(abnormal_ptr)>>4),    FP_OFF(abnormal_ptr)&0xf)

  #endif
 #endif


 #ifdef PIC

  typedef unsigned       UBYTE;
  typedef   signed       SBYTE;
  typedef unsigned        BYTE;

  typedef          long  UWORD;
  typedef   signed long  SWORD;
  typedef          long  WORD;

  typedef          long  ULONG;
  typedef   signed long  SLONG;
  typedef          long   LONG;

  typedef          int  USHORT;
  typedef   signed int  SSHORT;
  typedef          int   SHORT;

  typedef float           REAL;

  typedef         short    BIT;

 #else

  typedef unsigned char     UBYTE;
  typedef   signed char     SBYTE;
  typedef          char      BYTE;

  typedef unsigned char * USTRPTR;
  typedef   signed char * SSTRPTR;
  typedef          char *  STRPTR;

  typedef unsigned int      UWORD;
  typedef   signed int      SWORD;
  typedef          int       WORD;

  typedef unsigned long     ULONG;
  typedef   signed long     SLONG;

  typedef unsigned short   USHORT;
  typedef   signed short   SSHORT;

  typedef float              REAL;

  typedef unsigned            BIT;

 #endif


 #ifndef OS2

   typedef int BOOL;

   #define TRUE  1
   #define FALSE 0

 #endif


 union uBORL  // It's a long, it's 4 bytes, it's a long . . . it's both!
      {
       ULONG  ul_asulong;
       UBYTE  ucA1_asbyte[sizeof(ULONG)];
      };

 union uBORS  // It's a short, it's 2 bytes, it's a short . . . it's both!
      {
       USHORT  us_asushort;
       UBYTE   ucA1_asbyte[sizeof(USHORT)];
      };


#endif // __GTYPES_H























