<?php
/**************************************************************************
* This file is part of the WebIssues Server program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

require_once( 'common.inc.php' );

define( 'SCRIPT', 'index.php' );

$page_titles = array(
    'config' => 'Configuration',
    'tables' => 'Data Tables'
);

$action = $_POST[ 'action' ];
$page = '';
$body = '';
$title = '';

$result = wi_check_status();

function wi_check_status()
{
    global $page, $body, $title;
    global $config;

    $page = 'config';

    if ( !wi_check_config() )
        return false;

    $page = 'tables';

    if ( !wi_table_exists( 'server' ) ) {
        $body .= "<p><strong>ERROR:</strong> The data tables were not found in the database.</p>\n";
        return false;
    }

    $query = "SELECT server_name, db_version FROM {server}";

    $server_row = wi_query_row( $query );

    $db_version = $server_row[ 'db_version' ];

    if ( version_compare( $db_version, VERSION, '>' ) ) {
        $body .= "<p><strong>ERROR:</strong> Current database version ($db_version) is newer than the server.</p>\n";
        return false;
    }

    if ( version_compare( $db_version, VERSION, '<' ) ) {
        $body .= "<p><strong>ERROR:</strong> Current database version ($db_version) is older than the server.</p>\n";
        return false;
    }

    $title = $server_row[ 'server_name' ];

    $page = '';

    $body .= "<p>This server is configured and working correctly.</p>\n";
    $body .= "<p>Use the WebIssues Client application to access the server.</p>\n";

    return true;
}

require_once( 'wizard.inc.php' );
