// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// entry_points_gles_3_2_autogen.cpp:
//   Defines the GLES 3.2 entry points.

#include "libGLESv2/entry_points_gles_3_2_autogen.h"

#include "common/entry_points_enum_autogen.h"
#include "libANGLE/Context.h"
#include "libANGLE/Context.inl.h"
#include "libANGLE/capture_gles_3_2_autogen.h"
#include "libANGLE/entry_points_utils.h"
#include "libANGLE/gl_enum_utils.h"
#include "libANGLE/validationES32.h"
#include "libGLESv2/global_state.h"

namespace gl
{
void GL_APIENTRY BlendBarrier()
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::BlendBarrier, "glBlendBarrier", "context = %d", CID(context));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateBlendBarrier(context));
        if (isCallValid)
        {
            context->blendBarrier();
        }
        ANGLE_CAPTURE(BlendBarrier, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY BlendEquationSeparatei(GLuint buf, GLenum modeRGB, GLenum modeAlpha)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::BlendEquationSeparatei, "glBlendEquationSeparatei",
          "context = %d, buf = %u, modeRGB = %s, modeAlpha = %s", CID(context), buf,
          GLenumToString(GLenumGroup::BlendEquationModeEXT, modeRGB),
          GLenumToString(GLenumGroup::BlendEquationModeEXT, modeAlpha));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBlendEquationSeparatei(context, buf, modeRGB, modeAlpha));
        if (isCallValid)
        {
            context->blendEquationSeparatei(buf, modeRGB, modeAlpha);
        }
        ANGLE_CAPTURE(BlendEquationSeparatei, isCallValid, context, buf, modeRGB, modeAlpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY BlendEquationi(GLuint buf, GLenum mode)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::BlendEquationi, "glBlendEquationi",
          "context = %d, buf = %u, mode = %s", CID(context), buf,
          GLenumToString(GLenumGroup::BlendEquationModeEXT, mode));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBlendEquationi(context, buf, mode));
        if (isCallValid)
        {
            context->blendEquationi(buf, mode);
        }
        ANGLE_CAPTURE(BlendEquationi, isCallValid, context, buf, mode);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY
BlendFuncSeparatei(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::BlendFuncSeparatei, "glBlendFuncSeparatei",
          "context = %d, buf = %u, srcRGB = %s, dstRGB = %s, srcAlpha = %s, dstAlpha = %s",
          CID(context), buf, GLenumToString(GLenumGroup::BlendingFactor, srcRGB),
          GLenumToString(GLenumGroup::BlendingFactor, dstRGB),
          GLenumToString(GLenumGroup::BlendingFactor, srcAlpha),
          GLenumToString(GLenumGroup::BlendingFactor, dstAlpha));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateBlendFuncSeparatei(context, buf, srcRGB, dstRGB, srcAlpha, dstAlpha));
        if (isCallValid)
        {
            context->blendFuncSeparatei(buf, srcRGB, dstRGB, srcAlpha, dstAlpha);
        }
        ANGLE_CAPTURE(BlendFuncSeparatei, isCallValid, context, buf, srcRGB, dstRGB, srcAlpha,
                      dstAlpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY BlendFunci(GLuint buf, GLenum src, GLenum dst)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::BlendFunci, "glBlendFunci",
          "context = %d, buf = %u, src = %s, dst = %s", CID(context), buf,
          GLenumToString(GLenumGroup::BlendingFactor, src),
          GLenumToString(GLenumGroup::BlendingFactor, dst));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBlendFunci(context, buf, src, dst));
        if (isCallValid)
        {
            context->blendFunci(buf, src, dst);
        }
        ANGLE_CAPTURE(BlendFunci, isCallValid, context, buf, src, dst);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ColorMaski(GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ColorMaski, "glColorMaski",
          "context = %d, index = %u, r = %s, g = %s, b = %s, a = %s", CID(context), index,
          GLbooleanToString(r), GLbooleanToString(g), GLbooleanToString(b), GLbooleanToString(a));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateColorMaski(context, index, r, g, b, a));
        if (isCallValid)
        {
            context->colorMaski(index, r, g, b, a);
        }
        ANGLE_CAPTURE(ColorMaski, isCallValid, context, index, r, g, b, a);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY CopyImageSubData(GLuint srcName,
                                  GLenum srcTarget,
                                  GLint srcLevel,
                                  GLint srcX,
                                  GLint srcY,
                                  GLint srcZ,
                                  GLuint dstName,
                                  GLenum dstTarget,
                                  GLint dstLevel,
                                  GLint dstX,
                                  GLint dstY,
                                  GLint dstZ,
                                  GLsizei srcWidth,
                                  GLsizei srcHeight,
                                  GLsizei srcDepth)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::CopyImageSubData, "glCopyImageSubData",
          "context = %d, srcName = %u, srcTarget = %s, srcLevel = %d, srcX = %d, srcY = %d, srcZ = "
          "%d, dstName = %u, dstTarget = %s, dstLevel = %d, dstX = %d, dstY = %d, dstZ = %d, "
          "srcWidth = %d, srcHeight = %d, srcDepth = %d",
          CID(context), srcName, GLenumToString(GLenumGroup::CopyBufferSubDataTarget, srcTarget),
          srcLevel, srcX, srcY, srcZ, dstName,
          GLenumToString(GLenumGroup::CopyBufferSubDataTarget, dstTarget), dstLevel, dstX, dstY,
          dstZ, srcWidth, srcHeight, srcDepth);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateCopyImageSubData(context, srcName, srcTarget, srcLevel, srcX,
                                                     srcY, srcZ, dstName, dstTarget, dstLevel, dstX,
                                                     dstY, dstZ, srcWidth, srcHeight, srcDepth));
        if (isCallValid)
        {
            context->copyImageSubData(srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName,
                                      dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight,
                                      srcDepth);
        }
        ANGLE_CAPTURE(CopyImageSubData, isCallValid, context, srcName, srcTarget, srcLevel, srcX,
                      srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth,
                      srcHeight, srcDepth);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY DebugMessageCallback(GLDEBUGPROC callback, const void *userParam)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::DebugMessageCallback, "glDebugMessageCallback",
          "context = %d, callback = 0x%016" PRIxPTR ", userParam = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)callback, (uintptr_t)userParam);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDebugMessageCallback(context, callback, userParam));
        if (isCallValid)
        {
            context->debugMessageCallback(callback, userParam);
        }
        ANGLE_CAPTURE(DebugMessageCallback, isCallValid, context, callback, userParam);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY DebugMessageControl(GLenum source,
                                     GLenum type,
                                     GLenum severity,
                                     GLsizei count,
                                     const GLuint *ids,
                                     GLboolean enabled)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::DebugMessageControl, "glDebugMessageControl",
          "context = %d, source = %s, type = %s, severity = %s, count = %d, ids = 0x%016" PRIxPTR
          ", enabled = %s",
          CID(context), GLenumToString(GLenumGroup::DebugSource, source),
          GLenumToString(GLenumGroup::DebugType, type),
          GLenumToString(GLenumGroup::DebugSeverity, severity), count, (uintptr_t)ids,
          GLbooleanToString(enabled));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDebugMessageControl(context, source, type, severity, count, ids, enabled));
        if (isCallValid)
        {
            context->debugMessageControl(source, type, severity, count, ids, enabled);
        }
        ANGLE_CAPTURE(DebugMessageControl, isCallValid, context, source, type, severity, count, ids,
                      enabled);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY DebugMessageInsert(GLenum source,
                                    GLenum type,
                                    GLuint id,
                                    GLenum severity,
                                    GLsizei length,
                                    const GLchar *buf)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::DebugMessageInsert, "glDebugMessageInsert",
          "context = %d, source = %s, type = %s, id = %u, severity = %s, length = %d, buf = "
          "0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DebugSource, source),
          GLenumToString(GLenumGroup::DebugType, type), id,
          GLenumToString(GLenumGroup::DebugSeverity, severity), length, (uintptr_t)buf);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDebugMessageInsert(context, source, type, id, severity, length, buf));
        if (isCallValid)
        {
            context->debugMessageInsert(source, type, id, severity, length, buf);
        }
        ANGLE_CAPTURE(DebugMessageInsert, isCallValid, context, source, type, id, severity, length,
                      buf);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Disablei(GLenum target, GLuint index)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Disablei, "glDisablei", "context = %d, target = %s, index = %u",
          CID(context), GLenumToString(GLenumGroup::EnableCap, target), index);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDisablei(context, target, index));
        if (isCallValid)
        {
            context->disablei(target, index);
        }
        ANGLE_CAPTURE(Disablei, isCallValid, context, target, index);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY DrawElementsBaseVertex(GLenum mode,
                                        GLsizei count,
                                        GLenum type,
                                        const void *indices,
                                        GLint basevertex)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::DrawElementsBaseVertex, "glDrawElementsBaseVertex",
          "context = %d, mode = %s, count = %d, type = %s, indices = 0x%016" PRIxPTR
          ", basevertex = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, basevertex);

    if (context)
    {
        PrimitiveMode modePacked                              = FromGL<PrimitiveMode>(mode);
        DrawElementsType typePacked                           = FromGL<DrawElementsType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDrawElementsBaseVertex(context, modePacked, count, typePacked,
                                                           indices, basevertex));
        if (isCallValid)
        {
            context->drawElementsBaseVertex(modePacked, count, typePacked, indices, basevertex);
        }
        ANGLE_CAPTURE(DrawElementsBaseVertex, isCallValid, context, modePacked, count, typePacked,
                      indices, basevertex);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY DrawElementsInstancedBaseVertex(GLenum mode,
                                                 GLsizei count,
                                                 GLenum type,
                                                 const void *indices,
                                                 GLsizei instancecount,
                                                 GLint basevertex)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::DrawElementsInstancedBaseVertex,
          "glDrawElementsInstancedBaseVertex",
          "context = %d, mode = %s, count = %d, type = %s, indices = 0x%016" PRIxPTR
          ", instancecount = %d, basevertex = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, instancecount,
          basevertex);

    if (context)
    {
        PrimitiveMode modePacked                              = FromGL<PrimitiveMode>(mode);
        DrawElementsType typePacked                           = FromGL<DrawElementsType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawElementsInstancedBaseVertex(
                                                             context, modePacked, count, typePacked,
                                                             indices, instancecount, basevertex));
        if (isCallValid)
        {
            context->drawElementsInstancedBaseVertex(modePacked, count, typePacked, indices,
                                                     instancecount, basevertex);
        }
        ANGLE_CAPTURE(DrawElementsInstancedBaseVertex, isCallValid, context, modePacked, count,
                      typePacked, indices, instancecount, basevertex);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY DrawRangeElementsBaseVertex(GLenum mode,
                                             GLuint start,
                                             GLuint end,
                                             GLsizei count,
                                             GLenum type,
                                             const void *indices,
                                             GLint basevertex)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::DrawRangeElementsBaseVertex, "glDrawRangeElementsBaseVertex",
          "context = %d, mode = %s, start = %u, end = %u, count = %d, type = %s, indices = "
          "0x%016" PRIxPTR ", basevertex = %d",
          CID(context), GLenumToString(GLenumGroup::PrimitiveType, mode), start, end, count,
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indices, basevertex);

    if (context)
    {
        PrimitiveMode modePacked                              = FromGL<PrimitiveMode>(mode);
        DrawElementsType typePacked                           = FromGL<DrawElementsType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawRangeElementsBaseVertex(
                                                             context, modePacked, start, end, count,
                                                             typePacked, indices, basevertex));
        if (isCallValid)
        {
            context->drawRangeElementsBaseVertex(modePacked, start, end, count, typePacked, indices,
                                                 basevertex);
        }
        ANGLE_CAPTURE(DrawRangeElementsBaseVertex, isCallValid, context, modePacked, start, end,
                      count, typePacked, indices, basevertex);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Enablei(GLenum target, GLuint index)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Enablei, "glEnablei", "context = %d, target = %s, index = %u",
          CID(context), GLenumToString(GLenumGroup::EnableCap, target), index);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateEnablei(context, target, index));
        if (isCallValid)
        {
            context->enablei(target, index);
        }
        ANGLE_CAPTURE(Enablei, isCallValid, context, target, index);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY FramebufferTexture(GLenum target, GLenum attachment, GLuint texture, GLint level)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::FramebufferTexture, "glFramebufferTexture",
          "context = %d, target = %s, attachment = %s, texture = %u, level = %d", CID(context),
          GLenumToString(GLenumGroup::FramebufferTarget, target),
          GLenumToString(GLenumGroup::FramebufferAttachment, attachment), texture, level);

    if (context)
    {
        TextureID texturePacked                               = FromGL<TextureID>(texture);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateFramebufferTexture(context, target, attachment, texturePacked, level));
        if (isCallValid)
        {
            context->framebufferTexture(target, attachment, texturePacked, level);
        }
        ANGLE_CAPTURE(FramebufferTexture, isCallValid, context, target, attachment, texturePacked,
                      level);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

GLuint GL_APIENTRY GetDebugMessageLog(GLuint count,
                                      GLsizei bufSize,
                                      GLenum *sources,
                                      GLenum *types,
                                      GLuint *ids,
                                      GLenum *severities,
                                      GLsizei *lengths,
                                      GLchar *messageLog)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetDebugMessageLog, "glGetDebugMessageLog",
          "context = %d, count = %u, bufSize = %d, sources = 0x%016" PRIxPTR
          ", types = 0x%016" PRIxPTR ", ids = 0x%016" PRIxPTR ", severities = 0x%016" PRIxPTR
          ", lengths = 0x%016" PRIxPTR ", messageLog = 0x%016" PRIxPTR "",
          CID(context), count, bufSize, (uintptr_t)sources, (uintptr_t)types, (uintptr_t)ids,
          (uintptr_t)severities, (uintptr_t)lengths, (uintptr_t)messageLog);

    GLuint returnValue;
    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetDebugMessageLog(context, count, bufSize, sources, types, ids,
                                                       severities, lengths, messageLog));
        if (isCallValid)
        {
            returnValue = context->getDebugMessageLog(count, bufSize, sources, types, ids,
                                                      severities, lengths, messageLog);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::GetDebugMessageLog, GLuint>();
        }
        ANGLE_CAPTURE(GetDebugMessageLog, isCallValid, context, count, bufSize, sources, types, ids,
                      severities, lengths, messageLog, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<EntryPoint::GetDebugMessageLog, GLuint>();
    }
    return returnValue;
}

GLenum GL_APIENTRY GetGraphicsResetStatus()
{
    Context *context = GetGlobalContext();
    EVENT(context, gl::EntryPoint::GetGraphicsResetStatus, "glGetGraphicsResetStatus",
          "context = %d", CID(context));

    GLenum returnValue;
    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateGetGraphicsResetStatus(context));
        if (isCallValid)
        {
            returnValue = context->getGraphicsResetStatus();
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::GetGraphicsResetStatus, GLenum>();
        }
        ANGLE_CAPTURE(GetGraphicsResetStatus, isCallValid, context, returnValue);
    }
    else
    {

        returnValue = GetDefaultReturnValue<EntryPoint::GetGraphicsResetStatus, GLenum>();
    }
    return returnValue;
}

void GL_APIENTRY
GetObjectLabel(GLenum identifier, GLuint name, GLsizei bufSize, GLsizei *length, GLchar *label)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetObjectLabel, "glGetObjectLabel",
          "context = %d, identifier = %s, name = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", label = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, identifier), name, bufSize,
          (uintptr_t)length, (uintptr_t)label);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetObjectLabel(context, identifier, name, bufSize, length, label));
        if (isCallValid)
        {
            context->getObjectLabel(identifier, name, bufSize, length, label);
        }
        ANGLE_CAPTURE(GetObjectLabel, isCallValid, context, identifier, name, bufSize, length,
                      label);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetObjectPtrLabel(const void *ptr, GLsizei bufSize, GLsizei *length, GLchar *label)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetObjectPtrLabel, "glGetObjectPtrLabel",
          "context = %d, ptr = 0x%016" PRIxPTR ", bufSize = %d, length = 0x%016" PRIxPTR
          ", label = 0x%016" PRIxPTR "",
          CID(context), (uintptr_t)ptr, bufSize, (uintptr_t)length, (uintptr_t)label);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetObjectPtrLabel(context, ptr, bufSize, length, label));
        if (isCallValid)
        {
            context->getObjectPtrLabel(ptr, bufSize, length, label);
        }
        ANGLE_CAPTURE(GetObjectPtrLabel, isCallValid, context, ptr, bufSize, length, label);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetPointerv(GLenum pname, void **params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetPointerv, "glGetPointerv",
          "context = %d, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::GetPointervPName, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetPointerv(context, pname, params));
        if (isCallValid)
        {
            context->getPointerv(pname, params);
        }
        ANGLE_CAPTURE(GetPointerv, isCallValid, context, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetSamplerParameterIiv(GLuint sampler, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetSamplerParameterIiv, "glGetSamplerParameterIiv",
          "context = %d, sampler = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname), (uintptr_t)params);

    if (context)
    {
        SamplerID samplerPacked                               = FromGL<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetSamplerParameterIiv(context, samplerPacked, pname, params));
        if (isCallValid)
        {
            context->getSamplerParameterIiv(samplerPacked, pname, params);
        }
        ANGLE_CAPTURE(GetSamplerParameterIiv, isCallValid, context, samplerPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetSamplerParameterIuiv(GLuint sampler, GLenum pname, GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetSamplerParameterIuiv, "glGetSamplerParameterIuiv",
          "context = %d, sampler = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname), (uintptr_t)params);

    if (context)
    {
        SamplerID samplerPacked                               = FromGL<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetSamplerParameterIuiv(context, samplerPacked, pname, params));
        if (isCallValid)
        {
            context->getSamplerParameterIuiv(samplerPacked, pname, params);
        }
        ANGLE_CAPTURE(GetSamplerParameterIuiv, isCallValid, context, samplerPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetTexParameterIiv(GLenum target, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetTexParameterIiv, "glGetTexParameterIiv",
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::GetTextureParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                              = FromGL<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetTexParameterIiv(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getTexParameterIiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetTexParameterIiv, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetTexParameterIuiv(GLenum target, GLenum pname, GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetTexParameterIuiv, "glGetTexParameterIuiv",
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::GetTextureParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                              = FromGL<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetTexParameterIuiv(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->getTexParameterIuiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(GetTexParameterIuiv, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetnUniformfv(GLuint program, GLint location, GLsizei bufSize, GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetnUniformfv, "glGetnUniformfv",
          "context = %d, program = %u, location = %d, bufSize = %d, params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetnUniformfv(context, programPacked, locationPacked, bufSize, params));
        if (isCallValid)
        {
            context->getnUniformfv(programPacked, locationPacked, bufSize, params);
        }
        ANGLE_CAPTURE(GetnUniformfv, isCallValid, context, programPacked, locationPacked, bufSize,
                      params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetnUniformiv(GLuint program, GLint location, GLsizei bufSize, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetnUniformiv, "glGetnUniformiv",
          "context = %d, program = %u, location = %d, bufSize = %d, params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetnUniformiv(context, programPacked, locationPacked, bufSize, params));
        if (isCallValid)
        {
            context->getnUniformiv(programPacked, locationPacked, bufSize, params);
        }
        ANGLE_CAPTURE(GetnUniformiv, isCallValid, context, programPacked, locationPacked, bufSize,
                      params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetnUniformuiv(GLuint program, GLint location, GLsizei bufSize, GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetnUniformuiv, "glGetnUniformuiv",
          "context = %d, program = %u, location = %d, bufSize = %d, params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetnUniformuiv(context, programPacked, locationPacked, bufSize, params));
        if (isCallValid)
        {
            context->getnUniformuiv(programPacked, locationPacked, bufSize, params);
        }
        ANGLE_CAPTURE(GetnUniformuiv, isCallValid, context, programPacked, locationPacked, bufSize,
                      params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

GLboolean GL_APIENTRY IsEnabledi(GLenum target, GLuint index)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::IsEnabledi, "glIsEnabledi",
          "context = %d, target = %s, index = %u", CID(context),
          GLenumToString(GLenumGroup::EnableCap, target), index);

    GLboolean returnValue;
    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsEnabledi(context, target, index));
        if (isCallValid)
        {
            returnValue = context->isEnabledi(target, index);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsEnabledi, GLboolean>();
        }
        ANGLE_CAPTURE(IsEnabledi, isCallValid, context, target, index, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<EntryPoint::IsEnabledi, GLboolean>();
    }
    return returnValue;
}

void GL_APIENTRY MinSampleShading(GLfloat value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::MinSampleShading, "glMinSampleShading",
          "context = %d, value = %f", CID(context), value);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateMinSampleShading(context, value));
        if (isCallValid)
        {
            context->minSampleShading(value);
        }
        ANGLE_CAPTURE(MinSampleShading, isCallValid, context, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ObjectLabel(GLenum identifier, GLuint name, GLsizei length, const GLchar *label)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ObjectLabel, "glObjectLabel",
          "context = %d, identifier = %s, name = %u, length = %d, label = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::ObjectIdentifier, identifier), name, length,
          (uintptr_t)label);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateObjectLabel(context, identifier, name, length, label));
        if (isCallValid)
        {
            context->objectLabel(identifier, name, length, label);
        }
        ANGLE_CAPTURE(ObjectLabel, isCallValid, context, identifier, name, length, label);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ObjectPtrLabel(const void *ptr, GLsizei length, const GLchar *label)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ObjectPtrLabel, "glObjectPtrLabel",
          "context = %d, ptr = 0x%016" PRIxPTR ", length = %d, label = 0x%016" PRIxPTR "",
          CID(context), (uintptr_t)ptr, length, (uintptr_t)label);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateObjectPtrLabel(context, ptr, length, label));
        if (isCallValid)
        {
            context->objectPtrLabel(ptr, length, label);
        }
        ANGLE_CAPTURE(ObjectPtrLabel, isCallValid, context, ptr, length, label);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY PatchParameteri(GLenum pname, GLint value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::PatchParameteri, "glPatchParameteri",
          "context = %d, pname = %s, value = %d", CID(context),
          GLenumToString(GLenumGroup::PatchParameterName, pname), value);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidatePatchParameteri(context, pname, value));
        if (isCallValid)
        {
            context->patchParameteri(pname, value);
        }
        ANGLE_CAPTURE(PatchParameteri, isCallValid, context, pname, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY PopDebugGroup()
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::PopDebugGroup, "glPopDebugGroup", "context = %d", CID(context));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidatePopDebugGroup(context));
        if (isCallValid)
        {
            context->popDebugGroup();
        }
        ANGLE_CAPTURE(PopDebugGroup, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY PrimitiveBoundingBox(GLfloat minX,
                                      GLfloat minY,
                                      GLfloat minZ,
                                      GLfloat minW,
                                      GLfloat maxX,
                                      GLfloat maxY,
                                      GLfloat maxZ,
                                      GLfloat maxW)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::PrimitiveBoundingBox, "glPrimitiveBoundingBox",
          "context = %d, minX = %f, minY = %f, minZ = %f, minW = %f, maxX = %f, maxY = %f, maxZ = "
          "%f, maxW = %f",
          CID(context), minX, minY, minZ, minW, maxX, maxY, maxZ, maxW);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidatePrimitiveBoundingBox(context, minX, minY, minZ, minW, maxX, maxY, maxZ, maxW));
        if (isCallValid)
        {
            context->primitiveBoundingBox(minX, minY, minZ, minW, maxX, maxY, maxZ, maxW);
        }
        ANGLE_CAPTURE(PrimitiveBoundingBox, isCallValid, context, minX, minY, minZ, minW, maxX,
                      maxY, maxZ, maxW);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY PushDebugGroup(GLenum source, GLuint id, GLsizei length, const GLchar *message)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::PushDebugGroup, "glPushDebugGroup",
          "context = %d, source = %s, id = %u, length = %d, message = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DebugSource, source), id, length,
          (uintptr_t)message);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidatePushDebugGroup(context, source, id, length, message));
        if (isCallValid)
        {
            context->pushDebugGroup(source, id, length, message);
        }
        ANGLE_CAPTURE(PushDebugGroup, isCallValid, context, source, id, length, message);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ReadnPixels(GLint x,
                             GLint y,
                             GLsizei width,
                             GLsizei height,
                             GLenum format,
                             GLenum type,
                             GLsizei bufSize,
                             void *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ReadnPixels, "glReadnPixels",
          "context = %d, x = %d, y = %d, width = %d, height = %d, format = %s, type = %s, bufSize "
          "= %d, data = 0x%016" PRIxPTR "",
          CID(context), x, y, width, height, GLenumToString(GLenumGroup::PixelFormat, format),
          GLenumToString(GLenumGroup::PixelType, type), bufSize, (uintptr_t)data);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateReadnPixels(context, x, y, width, height, format, type, bufSize, data));
        if (isCallValid)
        {
            context->readnPixels(x, y, width, height, format, type, bufSize, data);
        }
        ANGLE_CAPTURE(ReadnPixels, isCallValid, context, x, y, width, height, format, type, bufSize,
                      data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY SamplerParameterIiv(GLuint sampler, GLenum pname, const GLint *param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::SamplerParameterIiv, "glSamplerParameterIiv",
          "context = %d, sampler = %u, pname = %s, param = 0x%016" PRIxPTR "", CID(context),
          sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname), (uintptr_t)param);

    if (context)
    {
        SamplerID samplerPacked                               = FromGL<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateSamplerParameterIiv(context, samplerPacked, pname, param));
        if (isCallValid)
        {
            context->samplerParameterIiv(samplerPacked, pname, param);
        }
        ANGLE_CAPTURE(SamplerParameterIiv, isCallValid, context, samplerPacked, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY SamplerParameterIuiv(GLuint sampler, GLenum pname, const GLuint *param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::SamplerParameterIuiv, "glSamplerParameterIuiv",
          "context = %d, sampler = %u, pname = %s, param = 0x%016" PRIxPTR "", CID(context),
          sampler, GLenumToString(GLenumGroup::SamplerParameterName, pname), (uintptr_t)param);

    if (context)
    {
        SamplerID samplerPacked                               = FromGL<SamplerID>(sampler);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateSamplerParameterIuiv(context, samplerPacked, pname, param));
        if (isCallValid)
        {
            context->samplerParameterIuiv(samplerPacked, pname, param);
        }
        ANGLE_CAPTURE(SamplerParameterIuiv, isCallValid, context, samplerPacked, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY TexBuffer(GLenum target, GLenum internalformat, GLuint buffer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::TexBuffer, "glTexBuffer",
          "context = %d, target = %s, internalformat = %s, buffer = %u", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::InternalFormat, internalformat), buffer);

    if (context)
    {
        TextureType targetPacked                              = FromGL<TextureType>(target);
        BufferID bufferPacked                                 = FromGL<BufferID>(buffer);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexBuffer(context, targetPacked, internalformat, bufferPacked));
        if (isCallValid)
        {
            context->texBuffer(targetPacked, internalformat, bufferPacked);
        }
        ANGLE_CAPTURE(TexBuffer, isCallValid, context, targetPacked, internalformat, bufferPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY TexBufferRange(GLenum target,
                                GLenum internalformat,
                                GLuint buffer,
                                GLintptr offset,
                                GLsizeiptr size)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::TexBufferRange, "glTexBufferRange",
          "context = %d, target = %s, internalformat = %s, buffer = %u, offset = %llu, size = %llu",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::InternalFormat, internalformat), buffer,
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(size));

    if (context)
    {
        TextureType targetPacked                              = FromGL<TextureType>(target);
        BufferID bufferPacked                                 = FromGL<BufferID>(buffer);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexBufferRange(context, targetPacked, internalformat,
                                                   bufferPacked, offset, size));
        if (isCallValid)
        {
            context->texBufferRange(targetPacked, internalformat, bufferPacked, offset, size);
        }
        ANGLE_CAPTURE(TexBufferRange, isCallValid, context, targetPacked, internalformat,
                      bufferPacked, offset, size);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY TexParameterIiv(GLenum target, GLenum pname, const GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::TexParameterIiv, "glTexParameterIiv",
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::TextureParameterName, pname), (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                              = FromGL<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexParameterIiv(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->texParameterIiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(TexParameterIiv, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY TexParameterIuiv(GLenum target, GLenum pname, const GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::TexParameterIuiv, "glTexParameterIuiv",
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TextureTarget, target),
          GLenumToString(GLenumGroup::TextureParameterName, pname), (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked                              = FromGL<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateTexParameterIuiv(context, targetPacked, pname, params));
        if (isCallValid)
        {
            context->texParameterIuiv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE(TexParameterIuiv, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY TexStorage3DMultisample(GLenum target,
                                         GLsizei samples,
                                         GLenum internalformat,
                                         GLsizei width,
                                         GLsizei height,
                                         GLsizei depth,
                                         GLboolean fixedsamplelocations)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::TexStorage3DMultisample, "glTexStorage3DMultisample",
          "context = %d, target = %s, samples = %d, internalformat = %s, width = %d, height = %d, "
          "depth = %d, fixedsamplelocations = %s",
          CID(context), GLenumToString(GLenumGroup::TextureTarget, target), samples,
          GLenumToString(GLenumGroup::InternalFormat, internalformat), width, height, depth,
          GLbooleanToString(fixedsamplelocations));

    if (context)
    {
        TextureType targetPacked                              = FromGL<TextureType>(target);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateTexStorage3DMultisample(context, targetPacked, samples, internalformat, width,
                                             height, depth, fixedsamplelocations));
        if (isCallValid)
        {
            context->texStorage3DMultisample(targetPacked, samples, internalformat, width, height,
                                             depth, fixedsamplelocations);
        }
        ANGLE_CAPTURE(TexStorage3DMultisample, isCallValid, context, targetPacked, samples,
                      internalformat, width, height, depth, fixedsamplelocations);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}
}  // namespace gl
