#!/usr/local/bin/perl
# virt_index.cgi
# Display a menu for some specific virtual server, or the default server

require './apache-lib.pl';
&ReadParse();
($conf, $v) = &get_virtual_config($in{'virt'});
&can_edit_virt($v) || &error($text{'virt_ecannot'});
$desc = &text('virt_header', &virtual_name($v));
&ui_print_header($desc, $text{'virt_title'}, "", undef, undef, undef, undef, &restart_button());

# Display header and icons
print "<h3>$text{'virt_opts'}</h3>\n";
$sw_icon = { "icon" => "images/show.gif",
	     "name" => $text{'virt_show'},
	     "link" => "show.cgi?virt=$in{'virt'}" };
if ($in{'virt'} && $access{'types'} eq '*') {
	$ed_icon = { "icon" => "images/edit.gif",
		     "name" => $text{'virt_edit'},
		     "link" => "manual_form.cgi?virt=$in{'virt'}" };
	}
&config_icons("virtual", "edit_virt.cgi?virt=$in{'virt'}&", $sw_icon,
	      $ed_icon ? $ed_icon : ());

# Display per-directory options
@dir = ( &find_directive_struct("Directory", $conf) ,
         &find_directive_struct("DirectoryMatch", $conf),
	 &find_directive_struct("Files", $conf),
	 &find_directive_struct("FilesMatch", $conf),
	 &find_directive_struct("Location", $conf),
	 &find_directive_struct("LocationMatch", $conf),
	 &find_directive_struct("Proxy", $conf) );
if (@dir) {
	print "<hr>\n";
	print "<h3>$text{'dir_title'}</h3>\n";
	foreach $d (@dir) {
		$what = &dir_name($d);
		substr($what, 0, 1) = uc(substr($what, 0, 1));
		push(@links, "dir_index.cgi?idx=".&indexof($d, @$conf).
			     "&virt=$in{'virt'}");
		push(@titles, $what);
		push(@icons, "images/dir.gif");
		}
	&icons_table(\@links, \@titles, \@icons, 3);
	print "<p>\n";
	}

print "<form action=create_dir.cgi>\n";
print "<input type=hidden name=virt value=$in{'virt'}>\n";
print "<table border>\n";
print "<tr $tb> <td><b>$text{'virt_adddir'}</b></td> </tr>\n";
print "<tr $cb> <td><table>\n";
print "<tr> <td><b>$text{'virt_type'}</b></td> <td><select name=type>\n";
foreach $t ($httpd_modules{'core'} >= 2.0 ?
		("Directory", "Files", "Location", "Proxy") :
	    $httpd_modules{'core'} >= 1.2 ? ("Directory", "Files", "Location")
					  : ("Directory", "Location")) {
	print "<option value=$t>$text{'virt_'.$t}\n";
	}
print "</select></td>\n";
if ($httpd_modules{'core'} >= 1.2) {
	print "<td><b>$text{'virt_regexp'}</b></td>\n";
	print "<td><input type=radio name=regexp value=0 checked> ",
	      "$text{'virt_exact'}\n";
	print "<input type=radio name=regexp value=1> ",
	      "$text{'virt_re'}</td> </tr>\n";
	}
else { print "<td></td> </tr>\n"; }
print "<tr> <td><b>$text{'virt_path'}</b></td>\n";
print "<td><input name=path size=40></td>\n";
print "<td colspan=2 align=right>",
      "<input type=submit value=\"$text{'create'}\"></td> </tr>\n";
print "</table></td></tr></table></form>\n";

if ($in{'virt'} && $access{'vaddr'}) {
	# Show form for changing virtual server
	print "<hr>\n";
	print "<form action=save_vserv.cgi>\n";
	print "<input type=hidden name=virt value=$in{'virt'}>\n";
	print "<table border>\n";
	print "<tr $tb> <td><b>$text{'virt_opts'}</b></td> </tr>\n";
	print "<tr $cb> <td><table>\n";

	$val = $v->{'value'};
	if ($val =~ /\s/) {
		$addrs = $val;
		}
	if ($val =~ /^(\S+):(\S+)$/) {
		$addr = $1; $port = $2;
		}
	else { $addr = $val; }

	if ($addrs) {
		print "<tr> <td valign=top><b>$text{'vserv_addrs'}</b></td>\n";
		print "<td><textarea name=addrs rows=4 cols=30>",
			join("\n", split(/\s+/, $addrs)),
			"</textarea></td> </tr>\n";
		}
	else {
		print "<tr> <td><b>$text{'vserv_addr'}</b></td> <td>\n";
		printf "<input type=radio name=addr_def value=1 %s> %s\n",
			$addr eq "_default_" ? "checked" : "",
			$text{'vserv_addr1'};
		printf "<input type=radio name=addr_def value=2 %s> %s\n",
			$addr eq "*" ? "checked" : "",
			$text{'vserv_any'}
			if ($httpd_modules{'core'} >= 1.312);
		printf "<input type=radio name=addr_def value=0 %s>\n",
			$addr eq "*" || $addr eq "_default_" ? "" : "checked";
		printf "<input name=addr size=20 value='%s'></td>\n",
			$addr eq "*" || $addr eq "_default_" ? "" : $addr;

		print "<td><b>$text{'vserv_port'}</b></td>\n";
		print "<td>",&choice_input($port eq "*" ? 1 : $port > 0 ? 2 : 0,
				   "port_mode", "0", "$text{'vserv_default'},0",
				   "$text{'vserv_any'},1", ",2");
		printf "<input name=port size=5 value=\"%s\"></td> </tr>\n",
			$port > 0 ? $port : "";
		}

	$root = &find_directive_struct("DocumentRoot", $v->{'members'});
	$name = &find_directive("ServerName", $v->{'members'});

	print "<tr> <td><b>$text{'vserv_root'}</b></td>\n";
	print "<td colspan=3>",&opt_input($root->{'words'}->[0], "root",
					  $text{'vserv_default'}, 50),
		&file_chooser_button("root", 1, 1),"</td> </tr>\n";

	print "<tr> <td><b>$text{'vserv_name'}</b></td>\n";
	print "<td colspan=3>",&opt_input($name, "name", $text{'vserv_default'},
					  30),"</td> </tr>\n";

	print "<tr> <td colspan=4 align=right>\n";
	print "<input type=submit value=\"$text{'save'}\">\n";
	print "<input type=submit value=\"$text{'vserv_delete'}\" name=delete>\n";
	print "</td> </tr>\n";
	print "</table></td></tr></table></form>\n";
	}

&ui_print_footer("", $text{'index_return'});

