#!/usr/local/bin/perl
# edit_slave.cgi
# Display options for an existing slave or stub zone

require './bind8-lib.pl';
&ReadParse();
$bconf = $conf = &get_config();
if ($in{'view'} ne '') {
	$conf = $conf->[$in{'view'}]->{'members'};
	}
$zconf = $conf->[$in{'index'}]->{'members'};
$dom = $conf->[$in{'index'}]->{'value'};
%access = &get_module_acl();
&can_edit_zone(\%access, $conf->[$in{'index'}]) ||
	&error($text{'slave_ecannot'});
if ($0 =~ /edit_slave/) {
	&header($text{'slave_title'}, "");
	}
else {
	&header($text{'stub_title'}, "");
	}
print "<center><font size=+2>", &ip6int_to_net(&arpa_to_ip($dom)),
      "</font></center>\n";

if (&find("file", $zconf)) {
	$file = &find("file", $zconf)->{'value'};
	print "<hr><p>\n";
	@recs = &read_zone_file($file, $dom);
	if ($dom =~ /in-addr\.arpa/i || $dom =~ /\.ip6\.int/i) {
		@rcodes = ("PTR", "NS");
		}
	else {
		@rcodes = ("A", "NS", "CNAME", "MX", "HINFO",
			   "TXT", "WKS", "RP");
		if ($config{'support_aaaa'}) {
			push(@rcodes, "AAAA");
			}
		}
	foreach $c (@rcodes) { $rnum{$c} = 0; }
	foreach $r (@recs) {
		$rnum{$r->{'type'}}++;
		if ($r->{'type'} eq "SOA") { $soa = $r; }
		}
	if ($config{'show_list'}) {
		# display as list
		$mid = int((@rcodes+1)/2);
		print "<table width=100%> <tr><td width=50%>\n";
		&types_table(@rcodes[0..$mid-1]);
		print "</td><td width=50%>\n";
		&types_table(@rcodes[$mid..$#rcodes]);
		print "</td></tr> </table>\n";
		}
	else {
		# display as icons
		for($i=0; $i<@rcodes; $i++) {
			push(@rlinks, "edit_recs.cgi?index=$in{'index'}".
				      "&view=$in{'view'}&type=$rcodes[$i]");
			push(@rtitles, $text{"type_$rcodes[$i]"}.
				       " ($rnum{$rcodes[$i]})");
			push(@ricons, "images/$rcodes[$i].gif");
			}
		&icons_table(\@rlinks, \@rtitles, \@ricons);
		}
	}

if (@links) {
	print "<hr>\n";
	&icons_table(\@links, \@titles, \@images);
	}

print "<hr>\n";

if ($access{'opts'}) {
	print "<form action=save_slave.cgi>\n";
	print "<input type=hidden name=index value=\"$in{'index'}\">\n";
	print "<input type=hidden name=view value=\"$in{'view'}\">\n";
	print "<input type=hidden name=slave_stub value=\"$scriptname\">\n";
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'slave_opts'}</b></td> </tr>\n";
	print "<tr $cb> <td><table width=100%>\n";

	print "<tr>\n";
	print &address_port_input($text{'slave_masters'},
				  $text{'slave_masterport'},
				  $text{'slave_master_port'}, 
				  $text{'default'}, 
				  "masters",
				  "port",
				  $zconf,
				  5);
	print "</tr>\n";

	print "<tr>\n";
	print &opt_input($text{'slave_max'}, "max-transfer-time-in",
			 $zconf, $text{'default'}, 4, $text{'slave_mins'});
	print "</tr>\n";

	print "<tr>\n";
	print &opt_input($text{'slave_file'}, "file", $zconf, $text{'slave_none'}, 40);
	print "</tr>\n";

	print "<tr>\n";
	print &choice_input($text{'slave_check'}, "check-names", $zconf,
			    $text{'warn'}, "warn", $text{'fail'}, "fail",
			    $text{'ignore'}, "ignore", $text{'default'}, undef);
	print &choice_input($text{'slave_notify'}, "notify", $zconf,
			    $text{'yes'}, "yes", $text{'no'}, "no",
			    $text{'default'}, undef);
	print "</tr>\n";

	print "<tr>\n";
	print &addr_match_input($text{'slave_update'}, "allow-update", $zconf);
	print &addr_match_input($text{'slave_transfer'}, "allow-transfer", $zconf);
	print "</tr>\n";

	print "<tr>\n";
	print &addr_match_input($text{'slave_query'}, "allow-query", $zconf);
	print &address_input($text{'slave_notify2'}, "also-notify", $zconf);
	print "</tr>\n";

	print "</table></td></tr> </table><br>\n";
	}
if ($access{'ro'}) {
	print "</form>\n" if ($access{'opts'});
	}
else {
	print "<table width=100%><tr><td width=25% align=left>\n";
	if ($access{'opts'}) {
		print "<input type=submit value='$text{'save'}'></td></form>\n"
		}
	else {
		print "</td>\n";
		}

	@views = &find("view", $bconf);
	if ($in{'view'} eq '' && @views || $in{'view'} ne '' && @views > 1) {
		print "<form action=move_zone.cgi>\n";
		print "<input type=hidden name=index value=\"$in{'index'}\">\n";
		print "<input type=hidden name=view value=\"$in{'view'}\">\n";
		print "<td width=25% align=middle>\n";
		print "<input type=submit value=\"$text{'master_move'}\">\n";
		print "<select name=newview>\n";
		foreach $v (@views) {
			printf "<option value=%d>%s\n",
			    $v->{'index'}, $v->{'value'}
				if ($v->{'index'} ne $in{'view'});
			}
		print "</select></td></form>\n";
		}
	else {
		print "<td width=25%></td>\n";
		}

	if ($access{'master'}) {
		print "<form action=convert_slave.cgi>\n";
		print "<input type=hidden name=index value='$in{'index'}'>\n";
		print "<input type=hidden name=view value='$in{'view'}'>\n";
		print "<td align=middle><input type=submit ",
		      "value=\"$text{'slave_convert'}\"></td></form>\n";
		}
	else {
		print "<td width=25%></td>\n";
		}

	print "<form action=delete_zone.cgi>\n";
	print "<input type=hidden name=index value=\"$in{'index'}\">\n";
	print "<input type=hidden name=view value=\"$in{'view'}\">\n";
	print "<td align=right width=25%><input type=submit ",
	      "value=\"$text{'delete'}\"></td></form>\n";
	print "</tr></table>\n";
	}
print "<hr>\n";
&footer("", $text{'index_return'});

sub types_table
{
if ($_[0]) {
	local($i);
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'master_type'}</b></td> ",
	      "<td><b>$text{'master_records'}</b></td> </tr>\n";
	for($i=0; $_[$i]; $i++) {
		print "<tr $cb> <td><a href=\"edit_recs.cgi?",
		      "index=$in{'index'}&view=$in{'view'}&type=$_[$i]\">",
		      $text{"type_$_[$i]"},"</a></td>\n";
		print "<td>$rnum{$_[$i]}</td> </tr>\n";
		}
	print "</table>\n";
	}
}

