#!/usr/local/bin/perl
# save_misc.cgi
# Save global miscellaneous options

require './bind8-lib.pl';
%access = &get_module_acl();
$access{'defaults'} || &error($text{'misc_ecannot'});
&error_setup($text{'misc_err'});
&ReadParse();

&lock_file($config{'chroot'}.$config{'named_conf'});
$conf = &get_config();
my $controls = &find("controls", $conf);

if ($in{'inet_def'} && $in{'unix_def'}) {
  if (defined($controls)) {
    &save_directive(&get_config_parent(), 'controls', [ ], 0);
  }
} else {
  if (!defined($controls)) {
    $controls={ 'name' => 'controls', 'type' => 1 };
    &save_directive(&get_config_parent(), 'controls', [ $controls ], 0);
  }
  if (!$in{'inet_def'}) {
    my $addr=$in{'inetaddr'};
    &check_ipaddress($addr) || &error(&text('eip', $addr));

    my $port=$in{'inetport'};
    my @allows=();
    foreach $allow (split(/\s+/, $in{'inetallow'})) {
      # Need to check acl is OK!
      #&check_ipaddress($allow) || &error(&text('eip', $allow));
      push(@allows, { 'name' => $allow });
    }

    my $inetdir = { 'name' => 'inet', 'type' => 1,
		    'values' => [ $addr,
				  'port', $port,
				  'allow' ],
		    'members' => \@allows };

    &save_directive($controls, "inet", [ $inetdir ], 1);
  } else {
    &save_directive($controls, "inet", [ ], 1);
  }

  if (!$in{'unix_def'}) {
    my $file=$in{'unixfile'};
    my $perms=$in{'unixperms'};
    my $owner=$in{'unixowner'};
    my $group=$in{'unixgroup'};

    my $unixdir = { 'name' => 'unix', 'type' => 0,
		    'values' => [ $file,
				  'perm', $perms,
				  'owner', $owner,
				  'group', $group ] };

    &save_directive($controls, "unix", [ $unixdir ], 1);
  } else {
    &save_directive($controls, "unix", [ ], 1);
  }
}

&flush_file_lines();
&unlock_file($config{'chroot'}.$config{'named_conf'});
&webmin_log("controls", undef, undef, \%in);
&redirect("");

