#!/usr/local/bin/perl
# Send the webmin feedback form

require './web-lib.pl';
&init_config();
&ReadParseMime();
&error_setup($text{'feedback_err'});
%access = &get_module_acl();
$access{'feedback'} || &error($text{'feedback_ecannot'});

# Construct the email body
$in{'text'} =~ s/\r//g;
$date = localtime(time());
$ver = &get_webmin_version();
if ($in{'name'} && $in{'email'}) {
	$from = "$in{'name'} <$in{'email'}>";
	}
elsif ($in{'email'}) {
	$from = $in{'email'};
	}
else {
	$from = "feedback\@".&get_system_hostname();
	}
local $m = $in{'module'};
$m || !$in{'config'} || &error($text{'feedback_emodule'});
&check_os_support($m) && $m !~ /\.\./ || &error($text{'feedback_emodule2'});
%minfo = &get_module_info($m);
if ($gconfig{'nofeedbackcc'}) {
	@tolist = ( $webmin_feedback_address );
	}
else {
	push(@tolist, $webmin_feedback_address) if ($in{'towebmin'});
	push(@tolist, $in{'cc'}) if ($in{'cc'});
	}
@tolist || &error($text{'feedback_eto'});
foreach $t (@tolist) {
	$body .= "To: $t\n";
	}
$body .= <<EOF;
From: $from
Subject: $text{'feedback_title'}

Name:           $in{'name'}
Email address:  $in{'email'}
Date:           $date
Webmin version: $ver
Module:         $in{'module'} ($minfo{'desc'})
Browser:        $ENV{'HTTP_USER_AGENT'}
EOF

if ($in{'os'}) {
	$uname = `uname -a`;
	$body .= <<EOF;
OS from webmin: $gconfig{'real_os_type'} $gconfig{'real_os_version'}
OS code:        $gconfig{'os_type'} $gconfig{'os_version'}
Uname output:   $uname
EOF
	}

$body .= <<EOF;

Problem description
---------------------------------------------------------------------------
$in{'text'}
---------------------------------------------------------------------------
EOF

if ($in{'config'} && !$gconfig{'nofeedbackconfig'}) {
	# Check if this user has full rights to the module
	$access{'feedback'} == 2 || &error($text{'feedback_ecannot2'});
	local %uacl = &get_module_acl(undef, $m);
	local %defacl;
	&read_file("$m/defaultacl", \%defacl);
	foreach $k (keys %uacl) {
		if ($defacl{$k} ne $uacl{$k}) {
			&error($text{'feedback_econfig'});
			}
		}

	# Attach all the text file from the module's config
	local %mconfig = &foreign_config($m);
	if (keys %mconfig) {
		$body .= "\nModule config for $m\n";
		$body .= ("-" x 79)."\n";
		foreach $k (keys %mconfig) {
			$body .= "$k=$mconfig{$k}\n";
			}
		$body .= ("-" x 79)."\n";
		}

	# Find out what config files the module uses
	local @files;
	if (-r "$m/feedback_files.pl") {
		# Ask the module for it's files
		&foreign_require($m, "feedback_files.pl");
		@files = &foreign_call($m, "feedback_files", $m);
		}

	# Use all the path in the config
	foreach $k (keys %mconfig) {
		push(@files, $mconfig{$k}) if ($mconfig{$k} =~ /^\//);
		}
	@files = &unique(@files);

	# Attach those config files that are plain text (less than 5%
	# non-ascii characters). Also skip logfiles.
	foreach $f (@files) {
		next if (!$f || -d $f);
		next if ($f =~ /\/var\/log\//);
		local $/ = undef;
		open(FILE, $f) || next;
		local $data = <FILE>;
		close(FILE);
		local $count = ($data =~ tr/[\000-\176]/[\000-\176]/);
		if (!length($data) || 100*$count / length($data) > 95) {
			# File is text
			$body .= "\nConfig file $f\n";
			$body .= ("-" x 79)."\n";
			$body .= $data;
			$body .= ("-" x 79)."\n";
			}
		}
	}

# Include uploaded attached files
foreach $a ('attach0', 'attach1') {
	if ($in{$a} ne '') {
		$body .= "\nAdditional file ".$in{"${a}_filename"}."\n";
		$body .= ("-" x 79)."\n";
		$body .= $in{$a};
		$body .= ("-" x 79)."\n";
		}
	}

if ($in{'mailserver'}) {
	$ok = &send_via_smtp($in{'mailserver'});
	$sent = 3 if ($ok);
	}

if (!$sent) {
	# Try to send the email by calling sendmail -t
	%sconfig = &foreign_config("sendmail");
	$sendmail = $sconfig{'sendmail_path'} ? $sconfig{'sendmail_path'}
					      : &has_command("sendmail");
	if (-x $sendmail && open(MAIL, "| $sendmail -t")) {
		print MAIL $body;
		if (close(MAIL)) {
			$sent = 2;
			}
		}
	}

if (!$sent) {
	# Try to connect to a local SMTP server
	$ok = &send_via_smtp("localhost");
	$sent = 1 if ($ok);
	}

if ($sent) {
	# Tell the user that it was sent OK
	&header($text{'feedback_title'}, "", undef, 0, 1);
	print "<hr><p>\n";
	if ($sent == 3) {
		print &text('feedback_via', join(",", @tolist),
			    "<tt>$in{'mailserver'}</tt>"),"\n";
		}
	elsif ($sent == 2) {
		print &text('feedback_prog', join(",", @tolist),
			    "<tt>$sendmail</tt>"),"\n";
		}
	else {
		print &text('feedback_via', join(",", @tolist),
			    "<tt>localhost</tt>"),"\n";
		}
	print "<p><hr>\n";
	&footer("", $text{'index'});

	# Save settings in config
	$gconfig{'feedback_name'} = $in{'name'};
	$gconfig{'feedback_email'} = $in{'email'};
	$gconfig{'feedback_mailserver'} = $in{'mailserver'};
	&write_file("$config_directory/config", \%gconfig);
	}
else {
	# Give up! Tell the user ..
	&error($text{'feedback_esend'});
	}

sub send_via_smtp
{
local $error;
&open_socket($_[0], 25, MAIL, \$error);
return 0 if ($error);
&smtp_command(MAIL, "helo ".&get_system_hostname()."\n") || return 0;
&smtp_command(MAIL, "mail from: $from\n") || return 0;
foreach $t (@tolist) {
	&smtp_command(MAIL, "rcpt to: $t\n") || return 0;
	}
&smtp_command(MAIL, "data\n");
print MAIL $body;
&smtp_command(MAIL, ".\n");
&smtp_command(MAIL, "quit\n");
close(MAIL);
return 1;
}

# smtp_command(handle, command)
sub smtp_command
{
local ($m, $c) = @_;
print $m $c;
local $r = <$m>;
return $r =~ /^[23]\d+/;
}


