/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

using namespace std;

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "conf.h"
#include "defs.h"


wf_outmodule_xml_conf::wf_outmodule_xml_conf() {
  config.option_add("verbose", WF_OPTION_TYPE_INT,
		    _("verbosity level"));
  config.option_add("lines", WF_OPTION_TYPE_INT,
		    _("show n first lines"));

  config.option_add("summary", WF_OPTION_TYPE_BOOL,
		    _("summary mode"));
  config.option_add("resolve", WF_OPTION_TYPE_BOOL,
		    _("resolve IP addresses"),
		    _("determine reverse DNS lookup handling: yes or no"));
  config.option_add("sresolve", WF_OPTION_TYPE_BOOL,
		    _("resolve service names"));
  config.option_add("whois_lookup", WF_OPTION_TYPE_BOOL,
		    _("do a whois lookup"),
		    _("determine whois lookup handling: yes or no"));
  config.option_add("format", WF_OPTION_TYPE_BOOL,
		    _("show initial firewall log format"));
  config.option_add("chain", WF_OPTION_TYPE_BOOL,
		    _("show chain name"));
  config.option_add("branch", WF_OPTION_TYPE_BOOL,
		    _("show branch name"));
  config.option_add("icmp_typename", WF_OPTION_TYPE_BOOL,
		    _("show ICMP type name"));
  config.option_add("mac_vendor", WF_OPTION_TYPE_BOOL,
		    _("show MAC vendor"));

  config["verbose"] = 0;
  config["lines"] = 0;

  config["summary"] = true;
  config["resolve"] = true;
  config["sresolve"] = true;
  config["whois_lookup"] = false;
  config["icmp_typename"] = true;
  config["mac_vendor"] = false;

  config["format"] = true;
  config["chain"] = true;
  config["branch"] = false;
}

ostream&
wf_outmodule_xml_conf::print(ostream& os) const {
  os << "PRINT XML CONFIG" << endl;
  // RV@@8
  return os;
}
