import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;
import java.util.*;

class StarThread extends Thread
{
    protected StarViewer appl;
    volatile boolean is_stop, is_suspended;
    public StarThread(StarViewer n_appl)
    {
	appl=n_appl;
	is_stop=false;
	is_suspended=false;
    }
    public void stopMe()
    {
	is_stop = true;
    }
    public void suspendMe()
    {
	is_suspended=true;
    }
    public void resumeMe()
    {
	is_suspended=false;
    }
    public void run()
    {
	while (!is_stop)
	    {
		if (!is_suspended)
		    {
			appl.panell.go();
			appl.panell.repaint();
		    }
		try
		    {
			sleep(20);
		    }
		catch (InterruptedException e) {}
	    }		
    }
}

class StarPanel extends Panel
{
    // Setup values
    public double laxis, saxis, iangle, speed;
    public int direction; 
    public boolean path;
    // Current angle
    protected double angle;
    // Window settings
    protected double xmin, xmax, ymin, ymax;
    protected int curx, cury, curhsize, curvsize;
    protected int oldx, oldy; // curx and cury when it is last painted or updated
    protected boolean need_repaint;
    // Answer and current location of the earth
    protected double focx, focy, x, y;
    // The user's reply
    protected int replyx, replyy;
    public double replyrealx, replyrealy;
    // Distance
    public double replydist;
    // Is replied?
    public boolean replied;
    // Current window dimension
    Dimension D; 	     
       	
    public void init()
    {
	angle=iangle;
	xmin=-laxis;
	xmax=laxis;
	ymin=-saxis;
	ymax=saxis;
	if (laxis>saxis)
	    {
		focx=direction*Math.sqrt(Math.abs(laxis*laxis-saxis*saxis));
		focy=0;
	    }
	else
	    {
		focx=0;
		focy=direction*Math.sqrt(Math.abs(saxis*saxis-laxis*laxis));
	    }
	replied=false;
	oldx = -1;
	oldy = -1;
	need_repaint = true;
    }
        
    public void untransreply()
    {
	replyrealx=((double)replyx-D.width/2)/curhsize*(xmax-xmin);
	replyrealy=-((double)replyy-D.height/2)/curvsize*(ymax-ymin);
    }
        
    public void trans(double x, double y)
    {
	curx=(int)(x/(xmax-xmin)*curhsize+D.width/2);
	cury=(int)((-y)/(ymax-ymin)*curvsize+D.height/2);
    }
	
    public double sdist(double x1, double y1, double x2, double y2) // squared distance
    {
	return (x2-x1)*(x2-x1)+(y2-y1)*(y2-y1);
    }
	
    public void go()
    {
	x=laxis*Math.cos(angle);
	y=saxis*Math.sin(angle);
	angle+=speed*0.02*((laxis+saxis)*(laxis+saxis)/4.0)/sdist(focx, focy, x, y);
    }
	 
    protected void paint_or_update(Graphics g, boolean is_update)
    {
	int x1, y1, x2, y2;

	D=getSize();
	if (! is_update || need_repaint) {
	    g.setColor(Color.white);
	    g.fillRect(0, 0, D.width, D.height);
	    need_repaint = false;
	}
	curvsize=Math.min((int)((D.width-10)*saxis/laxis), D.height-10);
	curhsize=(int)(curvsize*laxis/saxis);
	trans(x, y);
	if (is_update && oldx >= 0 && oldy >= 0) {
	    g.setColor(Color.white);
	    g.fillArc(oldx - 5, oldy - 5, 10, 10, 0, 360);
	}
	oldx = curx;
	oldy = cury;
	g.setColor(Color.black);			
	g.fillArc(curx-5, cury-5, 10, 10, 0, 360);
	if (path)
	    {
		trans(-laxis, saxis);
		x1=curx; y1=cury;
		trans(laxis, -saxis);
		x2=curx; y2=cury;			
		g.drawArc(x1, y1, x2-x1, y2-y1, 0, 360);
	    }
	if (replied)
	    {
		g.setColor(Color.red);
		trans(focx, focy);
		g.fillArc(curx-10, cury-10, 20, 20, 0, 360);
		g.setColor(Color.black);
		g.drawLine(replyx-10,replyy,replyx+10,replyy);
		g.drawLine(replyx,replyy-10,replyx,replyy+10);
	    }
    } 

    public void paint(Graphics g)
    {
	paint_or_update(g, false);
    }
    
    public void update(Graphics g)
    {
    	paint_or_update(g, true);
    }
    
    public void onReply(int x, int y)
    {
	replied=true;
	replyx=x;
	replyy=y;
	trans(focx, focy);
	replydist=Math.sqrt(sdist(curx, cury, replyx, replyy));		
	untransreply();
    }
}

class StarResultPanel extends Panel
{
    double marks[][];
    int curmark;
    public StarResultPanel(int n)
    {
	marks=new double[n][2];
	curmark=0;
    }
    public void addMark(double dist)
    {		
	marks[curmark][0]=dist;
	marks[curmark][1]=Math.random()*2*Math.PI;
	curmark++;
	repaint();
    }
	
    protected void paint_or_update(Graphics g, boolean is_update)
    {
	Dimension D;
	int i;
	int size, psize, ctrx, ctry, markx, marky;
	D=getSize();
	size=Math.min(D.width, D.height);
	psize=(size-4)/10;
	ctrx=D.width/2;
	ctry=D.height/2;
	for (i=0; i<=5; i++) g.drawArc(ctrx-i*psize-1, ctry-i*psize-1, 2*i*psize+2, 2*i*psize+2, 0, 360);
	for (i=0; i<curmark; i++)
	    if (marks[i][0]<25)
		{
		    markx=ctrx+(int)(marks[i][0]/5*psize*Math.cos(marks[i][1]));
		    marky=ctry+(int)(marks[i][0]/5*psize*Math.sin(marks[i][1]));
		    g.fillArc(markx-3, marky-3, 6, 6, 0, 360);
		}
    }

    public void paint(Graphics g)
    {
	paint_or_update(g, false);
    }

    public void update(Graphics g)
    {
	paint_or_update(g, true);
    }
}

// Ugly: Since AWT does not display Chinese, and Swing is inconvenient to use,
// We have to use this trick.
class StarButtonMouseListener implements MouseListener
{
    public void mouseClicked(MouseEvent e)
    {
	StarButton button;
	ActionEvent ae;

	button = (StarButton) e.getComponent();
	ae = new ActionEvent(button, ActionEvent.ACTION_PERFORMED, button.action);
	button.listener.actionPerformed(ae);
    }

    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}
    public void mousePressed(MouseEvent e) {}
    public void mouseReleased(MouseEvent e) {}
}

class StarButton extends Component
{
    protected String text;
    protected ActionListener listener;
    protected String action;

    public StarButton(String n_text)
    {
	text = n_text;
	addMouseListener(new StarButtonMouseListener());
    }

    public void setText(String n_text)
    {
	text = n_text;
	repaint();
    }
    
    public void paint(Graphics g)
    {
	Dimension size;
	FontMetrics metric;
	int text_width;

	size = getSize();
	metric = g.getFontMetrics();
	text_width = metric.stringWidth(text);
	g.drawString(text, (size.width - text_width) / 2, 20);
	g.drawRect(0, 0, size.width - 1, size.height - 1);
    }

    public Dimension getMinimumSize()
    {
	// FIXME
	return new Dimension(100, 30);
    }

    public Dimension getPreferredSize()
    {
	return getMinimumSize();
    }
    
    public Dimension getMaximumSize()
    {
	return getMinimumSize();
    }
    
    public void addActionListener(ActionListener n_listener)
    {
	listener = n_listener;
    }

    public void setActionCommand(String n_action)
    {
	action = n_action;
    }
}

class StarLabel extends Component
{
    protected String text;

    public StarLabel()
    {
	text = "";
    }
    
    public StarLabel(String n_text)
    {
	text = n_text;
    }

    public void setText(String n_text)
    {
	text = n_text;
	repaint();
    }
    
    public void paint(Graphics g)
    {
	g.drawString(text, 0, 20);
    }

    public Dimension getMinimumSize()
    {
	// FIXME
	return new Dimension(100, 30);
    }

    public Dimension getPreferredSize()
    {
	return getMinimumSize();
    }
    
    public Dimension getMaximumSize()
    {
	return getMinimumSize();
    }
    
}


class StarListener implements ActionListener
{
    protected StarViewer appl;
    public boolean isactive;
    public StarListener(StarViewer n_appl)
    {
	appl=n_appl;
	isactive=true;
    }
    public void actionPerformed(ActionEvent e)
    {
	if (e.getActionCommand()=="stop")
	    {
		if (isactive)
		    {
			isactive=false;
			appl.thr.suspendMe();
			appl.btnstop.setText(appl.msgs.getString("resume"));
		    }
		else
		    {
			isactive=true;
			appl.thr.resumeMe();
			appl.btnstop.setText(appl.msgs.getString("pause"));
		    }
	    }
    }
}

class StarMouseListener implements MouseListener
{
    StarViewer appl;
    public StarMouseListener(StarViewer n_appl)
    {
	appl=n_appl;
    }
    public void mouseClicked(MouseEvent e)
    {
	URL url;
	URLConnection conn;
	InputStream strm;
	double score;
	
	if (appl.ended) return;
	if (!appl.panell.replied)
	    {
		appl.panell.onReply(e.getX(), e.getY());			
		appl.panelr.addMark(appl.panell.replydist);
		if (! appl.is_test) {
		    try
			{
			    appl.showconn();
			    url=new URL(appl.querystr+"&todo=giveans&replyx="+String.valueOf(appl.panell.replyrealx)+"&replyy="+String.valueOf(appl.panell.replyrealy));
			    conn=url.openConnection();
			    conn.connect();
			    strm=(InputStream)conn.getContent();
			    while (strm.read()!=-1) ;
			    strm.close();
			}
		    catch (Exception exc)
			{
			    appl.panic(exc);
			}
		}
		appl.updatelblstatus();
	    }
	else if (appl.ctry<appl.ntry)
	    {
		appl.ctry++;
		appl.newtry();
		appl.updatelblntry();
		appl.updatelblstatus();			
	    }
	else
	    {
		appl.lblntry.setText(appl.msgs.getString("gameover"));
		score = appl.getscore();
		if (score < 0.0) {
		    appl.lblstatus.setText(appl.msgs.getString("noscore"));
		} else {
		    appl.lblstatus.setText(appl.msgs.getString("yourscore")+": "
					   +String.valueOf(appl.getscore())+"/10");
		}
		appl.endme();
	    }
    }
    public void mouseEntered(MouseEvent e){}
    public void mouseExited(MouseEvent e){}
    public void mousePressed(MouseEvent e){}
    public void mouseReleased(MouseEvent e){}			
}

public class StarViewer extends Applet
{
    public StarThread thr;
    public StarButton btnstop;
    public StarLabel lblntry, lblstatus;
    public StarPanel panell;
    public StarResultPanel panelr;
    public int ntry, ctry;
    public String querystr;
    public boolean ended;
    public Locale locale;
    public ResourceBundle msgs;
    public boolean is_test;
	
    public StarViewer()
    {
    }

    public String getAppletInfo()
    {
	return "Name: StarViewer (exercise version)\n" +
	    "Author: WANG Qing Chuan\n";
    }

    public String[][] getParameterInfo()
    {
	String[][] info =
	{
	    { "ntry", "int", ""},
	    { "speed", "double", ""},
	    { "ispath", "boolean", ""},
	    { "querystr", "string", ""},
	    { "locale", "string", ""}
	};
	return info;		
    }

    public void updatelblntry()
    {
	String msg;
	msg=msgs.getString("try")+" "+String.valueOf(ctry)+"/"+String.valueOf(ntry);
	lblntry.setText(msg);
    }
	
    public void updatelblstatus()
    {
	double replymm;
	String msg;
	if (panell.replied)
	    {
		replymm=panell.replydist/96*25.4;
		replymm=Math.rint(replymm*10)/10;
		msg = msgs.getString("distance") + ": "+String.valueOf(replymm)+" mm";
	    }
	else msg=msgs.getString("clicksun");
	lblstatus.setText(msg);
    }

    public void endme()
    {
	ended=true;
    }
	
    public void panic(Exception exc)
    {
	lblstatus.setText(msgs.getString("neterror"));
	System.out.println(exc.getMessage());
	lblstatus.repaint();
	endme();
    }
	
    public void showconn()
    {
	lblstatus.setText(msgs.getString("pleasewait"));
	lblstatus.repaint();
    }
	
    public double getscore()
    {
	URL url;
	URLConnection conn;
	InputStream strm;
	int curchar;
	char ch;
	String curstr=new String();
	StringTokenizer tokenizer;
	double score;

	if (is_test) {
	    score = -1.0;
	} else {
	    try
		{
		    showconn();
		    url=new URL(querystr+"&todo=getscore");
		    conn=url.openConnection();
		    conn.connect();
		    strm=(InputStream)conn.getContent();
		    while ((curchar=strm.read())!=-1)
			{
			    ch=(char)curchar;
			    curstr=curstr+ch;
			}
		    strm.close();
		    tokenizer=new StringTokenizer(curstr);
		    score=(new Double(tokenizer.nextToken())).doubleValue();
		}
	    catch (Exception exc)
		{
		    panic(exc);
		    return 0.0;
		}
	    score=Math.rint(score*10)/10;
	}
	updatelblstatus();
	return score;
    }
			
    public void newtry() 
    {
	URL url;
	URLConnection conn;
	InputStream strm;
	int curchar;
	char ch;
	String curstr=new String();
	StringTokenizer tokenizer;
	int direction;

	if (is_test) {
	    panell.direction = (Math.random() < 0.5) ? 1 : -1;
	    panell.laxis = 2.0 + 3.0 * Math.random();
	    panell.saxis = 2.0 + 3.0 * Math.random();
	    panell.iangle = 6.283 * Math.random();
	} else {
	    try
		{
		    showconn();
		    url=new URL(querystr+"&todo=getdata");
		    conn=url.openConnection();
		    conn.connect();
		    strm=(InputStream)conn.getContent();
		    while ((curchar=strm.read())!=-1)
			{
			    ch=(char)curchar;
			    curstr=curstr+ch;
			}
		    strm.close();
		    tokenizer=new StringTokenizer(curstr);
		    direction=(new Integer(tokenizer.nextToken())).intValue();
		    if (direction!=1&&direction!=-1) throw (new Exception());
		    panell.direction=direction;
		    panell.laxis=(new Double(tokenizer.nextToken())).doubleValue();
		    panell.saxis=(new Double(tokenizer.nextToken())).doubleValue();
		    panell.iangle=(new Double(tokenizer.nextToken())).doubleValue();
		}
	    catch (Exception exc)
		{
		    panic(exc);
		}
	}
	updatelblstatus();
	panell.init();
    }
	
    public void init()
    {
	GridBagLayout gridbag;
	GridBagConstraints c=new GridBagConstraints();
	StarListener listen;
	StarMouseListener mouselisten;
	String locale_name;

	locale_name = getParameter("locale");
	if (locale_name == null) locale_name = "";
	if (locale_name.compareTo("en") == 0) locale = Locale.ENGLISH;
	else if (locale_name.compareTo("cn") == 0) locale = Locale.SIMPLIFIED_CHINESE;
	else locale = Locale.getDefault();
	msgs = ResourceBundle.getBundle("resources.StarViewer", locale);
	ended=false;
	ntry=(new Integer(getParameter("ntry"))).intValue();
	querystr=getParameter("querystr");
	is_test = (querystr == null);
	
	ctry=1;
	setBackground(Color.white);
	listen=new StarListener(this);
	mouselisten=new StarMouseListener(this);
	gridbag=new GridBagLayout();				
	setLayout(gridbag);
	panell=new StarPanel();		
	panell.speed=(new Double(getParameter("speed"))).doubleValue();
	panell.path=(new Integer(getParameter("ispath"))).intValue()==1;
	panell.addMouseListener(mouselisten);
	btnstop=new StarButton(msgs.getString("pause"));
	btnstop.addActionListener(listen);
	btnstop.setActionCommand("stop");
	lblntry=new StarLabel();
	updatelblntry();
	lblstatus=new StarLabel();
	updatelblstatus();
	panelr=new StarResultPanel(ntry);
	panelr.setSize(80,80);
	panell.setSize(320,240);
	c.fill=GridBagConstraints.BOTH;
	c.weightx=1.0;
	c.weighty=1.0;
	c.gridwidth=1;
	c.gridheight=GridBagConstraints.REMAINDER;
	gridbag.setConstraints(panell, c);
	c.weightx=0.25;
	c.weighty=0.0;
	c.gridheight=1;
	c.gridwidth=GridBagConstraints.REMAINDER;		
	gridbag.setConstraints(btnstop, c);		
	gridbag.setConstraints(lblntry, c);
	c.gridheight=GridBagConstraints.RELATIVE;
	gridbag.setConstraints(lblstatus, c);
	c.weighty=1.0;		
	c.gridheight=GridBagConstraints.REMAINDER;
	gridbag.setConstraints(panelr, c);
	add(panell);		
	add(btnstop);
	add(lblntry);
	add(lblstatus);
	add(panelr);
	newtry();
	updatelblntry();
    }

    public void destroy()
    {
    }

    public void start()
    {
	thr = new StarThread(this);
	thr.start();
    }
	
    public void stop()
    {
	thr.stopMe();
    }

}
