/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.QuadToCubicPathConstructor;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.gdi.CloseFigure;
import org.freehep.graphicsio.emf.gdi.LineTo;
import org.freehep.graphicsio.emf.gdi.MoveToEx;
import org.freehep.graphicsio.emf.gdi.PolyBezierTo;
import org.freehep.graphicsio.emf.gdi.PolyBezierTo16;
import org.freehep.graphicsio.emf.gdi.PolylineTo;
import org.freehep.graphicsio.emf.gdi.PolylineTo16;

public class EMFPathConstructor
extends QuadToCubicPathConstructor
implements EMFConstants {
    private EMFOutputStream os;
    private Rectangle imageBounds;
    private boolean curved;
    private int pointIndex = 0;
    private boolean wide = false;
    private Point[] points = new Point[4];

    public EMFPathConstructor(EMFOutputStream eMFOutputStream, Rectangle rectangle) {
        this.os = eMFOutputStream;
        this.imageBounds = rectangle;
        this.curved = false;
    }

    public void move(double d2, double d3) throws IOException {
        this.flush();
        this.os.writeTag(new MoveToEx(new Point(this.toUnit(d2), this.toUnit(d3))));
        super.move(d2, d3);
    }

    private void addPoint(int n2, double d2, double d3) {
        if (n2 >= this.points.length) {
            Point[] pointArray = new Point[n2 << 1];
            System.arraycopy(this.points, 0, pointArray, 0, this.points.length);
            this.points = pointArray;
        }
        int n3 = this.toUnit(d2);
        int n4 = this.toUnit(d3);
        if (this.wide || n3 < Short.MIN_VALUE || n3 > Short.MAX_VALUE || n4 < Short.MIN_VALUE || n4 > Short.MAX_VALUE) {
            this.wide = true;
        }
        if (this.points[n2] == null) {
            this.points[n2] = new Point(n3, n4);
        } else {
            this.points[n2].x = n3;
            this.points[n2].y = n4;
        }
    }

    public void line(double d2, double d3) throws IOException {
        if (this.curved && this.pointIndex > 0) {
            this.flush();
        }
        this.curved = false;
        this.addPoint(this.pointIndex++, d2, d3);
        super.line(d2, d3);
    }

    public void cubic(double d2, double d3, double d4, double d5, double d6, double d7) throws IOException {
        if (!this.curved && this.pointIndex > 0) {
            this.flush();
        }
        this.curved = true;
        this.addPoint(this.pointIndex++, d2, d3);
        this.addPoint(this.pointIndex++, d4, d5);
        this.addPoint(this.pointIndex++, d6, d7);
        super.cubic(d2, d3, d4, d5, d6, d7);
    }

    public void closePath(double d2, double d3) throws IOException {
        this.flush();
        this.os.writeTag(new CloseFigure());
        super.closePath(d2, d3);
    }

    public void flush() throws IOException {
        if (this.curved) {
            if (this.wide) {
                this.os.writeTag(new PolyBezierTo(this.imageBounds, this.pointIndex, this.points));
            } else {
                this.os.writeTag(new PolyBezierTo16(this.imageBounds, this.pointIndex, this.points));
            }
        } else if (this.pointIndex == 1) {
            this.os.writeTag(new LineTo(this.points[0]));
        } else if (this.pointIndex > 1) {
            if (this.wide) {
                this.os.writeTag(new PolylineTo(this.imageBounds, this.pointIndex, this.points));
            } else {
                this.os.writeTag(new PolylineTo16(this.imageBounds, this.pointIndex, this.points));
            }
        }
        this.pointIndex = 0;
        this.wide = false;
        super.flush();
    }

    protected int toUnit(double d2) {
        return (int)(d2 * 1.0 * 20.0);
    }
}

