/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Color;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;

public class ExtLogPen
implements EMFConstants {
    private int penStyle;
    private int width;
    private int brushStyle;
    private Color color;
    private int hatch;
    private int[] style;

    public ExtLogPen(int n2, int n3, int n4, Color color, int n5, int[] nArray) {
        this.penStyle = n2;
        this.width = n3;
        this.brushStyle = n4;
        this.color = color;
        this.hatch = n5;
        this.style = nArray;
    }

    public ExtLogPen(EMFInputStream eMFInputStream) throws IOException {
        this.penStyle = eMFInputStream.readDWORD();
        this.width = eMFInputStream.readDWORD();
        this.brushStyle = eMFInputStream.readUINT();
        this.color = eMFInputStream.readCOLORREF();
        this.hatch = eMFInputStream.readULONG();
        int n2 = eMFInputStream.readDWORD();
        if (n2 == 0) {
            eMFInputStream.readDWORD();
        }
        this.style = eMFInputStream.readDWORD(n2);
    }

    public void write(EMFOutputStream eMFOutputStream) throws IOException {
        eMFOutputStream.writeDWORD(this.penStyle);
        eMFOutputStream.writeDWORD(this.width);
        eMFOutputStream.writeUINT(this.brushStyle);
        eMFOutputStream.writeCOLORREF(this.color);
        eMFOutputStream.writeULONG(this.hatch);
        eMFOutputStream.writeDWORD(this.style.length);
        if (this.style.length == 0) {
            eMFOutputStream.writeDWORD(0);
        }
        eMFOutputStream.writeDWORD(this.style);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  ExtLogPen\n");
        stringBuffer.append("    penStyle: " + Integer.toHexString(this.penStyle) + "\n");
        stringBuffer.append("    width: " + this.width + "\n");
        stringBuffer.append("    brushStyle: " + this.brushStyle + "\n");
        stringBuffer.append("    color: " + this.color + "\n");
        stringBuffer.append("    hatch: " + this.hatch + "\n");
        for (int i2 = 0; i2 < this.style.length; ++i2) {
            stringBuffer.append("      style[" + i2 + "]: " + this.style[i2] + "\n");
        }
        return stringBuffer.toString();
    }
}

