/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.images;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ImageHandler {
    public static final Image brokenImage;
    public static final Cursor brokenCursor;
    public static final Icon brokenIcon;
    private static String[] imageExtensions;
    private static Hashtable imageCache;
    private static Hashtable cursorCache;
    private static Hashtable iconCache;

    protected ImageHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getImage(URL uRL) {
        Image image = null;
        image = uRL != null ? (Image)imageCache.get(uRL) : brokenImage;
        if (image == null && uRL != null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            try {
                InputStream inputStream = uRL.openStream();
                try {
                    int n2;
                    int n3 = inputStream.available();
                    if (n3 == 0) {
                        n3 = 1000;
                    }
                    byte[] byArray = new byte[n3];
                    int n4 = 0;
                    while ((n2 = inputStream.read(byArray, n4, n3 - n4)) >= 0) {
                        if (n2 > 0) {
                            n4 += n2;
                            continue;
                        }
                        byte[] byArray2 = new byte[n3 += 1000];
                        System.arraycopy(byArray, 0, byArray2, 0, n4);
                        byArray = byArray2;
                    }
                    image = toolkit.createImage(byArray);
                }
                finally {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                image = brokenImage;
            }
            if (uRL != null) {
                imageCache.put(uRL, image);
            }
        }
        return image;
    }

    public static Cursor getBestCursor(String string, Class clazz, int n2, int n3) {
        return ImageHandler.getBestCursor(string, clazz, n2, n3, 0, 0);
    }

    public static Cursor getBestCursor(String string, Class clazz, int n2, int n3, int n4, int n5) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getBestCursorSize(n2, n3);
        if (dimension.width == 0 && dimension.height == 0) {
            return Cursor.getDefaultCursor();
        }
        string = string.replaceAll("%w", Integer.toString(dimension.width));
        string = string.replaceAll("%h", Integer.toString(dimension.height));
        return ImageHandler.getCursor(string, clazz, n4, n5);
    }

    public static Cursor getCursor(URL uRL) {
        return ImageHandler.getCursor(uRL, 0, 0);
    }

    public static Cursor getCursor(URL uRL, int n2, int n3) {
        Cursor cursor;
        Cursor cursor2 = cursor = uRL != null ? (Cursor)cursorCache.get(uRL) : null;
        if (cursor == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Image image = ImageHandler.getImage(uRL);
            cursor = image == brokenImage ? brokenCursor : toolkit.createCustomCursor(image, new Point(n2, n3), uRL.getFile());
            if (uRL != null) {
                cursorCache.put(uRL, cursor);
            }
        }
        return cursor;
    }

    public static Icon getIcon(URL uRL) {
        Icon icon;
        Icon icon2 = icon = uRL != null ? (Icon)iconCache.get(uRL) : null;
        if (icon == null) {
            Image image = ImageHandler.getImage(uRL);
            icon = image == brokenImage ? brokenIcon : new ImageIcon(image, uRL.getFile());
            if (uRL != null) {
                iconCache.put(uRL, icon);
            }
        }
        return icon;
    }

    public static Image getImage(String string, Class clazz) {
        if (string.indexOf(46) >= 0) {
            return ImageHandler.getImage(clazz.getResource(string));
        }
        for (int i2 = 0; i2 < imageExtensions.length; ++i2) {
            URL uRL = clazz.getResource(string + imageExtensions[i2]);
            if (uRL == null) continue;
            return ImageHandler.getImage(uRL);
        }
        return brokenImage;
    }

    public static Cursor getCursor(String string, Class clazz) {
        return ImageHandler.getCursor(string, clazz, 0, 0);
    }

    public static Cursor getCursor(String string, Class clazz, int n2, int n3) {
        if (string.indexOf(46) >= 0) {
            return ImageHandler.getCursor(clazz.getResource(string), n2, n3);
        }
        for (int i2 = 0; i2 < imageExtensions.length; ++i2) {
            URL uRL = clazz.getResource(string + imageExtensions[i2]);
            if (uRL == null) continue;
            return ImageHandler.getCursor(uRL, n2, n3);
        }
        return brokenCursor;
    }

    public static Icon getIcon(String string, Class clazz) {
        if (string.indexOf(46) >= 0) {
            return ImageHandler.getIcon(clazz.getResource(string));
        }
        for (int i2 = 0; i2 < imageExtensions.length; ++i2) {
            URL uRL = clazz.getResource(string + imageExtensions[i2]);
            if (uRL == null) continue;
            return ImageHandler.getIcon(uRL);
        }
        return brokenIcon;
    }

    static {
        imageExtensions = new String[]{".png", ".gif", ".jpeg", ".jpg"};
        imageCache = new Hashtable();
        cursorCache = new Hashtable();
        iconCache = new Hashtable();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        brokenImage = toolkit.getImage(ImageHandler.class.getResource("BrokenImage.gif"));
        if (brokenImage == null) {
            throw new RuntimeException("Could not load BrokenIcon .. this looks bad!");
        }
        brokenIcon = new ImageIcon(brokenImage, "BrokenIcon");
        Image image = toolkit.getImage(ImageHandler.class.getResource("BrokenCursor.gif"));
        brokenCursor = GraphicsEnvironment.isHeadless() ? Cursor.getPredefinedCursor(3) : (image != null ? toolkit.createCustomCursor(image, new Point(0, 0), "BrokenCursor") : null);
        if (brokenCursor == null) {
            throw new RuntimeException("Could not load BrokenCursor .. this looks bad!");
        }
    }
}

