/*******************************************************************************
 *
 *	Font metric data for ITC Zapf Chancery Medium Italic
 *
 *	Copyright 2001 Ian Pilcher
 *
 *
 *	See dlls/wineps/data/COPYRIGHTS for font copyright information.
 *
 */

#include "psdrv.h"
#include "data/agl.h"


/*
 *  Glyph metrics
 */

static const AFMMETRICS metrics[228] = 
{
    {  32, 0x0020,  220, GN_space },
    {  33, 0x0021,  280, GN_exclam },
    {  34, 0x0022,  220, GN_quotedbl },
    {  35, 0x0023,  440, GN_numbersign },
    {  36, 0x0024,  440, GN_dollar },
    {  37, 0x0025,  680, GN_percent },
    {  38, 0x0026,  780, GN_ampersand },
    { 169, 0x0027,  160, GN_quotesingle },
    {  40, 0x0028,  260, GN_parenleft },
    {  41, 0x0029,  220, GN_parenright },
    {  42, 0x002a,  420, GN_asterisk },
    {  43, 0x002b,  520, GN_plus },
    {  44, 0x002c,  220, GN_comma },
    {  45, 0x002d,  280, GN_hyphen },
    {  46, 0x002e,  220, GN_period },
    {  47, 0x002f,  340, GN_slash },
    {  48, 0x0030,  440, GN_zero },
    {  49, 0x0031,  440, GN_one },
    {  50, 0x0032,  440, GN_two },
    {  51, 0x0033,  440, GN_three },
    {  52, 0x0034,  440, GN_four },
    {  53, 0x0035,  440, GN_five },
    {  54, 0x0036,  440, GN_six },
    {  55, 0x0037,  440, GN_seven },
    {  56, 0x0038,  440, GN_eight },
    {  57, 0x0039,  440, GN_nine },
    {  58, 0x003a,  260, GN_colon },
    {  59, 0x003b,  240, GN_semicolon },
    {  60, 0x003c,  520, GN_less },
    {  61, 0x003d,  520, GN_equal },
    {  62, 0x003e,  520, GN_greater },
    {  63, 0x003f,  380, GN_question },
    {  64, 0x0040,  700, GN_at },
    {  65, 0x0041,  620, GN_A },
    {  66, 0x0042,  600, GN_B },
    {  67, 0x0043,  520, GN_C },
    {  68, 0x0044,  700, GN_D },
    {  69, 0x0045,  620, GN_E },
    {  70, 0x0046,  580, GN_F },
    {  71, 0x0047,  620, GN_G },
    {  72, 0x0048,  680, GN_H },
    {  73, 0x0049,  380, GN_I },
    {  74, 0x004a,  400, GN_J },
    {  75, 0x004b,  660, GN_K },
    {  76, 0x004c,  580, GN_L },
    {  77, 0x004d,  840, GN_M },
    {  78, 0x004e,  700, GN_N },
    {  79, 0x004f,  600, GN_O },
    {  80, 0x0050,  540, GN_P },
    {  81, 0x0051,  600, GN_Q },
    {  82, 0x0052,  600, GN_R },
    {  83, 0x0053,  460, GN_S },
    {  84, 0x0054,  500, GN_T },
    {  85, 0x0055,  740, GN_U },
    {  86, 0x0056,  640, GN_V },
    {  87, 0x0057,  880, GN_W },
    {  88, 0x0058,  560, GN_X },
    {  89, 0x0059,  560, GN_Y },
    {  90, 0x005a,  620, GN_Z },
    {  91, 0x005b,  240, GN_bracketleft },
    {  92, 0x005c,  480, GN_backslash },
    {  93, 0x005d,  320, GN_bracketright },
    {  94, 0x005e,  520, GN_asciicircum },
    {  95, 0x005f,  500, GN_underscore },
    { 193, 0x0060,  220, GN_grave },
    {  97, 0x0061,  420, GN_a },
    {  98, 0x0062,  420, GN_b },
    {  99, 0x0063,  340, GN_c },
    { 100, 0x0064,  440, GN_d },
    { 101, 0x0065,  340, GN_e },
    { 102, 0x0066,  320, GN_f },
    { 103, 0x0067,  400, GN_g },
    { 104, 0x0068,  440, GN_h },
    { 105, 0x0069,  240, GN_i },
    { 106, 0x006a,  220, GN_j },
    { 107, 0x006b,  440, GN_k },
    { 108, 0x006c,  240, GN_l },
    { 109, 0x006d,  620, GN_m },
    { 110, 0x006e,  460, GN_n },
    { 111, 0x006f,  400, GN_o },
    { 112, 0x0070,  440, GN_p },
    { 113, 0x0071,  400, GN_q },
    { 114, 0x0072,  300, GN_r },
    { 115, 0x0073,  320, GN_s },
    { 116, 0x0074,  320, GN_t },
    { 117, 0x0075,  460, GN_u },
    { 118, 0x0076,  440, GN_v },
    { 119, 0x0077,  680, GN_w },
    { 120, 0x0078,  420, GN_x },
    { 121, 0x0079,  400, GN_y },
    { 122, 0x007a,  440, GN_z },
    { 123, 0x007b,  240, GN_braceleft },
    { 124, 0x007c,  520, GN_bar },
    { 125, 0x007d,  240, GN_braceright },
    { 126, 0x007e,  520, GN_asciitilde },
    { 161, 0x00a1,  280, GN_exclamdown },
    { 162, 0x00a2,  440, GN_cent },
    { 163, 0x00a3,  440, GN_sterling },
    { 168, 0x00a4,  440, GN_currency },
    { 165, 0x00a5,  440, GN_yen },
    {  -1, 0x00a6,  520, GN_brokenbar },
    { 167, 0x00a7,  420, GN_section },
    { 200, 0x00a8,  360, GN_dieresis },
    {  -1, 0x00a9,  740, GN_copyright },
    { 227, 0x00aa,  260, GN_ordfeminine },
    { 171, 0x00ab,  340, GN_guillemotleft },
    {  -1, 0x00ac,  520, GN_logicalnot },
    {  -1, 0x00ae,  740, GN_registered },
    {  -1, 0x00b0,  400, GN_degree },
    {  -1, 0x00b1,  520, GN_plusminus },
    {  -1, 0x00b2,  264, GN_twosuperior },
    {  -1, 0x00b3,  264, GN_threesuperior },
    { 194, 0x00b4,  300, GN_acute },
    { 182, 0x00b6,  500, GN_paragraph },
    { 180, 0x00b7,  220, GN_periodcentered },
    { 203, 0x00b8,  300, GN_cedilla },
    {  -1, 0x00b9,  264, GN_onesuperior },
    { 235, 0x00ba,  260, GN_ordmasculine },
    { 187, 0x00bb,  380, GN_guillemotright },
    {  -1, 0x00bc,  660, GN_onequarter },
    {  -1, 0x00bd,  660, GN_onehalf },
    {  -1, 0x00be,  660, GN_threequarters },
    { 191, 0x00bf,  400, GN_questiondown },
    {  -1, 0x00c0,  620, GN_Agrave },
    {  -1, 0x00c1,  620, GN_Aacute },
    {  -1, 0x00c2,  620, GN_Acircumflex },
    {  -1, 0x00c3,  620, GN_Atilde },
    {  -1, 0x00c4,  620, GN_Adieresis },
    {  -1, 0x00c5,  620, GN_Aring },
    { 225, 0x00c6,  740, GN_AE },
    {  -1, 0x00c7,  520, GN_Ccedilla },
    {  -1, 0x00c8,  620, GN_Egrave },
    {  -1, 0x00c9,  620, GN_Eacute },
    {  -1, 0x00ca,  620, GN_Ecircumflex },
    {  -1, 0x00cb,  620, GN_Edieresis },
    {  -1, 0x00cc,  380, GN_Igrave },
    {  -1, 0x00cd,  380, GN_Iacute },
    {  -1, 0x00ce,  380, GN_Icircumflex },
    {  -1, 0x00cf,  380, GN_Idieresis },
    {  -1, 0x00d0,  700, GN_Eth },
    {  -1, 0x00d1,  700, GN_Ntilde },
    {  -1, 0x00d2,  600, GN_Ograve },
    {  -1, 0x00d3,  600, GN_Oacute },
    {  -1, 0x00d4,  600, GN_Ocircumflex },
    {  -1, 0x00d5,  600, GN_Otilde },
    {  -1, 0x00d6,  600, GN_Odieresis },
    {  -1, 0x00d7,  520, GN_multiply },
    { 233, 0x00d8,  660, GN_Oslash },
    {  -1, 0x00d9,  740, GN_Ugrave },
    {  -1, 0x00da,  740, GN_Uacute },
    {  -1, 0x00db,  740, GN_Ucircumflex },
    {  -1, 0x00dc,  740, GN_Udieresis },
    {  -1, 0x00dd,  560, GN_Yacute },
    {  -1, 0x00de,  540, GN_Thorn },
    { 251, 0x00df,  420, GN_germandbls },
    {  -1, 0x00e0,  420, GN_agrave },
    {  -1, 0x00e1,  420, GN_aacute },
    {  -1, 0x00e2,  420, GN_acircumflex },
    {  -1, 0x00e3,  420, GN_atilde },
    {  -1, 0x00e4,  420, GN_adieresis },
    {  -1, 0x00e5,  420, GN_aring },
    { 241, 0x00e6,  540, GN_ae },
    {  -1, 0x00e7,  340, GN_ccedilla },
    {  -1, 0x00e8,  340, GN_egrave },
    {  -1, 0x00e9,  340, GN_eacute },
    {  -1, 0x00ea,  340, GN_ecircumflex },
    {  -1, 0x00eb,  340, GN_edieresis },
    {  -1, 0x00ec,  240, GN_igrave },
    {  -1, 0x00ed,  240, GN_iacute },
    {  -1, 0x00ee,  240, GN_icircumflex },
    {  -1, 0x00ef,  240, GN_idieresis },
    {  -1, 0x00f0,  400, GN_eth },
    {  -1, 0x00f1,  460, GN_ntilde },
    {  -1, 0x00f2,  400, GN_ograve },
    {  -1, 0x00f3,  400, GN_oacute },
    {  -1, 0x00f4,  400, GN_ocircumflex },
    {  -1, 0x00f5,  400, GN_otilde },
    {  -1, 0x00f6,  400, GN_odieresis },
    {  -1, 0x00f7,  520, GN_divide },
    { 249, 0x00f8,  440, GN_oslash },
    {  -1, 0x00f9,  460, GN_ugrave },
    {  -1, 0x00fa,  460, GN_uacute },
    {  -1, 0x00fb,  460, GN_ucircumflex },
    {  -1, 0x00fc,  460, GN_udieresis },
    {  -1, 0x00fd,  400, GN_yacute },
    {  -1, 0x00fe,  440, GN_thorn },
    {  -1, 0x00ff,  400, GN_ydieresis },
    { 245, 0x0131,  240, GN_dotlessi },
    { 232, 0x0141,  580, GN_Lslash },
    { 248, 0x0142,  300, GN_lslash },
    { 234, 0x0152,  820, GN_OE },
    { 250, 0x0153,  560, GN_oe },
    {  -1, 0x0160,  460, GN_Scaron },
    {  -1, 0x0161,  320, GN_scaron },
    {  -1, 0x0178,  560, GN_Ydieresis },
    {  -1, 0x017d,  620, GN_Zcaron },
    {  -1, 0x017e,  440, GN_zcaron },
    { 166, 0x0192,  440, GN_florin },
    { 195, 0x02c6,  340, GN_circumflex },
    { 207, 0x02c7,  340, GN_caron },
    { 197, 0x02c9,  440, GN_macron },
    { 198, 0x02d8,  440, GN_breve },
    { 199, 0x02d9,  220, GN_dotaccent },
    { 202, 0x02da,  300, GN_ring },
    { 206, 0x02db,  280, GN_ogonek },
    { 196, 0x02dc,  440, GN_tilde },
    { 205, 0x02dd,  400, GN_hungarumlaut },
    {  -1, 0x03bc,  460, GN_mu },
    { 177, 0x2013,  500, GN_endash },
    { 208, 0x2014, 1000, GN_emdash },
    {  96, 0x2018,  240, GN_quoteleft },
    {  39, 0x2019,  240, GN_quoteright },
    { 184, 0x201a,  180, GN_quotesinglbase },
    { 170, 0x201c,  340, GN_quotedblleft },
    { 186, 0x201d,  360, GN_quotedblright },
    { 185, 0x201e,  280, GN_quotedblbase },
    { 178, 0x2020,  460, GN_dagger },
    { 179, 0x2021,  480, GN_daggerdbl },
    { 183, 0x2022,  600, GN_bullet },
    { 188, 0x2026, 1000, GN_ellipsis },
    { 189, 0x2030,  960, GN_perthousand },
    { 172, 0x2039,  240, GN_guilsinglleft },
    { 173, 0x203a,  260, GN_guilsinglright },
    {  -1, 0x2122, 1000, GN_trademark },
    {  -1, 0x2212,  520, GN_minus },
    { 164, 0x2215,   60, GN_fraction },
    { 174, 0xfb01,  520, GN_fi },
    { 175, 0xfb02,  520, GN_fl }
};


/*
 *  Font metrics
 */

const AFM PSDRV_ZapfChancery_MediumItalic =
{
    "ZapfChancery-MediumItalic",	    /* FontName */
    "ITC Zapf Chancery Medium Italic",	    /* FullName */
    "ITC Zapf Chancery",		    /* FamilyName */
    "AdobeStandardEncoding",		    /* EncodingScheme */
    FW_NORMAL,				    /* Weight */
    -14,				    /* ItalicAngle */
    FALSE,				    /* IsFixedPitch */
    -100,				    /* UnderlinePosition */
    50,					    /* UnderlineThickness */
    { -181, -314, 1065, 831 },		    /* FontBBox */
    714,				    /* Ascender */
    -314,				    /* Descender */
    {
	1000,				    /* WinMetrics.usUnitsPerEm */
	790,				    /* WinMetrics.sAscender */
	-303,				    /* WinMetrics.sDescender */
	29,				    /* WinMetrics.sLineGap */
	350,				    /* WinMetrics.sAvgCharWidth */
	689,				    /* WinMetrics.sTypoAscender */
	-259,				    /* WinMetrics.sTypoDescender */
	122,				    /* WinMetrics.sTypoLineGap */
	790,				    /* WinMetrics.usWinAscent */
	303				    /* WinMetrics.usWinDescent */
    },
    228,				    /* NumofMetrics */
    metrics				    /* Metrics */
};
