##################################################################
#                                                                #
# Makefile (specific entries)                                    #
#                                                                #
# Thomas Nemeth.                                                 #
#                                                                #
##################################################################

include ../Config.make


#*****************************************************************
# PACKAGE DEFINITION :
#

PACKAGE       = WMMaiLoad
PROGRAM       = wmmaiload

ifndef VERSION
  VERSION     = $(shell cat ../VERSION)
endif

ifndef DEBUG_LEVEL
  DEBUG_LEVEL = 0
endif


#*****************************************************************
# INSTALLATION DIRECTORIES :
#

DESTDIR    =
ifndef PREFIX
  PREFIX   = /usr/local
endif


##################################################################
#                                                                #
# DO NOT CHANGE LINES BELOW UNLESS YOU KNOW WHAT YOU ARE DOING ! #
#                                                                #
##################################################################

#*****************************************************************
# SPECIFIC INFORMATIONS :
#

LIB_SSL = $(shell grep -q '^OPTIONS.*HAVE_SSL' ../Config.make && echo '-lssl')
LIB_THREADS = $(shell grep -q '^OPTIONS.*HAVE_THREADS' ../Config.make && echo '-lpthread')

CROSS_COMPILE =
USER_CPPFLAGS = $(OPTIONS)
USER_CFLAGS   =
USER_LDFLAGS  = -L/usr/X11R6/lib -lX11 -lXext -lXpm $(LIB_THREADS) $(LIB_SSL)


#*****************************************************************
# TARGETS :
#

PREDEP =

