/***********************************************************************************************
   				wmSMPmon II - moniteur systeme pour Window Maker
VERSION	: 2.2
DATE	: 12/07/01
AUTEURS	: redseb <redseb@goupilfr.org> et PhiR <phir@gcu-squad.org>
UTILITE : A tous les possesseurs de WM ET de bi-proc!
************************************************************************************************
   				   Ce programme est sous GPL.
***********************************************************************************************/



#include	<linux/sys.h>
#include 	<sys/param.h>
#include 	<sys/types.h>
#include 	<string.h>
#include	"standards.h"
#include 	<X11/Xlib.h>
#include 	<X11/xpm.h>
#include 	<X11/extensions/shape.h>
#include 	"../wmgeneral/wmgeneral.h"
#include 	"wmSMPmon_master.xpm"
#include 	"wmSMPmon_mask.xbm"

#define		VERSION		"2.2"
#define		T_DATA		255
#define		TAILLE_T	44
#define		DIV1		6
#define		DIV2		10
#define		HAUTEUR		31
#define		ERREUR_SWP	"You seem having problems with your swap. Try the \"-no-swap\" option.\n"
#define		ERREUR_SMP	"Are you sure that you have a SMP box ? Try the \"-smp-fake\" option.\n"
#define		MSG_SMP_FAKE	"SMP fake mode : Emulating second CPU.\n"
#define		MSG_NO_SWAP	"No swap mode : Swap is not monitored.\n"

void usage(void) ;

int main(int argc, char **argv)
{
   XEvent		Event ;

   unsigned char      	*t = NULL,
                        *u = NULL,
                        tmp[192] ;

   unsigned int		t0[TAILLE_T],
      			t1[TAILLE_T],
                        tm[TAILLE_T],
   			c1 = 6,
      			c2 = 9,
                        etat = 1,
      			lecture = 1,
 			delay = 250000,
                        delta = 0,
                        cpu0t = 0,
                        cpu1t = 0,
                        no_swap = FAUX,
                        smp_fake = FAUX,
                        draw_graph = FAUX ;
                        
   unsigned long	mem, prec_mem = 0, prec_swap = 0,
   		 	total0o = 0, charge0o = 0, 
      			total1o = 0, charge1o = 0, cpu0o=0, cpu1o=0 ;

   register unsigned long	charge, total, cpu, i = 0 ;
   
   
   while(argc > i)
   {
      if(!strncmp(argv[i], "-r", 2))
      {
         i ++ ;
         delay = atol(argv[i]) ;
      }
      if(!strncmp(argv[i], "-h", 2))
      {
         usage() ;
      }
      if(!strncmp(argv[i], "-g", 2))
      {
         i ++ ;
         etat = atoi(argv[i]) ;
         if(1 > etat || etat > 3)
            usage() ;
      }
      if(!strncmp(argv[i], "-smp-fake", 9))
      {
         puts(MSG_SMP_FAKE) ;
         smp_fake = VRAI ;
      }
      if(!strncmp(argv[i], "-no-swap", 8))
      {
         puts(MSG_NO_SWAP) ;
         no_swap = VRAI ;
      }
      i ++ ;
   }
   openXwindow(argc,argv,wmSMPmon_master_xpm,wmSMPmon_mask_bits,wmSMPmon_mask_width,wmSMPmon_mask_height) ;

   delay = delay / 2 ;

   for(i = 0 ; i < TAILLE_T ; i ++)
      t0[i] = 0 ;
   for(i = 0 ; i < TAILLE_T ; i ++)
      t1[i] = 0 ;
   for(i = 0 ; i < TAILLE_T ; i ++)
      tm[i] = 0 ;

   if(no_swap)
      copyXPMArea(60, 63, 60, 10, 6, 50) ;

   while(VRAI)
   {
      if(lecture)
      {
         i = open("/proc/stat", O_RDONLY);
   	 read(i, tmp, 128);
         close(i);
  		
         strtok(tmp, "\n");
         t = strtok(NULL, "\n");
         if(!smp_fake)       
            u = strtok(NULL, "\n");
  		
         strtok(t, " "); /* CPU 0 */
         charge = atoi(strtok(NULL, " "))+atoi(strtok(NULL, " "))+atoi(strtok(NULL, " "));
         total = charge+ atoi(strtok(NULL, " "));
         if(!charge || !total)
         {
            puts(ERREUR_SMP) ;
            exit(ERREUR) ;
         }
         cpu =  ((HAUTEUR * (charge - charge0o)) / (total - total0o + 0.001)) + 1 ;
         total0o = total ;
         charge0o = charge ;
         cpu0t = cpu0t + cpu ;
         if(cpu != cpu0o)
         {
            delta = HAUTEUR - cpu ;
       	    copyXPMArea(111, 0, 3, HAUTEUR, 4, 5) ;
       	    copyXPMArea(108, delta, 3, cpu, 4, 5 + delta) ;
            cpu0o = cpu;
         }
         if(!smp_fake)
         {
            strtok(u, " ");  /* CPU 1*/
            charge = atoi(strtok(NULL, " "))+atoi(strtok(NULL, " "))+atoi(strtok(NULL, " "));
            total = charge+ atoi(strtok(NULL, " ")); 
            cpu = ((HAUTEUR * (charge - charge1o)) / (total - total1o + 0.001)) + 1 ;
            total1o = total;
            charge1o = charge;         
         }
         cpu1t = cpu1t + cpu ;
         if(cpu != cpu1o)
         {
            delta = HAUTEUR - cpu ;
       	    copyXPMArea(111, 0, 3, HAUTEUR, 9, 5) ;
       	    copyXPMArea(108, delta, 3, cpu, 9, 5 + delta) ;
            cpu1o = cpu;
         }  		
         if(c1 > DIV1)
         {
            i = open("/proc/meminfo", O_RDONLY);
            read(i, tmp, 192);
            close(i);
            strtok(tmp, "\n");
            t = strtok(NULL, "\n");
            u = strtok(NULL, "\n");	
            strtok(t, " ");
            total = atoi(strtok(NULL, " "));
            charge = atoi(strtok(NULL, " "));
            strtok(NULL, " ");
            strtok(NULL, " ");
            strtok(NULL, " ");
            cpu = atoi(strtok(NULL, " "));
            
            mem = ((charge - cpu) / (total / 100)) ;
            if(mem != prec_mem)
            {
               copyXPMArea(30, 63, 30, 8, 29, 39) ;
               copyXPMArea(0, 63, (mem * 30 / 100), 8, 29, 39) ;
               prec_mem = mem ;
            }		
            strtok(u, " ");
            if(!no_swap)
            {
               total = charge = 0 ;
               total = atoi(strtok(NULL, " "));
               strtok(NULL, " ");
               charge = atoi(strtok(NULL, " "));
               if(!charge || !total)
               {
                  puts(ERREUR_SWP) ;
                  exit(ERREUR) ;
               }
               mem = 100 - (charge / (total / 100)) ; 
               if(mem != prec_swap)
               {
                  copyXPMArea(30, 63, 30, 8, 29, 50) ;
                  copyXPMArea(0, 63, (mem * 30 / 100), 8, 29, 50) ;
                  prec_swap = mem ;
               }
            }
            c1 = 0;
         }
         if(c2 > DIV2)
            draw_graph = VRAI ;
         if(draw_graph)
         {
            for(i = 1 ; i < TAILLE_T ; i ++)
            {
               t0[i - 1] = t0[i] ;
               t1[i - 1] = t1[i] ;
               tm[i - 1] = tm[i] ;
            }
            if((t0[TAILLE_T - 1] = cpu0t / c2) > HAUTEUR)
               t0[TAILLE_T - 1] = HAUTEUR ;
            if((t1[TAILLE_T - 1] = cpu1t / c2) > HAUTEUR)
               t1[TAILLE_T - 1] = HAUTEUR ;
            if((tm[TAILLE_T - 1] = (cpu0t + cpu1t) / (2 * c2)) > HAUTEUR)
               tm[TAILLE_T - 1] = HAUTEUR ;
            cpu0t = 0 ;
            cpu1t = 0 ;
            switch(etat)
            {
               case 1 :
                  copyXPMArea(64, 32, TAILLE_T, HAUTEUR, 15, 5) ;
                  for(i = 0 ; i < TAILLE_T ; i ++)
                     copyXPMArea(114, 0, 1, tm[i], 15 + i, HAUTEUR + 5 - tm[i]) ;
                  break ;
               case 2 :
                  copyXPMArea(64, 0, TAILLE_T, HAUTEUR, 15, 5) ;
                  for(i = 0 ; i < TAILLE_T ; i ++)
                     copyXPMArea(114, 0, 1, t0[i]/2, 15 + i, HAUTEUR/2 + 5 - t0[i]/2) ;
                  for(i = 0 ; i < TAILLE_T ; i ++)
                     copyXPMArea(114, 0, 1, t1[i]/2, 15 + i, HAUTEUR/2 + 21 - t1[i]/2) ;
                  break ;
               case 3 :
                  copyXPMArea(64, 0, TAILLE_T, HAUTEUR, 15, 5) ;
                  for(i = 0 ; i < TAILLE_T ; i ++)
                     copyXPMArea(114, 0, 1, t0[i]/2, 15 + i, HAUTEUR/2 + 5 - t0[i]/2) ;
                  for(i = 0 ; i < TAILLE_T ; i ++)
                     copyXPMArea(115, (HAUTEUR - t1[i])/2, 1, t1[i]/2, 15 + i, HAUTEUR/2 + 6) ;               
                  break ;
            }
            c2 = 0 ;
            draw_graph = FAUX ;
         }
         c1 ++ ;
         c2 ++ ;
      }
      lecture = 1 - lecture ;
      RedrawWindow() ;
      if(XCheckMaskEvent(display, ButtonPressMask, &Event))
      {
	 if(Event.type == ButtonPress)
      	 {
            if((etat ++) >= 3)
               etat = 1 ;
            draw_graph = VRAI ;
            lecture = VRAI ;
         }
      }
      usleep(delay);      
   }
}

void usage(void)
{
   puts("\nwmSMPmon "VERSION" - display system charge of a dual-CPU Linux box.\n\n"
        "Options : -h        this help screen.\n"
        "          -r        refresh rate (in microseconds, default 250000).\n"
        "          -g        graph style (try 2 or 3, default is 1).\n"
        "          -no-swap  don't monitore swap size.\n"
	"          -smp-fake emulate a second CPU (funny for not-SMP box).\n\n"
        "<redseb@goupilfr.org> http://goupilfr.org\n"
	"<phir@gcu-squad.org> http://gcu-squad.org\n"
        ) ;
   exit(OK) ;
}  

