/* lowlevelfunc.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: lowlevelfunc.h,v 1.11 2002/01/07 01:05:47 ralf Exp $ */

#ifndef LOWLEVELFUNC_H
#define LOWLEVELFUNC_H

#include "aguixdefs.h"
#include "time.h"

void *_allocsafe(size_t size);
void waittime(unsigned long msec);
#ifdef USE_MEM_SYSTEM
void _freesafe(void *p);
void _memsysteminit();
void _memsystemcheck();
#else
#define _freesafe(P) free(P)
#endif /* USE_MEM_SYSTEM */
char *dupstring(const char *str);
char *catstring(const char *str1,const char *str2);
char *shrinkstring(const char *str,int maxlen);
int WriteLong2Str(char *buffer,loff_t size);
int MakeLong2NiceStr(char *buffer,loff_t size);
int LongSize(loff_t value);

#ifdef DEVELOPER
  #define debugmsg(P) printf(P)
#else
  #define debugmsg(P) 
#endif

#endif /* LOWLEVELFUNC_H */

