/* basic_actions.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: basic_actions.cc,v 1.12 2002/03/01 11:39:37 ralf Exp $ */

#include "basic_actions.h"
#include "listermode.h"
#include "normalmode.h"
#include "worker.h"

/***********
  DNDAction
************/

const char *DNDAction::name="DNDAction";

bool DNDAction::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *DNDAction::getName()
{
  return name;
}

DNDAction::DNDAction(Worker *tworker):FunctionProto(tworker)
{
}

DNDAction::~DNDAction()
{
}

DNDAction *DNDAction::duplicate()
{
  DNDAction *dnda=new DNDAction(worker);
  return dnda;
}

int DNDAction::run(ActionMessage *msg)
{
  ListerMode *lm1;
  // do nothing in case of DND
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1=worker->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL)
        if(lm1->isType("NormalMode")==true)
          normalmodedndaction();
    }
  }
  return 0;
}

const char *DNDAction::getDescription()
{
  return catalog.getLocaleCom(0);
}

void DNDAction::normalmodedndaction()
{
  ListerMode *lm1;
  Lister *l1=worker->getActiveLister();
  NormalMode *nm=NULL;
  ActionMessage amsg;
  if(l1!=NULL) {
    lm1=l1->getActiveMode();
    if(lm1!=NULL)
      if(lm1->isType("NormalMode")==true) nm=(NormalMode*)lm1;
  }
  if(nm!=NULL) {
    List *files=new List();
    //TODO: Perhaps change ONLYSELECT in SELORACT, so also the active entry is taken
    nm->getSelFiles(files,NormalMode::NM_GETFILES_SELORACT,true);
    int id=files->initEnum();
    FileEntry *fe=NULL;
    WCFiletype *ft,*fft[4];
    List *filetypes=wconfig->getFiletypes();
    fft[0]=NULL;
    fft[1]=NULL;
    fft[2]=NULL;
    fft[3]=NULL;
    
    amsg.startLister=l1;
    amsg.mode=amsg.AM_MODE_SPECIAL;
    
    int e=filetypes->initEnum();
    ft=(WCFiletype*)filetypes->getFirstElement(e);
    while(ft!=NULL) {
      switch(ft->getinternID()) {
        case NOTYETTYPE:
          fft[0]=ft;
          break;
        case UNKNOWNTYPE:
          fft[1]=ft;
          break;
        case VOIDTYPE:
          fft[2]=ft;
          break;
      }
      ft=(WCFiletype*)filetypes->getNextElement(e);
    }
    filetypes->closeEnum(e);
    if(files->size()==0) {
      ft=fft[2];
      if(ft!=NULL) {
        amsg.extraInfo=fe;
        amsg.flags=ft->getDNDActionsGF();
        worker->interpret(ft->getDNDActions(),&amsg);
      }
    } else {
      NM_specialsource *ss1=(NM_specialsource*)files->getFirstElement(id);
      while(ss1!=NULL) {
        fe=ss1->entry;
        if(fe!=NULL) {
          if(fe->isDir()==false) {
            ft=fe->filetype;
            if(ft==NULL) ft=fft[0]; // not yet checked
            if(ft!=NULL) {
              amsg.extraInfo=fe;
              amsg.flags=ft->getDNDActionsGF();
              worker->interpret(ft->getDNDActions(),&amsg);
            }
          }
        }
        _freesafe(ss1);
        ss1=(NM_specialsource*)files->getNextElement(id);
      }
      files->closeEnum(id);
    }
    delete files;
  }
}

/***************
 Ende DNDAction
****************/

/*******************
  DoubleClickAction
********************/

const char *DoubleClickAction::name="DoubleClickAction";

bool DoubleClickAction::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *DoubleClickAction::getName()
{
  return name;
}

DoubleClickAction::DoubleClickAction(Worker *tworker):FunctionProto(tworker)
{
}

DoubleClickAction::~DoubleClickAction()
{
}

DoubleClickAction *DoubleClickAction::duplicate()
{
  DoubleClickAction *ta=new DoubleClickAction(worker);
  return ta;
}

int DoubleClickAction::run(ActionMessage *msg)
{
  ListerMode *lm1;
  am=msg;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1=worker->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL)
        if(lm1->isType("NormalMode")==true)
          normalmodeddaction();
    }
  } else normalmodeddaction();
  return 0;
}

const char *DoubleClickAction::getDescription()
{
  return catalog.getLocaleCom(1);
}

void DoubleClickAction::normalmodeddaction()
{
  ListerMode *lm1;
  Lister *l1;
  NormalMode *nm=NULL;
  ActionMessage amsg;
  if(am->mode!=am->AM_MODE_DNDACTION) {
    l1=worker->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL)
        if(lm1->isType("NormalMode")==true) nm=(NormalMode*)lm1;
    }
    if(nm!=NULL) {
      List *files=new List();
      //TODO: Perhaps change ONLYSELECT in SELORACT, so also the active entry is taken
      nm->getSelFiles(files,NormalMode::NM_GETFILES_SELORACT,true);
      int id=files->initEnum();
      FileEntry *fe=NULL;
      WCFiletype *ft,*fft[4];
      List *filetypes=wconfig->getFiletypes();
      fft[0]=NULL;
      fft[1]=NULL;
      fft[2]=NULL;
      fft[3]=NULL;
    
      amsg.startLister=l1;
      amsg.mode=amsg.AM_MODE_SPECIAL;
    
      int e=filetypes->initEnum();
      ft=(WCFiletype*)filetypes->getFirstElement(e);
      while(ft!=NULL) {
        switch(ft->getinternID()) {
          case NOTYETTYPE:
            fft[0]=ft;
            break;
          case UNKNOWNTYPE:
            fft[1]=ft;
            break;
          case VOIDTYPE:
            fft[2]=ft;
            break;
        }
        ft=(WCFiletype*)filetypes->getNextElement(e);
      }
      filetypes->closeEnum(e);
      if(files->size()==0) {
        ft=fft[2];
        if(ft!=NULL) {
          amsg.extraInfo=fe;
          amsg.flags=ft->getDoubleClickActionsGF();
          worker->interpret(ft->getDoubleClickActions(),&amsg);
        }
      } else {
        NM_specialsource *ss1=(NM_specialsource*)files->getFirstElement(id);
        while(ss1!=NULL) {
          fe=ss1->entry;
          if(fe!=NULL) {
            if(fe->isDir()==false) {
              ft=fe->filetype;
              if(ft==NULL) ft=fft[0]; // not yet checked
              if(ft!=NULL) {
                amsg.extraInfo=fe;
                amsg.flags=ft->getDoubleClickActionsGF();
                worker->interpret(ft->getDoubleClickActions(),&amsg);
              }
            }
          }
          _freesafe(ss1);
          ss1=(NM_specialsource*)files->getNextElement(id);
        }
        files->closeEnum(id);
      }
      delete files;
    }
  } else {
    l1=((DNDMsg*)am->extraInfo)->getSourceLister();
    if(l1==NULL) return;

    FileEntry *fe=((DNDMsg*)am->extraInfo)->getFE();
    if(fe!=NULL) {
      WCFiletype *ft,*fft[4];
      List *filetypes=wconfig->getFiletypes();
      fft[0]=NULL;
      fft[1]=NULL;
      fft[2]=NULL;
      fft[3]=NULL;
    
      amsg.startLister=l1;
      amsg.mode=amsg.AM_MODE_SPECIAL;
    
      int e=filetypes->initEnum();
      ft=(WCFiletype*)filetypes->getFirstElement(e);
      while(ft!=NULL) {
        switch(ft->getinternID()) {
          case NOTYETTYPE:
            fft[0]=ft;
            break;
          case UNKNOWNTYPE:
            fft[1]=ft;
            break;
          case VOIDTYPE:
            fft[2]=ft;
            break;
          case DIRTYPE:
            fft[3]=ft;
            break;
        }
        ft=(WCFiletype*)filetypes->getNextElement(e);
      }
      filetypes->closeEnum(e);
      ft=fe->filetype;
      if(ft==NULL) {
        if(fe->isDir()==false) ft=fft[0]; // not yet checked
        else ft=fft[3]; // dir
      }
      if(ft!=NULL) {
        amsg.extraInfo=fe;
        amsg.flags=ft->getDoubleClickActionsGF();
        worker->interpret(ft->getDoubleClickActions(),&amsg);
      }
    }
  }
}

/***************
 Ende DoubleClickAction
****************/

/***********
  ShowAction
************/

const char *ShowAction::name="ShowAction";

bool ShowAction::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *ShowAction::getName()
{
  return name;
}

ShowAction::ShowAction(Worker *tworker):FunctionProto(tworker)
{
}

ShowAction::~ShowAction()
{
}

ShowAction *ShowAction::duplicate()
{
  ShowAction *ta=new ShowAction(worker);
  return ta;
}

int ShowAction::run(ActionMessage *msg)
{
  ListerMode *lm1;
  am=msg;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1=worker->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL)
        if(lm1->isType("NormalMode")==true)
          normalmodeshow();
    }
  } else normalmodeshow();
  return 0;
}

const char *ShowAction::getDescription()
{
  return catalog.getLocaleCom(2);
}

void ShowAction::normalmodeshow()
{
  ListerMode *lm1;
  NormalMode *nm=NULL;
  ActionMessage amsg;
  Lister *l1;
  if(am->mode!=am->AM_MODE_DNDACTION) {
    l1=worker->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL)
        if(lm1->isType("NormalMode")==true) nm=(NormalMode*)lm1;
    }
    if(nm!=NULL) {
      List *files=new List();
      //TODO: Perhaps change ONLYSELECT in SELORACT, so also the active entry is taken
      nm->getSelFiles(files,NormalMode::NM_GETFILES_SELORACT,true);
      int id=files->initEnum();
      FileEntry *fe=NULL;
      WCFiletype *ft,*fft[4];
      List *filetypes=wconfig->getFiletypes();
      fft[0]=NULL;
      fft[1]=NULL;
      fft[2]=NULL;
      fft[3]=NULL;
    
      amsg.startLister=l1;
      amsg.mode=amsg.AM_MODE_SPECIAL;
    
      int e=filetypes->initEnum();
      ft=(WCFiletype*)filetypes->getFirstElement(e);
      while(ft!=NULL) {
        switch(ft->getinternID()) {
          case NOTYETTYPE:
            fft[0]=ft;
            break;
          case UNKNOWNTYPE:
            fft[1]=ft;
            break;
          case VOIDTYPE:
            fft[2]=ft;
            break;
        }
        ft=(WCFiletype*)filetypes->getNextElement(e);
      }
      filetypes->closeEnum(e);
      if(files->size()==0) {
        ft=fft[2];
        if(ft!=NULL) {
          amsg.extraInfo=fe;
          amsg.flags=ft->getShowActionsGF();
          worker->interpret(ft->getShowActions(),&amsg);
        }
      } else {
        NM_specialsource *ss1=(NM_specialsource*)files->getFirstElement(id);
        while(ss1!=NULL) {
          fe=ss1->entry;
          if(fe!=NULL) {
            if(fe->isDir()==false) {
              ft=fe->filetype;
              if(ft==NULL) ft=fft[0]; // not yet checked
              if(ft!=NULL) {
                amsg.extraInfo=fe;
                amsg.flags=ft->getShowActionsGF();
                worker->interpret(ft->getShowActions(),&amsg);
              }
            }
          }
          _freesafe(ss1);
          ss1=(NM_specialsource*)files->getNextElement(id);
        }
        files->closeEnum(id);
      }
      delete files;
    }
  } else {
    l1=((DNDMsg*)am->extraInfo)->getSourceLister();
    if(l1==NULL) return;

    FileEntry *fe=((DNDMsg*)am->extraInfo)->getFE();
    if(fe!=NULL) {
      WCFiletype *ft,*fft[4];
      List *filetypes=wconfig->getFiletypes();
      fft[0]=NULL;
      fft[1]=NULL;
      fft[2]=NULL;
      fft[3]=NULL;
    
      amsg.startLister=l1;
      amsg.mode=amsg.AM_MODE_SPECIAL;
    
      int e=filetypes->initEnum();
      ft=(WCFiletype*)filetypes->getFirstElement(e);
      while(ft!=NULL) {
        switch(ft->getinternID()) {
          case NOTYETTYPE:
            fft[0]=ft;
            break;
          case UNKNOWNTYPE:
            fft[1]=ft;
            break;
          case VOIDTYPE:
            fft[2]=ft;
            break;
          case DIRTYPE:
            fft[3]=ft;
            break;
        }
        ft=(WCFiletype*)filetypes->getNextElement(e);
      }
      filetypes->closeEnum(e);
      ft=fe->filetype;
      if(ft==NULL) {
        if(fe->isDir()==false) ft=fft[0]; // not yet checked
        else ft=fft[3]; // dir
      }
      if(ft!=NULL) {
        amsg.extraInfo=fe;
        amsg.flags=ft->getShowActionsGF();
        worker->interpret(ft->getShowActions(),&amsg);
      }
    }
  }
}

/***************
 Ende ShowAction
****************/

/***********
 RawShowAction
************/

const char *RawShowAction::name="RawShowAction";

bool RawShowAction::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *RawShowAction::getName()
{
  return name;
}

RawShowAction::RawShowAction(Worker *tworker):FunctionProto(tworker)
{
}

RawShowAction::~RawShowAction()
{
}

RawShowAction *RawShowAction::duplicate()
{
  RawShowAction *ta=new RawShowAction(worker);
  return ta;
}

int RawShowAction::run(ActionMessage *msg)
{
  ListerMode *lm1;
  am=msg;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1=worker->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL)
        if(lm1->isType("NormalMode")==true)
          normalmoderawshow();
    }
  } else normalmoderawshow();
  return 0;
}

const char *RawShowAction::getDescription()
{
  return catalog.getLocaleCom(3);
}

void RawShowAction::normalmoderawshow()
{
  ListerMode *lm1;
  NormalMode *nm=NULL;
  ActionMessage amsg;
  Lister *l1;
  if(am->mode!=am->AM_MODE_DNDACTION) {
    l1=worker->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL)
        if(lm1->isType("NormalMode")==true) nm=(NormalMode*)lm1;
    }
    if(nm!=NULL) {
      List *files=new List();
      //TODO: Perhaps change ONLYSELECT in SELORACT, so also the active entry is taken
      nm->getSelFiles(files,NormalMode::NM_GETFILES_SELORACT,true);
      int id=files->initEnum();
      FileEntry *fe=NULL;
      WCFiletype *ft,*fft[4];
      List *filetypes=wconfig->getFiletypes();
      fft[0]=NULL;
      fft[1]=NULL;
      fft[2]=NULL;
      fft[3]=NULL;
    
      amsg.startLister=l1;
      amsg.mode=amsg.AM_MODE_SPECIAL;
    
      int e=filetypes->initEnum();
      ft=(WCFiletype*)filetypes->getFirstElement(e);
      while(ft!=NULL) {
        switch(ft->getinternID()) {
          case NOTYETTYPE:
            fft[0]=ft;
            break;
          case UNKNOWNTYPE:
            fft[1]=ft;
            break;
          case VOIDTYPE:
            fft[2]=ft;
            break;
        }
        ft=(WCFiletype*)filetypes->getNextElement(e);
      }
      filetypes->closeEnum(e);
      if(files->size()==0) {
        ft=fft[2];
        if(ft!=NULL) {
          amsg.extraInfo=fe;
          amsg.flags=ft->getRawShowActionsGF();
          worker->interpret(ft->getRawShowActions(),&amsg);
        }
      } else {
        NM_specialsource *ss1=(NM_specialsource*)files->getFirstElement(id);
        while(ss1!=NULL) {
          fe=ss1->entry;
          if(fe!=NULL) {
            if(fe->isDir()==false) {
              ft=fe->filetype;
              if(ft==NULL) ft=fft[0]; // not yet checked
              if(ft!=NULL) {
                amsg.extraInfo=fe;
                amsg.flags=ft->getRawShowActionsGF();
                worker->interpret(ft->getRawShowActions(),&amsg);
              }
            }
          }
          _freesafe(ss1);
          ss1=(NM_specialsource*)files->getNextElement(id);
        }
        files->closeEnum(id);
      }
      delete files;
    }
  } else {
    l1=((DNDMsg*)am->extraInfo)->getSourceLister();
    if(l1==NULL) return;

    FileEntry *fe=((DNDMsg*)am->extraInfo)->getFE();
    if(fe!=NULL) {
      WCFiletype *ft,*fft[4];
      List *filetypes=wconfig->getFiletypes();
      fft[0]=NULL;
      fft[1]=NULL;
      fft[2]=NULL;
      fft[3]=NULL;
    
      amsg.startLister=l1;
      amsg.mode=amsg.AM_MODE_SPECIAL;
    
      int e=filetypes->initEnum();
      ft=(WCFiletype*)filetypes->getFirstElement(e);
      while(ft!=NULL) {
        switch(ft->getinternID()) {
          case NOTYETTYPE:
            fft[0]=ft;
            break;
          case UNKNOWNTYPE:
            fft[1]=ft;
            break;
          case VOIDTYPE:
            fft[2]=ft;
            break;
          case DIRTYPE:
            fft[3]=ft;
            break;
        }
        ft=(WCFiletype*)filetypes->getNextElement(e);
      }
      filetypes->closeEnum(e);
      ft=fe->filetype;
      if(ft==NULL) {
        if(fe->isDir()==false) ft=fft[0]; // not yet checked
        else ft=fft[3]; // dir
      }
      if(ft!=NULL) {
        amsg.extraInfo=fe;
        amsg.flags=ft->getRawShowActionsGF();
        worker->interpret(ft->getRawShowActions(),&amsg);
      }
    }
  }
}

/***************
 Ende RawShowAction
****************/

/***********
  UserAction
************/

const char *UserAction::name="UserAction";

bool UserAction::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *UserAction::getName()
{
  return name;
}

UserAction::UserAction(Worker *tworker):FunctionProto(tworker)
{
  nr=0;
}

UserAction::~UserAction()
{
}

UserAction *UserAction::duplicate()
{
  UserAction *ta=new UserAction(worker);
  ta->nr=nr;
  return ta;
}

int UserAction::run(ActionMessage *msg)
{
  ListerMode *lm1;
  am=msg;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1=worker->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL)
        if(lm1->isType("NormalMode")==true)
          normalmodeuseraction();
    }
  } else normalmodeuseraction();
  return 0;
}

const char *UserAction::getDescription()
{
  return catalog.getLocaleCom(4);
}

void UserAction::normalmodeuseraction()
{
  ListerMode *lm1;
  NormalMode *nm=NULL;
  ActionMessage amsg;
  Lister *l1;
  if(am->mode!=am->AM_MODE_DNDACTION) {
    l1=worker->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL)
        if(lm1->isType("NormalMode")==true) nm=(NormalMode*)lm1;
    }
    if(nm!=NULL) {
      List *files=new List();
      //TODO: Perhaps change ONLYSELECT in SELORACT, so also the active entry is taken
      nm->getSelFiles(files,NormalMode::NM_GETFILES_SELORACT,true);
      int id=files->initEnum();
      FileEntry *fe=NULL;
      WCFiletype *ft,*fft[4];
      List *filetypes=wconfig->getFiletypes();
      fft[0]=NULL;
      fft[1]=NULL;
      fft[2]=NULL;
      fft[3]=NULL;
    
      amsg.startLister=l1;
      amsg.mode=amsg.AM_MODE_SPECIAL;
    
      int e=filetypes->initEnum();
      ft=(WCFiletype*)filetypes->getFirstElement(e);
      while(ft!=NULL) {
        switch(ft->getinternID()) {
          case NOTYETTYPE:
            fft[0]=ft;
            break;
          case UNKNOWNTYPE:
            fft[1]=ft;
            break;
          case VOIDTYPE:
            fft[2]=ft;
            break;
        }
        ft=(WCFiletype*)filetypes->getNextElement(e);
      }
      filetypes->closeEnum(e);
      if(files->size()==0) {
        ft=fft[2];
        if(ft!=NULL) {
          amsg.extraInfo=fe;
          amsg.flags=ft->getUserActionsGF(nr);
          worker->interpret(ft->getUserActions(nr),&amsg);
        }
      } else {
        NM_specialsource *ss1=(NM_specialsource*)files->getFirstElement(id);
        while(ss1!=NULL) {
          fe=ss1->entry;
          if(fe!=NULL) {
            if(fe->isDir()==false) {
              ft=fe->filetype;
              if(ft==NULL) ft=fft[0]; // not yet checked
              if(ft!=NULL) {
                amsg.extraInfo=fe;
                amsg.flags=ft->getUserActionsGF(nr);
                worker->interpret(ft->getUserActions(nr),&amsg);
              }
            }
          }
          _freesafe(ss1);
          ss1=(NM_specialsource*)files->getNextElement(id);
        }
        files->closeEnum(id);
      }
      delete files;
    }
  } else {
    l1=((DNDMsg*)am->extraInfo)->getSourceLister();
    if(l1==NULL) return;

    FileEntry *fe=((DNDMsg*)am->extraInfo)->getFE();
    if(fe!=NULL) {
      WCFiletype *ft,*fft[4];
      List *filetypes=wconfig->getFiletypes();
      fft[0]=NULL;
      fft[1]=NULL;
      fft[2]=NULL;
      fft[3]=NULL;
    
      amsg.startLister=l1;
      amsg.mode=amsg.AM_MODE_SPECIAL;
    
      int e=filetypes->initEnum();
      ft=(WCFiletype*)filetypes->getFirstElement(e);
      while(ft!=NULL) {
        switch(ft->getinternID()) {
          case NOTYETTYPE:
            fft[0]=ft;
            break;
          case UNKNOWNTYPE:
            fft[1]=ft;
            break;
          case VOIDTYPE:
            fft[2]=ft;
            break;
          case DIRTYPE:
            fft[3]=ft;
            break;
        }
        ft=(WCFiletype*)filetypes->getNextElement(e);
      }
      filetypes->closeEnum(e);
      ft=fe->filetype;
      if(ft==NULL) {
        if(fe->isDir()==false) ft=fft[0]; // not yet checked
        else ft=fft[3]; // dir
      }
      if(ft!=NULL) {
        amsg.extraInfo=fe;
        amsg.flags=ft->getUserActionsGF(nr);
        worker->interpret(ft->getUserActions(nr),&amsg);
      }
    }
  }
}

int UserAction::configure()
{
  AGUIX *aguix=worker->getAGUIX();
  Button *okb,*cb;
  AWindow *win;
  CycleButton *rcyb;
  int tw,w,h,x,y,t1,t2;
  AGMessage *msg;
  int endmode=-1;
  char *tstr;
  
  w=h=10;
  x=y=5;
  win=new AWindow(aguix);

  tstr=(char*)_allocsafe(strlen(catalog.getLocale(293))+strlen(catalog.getLocaleCom(4))+1);
  sprintf(tstr,catalog.getLocale(293),catalog.getLocaleCom(4));
  win->create(NULL,10,10,w,h,0,tstr);
  _freesafe(tstr);

  rcyb=(CycleButton*)win->add(new CycleButton(aguix,x,y,100,1,0,0));
  rcyb->addOption(catalog.getLocale(255));
  rcyb->addOption(catalog.getLocale(256));
  rcyb->addOption(catalog.getLocale(257));
  rcyb->addOption(catalog.getLocale(258));
  rcyb->addOption(catalog.getLocale(259));
  rcyb->addOption(catalog.getLocale(260));
  rcyb->addOption(catalog.getLocale(261));
  rcyb->addOption(catalog.getLocale(262));
  rcyb->addOption(catalog.getLocale(263));
  rcyb->addOption(catalog.getLocale(264));
  rcyb->resize(rcyb->getMaxSize(),rcyb->getHeight());
  rcyb->setOption(nr);
  
  y+=rcyb->getHeight()+5;
  tw=x+rcyb->getWidth()+5;
  if(tw>w) w=tw;
  x=5;

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  okb=(Button*)win->add(new Button(aguix,
                                   5,
                                   y,
                                   t1,
                                   catalog.getLocale(11),
                                   1,
                                   0,
                                   0));
  cb=(Button*)win->add(new Button(aguix,
                                  w-5-t2,
                                  y,
                                  t2,
                                  catalog.getLocale(8),
                                  1,
                                  0,
                                  0));
  y+=okb->getHeight()+5;
  
  h=y;
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  win->show();
  for(;endmode==-1;) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      switch(msg->type) {
        case AG_CLOSEWINDOW:
          if(msg->closewindow.window==win->getWindow()) endmode=1;
          break;
        case AG_BUTTONCLICKED:
          if(msg->button.button==okb) endmode=0;
          else if(msg->button.button==cb) endmode=1;
          break;
      }
      aguix->ReplyMessage(msg);
    }
  }
  
  if(endmode==0) {
    // ok
    nr=rcyb->getSelectedOption();
  }
  
  win->close();
  delete win;

  return endmode;
}

bool UserAction::save(Datei *fh)
{
  fh->putInt(Datei::getIntSize());
  fh->putInt(nr);
  return true;
}

int UserAction::load(Datei *fh)
{
  int chunksize=fh->getInt();
  if(chunksize>=Datei::getIntSize()) {
    nr=fh->getInt();
    chunksize-=Datei::getIntSize();
    if((nr<0)||(nr>9)) nr=0;
  }
  while(chunksize>0) {
    fh->getUChar();
    chunksize--;
  }
  return true;
}

/***************
 Ende UserAction
****************/

/*****************
 ChangeHiddenFlag
******************/

const char *ChangeHiddenFlag::name="ChangeHiddenFlag";

ChangeHiddenFlag::ChangeHiddenFlag(Worker *tworker):FunctionProto(tworker)
{
  mode=0;
}

ChangeHiddenFlag::~ChangeHiddenFlag()
{
}

ChangeHiddenFlag *ChangeHiddenFlag::duplicate()
{
  ChangeHiddenFlag *ta=new ChangeHiddenFlag(worker);
  ta->mode=mode;
  return ta;
}

bool ChangeHiddenFlag::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *ChangeHiddenFlag::getName()
{
  return name;
}

int ChangeHiddenFlag::run(ActionMessage *msg)
{
  ListerMode *lm1;
  NormalMode *nm1;
  am=msg;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1=worker->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;
          switch(mode) {
            case 1:
              nm1->setShowHiddenE(false);
              break;
            case 2:
              nm1->setShowHiddenE(true);
              break;
            default:
              nm1->toggleHiddenE();          
          }
        }
      }
    }
  }
  return 0;
}

bool ChangeHiddenFlag::save(Datei *fh)
{
  fh->putInt(Datei::getIntSize());
  fh->putInt(mode);
  return true;
}

int ChangeHiddenFlag::load(Datei *fh)
{
  int chunksize=fh->getInt();
  int i1;
  if(chunksize>=Datei::getIntSize()) {
    i1=fh->getInt();
    chunksize-=Datei::getIntSize();
    mode=i1;
    if((mode<0)||(mode>2)) mode=0;
  }
  while(chunksize>0) {
    fh->getUChar();
    chunksize--;
  }
  return true;
}

const char *ChangeHiddenFlag::getDescription()
{
  return catalog.getLocaleCom(7);
}

int ChangeHiddenFlag::configure()
{
  AGUIX *aguix=worker->getAGUIX();
  Button *okb,*cb;
  AWindow *win;
  CycleButton *rcyb;
  int tw,w,h,x,y,t1,t2;
  AGMessage *msg;
  int endmode=-1;
  char *tstr;
  
  w=h=10;
  x=y=5;
  win=new AWindow(aguix);

  tstr=(char*)_allocsafe(strlen(catalog.getLocale(293))+strlen(catalog.getLocaleCom(7))+1);
  sprintf(tstr,catalog.getLocale(293),catalog.getLocaleCom(7));
  win->create(NULL,10,10,w,h,0,tstr);
  _freesafe(tstr);

  rcyb=(CycleButton*)win->add(new CycleButton(aguix,x,y,100,1,0,0));
  rcyb->addOption(catalog.getLocale(360));
  rcyb->addOption(catalog.getLocale(361));
  rcyb->addOption(catalog.getLocale(362));
  rcyb->resize(rcyb->getMaxSize(),rcyb->getHeight());
  switch(mode) {
    case 1:
      rcyb->setOption(1);
      break;
    case 2:
      rcyb->setOption(2);
      break;
    default:
      rcyb->setOption(0);
      break;
  }
  
  y+=rcyb->getHeight()+5;
  tw=x+rcyb->getWidth()+5;
  if(tw>w) w=tw;
  x=5;

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  okb=(Button*)win->add(new Button(aguix,
                                   5,
                                   y,
                                   t1,
                                   catalog.getLocale(11),
                                   1,
                                   0,
                                   0));
  cb=(Button*)win->add(new Button(aguix,
                                  w-5-t2,
                                  y,
                                  t2,
                                  catalog.getLocale(8),
                                  1,
                                  0,
                                  0));
  y+=okb->getHeight()+5;
  
  h=y;
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  win->show();
  for(;endmode==-1;) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      switch(msg->type) {
        case AG_CLOSEWINDOW:
          if(msg->closewindow.window==win->getWindow()) endmode=1;
          break;
        case AG_BUTTONCLICKED:
          if(msg->button.button==okb) endmode=0;
          else if(msg->button.button==cb) endmode=1;
          break;
      }
      aguix->ReplyMessage(msg);
    }
  }
  
  if(endmode==0) {
    // ok
    switch(rcyb->getSelectedOption()) {
      case 1:
        mode=1;
        break;
      case 2:
        mode=2;
        break;
      default:
        mode=0;
        break;
    }
  }
  
  win->close();
  delete win;

  return endmode;
}

/**********************
 Ende ChangeHiddenFlag
***********************/

