/* cursorops.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: cursorops.h,v 1.6 2001/11/03 17:08:09 ralf Exp $ */

#ifndef CURSOROPS_H
#define CURSOROPS_H

#include "wdefines.h"
#include "functionproto.h"
class Worker;

class RowUp:public FunctionProto
{
public:
  RowUp(Worker*);
  virtual ~RowUp();
  virtual RowUp *duplicate();
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual const char *getDescription();
protected:
  static const char *name;
};

class RowDown:public FunctionProto
{
public:
  RowDown(Worker*);
  virtual ~RowDown();
  virtual RowDown *duplicate();
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual const char *getDescription();
protected:
  static const char *name;
};

class FirstRow:public FunctionProto
{
public:
  FirstRow(Worker*);
  virtual ~FirstRow();
  virtual FirstRow *duplicate();
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual const char *getDescription();
protected:
  static const char *name;
};

class LastRow:public FunctionProto
{
public:
  LastRow(Worker*);
  virtual ~LastRow();
  virtual LastRow *duplicate();
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual const char *getDescription();
protected:
  static const char *name;
};

class PageUp:public FunctionProto
{
public:
  PageUp(Worker*);
  virtual ~PageUp();
  virtual PageUp *duplicate();
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual const char *getDescription();
protected:
  static const char *name;
};

class PageDown:public FunctionProto
{
public:
  PageDown(Worker*);
  virtual ~PageDown();
  virtual PageDown *duplicate();
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual const char *getDescription();
protected:
  static const char *name;
};

class SelectOp:public FunctionProto
{
public:
  SelectOp(Worker*);
  virtual ~SelectOp();
  virtual SelectOp *duplicate();
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual const char *getDescription();
protected:
  static const char *name;
};

class SelectAllOp:public FunctionProto
{
public:
  SelectAllOp(Worker*);
  virtual ~SelectAllOp();
  virtual SelectAllOp *duplicate();
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual const char *getDescription();
protected:
  static const char *name;
};

class SelectNoneOp:public FunctionProto
{
public:
  SelectNoneOp(Worker*);
  virtual ~SelectNoneOp();
  virtual SelectNoneOp *duplicate();
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual const char *getDescription();
protected:
  static const char *name;
};

class InvertAllOp:public FunctionProto
{
public:
  InvertAllOp(Worker*);
  virtual ~InvertAllOp();
  virtual InvertAllOp *duplicate();
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual const char *getDescription();
protected:
  static const char *name;
};

class ParentDirOp:public FunctionProto
{
public:
  ParentDirOp(Worker*);
  virtual ~ParentDirOp();
  virtual ParentDirOp *duplicate();
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual const char *getDescription();
protected:
  static const char *name;
};

class EnterDirOp:public FunctionProto
{
public:
  EnterDirOp(Worker*);
  virtual ~EnterDirOp();
  virtual EnterDirOp *duplicate();
  virtual int configure();
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual const char *getDescription();
  virtual int load(Datei*);
  virtual bool save(Datei *);

  typedef enum {ENTERDIROP_ACTIVE=0,
                ENTERDIROP_ACTIVE2OTHER,
                ENTERDIROP_SPECIAL,
                ENTERDIROP_REQUEST} enterdir_t;
  void setMode(enterdir_t);
  void setDir(const char*);
protected:
  static const char *name;
  // Infos to save
  enterdir_t enterdirmode;
  char *dir;
};

#endif

