/* deleteop.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: deleteop.h,v 1.7 2002/01/05 23:46:56 ralf Exp $ */

#ifndef DELETEOP_H
#define DELETEOP_H

#include "wdefines.h"
#include "functionproto.h"
#include <aguix/awindow.h>
#include <aguix/text.h>
#include <aguix/solidbutton.h>
#include <aguix/button.h>
#include <aguix/cyclebutton.h>
#include <aguix/bevelbox.h>

class Worker;

class DeleteOp:public FunctionProto
{
public:
  DeleteOp(Worker*);
  virtual ~DeleteOp();
  virtual DeleteOp *duplicate();
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual const char *getDescription();
  virtual int configure();
  virtual int load(Datei*);
  virtual bool save(Datei *);

protected:
  static const char *name;
  // Infos to save
  bool also_active;

  // temp variables
  Lister *startlister;
  
  int normalmodedelete();
};

class DeleteOpWin
{
public:
  DeleteOpWin(AGUIX*);
  ~DeleteOpWin();
  int open();
  void close();
  // called once:
  void set_files_to_delete(long nfiles);
  void set_dirs_to_delete(long ndirs);
  
  void dir_finished();
  void file_finished();
  void setfilename(char *name);
  // for setting a message in the two lines used for display copy source/dest
  void setmessage(char *msg);
  // for dec file/dir-counter (mainly in case of skiped files/dirs
  void dec_file_counter(unsigned long f);
  void dec_dir_counter(unsigned long d);

  /* should be called in copy-loop
   * does the update of the window AND process X-events
   * returnvalues: 0 - normal exists
   *               1 - cancel/close window pressed */ 
  int redraw();
protected:
  char *source;
  long deleted_files,files;
  long deleted_dirs,dirs;
  int sbw;
  
  AGUIX *aguix;
  AWindow *window;
  Text *sourcetext,*files2gotext,*dirs2gotext;
  SolidButton *gsb;
  Button *cb;
  bool update_sourcetext,update_files2gotext,update_dirs2gotext;
  BevelBox *bb1, *bb2, *bb3;
  int melw;
  int filenamespace;
};

#endif
