/* normalops.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: normalops.h,v 1.5 2001/11/03 17:10:29 ralf Exp $ */

#ifndef NORMALOPS_H
#define NORMALOPS_H

#include "functionproto.h"
class Worker;

class ChangeListerSetOp:public FunctionProto
{
public:
  ChangeListerSetOp(Worker*);
  virtual ~ChangeListerSetOp();
  virtual ChangeListerSetOp *duplicate();
  virtual int configure();
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual const char *getDescription();
  virtual int load(Datei*);
  virtual bool save(Datei *);

  enum { CLS_LEFT_LISTER,CLS_RIGHT_LISTER,CLS_ACTUAL_LISTER,CLS_OTHER_LISTER};
  void setMode(int);
protected:
  static const char *name;
  int mode;
};

class SwitchListerOp:public FunctionProto
{
public:
  SwitchListerOp(Worker*);
  virtual ~SwitchListerOp();
  virtual SwitchListerOp *duplicate();
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual const char *getDescription();
protected:
  static const char *name;
};

class FilterSelectOp:public FunctionProto
{
public:
  FilterSelectOp(Worker*);
  virtual ~FilterSelectOp();
  virtual FilterSelectOp *duplicate();
  virtual int configure();
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual const char *getDescription();
  virtual int load(Datei*);
  virtual bool save(Datei *);
  
  bool requestfilter();
protected:
  static const char *name;
  char *filter;
  char *actual_filter;
};

class FilterUnSelectOp:public FilterSelectOp
{
public:
  FilterUnSelectOp(Worker*);
  virtual ~FilterUnSelectOp();
  virtual FilterUnSelectOp *duplicate();
  virtual int configure();
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual const char *getDescription();
  
  bool requestfilter();
protected:
  static const char *name;
};

class Path2OSideOp:public FunctionProto
{
public:
  Path2OSideOp(Worker*);
  virtual ~Path2OSideOp();
  virtual Path2OSideOp *duplicate();
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual const char *getDescription();
protected:
  static const char *name;
};

class QuitOp:public FunctionProto
{
public:
  QuitOp(Worker*);
  virtual ~QuitOp();
  virtual QuitOp *duplicate();
  virtual int configure();
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual const char *getDescription();
  virtual int load(Datei*);
  virtual bool save(Datei *);
  
  void setMode(int);
  enum {Q_NORMAL_QUIT,Q_QUICK_QUIT};
protected:
  static const char *name;
  int mode;
};

#endif

