/* shortkeyfromlist.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: shortkeyfromlistop.cc,v 1.1 2001/12/11 23:13:22 ralf Exp $ */

#include "shortkeyfromlistop.h"
#include "listermode.h"
#include "normalmode.h"
#include "worker.h"

const char *ShortkeyFromListOp::name="ShortkeyFromListOp";

ShortkeyFromListOp::ShortkeyFromListOp(Worker *tworker):FunctionProto(tworker)
{
}

ShortkeyFromListOp::~ShortkeyFromListOp()
{
}

ShortkeyFromListOp*
ShortkeyFromListOp::duplicate()
{
  ShortkeyFromListOp *ta=new ShortkeyFromListOp(worker);
  return ta;
}

bool
ShortkeyFromListOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *
ShortkeyFromListOp::getName()
{
  return name;
}

int
ShortkeyFromListOp::run(ActionMessage *msg)
{
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    worker->activateShortkeyFromList();
  }
  return 0;
}

const char *
ShortkeyFromListOp::getDescription()
{
  return catalog.getLocaleCom(42);
}

