/* showimagemode.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: showimagemode.cc,v 1.6 2001/11/03 17:10:44 ralf Exp $ */

#include "showimagemode.h"
#include "normalmode.h"
#include "locale.h"
#include "wconfig.h"
#include "worker.h"

#define DEFAULT_SHOW_PROGRAM "xliwrapper_worker %d %d %d %d %x \"%s\" %s"

const char *ShowImageMode::type="ShowImageMode";

ShowImageMode::ShowImageMode(Lister *parent):ListerMode(parent)
{
  x=0;
  y=0;
  w=0;
  h=0;
  imgwin=NULL;
  lastactivefe=NULL;
  show_program=dupstring(DEFAULT_SHOW_PROGRAM);
  blanked=false;
}

ShowImageMode::~ShowImageMode()
{
  lastactivefe=NULL;
  _freesafe(show_program);
}

void ShowImageMode::messageHandler(AGMessage *msg)
{
  int tx,ty,tw,th;
  bool ma=false;
  switch(msg->type) {
    case AG_SIZECHANGED:
      parentlister->getGeometry(&tx,&ty,&tw,&th);
      reconf(tx,ty,tw,th);
      break;
  }
  if(ma==true) parentlister->makeActive();
}

void ShowImageMode::on()
{
  parentlister->getGeometry(&x,&y,&w,&h);

  imgwin=new AWindow(aguix);
  imgwin->create(parentawindow,x,y,w,h,0,"");
  imgwin->show();
  
  parentlister->setActiveMode(this);
  setName();
}

void ShowImageMode::off()
{
  parentlister->setActiveMode(NULL);
  parentlister->setName("");
  imgwin->close();
  delete imgwin;
  imgwin=NULL;
  lastactivefe=NULL;
}

void ShowImageMode::reconf(int tx,int ty,int tw,int th)
{
  if((tw!=w)||(th!=h)||(tx!=x)||(ty!=y)) {
    w=tw;
    h=th;
    x=tx;
    y=ty;
    imgwin->resize(w,h);
    imgwin->move(x,y);
    update(true);
  }
}

void ShowImageMode::activate()
{
}

void ShowImageMode::deactivate()
{
}

bool ShowImageMode::isType(const char *str)
{
  if(strcmp(str,type)==0) return true; else return false;
}

const char *ShowImageMode::getType()
{
  return type;
}

int ShowImageMode::configure()
{
  Button *okb,*cb,*db;
  AWindow *win;
  StringGadget *sg;
  Text *ttext;
  int tw,ttw,tth,ttx,tty,t1,t2;
  AGMessage *msg;
  int endmode=-1;
  char *tstr;
  char **liness;
  int lines;
  Requester *req;
  int i;
  
  ttw=tth=10;
  ttx=tty=5;
  win=new AWindow(aguix);

  tstr=(char*)_allocsafe(strlen(catalog.getLocale(293))+strlen(getName())+1);
  sprintf(tstr,catalog.getLocale(293),getName());
  win->create(NULL,10,10,ttw,tth,0,tstr);
  _freesafe(tstr);

  lines=createLines(catalog.getLocale(104),&liness);

  for(i=0;i<lines;i++) {
    ttext=(Text*)win->add(new Text(aguix,ttx,tty,liness[i],1));
    tty+=ttext->getHeight()+5;
    tw=ttx+ttext->getWidth()+5;
    if(tw>ttw) ttw=tw;
  }

  sg=(StringGadget*)win->add(new StringGadget(aguix,ttx,tty,ttw-10,show_program,0));
  
  tty+=sg->getHeight()+5;
  db=(Button*)win->add(new Button(aguix,ttx,tty,ttw-10,catalog.getLocale(110),1,0,0));
  tty+=db->getHeight()+5;

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>ttw) ttw=tw;
  okb=(Button*)win->add(new Button(aguix,
                                   5,
                                   tty,
                                   t1,
                                   catalog.getLocale(11),
                                   1,
                                   0,
                                   0));
  cb=(Button*)win->add(new Button(aguix,
                                  ttw-5-t2,
                                  tty,
                                  t2,
                                  catalog.getLocale(8),
                                  1,
                                  0,
                                  0));
  tty+=okb->getHeight()+5;
  
  tth=tty;
  
  sg->resize(ttw-10,sg->getHeight());
  db->resize(ttw-10,db->getHeight());
  
  win->resize(ttw,tth);
  win->setMaxSize(ttw,tth);
  win->setMinSize(ttw,tth);
  win->show();
  req=new Requester(aguix);
  for(;endmode==-1;) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      switch(msg->type) {
        case AG_CLOSEWINDOW:
          if(msg->closewindow.window==win->getWindow()) endmode=1;
          break;
        case AG_BUTTONCLICKED:
          if(msg->button.button==okb) {
            if(checksp(sg->getText())==true) endmode=0;
            else {
              req->request(catalog.getLocale(124),catalog.getLocale(111),catalog.getLocale(11));
            }
          } else if(msg->button.button==cb) endmode=1;
          else if(msg->button.button==db) {
            sg->setText(DEFAULT_SHOW_PROGRAM);
          }
          break;
      }
      aguix->ReplyMessage(msg);
    }
  }
  delete req;
  
  if(endmode==0) {
    // ok
    if(checksp(sg->getText())==true) {
      _freesafe(show_program);
      show_program=dupstring(sg->getText());
    }
  }
  
  win->close();
  delete win;

  for(i=0;i<lines;i++) _freesafe(liness[i]);
  _freesafe(liness);

  return endmode;
}

void ShowImageMode::cyclicfunc(cyclicfunc_mode_t mode)
{
  update(false);
}

const char* ShowImageMode::getName()
{
  return catalog.getLocale(174);
}

int ShowImageMode::load(Datei *fh)
{
  int chunksize=fh->getInt();
  int is=Datei::getIntSize();
  char *tstr;
  int len;

  if(chunksize>=is) {
    len=fh->getInt();
    chunksize-=is;
    tstr=fh->getString(len);
    chunksize-=len;
    if(checksp(tstr)==true) {
      _freesafe(show_program);
      show_program=tstr;
    } else _freesafe(tstr);
  }
  while(chunksize>0) {
    fh->getUChar();
    chunksize--;
  }
  return 0;
}

bool ShowImageMode::save(Datei *fh)
{
  int cs=Datei::getIntSize()+strlen(show_program);

  fh->putInt(cs);
  fh->putInt(strlen(show_program));
  fh->putString(show_program);
  return false;
}

void ShowImageMode::setName()
{
  parentlister->setName(catalog.getLocale(174));
}

void ShowImageMode::reconfig()
{
}

void ShowImageMode::update(bool force)
{
  NormalMode *nm1=NULL;
  ListerMode *lm1=NULL;
  Lister *ol=NULL;
  List *files;
  List *colors;
  WC_Color *bgcol;
  NM_specialsource *ss1;
  FileEntry *fe;
  char *buf,*colbuf;
  
  ol=parentlister->getWorker()->getOtherLister(parentlister);
  if(ol!=NULL) {
    lm1=ol->getActiveMode();
    if(lm1!=NULL)
      if(lm1->isType("NormalMode")==true)
        nm1=(NormalMode*)lm1;
  }
  
  if(force==true) lastactivefe=NULL;
  
  if(nm1!=NULL) {
    files=new List();
    
    nm1->getSelFiles(files,NormalMode::NM_GETFILES_ONLYACTIVE);
    ss1=(NM_specialsource*)files->getFirstElement();
    if(ss1!=NULL) {
      fe=ss1->entry;
      if(fe!=lastactivefe) {
        lastactivefe=fe;
        if(lastactivefe!=NULL) {
          // first get the background color in the X format for xli
          colors=(List*)wconfig->getColors();
          bgcol=(WC_Color*)colors->getElementAt(0);
          colbuf=(char*)_allocsafe(strlen("rgb://")+3*sizeof(int)+1);
          sprintf(colbuf,"rgb:%x/%x/%x",bgcol->red,bgcol->green,bgcol->blue);
        
          buf=(char*)_allocsafe(strlen(show_program)+10+32+32+32+32+strlen(lastactivefe->fullname)+
                                strlen(colbuf)+1);
          
          blank();
          sprintf(buf,show_program,0,0,w,h,imgwin->getWindow(),lastactivefe->fullname,colbuf);
          system(buf);
          blanked=false;
          
          _freesafe(buf);
          _freesafe(colbuf);
        }
      }
    } else {
      lastactivefe=NULL;
      blank();
    }
    
    ss1=(NM_specialsource*)files->getFirstElement();
    while(ss1!=NULL) {
      _freesafe(ss1);
      ss1=(NM_specialsource*)files->getNextElement();
    }
    
    delete files;
  }
}

bool ShowImageMode::checksp(const char *str)
{
/* Zu pruefen:
   4x %d
   1x %x
   2x %s
   in der Reihenfolge */
  bool returnvalue=false;
  int mode=0;
  int pos=0;
  int ch;
  while(str[pos]!='\0') {
    ch=str[pos++];
    switch(mode) {
      case 1:
        if(ch=='d') mode=2;
        else if(ch=='%') mode=0;
        else mode=13;
        break;
      case 2:
        if(ch=='%') mode=3;
        break;
      case 3:
        if(ch=='d') mode=4;
        else if(ch=='%') mode=2;
        else mode=13;
        break;
      case 4:
        if(ch=='%') mode=5;
        break;
      case 5:
        if(ch=='d') mode=6;
        else if(ch=='%') mode=4;
        else mode=13;
        break;
      case 6:
        if(ch=='%') mode=7;
        break;
      case 7:
        if(ch=='d') mode=8;
        else if(ch=='%') mode=6;
        else mode=13;
        break;
      case 8:
        if(ch=='%') mode=9;
        break;
      case 9:
        if(ch=='x') mode=10;
        else if(ch=='%') mode=8;
        else mode=13;
        break;
      case 10:
        if(ch=='%') mode=11;
        break;
      case 11:
        if(ch=='s') mode=14;
        else if(ch=='%') mode=10;
        else mode=13;
        break;
      case 12:// accept
        break;
      case 13:// reject
        break;
      case 14:
        if(ch=='%') mode=15;
        break;
      case 15:
        if(ch=='s') mode=12;
        else if(ch=='%') mode=14;
        else mode=13;
        break;
      default:
        if(ch=='%') mode=1;
        break;
    }
  }
  if(mode==12) returnvalue=true;
  return returnvalue;
}

void ShowImageMode::blank()
{
  if(blanked==false) {
    XSetWindowAttributes attr;
    attr.background_pixel=aguix->getPixel(0);
    attr.background_pixmap=None;
    XChangeWindowAttributes(aguix->getDisplay(),imgwin->getWindow(),CWBackPixel|CWBackPixmap,&attr);
    XClearWindow(aguix->getDisplay(),imgwin->getWindow());
    aguix->Flush();
  }
  blanked=true;
}

