/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*- */
/* writerperfect
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Major Contributor(s):
 * Copyright (C) 2002-2004 William Lachance (wrlach@gmail.com)
 * Copyright (C) 2004-2006 Fridrich Strba (fridrich.strba@bluewin.ch)
 *
 * For minor contributions see the git repository.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libwpd.sourceforge.net
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifndef VERSION
#define VERSION "UNKNOWN VERSION"
#endif

#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include <libepubgen/libepubgen.h>

#include <libmwaw/libmwaw.hxx>

#include "EpubPackage.hxx"

class EpubOutputFileHelper
{
public:
	EpubOutputFileHelper(const char *const outFileName) :
		m_fileName(outFileName)
	{
	}

	bool convertDocument(librevenge::RVNGInputStream &input)
	{
		EpubPackage package(m_fileName ? m_fileName : "");
		libepubgen::EPUBTextGenerator collector(&package);

		return MWAWDocument::MWAW_R_OK == MWAWDocument::parse(&input, &collector);
	}

	bool isSupportedFormat(librevenge::RVNGInputStream &input)
	{
		MWAWDocument::Type type;
		MWAWDocument::Kind kind;
		MWAWDocument::Confidence confidence = MWAWDocument::isFileFormatSupported(&input, type, kind);
		if (confidence != MWAWDocument::MWAW_C_EXCELLENT)
		{
			fprintf(stderr, "ERROR: We have no confidence that you are giving us a valid Mac Classic document.\n");
			return false;
		}
		return kind == MWAWDocument::MWAW_K_TEXT;
	}

private:
	const char *m_fileName;
};

int printUsage(char *name)
{
	// TODO: allow to write data on output
	fprintf(stderr, "Usage : %s <infile> <outfile>\n", name);
	fprintf(stderr, "\twhere <infile> is the Mac source document\n");
	fprintf(stderr, "\tand <outfile> is the ePub target document.\n");
	fprintf(stderr, "Options:\n");
	fprintf(stderr, "\t-h:                Shows this help message\n");
	fprintf(stderr, "\t-v:                Output %s version \n", name);
	return 1;
}

int printVersion(char const *name)
{
	printf("%s %s\n", name, VERSION);
	return 0;
}

int main(int argc, char *argv[])
{
	bool printHelp=false;
	int ch;

	while ((ch = getopt(argc, argv, "hv")) != -1)
	{
		switch (ch)
		{
		case 'v':
			printVersion(argv[0]);
			return 0;
		case 'h':
		default:
			printHelp=true;
			break;
		}
	}
	// TODO: allow to write data on output
	if (argc != 2+optind || printHelp)
	{
		printUsage(argv[0]);
		return -1;
	}

	char const *szInputFile = argv[optind];
	char const *szOutFile = (argc == 2+optind) ? argv[optind+1] : 0;

	librevenge::RVNGFileStream input(szInputFile);
	EpubOutputFileHelper helper(szOutFile);

	if (!helper.isSupportedFormat(input))
	{
		fprintf(stderr, "ERROR: the document is not in any supported format.\n");
		return 1;
	}

	if (!helper.convertDocument(input))
	{
		fprintf(stderr, "ERROR : Couldn't convert the document\n");
		return 1;
	}

	return 0;
}

/* vim:set shiftwidth=4 softtabstop=4 noexpandtab: */
