/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef SoundCard_H
#define	SoundCard_H

#include "SoundDev.h"

#include <wx/wx.h>

#ifdef __WINDOWS__
#include <windows.h>
#include <mmsystem.h>

const int NUM_IN_OUT_CHANNELS = 1;
const int BYTES_PER_SAMPLE    = 2;	/* Must be the same as the size of wxInt16 */
const int BITS_PER_SAMPLE     = BYTES_PER_SAMPLE * 8;

const int NUM_SOUND_BUFFERS_IN  = 30;
const int NUM_SOUND_BUFFERS_OUT = 30;
#endif

class CSoundCard : public ISoundDev {

    public:
    	CSoundCard(const wxString& device, int sampleRate, int rxBufferSize, int txBufferSize);
	virtual ~CSoundCard();

	virtual void openWrite();
	virtual void openRead();

	virtual void read(double* sample, int& len);
	virtual void write(double* sample, int len);

	virtual void close();

	static wxArrayString getDevices();

    private:
	wxString m_device;
	int      m_sampleRate;
	int      m_rxBufferSize;
	int      m_txBufferSize;

#ifdef __WINDOWS__
	UINT     m_devIn;
	HWAVEIN  m_waveIn;
	HANDLE   m_waveInEvent;
	wxInt16* m_waveInBuffer[NUM_SOUND_BUFFERS_IN];
	WAVEHDR  m_waveInHeader[NUM_SOUND_BUFFERS_IN];
	int      m_bufferInNum;

	UINT     m_devOut;
	HWAVEOUT m_waveOut;
	HANDLE   m_waveOutEvent;
	wxInt16* m_waveOutBuffer[NUM_SOUND_BUFFERS_OUT];
	WAVEHDR  m_waveOutHeader[NUM_SOUND_BUFFERS_OUT];
#else
	int      m_fd;
#endif

#ifdef __WINDOWS__
	void addInBuffer();
	void getDoneBuffer(int& iCntPrepBuf, int& iIndexDoneBuf) const;
	void addOutBuffer(int n);
#endif
};

#endif
