/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "JT6MPreferences.h"

#include "JT6MApp.h"
#include "JT6MDefs.h"

const int BORDER_SIZE = 5;

BEGIN_EVENT_TABLE(CJT6MPreferences, wxDialog)
	EVT_BUTTON(wxID_OK,     CJT6MPreferences::onOK)
	EVT_BUTTON(wxID_CANCEL, CJT6MPreferences::onCancel)
END_EVENT_TABLE()

CJT6MPreferences::CJT6MPreferences(wxWindow* parent, int id) :
wxDialog(parent, id, wxString(wxT("JT6M Preferences"))),
m_personal(NULL),
m_message(NULL),
m_sound(NULL),
m_ptt(NULL),
m_path(NULL),
m_proto(NULL)
{
	wxBoxSizer* mainSizer = new wxBoxSizer(wxVERTICAL);

	wxNotebook* noteBook = new wxNotebook(this, -1);
	wxNotebookSizer* sizer = new wxNotebookSizer(noteBook);

	wxString callsign, locator;
	::wxGetApp().getPersonal(callsign, locator);
	m_personal = new CPersonalPreferences(noteBook, -1, callsign, locator);
	noteBook->AddPage(m_personal, wxT("Personal"), true);

	wxString* messages = new wxString[JT6M_MAX_MESSAGES];
	for (int i = 0; i < JT6M_MAX_MESSAGES; i++)
		messages[i] = ::wxGetApp().getOriginalMessage(i);
	m_message = new CMessagePreferences(noteBook, -1, messages, JT6M_MAX_MESSAGES, JT6M_MAX_MESSAGE_LENGTH);
	noteBook->AddPage(m_message, wxT("Messages"), false);
	delete[] messages;

	wxString soundFileName;
	::wxGetApp().getSound(soundFileName);
	m_sound = new CSoundPreferences(noteBook, -1, soundFileName);
	noteBook->AddPage(m_sound, wxT("Sound"), false);

	wxString pttType, pttDevice;
	::wxGetApp().getPTT(pttType, pttDevice);
	m_ptt = new CPTTPreferences(noteBook, -1, pttType, pttDevice);
	noteBook->AddPage(m_ptt, wxT("PTT"), false);

	wxString pathAudio, pathText;
	::wxGetApp().getPaths(pathAudio, pathText);
	m_path = new CPathPreferences(noteBook, -1, pathAudio, pathText);
	noteBook->AddPage(m_path, wxT("Paths"), false);

	int minLength = ::wxGetApp().getMinLength();
	m_proto = new CJT6MProtocolPreferences(noteBook, -1, minLength);
	noteBook->AddPage(m_proto, wxT("JT6M"), false);

	mainSizer->Add(sizer, 1, wxALL | wxGROW, BORDER_SIZE);

	mainSizer->Add(CreateButtonSizer(wxOK | wxCANCEL), 0, wxALL | wxALIGN_RIGHT, BORDER_SIZE);

	SetAutoLayout(true);
	Layout();

	mainSizer->Fit(this);
	mainSizer->SetSizeHints(this);

	SetSizer(mainSizer);
}

CJT6MPreferences::~CJT6MPreferences()
{
}

void CJT6MPreferences::onOK(const wxCommandEvent& event)
{
	wxASSERT(m_personal != NULL);
	wxASSERT(m_message != NULL);
	wxASSERT(m_sound != NULL);
	wxASSERT(m_ptt != NULL);
	wxASSERT(m_path != NULL);
	wxASSERT(m_proto != NULL);

	if (!m_personal->isCallsignValid()) {
		wxMessageDialog dialog(this, wxT("The Callsign is not valid"), wxT("JT6M Error"), wxICON_ERROR);
		dialog.ShowModal();
		return;
	}

	if (!m_personal->isLocatorValid()) {
		wxMessageDialog dialog(this, wxT("The Locator is not valid"), wxT("JT6M Error"), wxICON_ERROR);
		dialog.ShowModal();
		return;
	}

	for (int i = 0; i < JT6M_MAX_MESSAGES; i++) {
		if (!m_message->isValid(i)) {
			wxMessageDialog dialog(this, wxT("A message is not valid"), wxT("JT6M Error"), wxICON_ERROR);
			dialog.ShowModal();
			return;
		}
	}

	wxString callsign = m_personal->getCallsign();
	wxString locator  = m_personal->getLocator();
	::wxGetApp().setPersonal(callsign, locator);

	wxString pttType   = m_ptt->getType();
	wxString pttDevice = m_ptt->getDevice();
	::wxGetApp().setPTT(pttType, pttDevice);

	wxString soundDevice = m_sound->getDevice();
	::wxGetApp().setSound(soundDevice);

	for (int i = 0; i < JT6M_MAX_MESSAGES; i++) {
		wxString message = m_message->getMessage(i);
		::wxGetApp().setMessage(i, message);
	}

	wxString pathAudio = m_path->getAudioPath();
	wxString pathText  = m_path->getTextPath();
	::wxGetApp().setPaths(pathAudio, pathText);

	int minLength = m_proto->getMinLength();
	::wxGetApp().setMinLength(minLength);

	if (IsModal()) {
		EndModal(wxID_OK);
	} else {
		SetReturnCode(wxID_OK);
		Show(false);
	}
}

void CJT6MPreferences::onCancel(const wxCommandEvent& event)
{
	if (IsModal()) {
		EndModal(wxID_CANCEL);
	} else {
		SetReturnCode(wxID_CANCEL);
		Show(false);
	}
}
