/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import com.icl.saxon.PreparedStyleSheet;
import com.icl.saxon.expr.AnyNameTest;
import com.icl.saxon.om.ElementInfo;
import com.icl.saxon.om.Name;
import com.icl.saxon.output.ContentHandlerProxy;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.style.StyleNodeFactory;
import com.icl.saxon.tree.Builder;
import com.icl.saxon.tree.DocumentImpl;
import com.icl.saxon.tree.Stripper;
import org.xml.sax.SAXException;

public abstract class EmbeddedStyleSheet {
    public static PreparedStyleSheet build(ElementInfo elementInfo) throws SAXException {
        Stripper stripper = new Stripper();
        stripper.setPreserveSpace(new AnyNameTest(), false);
        stripper.setPreserveSpace(new Name("xsl", "http://www.w3.org/1999/XSL/Transform", "text"), true);
        Builder builder = new Builder();
        builder.setStripper(stripper);
        builder.setNodeFactory(new StyleNodeFactory());
        builder.setDiscardCommentsAndPIs(true);
        stripper.setNextHandler(builder);
        Outputter outputter = new Outputter();
        ContentHandlerProxy contentHandlerProxy = new ContentHandlerProxy();
        contentHandlerProxy.setUnderlyingContentHandler(stripper);
        outputter.setEmitter(contentHandlerProxy);
        stripper.startDocument();
        elementInfo.copy(outputter);
        stripper.endDocument();
        DocumentImpl documentImpl = builder.getCurrentDocument();
        PreparedStyleSheet preparedStyleSheet = new PreparedStyleSheet();
        preparedStyleSheet.setStyleSheetDocument(documentImpl);
        return preparedStyleSheet;
    }
}

