/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.AttributeCollection;
import com.icl.saxon.expr.BooleanValue;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.NodeEnumeration;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.NumericValue;
import com.icl.saxon.expr.ObjectValue;
import com.icl.saxon.expr.SingletonEnumeration;
import com.icl.saxon.expr.SingletonNodeSet;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.CharacterSet;
import com.icl.saxon.output.ContentHandlerProxy;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.output.OutputDetails;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.tree.Builder;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.xml.sax.SAXException;

public class FragmentValue
extends SingletonNodeSet
implements Emitter {
    private char[] buffer = new char[4096];
    private int used = 0;
    private Vector events = new Vector(20, 20);
    private String baseURI = null;
    private static AttributeCollection emptyAttributeCollection = new AttributeCollection();
    private static Integer START_ELEMENT = new Integer(1);
    private static Integer END_ELEMENT = new Integer(2);
    private static Integer START_NAMESPACE = new Integer(3);
    private static Integer END_NAMESPACE = new Integer(4);
    private static Integer CHARACTERS = new Integer(5);
    private static Integer PROCESSING_INSTRUCTION = new Integer(6);
    private static Integer COMMENT = new Integer(7);
    private static Integer ESCAPING_ON = new Integer(8);
    private static Integer ESCAPING_OFF = new Integer(9);
    boolean previousCharacters;

    public FragmentValue() throws SAXException {
    }

    public FragmentValue(String string) throws SAXException {
        this.buffer = string.toCharArray();
        this.used = string.length();
    }

    public void setBaseURI(String string) {
        this.baseURI = string;
    }

    public Emitter getEmitter() throws SAXException {
        return this;
    }

    public String asString() throws SAXException {
        return new String(this.buffer, 0, this.used);
    }

    public double asNumber() throws SAXException {
        return Value.stringToNumber(this.asString());
    }

    public boolean asBoolean() throws SAXException {
        return true;
    }

    public int getCount() throws SAXException {
        return 1;
    }

    public boolean isEmpty() throws SAXException {
        return false;
    }

    public boolean isSingular() throws SAXException {
        return true;
    }

    public boolean contains(NodeInfo nodeInfo) throws SAXException {
        if (this.node == null) {
            return false;
        }
        return nodeInfo == this.node;
    }

    public Expression simplify() throws SAXException {
        return this;
    }

    public Vector getVector() throws SAXException {
        Vector<DocumentInfo> vector = new Vector<DocumentInfo>(1);
        vector.addElement(this.getRootNode());
        return vector;
    }

    public NodeInfo[] getNodes() throws SAXException {
        NodeInfo[] nodeInfoArray = new NodeInfo[]{this.getRootNode()};
        return nodeInfoArray;
    }

    public NodeInfo getFirst() throws SAXException {
        return this.getRootNode();
    }

    public NodeEnumeration enumerate() throws SAXException {
        return new SingletonEnumeration(this.getRootNode());
    }

    public boolean equals(Value value) throws SAXException {
        if (value instanceof NodeSetValue) {
            String string = this.asString();
            NodeEnumeration nodeEnumeration = ((NodeSetValue)value).enumerate();
            while (nodeEnumeration.hasMoreElements()) {
                if (!nodeEnumeration.nextElement().getValue().equals(string)) continue;
                return true;
            }
            return false;
        }
        if (value instanceof NumericValue) {
            return this.asNumber() == value.asNumber();
        }
        if (value instanceof StringValue || value instanceof ObjectValue) {
            return this.asString().equals(value.asString());
        }
        if (value instanceof BooleanValue) {
            return value.asBoolean();
        }
        throw new SAXException("Unknown data type in a relational expression");
    }

    public boolean notEquals(Value value) throws SAXException {
        if (value instanceof NodeSetValue) {
            String string = this.asString();
            NodeEnumeration nodeEnumeration = ((NodeSetValue)value).enumerate();
            while (nodeEnumeration.hasMoreElements()) {
                if (nodeEnumeration.nextElement().getValue().equals(string)) continue;
                return true;
            }
            return false;
        }
        if (value instanceof NumericValue) {
            return this.asNumber() != value.asNumber();
        }
        if (value instanceof StringValue || value instanceof ObjectValue) {
            return !this.asString().equals(value.asString());
        }
        if (value instanceof BooleanValue) {
            return !value.asBoolean();
        }
        throw new SAXException("Unknown data type in a relational expression");
    }

    public boolean compare(int n, Value value) throws SAXException {
        if (n == 11) {
            return this.equals(value);
        }
        if (n == 34) {
            return this.notEquals(value);
        }
        return new NumericValue(this.asNumber()).compare(n, value);
    }

    public int getType() {
        return 4;
    }

    public int getDataType() {
        return 4;
    }

    public String toString() {
        return "** RESULT TREE FRAGMENT **";
    }

    public void startDocument() throws SAXException {
        this.previousCharacters = false;
    }

    public void endDocument() throws SAXException {
        this.previousCharacters = false;
    }

    public void startElement(Name name, AttributeCollection attributeCollection) throws SAXException {
        this.events.addElement(START_ELEMENT);
        this.events.addElement(name);
        int n = attributeCollection.getLength();
        AttributeCollection attributeCollection2 = n == 0 ? emptyAttributeCollection : attributeCollection.copy();
        this.events.addElement(attributeCollection2);
        this.previousCharacters = false;
    }

    public void endElement(Name name) throws SAXException {
        this.events.addElement(END_ELEMENT);
        this.events.addElement(name);
        this.previousCharacters = false;
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.events.addElement(START_NAMESPACE);
        this.events.addElement(string);
        this.events.addElement(string2);
        this.previousCharacters = false;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        Object[] objectArray;
        while (this.used + n2 >= this.buffer.length) {
            objectArray = new char[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, objectArray, 0, this.used);
            this.buffer = objectArray;
        }
        System.arraycopy(cArray, n, this.buffer, this.used, n2);
        if (this.previousCharacters) {
            objectArray = (int[])this.events.elementAt(this.events.size() - 1);
            objectArray[1] = objectArray[1] + n2;
        } else {
            this.events.addElement(CHARACTERS);
            objectArray = new int[]{this.used, n2};
            this.events.addElement(objectArray);
        }
        this.used += n2;
        this.previousCharacters = true;
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.events.addElement(PROCESSING_INSTRUCTION);
        this.events.addElement(string);
        this.events.addElement(string2);
        this.previousCharacters = false;
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        this.events.addElement(COMMENT);
        this.events.addElement(new String(cArray, n, n2));
        this.previousCharacters = false;
    }

    public void setWriter(Writer writer) throws SAXException {
    }

    public void setCharacterSet(CharacterSet characterSet) throws SAXException {
    }

    public void setEscaping(boolean bl) throws SAXException {
        this.events.addElement(bl ? ESCAPING_ON : ESCAPING_OFF);
        this.previousCharacters = false;
    }

    public void setOutputDetails(OutputDetails outputDetails) throws SAXException {
    }

    public DocumentInfo getRootNode() throws SAXException {
        if (this.node != null) {
            return (DocumentInfo)this.node;
        }
        Builder builder = new Builder();
        builder.setSystemId(this.baseURI);
        ContentHandlerProxy contentHandlerProxy = new ContentHandlerProxy();
        contentHandlerProxy.setUnderlyingContentHandler(builder);
        contentHandlerProxy.setRequireWellFormed(false);
        contentHandlerProxy.startDocument();
        this.replay(contentHandlerProxy);
        contentHandlerProxy.endDocument();
        this.node = builder.getCurrentDocument();
        return (DocumentInfo)this.node;
    }

    public void copy(Outputter outputter) throws SAXException {
        Emitter emitter = outputter.getEmitter();
        this.replay(emitter);
    }

    public void replay(Emitter emitter) throws SAXException {
        Enumeration enumeration = this.events.elements();
        while (enumeration.hasMoreElements()) {
            Object e;
            Object e2;
            Object e3 = enumeration.nextElement();
            if (e3 == START_ELEMENT) {
                e2 = enumeration.nextElement();
                e = enumeration.nextElement();
                emitter.startElement((Name)e2, (AttributeCollection)e);
                continue;
            }
            if (e3 == END_ELEMENT) {
                e2 = enumeration.nextElement();
                emitter.endElement((Name)e2);
                continue;
            }
            if (e3 == CHARACTERS) {
                e2 = enumeration.nextElement();
                emitter.characters(this.buffer, ((int[])e2)[0], ((int[])e2)[1]);
                continue;
            }
            if (e3 == START_NAMESPACE) {
                e2 = enumeration.nextElement();
                e = enumeration.nextElement();
                emitter.startPrefixMapping((String)e2, (String)e);
                continue;
            }
            if (e3 == PROCESSING_INSTRUCTION) {
                e2 = enumeration.nextElement();
                e = enumeration.nextElement();
                emitter.processingInstruction((String)e2, (String)e);
                continue;
            }
            if (e3 == COMMENT) {
                e2 = enumeration.nextElement();
                emitter.comment(((String)e2).toCharArray(), 0, ((String)e2).length());
                continue;
            }
            if (e3 == ESCAPING_ON) {
                emitter.setEscaping(true);
                continue;
            }
            if (e3 == ESCAPING_OFF) {
                emitter.setEscaping(false);
                continue;
            }
            throw new SAXException("Corrupt data in Result Tree Fragment: " + e3);
        }
    }
}

