/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.40
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIGJAVA
#define SWIG_DIRECTORS


#ifdef __cplusplus
/* SwigValueWrapper is described in swig.swg */
template<typename T> class SwigValueWrapper {
  struct SwigMovePointer {
    T *ptr;
    SwigMovePointer(T *p) : ptr(p) { }
    ~SwigMovePointer() { delete ptr; }
    SwigMovePointer& operator=(SwigMovePointer& rhs) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = rhs.ptr; rhs.ptr = 0; return *this; }
  } pointer;
  SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
  SwigValueWrapper(const SwigValueWrapper<T>& rhs);
public:
  SwigValueWrapper() : pointer(0) { }
  SwigValueWrapper& operator=(const T& t) { SwigMovePointer tmp(new T(t)); pointer = tmp; return *this; }
  operator T&() const { return *pointer.ptr; }
  T *operator&() { return pointer.ptr; }
};

template <typename T> T SwigValueInit() {
  return T();
}
#endif

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__)) 
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__)) 
# else
#   define SWIGUNUSED 
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif 
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#  ifndef GCC_HASCLASSVISIBILITY
#    define GCC_HASCLASSVISIBILITY
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif



/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTEL_COMPILER)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" }
  };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else

/*  Errors in SWIG */
#define  SWIG_UnknownError    	   -1 
#define  SWIG_IOError        	   -2 
#define  SWIG_RuntimeError   	   -3 
#define  SWIG_IndexError     	   -4 
#define  SWIG_TypeError      	   -5 
#define  SWIG_DivisionByZero 	   -6 
#define  SWIG_OverflowError  	   -7 
#define  SWIG_SyntaxError    	   -8 
#define  SWIG_ValueError     	   -9 
#define  SWIG_SystemError    	   -10
#define  SWIG_AttributeError 	   -11
#define  SWIG_MemoryError    	   -12 
#define  SWIG_NullReferenceError   -13



/* -----------------------------------------------------------------------------
 * See the LICENSE file for information on copyright, usage and redistribution
 * of SWIG, and the README file for authors - http://www.swig.org/release.html.
 *
 * director.swg
 *
 * This file contains support for director classes that proxy
 * method calls from C++ to Java extensions.
 * ----------------------------------------------------------------------------- */

#ifdef __cplusplus

#if defined(DEBUG_DIRECTOR_OWNED)
#include <iostream>
#endif

namespace Swig {
  /* Java object wrapper */
  class JObjectWrapper {
  public:
    JObjectWrapper() : jthis_(NULL), weak_global_(true) {
    }

    ~JObjectWrapper() {
      jthis_ = NULL;
      weak_global_ = true;
    }

    bool set(JNIEnv *jenv, jobject jobj, bool mem_own, bool weak_global) {
      if (!jthis_) {
        weak_global_ = weak_global;
        if (jobj)
          jthis_ = ((weak_global_ || !mem_own) ? jenv->NewWeakGlobalRef(jobj) : jenv->NewGlobalRef(jobj));
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> " << jthis_ << std::endl;
#endif
        return true;
      } else {
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> already set" << std::endl;
#endif
        return false;
      }
    }

    jobject get(JNIEnv *jenv) const {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::get(";
      if (jthis_)
        std::cout << jthis_;
      else
        std::cout << "null";
      std::cout << ") -> return new local ref" << std::endl;
#endif
      return (jthis_ ? jenv->NewLocalRef(jthis_) : jthis_);
    }

    void release(JNIEnv *jenv) {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::release(" << jthis_ << "): " << (weak_global_ ? "weak global ref" : "global ref") << std::endl;
#endif
      if (jthis_) {
        if (weak_global_) {
          if (jenv->IsSameObject(jthis_, NULL) == JNI_FALSE)
            jenv->DeleteWeakGlobalRef((jweak)jthis_);
        } else
          jenv->DeleteGlobalRef(jthis_);
      }

      jthis_ = NULL;
      weak_global_ = true;
    }

    jobject peek() {
      return jthis_;
    }

    /* Java proxy releases ownership of C++ object, C++ object is now
       responsible for destruction (creates NewGlobalRef to pin Java
       proxy) */
    void java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      if (take_or_release) {  /* Java takes ownership of C++ object's lifetime. */
        if (!weak_global_) {
          jenv->DeleteGlobalRef(jthis_);
          jthis_ = jenv->NewWeakGlobalRef(jself);
          weak_global_ = true;
        }
      } else { /* Java releases ownership of C++ object's lifetime */
        if (weak_global_) {
          jenv->DeleteWeakGlobalRef((jweak)jthis_);
          jthis_ = jenv->NewGlobalRef(jself);
          weak_global_ = false;
        }
      }
    }

  private:
    /* pointer to Java object */
    jobject jthis_;
    /* Local or global reference flag */
    bool weak_global_;
  };

  /* director base class */
  class Director {
    /* pointer to Java virtual machine */
    JavaVM *swig_jvm_;

  protected:
#if defined (_MSC_VER) && (_MSC_VER<1300)
    class JNIEnvWrapper;
    friend class JNIEnvWrapper;
#endif
    /* Utility class for managing the JNI environment */
    class JNIEnvWrapper {
      const Director *director_;
      JNIEnv *jenv_;
    public:
      JNIEnvWrapper(const Director *director) : director_(director), jenv_(0) {
#if defined(SWIG_JAVA_ATTACH_CURRENT_THREAD_AS_DAEMON)
        // Attach a daemon thread to the JVM. Useful when the JVM should not wait for 
        // the thread to exit upon shutdown. Only for jdk-1.4 and later.
        director_->swig_jvm_->AttachCurrentThreadAsDaemon((void **) &jenv_, NULL);
#else
        director_->swig_jvm_->AttachCurrentThread((void **) &jenv_, NULL);
#endif
      }
      ~JNIEnvWrapper() {
#if !defined(SWIG_JAVA_NO_DETACH_CURRENT_THREAD)
        // Some JVMs, eg jdk-1.4.2 and lower on Solaris have a bug and crash with the DetachCurrentThread call.
        // However, without this call, the JVM hangs on exit when the thread was not created by the JVM and creates a memory leak.
        director_->swig_jvm_->DetachCurrentThread();
#endif
      }
      JNIEnv *getJNIEnv() const {
        return jenv_;
      }
    };

    /* Java object wrapper */
    JObjectWrapper swig_self_;

    /* Disconnect director from Java object */
    void swig_disconnect_director_self(const char *disconn_method) {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      jobject jobj = swig_self_.peek();
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "Swig::Director::disconnect_director_self(" << jobj << ")" << std::endl;
#endif
      if (jobj && jenv->IsSameObject(jobj, NULL) == JNI_FALSE) {
        jmethodID disconn_meth = jenv->GetMethodID(jenv->GetObjectClass(jobj), disconn_method, "()V");
        if (disconn_meth) {
#if defined(DEBUG_DIRECTOR_OWNED)
          std::cout << "Swig::Director::disconnect_director_self upcall to " << disconn_method << std::endl;
#endif
          jenv->CallVoidMethod(jobj, disconn_meth);
        }
      }
    }

  public:
    Director(JNIEnv *jenv) : swig_jvm_((JavaVM *) NULL), swig_self_() {
      /* Acquire the Java VM pointer */
      jenv->GetJavaVM(&swig_jvm_);
    }

    virtual ~Director() {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      swig_self_.release(jenv);
    }

    bool swig_set_self(JNIEnv *jenv, jobject jself, bool mem_own, bool weak_global) {
      return swig_self_.set(jenv, jself, mem_own, weak_global);
    }

    jobject swig_get_self(JNIEnv *jenv) const {
      return swig_self_.get(jenv);
    }

    // Change C++ object's ownership, relative to Java
    void swig_java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      swig_self_.java_change_ownership(jenv, jself, take_or_release);
    }
  };
}

#endif /* __cplusplus */


namespace Swig {
  static jclass jclass_XapianJNI = NULL;
  static jmethodID director_methids[20];
}

/* xapian.i: the Xapian scripting interface.
 *
 * Copyright 1999,2000,2001 BrightStation PLC
 * Copyright 2001,2002 Ananova Ltd
 * Copyright 2002,2003,2005 James Aylett
 * Copyright 2002,2003,2004,2005,2006,2007,2008,2009,2010 Olly Betts
 * Copyright 2007 Lemur Consulting Ltd
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */


/** @file xapian-head.i
 * @brief Header for SWIG interface file for Xapian.
 */
/* Copyright (C) 2005,2006,2007,2008,2009 Olly Betts
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

// Disable any deprecation warnings for Xapian methods/functions/classes.
#define XAPIAN_DEPRECATED(D) D
#include <xapian.h>

#include <string>
#include <vector>

using namespace std;

// If a backend has been disabled in xapian-core (manually or automatically) we
// include a stub definition here so the bindings can still be built.
namespace Xapian {
#ifndef XAPIAN_HAS_BRASS_BACKEND
    namespace Brass {
	static Database open(const string &) {
	    throw FeatureUnavailableError("Brass backend not supported");
	}
	static WritableDatabase open(const string &, int, int = 8192) {
	    throw FeatureUnavailableError("Brass backend not supported");
	}
    }
#endif

#ifndef XAPIAN_HAS_CHERT_BACKEND
    namespace Chert {
	static Database open(const string &) {
	    throw FeatureUnavailableError("Chert backend not supported");
	}
	static WritableDatabase open(const string &, int, int = 8192) {
	    throw FeatureUnavailableError("Chert backend not supported");
	}
    }
#endif

#ifndef XAPIAN_HAS_FLINT_BACKEND
    namespace Flint {
	static Database open(const string &) {
	    throw FeatureUnavailableError("Flint backend not supported");
	}
	static WritableDatabase open(const string &, int, int = 8192) {
	    throw FeatureUnavailableError("Flint backend not supported");
	}
    }
#endif

#ifndef XAPIAN_HAS_INMEMORY_BACKEND
    namespace InMemory {
	static WritableDatabase open() {
	    throw FeatureUnavailableError("InMemory backend not supported");
	}
    }
#endif

#ifndef XAPIAN_HAS_REMOTE_BACKEND
    namespace Remote {
	static Database open(const string &, unsigned int, timeout = 0, timeout = 0) {
	    throw FeatureUnavailableError("Remote backend not supported");
	}

	static WritableDatabase open_writable(const string &, unsigned int, timeout = 0, timeout = 0) {
	    throw FeatureUnavailableError("Remote backend not supported");
	}

	static Database open(const string &, const string &, timeout = 0) {
	    throw FeatureUnavailableError("Remote backend not supported");
	}

	static WritableDatabase open_writable(const string &, const string &, timeout = 0) {
	    throw FeatureUnavailableError("Remote backend not supported");
	}
    }
#endif
}


#include <stdexcept>


#include <string>


#include <vector>
#include <stdexcept>


#include <map>
#include <algorithm>
#include <stdexcept>


SWIGINTERN void SWIG_JavaException(JNIEnv *jenv, int code, const char *msg) {
  SWIG_JavaExceptionCodes exception_code = SWIG_JavaUnknownError;
  switch(code) {
  case SWIG_MemoryError:
    exception_code = SWIG_JavaOutOfMemoryError;
    break;
  case SWIG_IOError:
    exception_code = SWIG_JavaIOException;
    break;
  case SWIG_SystemError:
  case SWIG_RuntimeError:
    exception_code = SWIG_JavaRuntimeException;
    break;
  case SWIG_OverflowError:
  case SWIG_IndexError:
    exception_code = SWIG_JavaIndexOutOfBoundsException;
    break;
  case SWIG_DivisionByZero:
    exception_code = SWIG_JavaArithmeticException;
    break;
  case SWIG_SyntaxError:
  case SWIG_ValueError:
  case SWIG_TypeError:
    exception_code = SWIG_JavaIllegalArgumentException;
    break;
  case SWIG_UnknownError:
  default:
    exception_code = SWIG_JavaUnknownError;
    break;
  }
  SWIG_JavaThrowException(jenv, exception_code, msg);
}


#include <stdexcept>


#include <utility>


/* java-swig/util.i: custom Java typemaps for xapian-bindings
 *
 * Copyright (c) 2007,2009 Olly Betts
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

// In Java, we don't get SWIG_exception in the generated C++ wrapper sources.
# define XapianException(TYPE, MSG) SWIG_JavaException(jenv, TYPE, (MSG).c_str())


namespace Xapian {

// Wrap Xapian::version_string as Xapian.Version.String() as Java can't have
// functions outside a class and we don't want Xapian.Xapian.versionString()!
class Version {
  private:
    Version();
    ~Version();
  public:
    static const char * String() { return Xapian::version_string(); }
    static int Major() { return Xapian::major_version(); }
    static int Minor() { return Xapian::minor_version(); }
    static int Revision() { return Xapian::revision(); }
};

}


#ifndef XapianException
# define XapianException(TYPE, MSG) SWIG_exception((TYPE), (MSG).c_str())
#endif

static int XapianExceptionHandler(string & msg) {
    try {
	// Rethrow so we can look at the exception if it was a Xapian::Error.
	throw;
    } catch (const Xapian::Error &e) {
	msg = e.get_type();
	msg += ": ";
	msg += e.get_msg();
	try {
	    // Re-rethrow the previous exception so we can handle the type in a
	    // fine-grained way, but only in one place to avoid bloating the
	    // file.
	    throw;
	} catch (const Xapian::InvalidArgumentError &e) {
	    return SWIG_ValueError;
	} catch (const Xapian::RangeError &e) {
	    return SWIG_IndexError;
	} catch (const Xapian::DatabaseError &) {
	    return SWIG_IOError;
	} catch (const Xapian::NetworkError &) {
	    return SWIG_IOError;
	} catch (const Xapian::InternalError &) {
	    return SWIG_RuntimeError;
	} catch (const Xapian::RuntimeError &) {
	    return SWIG_RuntimeError;
	} catch (...) {
	    return SWIG_UnknownError;
	}
    } catch (...) {
	msg = "unknown error in Xapian";
    }
    return SWIG_UnknownError;
}

SWIGINTERN Xapian::termpos Xapian_PositionIterator_get_termpos(Xapian::PositionIterator const *self){
	    return *(*self);
	}
SWIGINTERN Xapian::termpos Xapian_PositionIterator_next(Xapian::PositionIterator *self){ return *(++(*self)); }
SWIGINTERN bool Xapian_PositionIterator_equals(Xapian::PositionIterator const *self,Xapian::PositionIterator const &other){
	    return (*self) == other;
	}
SWIGINTERN bool Xapian_PostingIterator_hasNext(Xapian::PostingIterator const *self){ return (*self) == Xapian::PostingIterator(); }
SWIGINTERN Xapian::docid Xapian_PostingIterator_get_docid(Xapian::PostingIterator const *self){
	return *(*self);
    }
SWIGINTERN Xapian::docid Xapian_PostingIterator_next(Xapian::PostingIterator *self){ return *(++(*self)); }
SWIGINTERN bool Xapian_PostingIterator_equals(Xapian::PostingIterator const *self,Xapian::PostingIterator const &other){
	return (*self) == other;
    }
SWIGINTERN std::string Xapian_TermIterator_get_term(Xapian::TermIterator const *self){
	    return *(*self);
	}
SWIGINTERN std::string Xapian_TermIterator_next(Xapian::TermIterator *self){ return *(++(*self)); }
SWIGINTERN bool Xapian_TermIterator_equals(Xapian::TermIterator const *self,Xapian::TermIterator const &other){
	    return (*self) == other;
	}
SWIGINTERN bool Xapian_TermIterator_hasNext(Xapian::TermIterator const *self){ return (*self) == Xapian::TermIterator(); }
SWIGINTERN std::string Xapian_ValueIterator_get_value(Xapian::ValueIterator const *self){
	    return *(*self);
	}
SWIGINTERN std::string Xapian_ValueIterator_next(Xapian::ValueIterator *self){ return *(++(*self)); }
SWIGINTERN bool Xapian_ValueIterator_equals(Xapian::ValueIterator const *self,Xapian::ValueIterator const &other){
	    return (*self) == other;
	}
SWIGINTERN bool Xapian_ValueIterator_hasNext(Xapian::ValueIterator const *self){ return (*self) == Xapian::ValueIterator(); }
SWIGINTERN Xapian::MSetIterator Xapian_MSet_get_hit(Xapian::MSet const *self,Xapian::doccount i){
	    return ((*self)[i]);
	}
SWIGINTERN int Xapian_MSet_get_document_percentage(Xapian::MSet const *self,Xapian::doccount i){
	    return (*self).convert_to_percent( ((*self)[i]) );
	}
SWIGINTERN Xapian::Document const Xapian_MSet_get_document(Xapian::MSet const *self,Xapian::doccount i){
	    return ((*self)[i]).get_document();
	}
SWIGINTERN Xapian::docid Xapian_MSet_get_docid(Xapian::MSet const *self,Xapian::doccount i){
	    return *((*self)[i]);
	}
SWIGINTERN Xapian::MSetIterator Xapian_MSet_getElement(Xapian::MSet const *self,Xapian::doccount i){
	    return ((*self)[i]);
	}
SWIGINTERN Xapian::docid Xapian_MSetIterator_get_docid(Xapian::MSetIterator const *self){
	    return *(*self);
	}
SWIGINTERN Xapian::docid Xapian_MSetIterator_next(Xapian::MSetIterator *self){ return *(++(*self)); }
SWIGINTERN Xapian::docid Xapian_MSetIterator_prev(Xapian::MSetIterator *self){ return *(--(*self)); }
SWIGINTERN bool Xapian_MSetIterator_equals(Xapian::MSetIterator const *self,Xapian::MSetIterator const &other){
	    return (*self) == other;
	}
SWIGINTERN std::string Xapian_ESetIterator_get_term(Xapian::ESetIterator const *self){
	    return *(*self);
	}
SWIGINTERN std::string Xapian_ESetIterator_next(Xapian::ESetIterator *self){ return *(++(*self)); }
SWIGINTERN std::string Xapian_ESetIterator_prev(Xapian::ESetIterator *self){ return *(--(*self)); }
SWIGINTERN bool Xapian_ESetIterator_equals(Xapian::ESetIterator const *self,Xapian::ESetIterator const &other){
	    return (*self) == other;
	}
SWIGINTERN Xapian::Query *new_Xapian_Query__SWIG_13(Xapian::Query::op op,std::vector< std::string > const &subqs,Xapian::termcount param=0){
		return new Xapian::Query(op, subqs.begin(), subqs.end(), param);
	    }
SWIGINTERN Xapian::Query *new_Xapian_Query__SWIG_15(Xapian::Query::op op,std::vector< Xapian::Query > const &subqs,Xapian::termcount param=0){
		return new Xapian::Query(op, subqs.begin(), subqs.end(), param);
	    }


/* ---------------------------------------------------
 * C++ director class methods
 * --------------------------------------------------- */

#include "xapian_wrap.h"

SwigDirector_PostingSource::SwigDirector_PostingSource(JNIEnv *jenv) : Xapian::PostingSource(), Swig::Director(jenv) {
}

SwigDirector_PostingSource::~SwigDirector_PostingSource() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


Xapian::doccount SwigDirector_PostingSource::get_termfreq_min() const {
  Xapian::doccount c_result = SwigValueInit< Xapian::doccount >() ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Xapian::PostingSource::get_termfreq_min.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_XapianJNI, Swig::director_methids[0], swigjobj);
    if (jenv->ExceptionOccurred()) return c_result;
    c_result = (Xapian::doccount)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

Xapian::doccount SwigDirector_PostingSource::get_termfreq_est() const {
  Xapian::doccount c_result = SwigValueInit< Xapian::doccount >() ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Xapian::PostingSource::get_termfreq_est.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_XapianJNI, Swig::director_methids[1], swigjobj);
    if (jenv->ExceptionOccurred()) return c_result;
    c_result = (Xapian::doccount)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

Xapian::doccount SwigDirector_PostingSource::get_termfreq_max() const {
  Xapian::doccount c_result = SwigValueInit< Xapian::doccount >() ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[2]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Xapian::PostingSource::get_termfreq_max.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_XapianJNI, Swig::director_methids[2], swigjobj);
    if (jenv->ExceptionOccurred()) return c_result;
    c_result = (Xapian::doccount)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

Xapian::weight SwigDirector_PostingSource::get_weight() const {
  Xapian::weight c_result = SwigValueInit< Xapian::weight >() ;
  jdouble jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[3]) {
    return Xapian::PostingSource::get_weight();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jdouble) jenv->CallStaticDoubleMethod(Swig::jclass_XapianJNI, Swig::director_methids[3], swigjobj);
    if (jenv->ExceptionOccurred()) return c_result;
    c_result = (Xapian::weight)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

Xapian::docid SwigDirector_PostingSource::get_docid() const {
  Xapian::docid c_result = SwigValueInit< Xapian::docid >() ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[4]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Xapian::PostingSource::get_docid.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_XapianJNI, Swig::director_methids[4], swigjobj);
    if (jenv->ExceptionOccurred()) return c_result;
    c_result = (Xapian::docid)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_PostingSource::next(Xapian::weight min_wt) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jdouble jmin_wt  ;
  
  if (!swig_override[5]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Xapian::PostingSource::next.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jmin_wt = (jdouble) min_wt;
    jenv->CallStaticVoidMethod(Swig::jclass_XapianJNI, Swig::director_methids[5], swigjobj, jmin_wt);
    if (jenv->ExceptionOccurred()) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_PostingSource::skip_to(Xapian::docid did, Xapian::weight min_wt) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jdid  ;
  jdouble jmin_wt  ;
  
  if (!swig_override[6]) {
    Xapian::PostingSource::skip_to(did,min_wt);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jdid = (jlong) did;
    jmin_wt = (jdouble) min_wt;
    jenv->CallStaticVoidMethod(Swig::jclass_XapianJNI, Swig::director_methids[6], swigjobj, jdid, jmin_wt);
    if (jenv->ExceptionOccurred()) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

bool SwigDirector_PostingSource::check(Xapian::docid did, Xapian::weight min_wt) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jdid  ;
  jdouble jmin_wt  ;
  
  if (!swig_override[7]) {
    return Xapian::PostingSource::check(did,min_wt);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jdid = (jlong) did;
    jmin_wt = (jdouble) min_wt;
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_XapianJNI, Swig::director_methids[7], swigjobj, jdid, jmin_wt);
    if (jenv->ExceptionOccurred()) return c_result;
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_PostingSource::at_end() const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[8]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Xapian::PostingSource::at_end.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_XapianJNI, Swig::director_methids[8], swigjobj);
    if (jenv->ExceptionOccurred()) return c_result;
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

Xapian::PostingSource *SwigDirector_PostingSource::clone() const {
  return Xapian::PostingSource::clone();
}

std::string SwigDirector_PostingSource::name() const {
  std::string c_result ;
  jstring jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[9]) {
    return Xapian::PostingSource::name();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jstring) jenv->CallStaticObjectMethod(Swig::jclass_XapianJNI, Swig::director_methids[9], swigjobj);
    if (jenv->ExceptionOccurred()) return c_result;
    if(!jresult) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
      return c_result;
    } 
    const char *c_result_pstr = (const char *)jenv->GetStringUTFChars(jresult, 0); 
    if (!c_result_pstr) return c_result;
    c_result.assign(c_result_pstr);
    jenv->ReleaseStringUTFChars(jresult, c_result_pstr); 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

std::string SwigDirector_PostingSource::serialise() const {
  return Xapian::PostingSource::serialise();
}

Xapian::PostingSource *SwigDirector_PostingSource::unserialise(std::string const &s) const {
  return Xapian::PostingSource::unserialise(s);
}

void SwigDirector_PostingSource::init(Xapian::Database const &db) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jdb = 0 ;
  
  if (!swig_override[10]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Xapian::PostingSource::init.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(Xapian::Database **)&jdb = (Xapian::Database *) &db; 
    jenv->CallStaticVoidMethod(Swig::jclass_XapianJNI, Swig::director_methids[10], swigjobj, jdb);
    if (jenv->ExceptionOccurred()) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

std::string SwigDirector_PostingSource::get_description() const {
  std::string c_result ;
  jstring jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[11]) {
    return Xapian::PostingSource::get_description();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jstring) jenv->CallStaticObjectMethod(Swig::jclass_XapianJNI, Swig::director_methids[11], swigjobj);
    if (jenv->ExceptionOccurred()) return c_result;
    if(!jresult) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
      return c_result;
    } 
    const char *c_result_pstr = (const char *)jenv->GetStringUTFChars(jresult, 0); 
    if (!c_result_pstr) return c_result;
    c_result.assign(c_result_pstr);
    jenv->ReleaseStringUTFChars(jresult, c_result_pstr); 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_PostingSource::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "getTermfreqMin", "()J", NULL 
    },
    {
      "getTermfreqEst", "()J", NULL 
    },
    {
      "getTermfreqMax", "()J", NULL 
    },
    {
      "getWeight", "()D", NULL 
    },
    {
      "getDocId", "()J", NULL 
    },
    {
      "next", "(D)V", NULL 
    },
    {
      "skipTo", "(JD)V", NULL 
    },
    {
      "check", "(JD)Z", NULL 
    },
    {
      "atEnd", "()Z", NULL 
    },
    {
      "name", "()Ljava/lang/String;", NULL 
    },
    {
      "init", "(LDatabase;)V", NULL 
    },
    {
      "toString", "()Ljava/lang/String;", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("PostingSource");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 12; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_MatchDecider::SwigDirector_MatchDecider(JNIEnv *jenv) : Xapian::MatchDecider(), Swig::Director(jenv) {
}

bool SwigDirector_MatchDecider::operator ()(Xapian::Document const &doc) const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jdoc = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Xapian::MatchDecider::operator ().");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(Xapian::Document **)&jdoc = (Xapian::Document *) &doc; 
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_XapianJNI, Swig::director_methids[12], swigjobj, jdoc);
    if (jenv->ExceptionOccurred()) return c_result;
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

SwigDirector_MatchDecider::~SwigDirector_MatchDecider() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_MatchDecider::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "accept", "(LDocument;)Z", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("MatchDecider");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_ExpandDecider::SwigDirector_ExpandDecider(JNIEnv *jenv) : Xapian::ExpandDecider(), Swig::Director(jenv) {
}

bool SwigDirector_ExpandDecider::operator ()(std::string const &term) const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jterm = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Xapian::ExpandDecider::operator ().");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jterm = jenv->NewStringUTF((&term)->c_str()); 
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_XapianJNI, Swig::director_methids[13], swigjobj, jterm);
    if (jenv->ExceptionOccurred()) return c_result;
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

SwigDirector_ExpandDecider::~SwigDirector_ExpandDecider() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_ExpandDecider::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "accept", "(Ljava/lang/String;)Z", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("ExpandDecider");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_Stopper::SwigDirector_Stopper(JNIEnv *jenv) : Xapian::Stopper(), Swig::Director(jenv) {
}

bool SwigDirector_Stopper::operator ()(std::string const &term) const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jterm = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Xapian::Stopper::operator ().");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jterm = jenv->NewStringUTF((&term)->c_str()); 
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_XapianJNI, Swig::director_methids[14], swigjobj, jterm);
    if (jenv->ExceptionOccurred()) return c_result;
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

SwigDirector_Stopper::~SwigDirector_Stopper() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


std::string SwigDirector_Stopper::get_description() const {
  std::string c_result ;
  jstring jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[1]) {
    return Xapian::Stopper::get_description();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jstring) jenv->CallStaticObjectMethod(Swig::jclass_XapianJNI, Swig::director_methids[15], swigjobj);
    if (jenv->ExceptionOccurred()) return c_result;
    if(!jresult) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
      return c_result;
    } 
    const char *c_result_pstr = (const char *)jenv->GetStringUTFChars(jresult, 0); 
    if (!c_result_pstr) return c_result;
    c_result.assign(c_result_pstr);
    jenv->ReleaseStringUTFChars(jresult, c_result_pstr); 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_Stopper::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "apply", "(Ljava/lang/String;)Z", NULL 
    },
    {
      "toString", "()Ljava/lang/String;", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("Stopper");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_ValueRangeProcessor::SwigDirector_ValueRangeProcessor(JNIEnv *jenv) : Xapian::ValueRangeProcessor(), Swig::Director(jenv) {
}

SwigDirector_ValueRangeProcessor::~SwigDirector_ValueRangeProcessor() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


Xapian::valueno SwigDirector_ValueRangeProcessor::operator ()(std::string &begin, std::string &end) {
  Xapian::valueno c_result = SwigValueInit< Xapian::valueno >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jbegin = 0 ;
  jlong jend = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Xapian::ValueRangeProcessor::operator ().");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(std::string **)&jbegin = (std::string *) &begin; 
    *(std::string **)&jend = (std::string *) &end; 
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_XapianJNI, Swig::director_methids[16], swigjobj, jbegin, jend);
    if (jenv->ExceptionOccurred()) return c_result;
    c_result = (Xapian::valueno)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_ValueRangeProcessor::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "apply", "(LSWIGTYPE_p_std__string;LSWIGTYPE_p_std__string;)I", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("ValueRangeProcessor");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_StemImplementation::SwigDirector_StemImplementation(JNIEnv *jenv) : Xapian::StemImplementation(), Swig::Director(jenv) {
}

SwigDirector_StemImplementation::~SwigDirector_StemImplementation() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


std::string SwigDirector_StemImplementation::operator ()(std::string const &word) {
  std::string c_result ;
  jstring jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jword = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Xapian::StemImplementation::operator ().");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jword = jenv->NewStringUTF((&word)->c_str()); 
    jresult = (jstring) jenv->CallStaticObjectMethod(Swig::jclass_XapianJNI, Swig::director_methids[17], swigjobj, jword);
    if (jenv->ExceptionOccurred()) return c_result;
    if(!jresult) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
      return c_result;
    } 
    const char *c_result_pstr = (const char *)jenv->GetStringUTFChars(jresult, 0); 
    if (!c_result_pstr) return c_result;
    c_result.assign(c_result_pstr);
    jenv->ReleaseStringUTFChars(jresult, c_result_pstr); 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

std::string SwigDirector_StemImplementation::get_description() const {
  std::string c_result ;
  jstring jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Xapian::StemImplementation::get_description.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jstring) jenv->CallStaticObjectMethod(Swig::jclass_XapianJNI, Swig::director_methids[18], swigjobj);
    if (jenv->ExceptionOccurred()) return c_result;
    if(!jresult) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
      return c_result;
    } 
    const char *c_result_pstr = (const char *)jenv->GetStringUTFChars(jresult, 0); 
    if (!c_result_pstr) return c_result;
    c_result.assign(c_result_pstr);
    jenv->ReleaseStringUTFChars(jresult, c_result_pstr); 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_StemImplementation::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "apply", "(Ljava/lang/String;)Ljava/lang/String;", NULL 
    },
    {
      "toString", "()Ljava/lang/String;", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("StemImplementation");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_KeyMaker::SwigDirector_KeyMaker(JNIEnv *jenv) : Xapian::KeyMaker(), Swig::Director(jenv) {
}

std::string SwigDirector_KeyMaker::operator ()(Xapian::Document const &doc) const {
  std::string c_result ;
  jstring jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jdoc = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Xapian::KeyMaker::operator ().");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(Xapian::Document **)&jdoc = (Xapian::Document *) &doc; 
    jresult = (jstring) jenv->CallStaticObjectMethod(Swig::jclass_XapianJNI, Swig::director_methids[19], swigjobj, jdoc);
    if (jenv->ExceptionOccurred()) return c_result;
    if(!jresult) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
      return c_result;
    } 
    const char *c_result_pstr = (const char *)jenv->GetStringUTFChars(jresult, 0); 
    if (!c_result_pstr) return c_result;
    c_result.assign(c_result_pstr);
    jenv->ReleaseStringUTFChars(jresult, c_result_pstr); 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

SwigDirector_KeyMaker::~SwigDirector_KeyMaker() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_KeyMaker::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "apply", "(LDocument;)Ljava/lang/String;", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("KeyMaker");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}



#ifdef __cplusplus
extern "C" {
#endif

SWIGEXPORT jstring JNICALL Java_XapianJNI_Version_1string(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)Xapian::Version::String();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_XapianJNI_Version_1major(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)Xapian::Version::Major();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_XapianJNI_Version_1minor(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)Xapian::Version::Minor();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_XapianJNI_Version_1revision(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)Xapian::Version::Revision();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_XapianJNI_BAD_1VALUENO_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::valueno result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::valueno)(Xapian::valueno)Xapian::BAD_VALUENO;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1PositionIterator_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::PositionIterator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::PositionIterator *)new Xapian::PositionIterator();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::PositionIterator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1PositionIterator_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::PositionIterator *arg1 = 0 ;
  Xapian::PositionIterator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PositionIterator **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::PositionIterator const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::PositionIterator *)new Xapian::PositionIterator((Xapian::PositionIterator const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::PositionIterator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1PositionIterator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::PositionIterator *arg1 = (Xapian::PositionIterator *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::PositionIterator **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_PositionIterator_1getTermPos(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::PositionIterator *arg1 = (Xapian::PositionIterator *) 0 ;
  Xapian::termpos result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PositionIterator **)&jarg1; 
  {
    try {
      result = (Xapian::termpos)Xapian_PositionIterator_get_termpos((Xapian::PositionIterator const *)arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_PositionIterator_1next(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::PositionIterator *arg1 = (Xapian::PositionIterator *) 0 ;
  Xapian::termpos result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PositionIterator **)&jarg1; 
  {
    try {
      result = (Xapian::termpos)Xapian_PositionIterator_next(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_XapianJNI_PositionIterator_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Xapian::PositionIterator *arg1 = (Xapian::PositionIterator *) 0 ;
  Xapian::PositionIterator *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::PositionIterator **)&jarg1; 
  arg2 = *(Xapian::PositionIterator **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::PositionIterator const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)Xapian_PositionIterator_equals((Xapian::PositionIterator const *)arg1,(Xapian::PositionIterator const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_PositionIterator_1skipTo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  Xapian::PositionIterator *arg1 = (Xapian::PositionIterator *) 0 ;
  Xapian::termpos arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PositionIterator **)&jarg1; 
  arg2 = (Xapian::termpos)jarg2; 
  {
    try {
      (arg1)->skip_to(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_PositionIterator_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::PositionIterator *arg1 = (Xapian::PositionIterator *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PositionIterator **)&jarg1; 
  {
    try {
      result = ((Xapian::PositionIterator const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1PostingIterator_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::PostingIterator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::PostingIterator *)new Xapian::PostingIterator();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::PostingIterator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1PostingIterator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::PostingIterator *arg1 = (Xapian::PostingIterator *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::PostingIterator **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1PostingIterator_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::PostingIterator *arg1 = 0 ;
  Xapian::PostingIterator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingIterator **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::PostingIterator const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::PostingIterator *)new Xapian::PostingIterator((Xapian::PostingIterator const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::PostingIterator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_PostingIterator_1skipTo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  Xapian::PostingIterator *arg1 = (Xapian::PostingIterator *) 0 ;
  Xapian::docid arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingIterator **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  {
    try {
      (arg1)->skip_to(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_PostingIterator_1getDocLength(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::PostingIterator *arg1 = (Xapian::PostingIterator *) 0 ;
  Xapian::termcount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingIterator **)&jarg1; 
  {
    try {
      result = (Xapian::termcount)((Xapian::PostingIterator const *)arg1)->get_doclength();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_PostingIterator_1getWdf(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::PostingIterator *arg1 = (Xapian::PostingIterator *) 0 ;
  Xapian::termcount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingIterator **)&jarg1; 
  {
    try {
      result = (Xapian::termcount)((Xapian::PostingIterator const *)arg1)->get_wdf();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_PostingIterator_1positionListBegin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::PostingIterator *arg1 = (Xapian::PostingIterator *) 0 ;
  Xapian::PositionIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingIterator **)&jarg1; 
  {
    try {
      result = ((Xapian::PostingIterator const *)arg1)->positionlist_begin();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::PositionIterator **)&jresult = new Xapian::PositionIterator((const Xapian::PositionIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_PostingIterator_1positionListEnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::PostingIterator *arg1 = (Xapian::PostingIterator *) 0 ;
  Xapian::PositionIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingIterator **)&jarg1; 
  {
    try {
      result = ((Xapian::PostingIterator const *)arg1)->positionlist_end();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::PositionIterator **)&jresult = new Xapian::PositionIterator((const Xapian::PositionIterator &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_PostingIterator_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::PostingIterator *arg1 = (Xapian::PostingIterator *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingIterator **)&jarg1; 
  {
    try {
      result = ((Xapian::PostingIterator const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_XapianJNI_PostingIterator_1hasNext(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Xapian::PostingIterator *arg1 = (Xapian::PostingIterator *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingIterator **)&jarg1; 
  result = (bool)Xapian_PostingIterator_hasNext((Xapian::PostingIterator const *)arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_PostingIterator_1getDocId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::PostingIterator *arg1 = (Xapian::PostingIterator *) 0 ;
  Xapian::docid result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingIterator **)&jarg1; 
  {
    try {
      result = (Xapian::docid)Xapian_PostingIterator_get_docid((Xapian::PostingIterator const *)arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_PostingIterator_1next(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::PostingIterator *arg1 = (Xapian::PostingIterator *) 0 ;
  Xapian::docid result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingIterator **)&jarg1; 
  {
    try {
      result = (Xapian::docid)Xapian_PostingIterator_next(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_XapianJNI_PostingIterator_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Xapian::PostingIterator *arg1 = (Xapian::PostingIterator *) 0 ;
  Xapian::PostingIterator *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::PostingIterator **)&jarg1; 
  arg2 = *(Xapian::PostingIterator **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::PostingIterator const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)Xapian_PostingIterator_equals((Xapian::PostingIterator const *)arg1,(Xapian::PostingIterator const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1TermIterator_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::TermIterator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::TermIterator *)new Xapian::TermIterator();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TermIterator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1TermIterator_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::TermIterator *arg1 = 0 ;
  Xapian::TermIterator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermIterator **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::TermIterator const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::TermIterator *)new Xapian::TermIterator((Xapian::TermIterator const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TermIterator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1TermIterator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::TermIterator *arg1 = (Xapian::TermIterator *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::TermIterator **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_TermIterator_1getTerm(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::TermIterator *arg1 = (Xapian::TermIterator *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermIterator **)&jarg1; 
  {
    try {
      result = Xapian_TermIterator_get_term((Xapian::TermIterator const *)arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_TermIterator_1next(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::TermIterator *arg1 = (Xapian::TermIterator *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermIterator **)&jarg1; 
  {
    try {
      result = Xapian_TermIterator_next(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_XapianJNI_TermIterator_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Xapian::TermIterator *arg1 = (Xapian::TermIterator *) 0 ;
  Xapian::TermIterator *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::TermIterator **)&jarg1; 
  arg2 = *(Xapian::TermIterator **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::TermIterator const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)Xapian_TermIterator_equals((Xapian::TermIterator const *)arg1,(Xapian::TermIterator const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_TermIterator_1skipTo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Xapian::TermIterator *arg1 = (Xapian::TermIterator *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermIterator **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      (arg1)->skip_to((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_TermIterator_1getWdf(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::TermIterator *arg1 = (Xapian::TermIterator *) 0 ;
  Xapian::termcount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermIterator **)&jarg1; 
  {
    try {
      result = (Xapian::termcount)((Xapian::TermIterator const *)arg1)->get_wdf();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_TermIterator_1getTermFreq(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::TermIterator *arg1 = (Xapian::TermIterator *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermIterator **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::TermIterator const *)arg1)->get_termfreq();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_TermIterator_1positionListBegin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::TermIterator *arg1 = (Xapian::TermIterator *) 0 ;
  Xapian::PositionIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermIterator **)&jarg1; 
  {
    try {
      result = (arg1)->positionlist_begin();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::PositionIterator **)&jresult = new Xapian::PositionIterator((const Xapian::PositionIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_TermIterator_1positionListEnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::TermIterator *arg1 = (Xapian::TermIterator *) 0 ;
  Xapian::PositionIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermIterator **)&jarg1; 
  {
    try {
      result = (arg1)->positionlist_end();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::PositionIterator **)&jresult = new Xapian::PositionIterator((const Xapian::PositionIterator &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_TermIterator_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::TermIterator *arg1 = (Xapian::TermIterator *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermIterator **)&jarg1; 
  {
    try {
      result = ((Xapian::TermIterator const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_XapianJNI_TermIterator_1hasNext(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Xapian::TermIterator *arg1 = (Xapian::TermIterator *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermIterator **)&jarg1; 
  result = (bool)Xapian_TermIterator_hasNext((Xapian::TermIterator const *)arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1ValueIterator_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::ValueIterator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::ValueIterator *)new Xapian::ValueIterator();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::ValueIterator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1ValueIterator_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ValueIterator *arg1 = 0 ;
  Xapian::ValueIterator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueIterator **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::ValueIterator const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::ValueIterator *)new Xapian::ValueIterator((Xapian::ValueIterator const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::ValueIterator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1ValueIterator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::ValueIterator *arg1 = (Xapian::ValueIterator *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::ValueIterator **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_ValueIterator_1getValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::ValueIterator *arg1 = (Xapian::ValueIterator *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueIterator **)&jarg1; 
  {
    try {
      result = Xapian_ValueIterator_get_value((Xapian::ValueIterator const *)arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_ValueIterator_1next(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::ValueIterator *arg1 = (Xapian::ValueIterator *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueIterator **)&jarg1; 
  {
    try {
      result = Xapian_ValueIterator_next(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_XapianJNI_ValueIterator_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Xapian::ValueIterator *arg1 = (Xapian::ValueIterator *) 0 ;
  Xapian::ValueIterator *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::ValueIterator **)&jarg1; 
  arg2 = *(Xapian::ValueIterator **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::ValueIterator const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)Xapian_ValueIterator_equals((Xapian::ValueIterator const *)arg1,(Xapian::ValueIterator const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_ValueIterator_1getDocId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ValueIterator *arg1 = (Xapian::ValueIterator *) 0 ;
  Xapian::docid result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueIterator **)&jarg1; 
  {
    try {
      result = (Xapian::docid)((Xapian::ValueIterator const *)arg1)->get_docid();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_XapianJNI_ValueIterator_1getValueNo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Xapian::ValueIterator *arg1 = (Xapian::ValueIterator *) 0 ;
  Xapian::valueno result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueIterator **)&jarg1; 
  {
    try {
      result = (Xapian::valueno)((Xapian::ValueIterator const *)arg1)->get_valueno();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_ValueIterator_1skipTo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  Xapian::ValueIterator *arg1 = (Xapian::ValueIterator *) 0 ;
  Xapian::docid arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueIterator **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  {
    try {
      (arg1)->skip_to(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_XapianJNI_ValueIterator_1check(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jboolean jresult = 0 ;
  Xapian::ValueIterator *arg1 = (Xapian::ValueIterator *) 0 ;
  Xapian::docid arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueIterator **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  {
    try {
      result = (bool)(arg1)->check(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_ValueIterator_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::ValueIterator *arg1 = (Xapian::ValueIterator *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueIterator **)&jarg1; 
  {
    try {
      result = ((Xapian::ValueIterator const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_XapianJNI_ValueIterator_1hasNext(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Xapian::ValueIterator *arg1 = (Xapian::ValueIterator *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueIterator **)&jarg1; 
  result = (bool)Xapian_ValueIterator_hasNext((Xapian::ValueIterator const *)arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1Document_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Document *arg1 = 0 ;
  Xapian::Document *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Document const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::Document *)new Xapian::Document((Xapian::Document const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Document **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1Document_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::Document *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::Document *)new Xapian::Document();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Document **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1Document(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::Document **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_Document_1getValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jstring jresult = 0 ;
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  Xapian::valueno arg2 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  {
    try {
      result = ((Xapian::Document const *)arg1)->get_value(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_Document_1addValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3) {
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  Xapian::valueno arg2 ;
  std::string *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try {
      (arg1)->add_value(arg2,(std::string const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_Document_1removeValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  Xapian::valueno arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  {
    try {
      (arg1)->remove_value(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_Document_1clearValues(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  {
    try {
      (arg1)->clear_values();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_Document_1getData(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  {
    try {
      result = ((Xapian::Document const *)arg1)->get_data();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_Document_1setData(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      (arg1)->set_data((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_Document_1addPosting_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jlong jarg4) {
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::termpos arg3 ;
  Xapian::termcount arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (Xapian::termpos)jarg3; 
  arg4 = (Xapian::termcount)jarg4; 
  {
    try {
      (arg1)->add_posting((std::string const &)*arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_Document_1addPosting_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::termpos arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (Xapian::termpos)jarg3; 
  {
    try {
      (arg1)->add_posting((std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_Document_1addTerm_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::termcount arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (Xapian::termcount)jarg3; 
  {
    try {
      (arg1)->add_term((std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_Document_1addTerm_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      (arg1)->add_term((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_Document_1addBooleanTerm(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      (arg1)->add_boolean_term((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_Document_1removePosting_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jlong jarg4) {
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::termpos arg3 ;
  Xapian::termcount arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (Xapian::termpos)jarg3; 
  arg4 = (Xapian::termcount)jarg4; 
  {
    try {
      (arg1)->remove_posting((std::string const &)*arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_Document_1removePosting_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::termpos arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (Xapian::termpos)jarg3; 
  {
    try {
      (arg1)->remove_posting((std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_Document_1removeTerm(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      (arg1)->remove_term((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_Document_1clearTerms(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  {
    try {
      (arg1)->clear_terms();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Document_1termListCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  Xapian::termcount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  {
    try {
      result = (Xapian::termcount)((Xapian::Document const *)arg1)->termlist_count();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Document_1termListBegin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  {
    try {
      result = ((Xapian::Document const *)arg1)->termlist_begin();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Document_1termListEnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  {
    try {
      result = ((Xapian::Document const *)arg1)->termlist_end();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Document_1valuesCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  Xapian::termcount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  {
    try {
      result = (Xapian::termcount)((Xapian::Document const *)arg1)->values_count();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Document_1valuesBegin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  Xapian::ValueIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  {
    try {
      result = ((Xapian::Document const *)arg1)->values_begin();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::ValueIterator **)&jresult = new Xapian::ValueIterator((const Xapian::ValueIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Document_1valuesEnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  Xapian::ValueIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  {
    try {
      result = ((Xapian::Document const *)arg1)->values_end();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::ValueIterator **)&jresult = new Xapian::ValueIterator((const Xapian::ValueIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Document_1getDocId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  Xapian::docid result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  {
    try {
      result = (Xapian::docid)((Xapian::Document const *)arg1)->get_docid();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_Document_1serialise(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  {
    try {
      result = ((Xapian::Document const *)arg1)->serialise();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Document_1unserialise(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Xapian::Document result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = Xapian::Document::unserialise((std::string const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Document **)&jresult = new Xapian::Document((const Xapian::Document &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_Document_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  {
    try {
      result = ((Xapian::Document const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1PostingSource(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::PostingSource *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::PostingSource *)new SwigDirector_PostingSource(jenv);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::PostingSource **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1PostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_PostingSource_1getTermfreqMin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::PostingSource const *)arg1)->get_termfreq_min();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_PostingSource_1getTermfreqEst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::PostingSource const *)arg1)->get_termfreq_est();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_PostingSource_1getTermfreqMax(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::PostingSource const *)arg1)->get_termfreq_max();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_XapianJNI_PostingSource_1getMaxweight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  Xapian::weight result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::weight)((Xapian::PostingSource const *)arg1)->get_maxweight();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_XapianJNI_PostingSource_1getWeight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  Xapian::weight result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::weight)((Xapian::PostingSource const *)arg1)->get_weight();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_XapianJNI_PostingSource_1getWeightSwigExplicitPostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  Xapian::weight result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::weight)((Xapian::PostingSource const *)arg1)->Xapian::PostingSource::get_weight();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_PostingSource_1getDocId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  Xapian::docid result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::docid)((Xapian::PostingSource const *)arg1)->get_docid();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_PostingSource_1next(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  Xapian::weight arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  arg2 = (Xapian::weight)jarg2; 
  {
    try {
      (arg1)->next(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_PostingSource_1skipTo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jdouble jarg3) {
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  Xapian::docid arg2 ;
  Xapian::weight arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  arg3 = (Xapian::weight)jarg3; 
  {
    try {
      (arg1)->skip_to(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_PostingSource_1skipToSwigExplicitPostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jdouble jarg3) {
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  Xapian::docid arg2 ;
  Xapian::weight arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  arg3 = (Xapian::weight)jarg3; 
  {
    try {
      (arg1)->Xapian::PostingSource::skip_to(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_XapianJNI_PostingSource_1check(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jdouble jarg3) {
  jboolean jresult = 0 ;
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  Xapian::docid arg2 ;
  Xapian::weight arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  arg3 = (Xapian::weight)jarg3; 
  {
    try {
      result = (bool)(arg1)->check(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_XapianJNI_PostingSource_1checkSwigExplicitPostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jdouble jarg3) {
  jboolean jresult = 0 ;
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  Xapian::docid arg2 ;
  Xapian::weight arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  arg3 = (Xapian::weight)jarg3; 
  {
    try {
      result = (bool)(arg1)->Xapian::PostingSource::check(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_XapianJNI_PostingSource_1atEnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  {
    try {
      result = (bool)((Xapian::PostingSource const *)arg1)->at_end();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_PostingSource_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  {
    try {
      result = ((Xapian::PostingSource const *)arg1)->name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_PostingSource_1nameSwigExplicitPostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  {
    try {
      result = ((Xapian::PostingSource const *)arg1)->Xapian::PostingSource::name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_PostingSource_1init(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  Xapian::Database *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  arg2 = *(Xapian::Database **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Database const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->init((Xapian::Database const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_PostingSource_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  {
    try {
      result = ((Xapian::PostingSource const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_PostingSource_1toStringSwigExplicitPostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  {
    try {
      result = ((Xapian::PostingSource const *)arg1)->Xapian::PostingSource::get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_PostingSource_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  Xapian::PostingSource *obj = *((Xapian::PostingSource **)&objarg);
  (void)jcls;
  SwigDirector_PostingSource *director = dynamic_cast<SwigDirector_PostingSource *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_PostingSource_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  Xapian::PostingSource *obj = *((Xapian::PostingSource **)&objarg);
  SwigDirector_PostingSource *director = dynamic_cast<SwigDirector_PostingSource *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1ValuePostingSource(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  Xapian::ValuePostingSource *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  {
    try {
      result = (Xapian::ValuePostingSource *)new Xapian::ValuePostingSource(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::ValuePostingSource **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_ValuePostingSource_1getTermfreqMin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ValuePostingSource *arg1 = (Xapian::ValuePostingSource *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValuePostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::ValuePostingSource const *)arg1)->get_termfreq_min();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_ValuePostingSource_1getTermfreqEst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ValuePostingSource *arg1 = (Xapian::ValuePostingSource *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValuePostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::ValuePostingSource const *)arg1)->get_termfreq_est();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_ValuePostingSource_1getTermfreqMax(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ValuePostingSource *arg1 = (Xapian::ValuePostingSource *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValuePostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::ValuePostingSource const *)arg1)->get_termfreq_max();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_ValuePostingSource_1next(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  Xapian::ValuePostingSource *arg1 = (Xapian::ValuePostingSource *) 0 ;
  Xapian::weight arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValuePostingSource **)&jarg1; 
  arg2 = (Xapian::weight)jarg2; 
  {
    try {
      (arg1)->next(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_ValuePostingSource_1skipTo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jdouble jarg3) {
  Xapian::ValuePostingSource *arg1 = (Xapian::ValuePostingSource *) 0 ;
  Xapian::docid arg2 ;
  Xapian::weight arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValuePostingSource **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  arg3 = (Xapian::weight)jarg3; 
  {
    try {
      (arg1)->skip_to(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_XapianJNI_ValuePostingSource_1check(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jdouble jarg3) {
  jboolean jresult = 0 ;
  Xapian::ValuePostingSource *arg1 = (Xapian::ValuePostingSource *) 0 ;
  Xapian::docid arg2 ;
  Xapian::weight arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValuePostingSource **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  arg3 = (Xapian::weight)jarg3; 
  {
    try {
      result = (bool)(arg1)->check(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_XapianJNI_ValuePostingSource_1atEnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Xapian::ValuePostingSource *arg1 = (Xapian::ValuePostingSource *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValuePostingSource **)&jarg1; 
  {
    try {
      result = (bool)((Xapian::ValuePostingSource const *)arg1)->at_end();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_ValuePostingSource_1getDocId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ValuePostingSource *arg1 = (Xapian::ValuePostingSource *) 0 ;
  Xapian::docid result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValuePostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::docid)((Xapian::ValuePostingSource const *)arg1)->get_docid();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_ValuePostingSource_1init(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::ValuePostingSource *arg1 = (Xapian::ValuePostingSource *) 0 ;
  Xapian::Database *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::ValuePostingSource **)&jarg1; 
  arg2 = *(Xapian::Database **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Database const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->init((Xapian::Database const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1ValuePostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::ValuePostingSource *arg1 = (Xapian::ValuePostingSource *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::ValuePostingSource **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1ValueWeightPostingSource(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  Xapian::ValueWeightPostingSource *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  {
    try {
      result = (Xapian::ValueWeightPostingSource *)new Xapian::ValueWeightPostingSource(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::ValueWeightPostingSource **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_XapianJNI_ValueWeightPostingSource_1getWeight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::ValueWeightPostingSource *arg1 = (Xapian::ValueWeightPostingSource *) 0 ;
  Xapian::weight result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueWeightPostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::weight)((Xapian::ValueWeightPostingSource const *)arg1)->get_weight();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_ValueWeightPostingSource_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::ValueWeightPostingSource *arg1 = (Xapian::ValueWeightPostingSource *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueWeightPostingSource **)&jarg1; 
  {
    try {
      result = ((Xapian::ValueWeightPostingSource const *)arg1)->name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_ValueWeightPostingSource_1init(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::ValueWeightPostingSource *arg1 = (Xapian::ValueWeightPostingSource *) 0 ;
  Xapian::Database *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::ValueWeightPostingSource **)&jarg1; 
  arg2 = *(Xapian::Database **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Database const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->init((Xapian::Database const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_ValueWeightPostingSource_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::ValueWeightPostingSource *arg1 = (Xapian::ValueWeightPostingSource *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueWeightPostingSource **)&jarg1; 
  {
    try {
      result = ((Xapian::ValueWeightPostingSource const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1ValueWeightPostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::ValueWeightPostingSource *arg1 = (Xapian::ValueWeightPostingSource *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::ValueWeightPostingSource **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1DecreasingValueWeightPostingSource_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  Xapian::docid arg2 ;
  Xapian::docid arg3 ;
  Xapian::DecreasingValueWeightPostingSource *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  arg3 = (Xapian::docid)jarg3; 
  {
    try {
      result = (Xapian::DecreasingValueWeightPostingSource *)new Xapian::DecreasingValueWeightPostingSource(arg1,arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::DecreasingValueWeightPostingSource **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1DecreasingValueWeightPostingSource_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  Xapian::docid arg2 ;
  Xapian::DecreasingValueWeightPostingSource *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  {
    try {
      result = (Xapian::DecreasingValueWeightPostingSource *)new Xapian::DecreasingValueWeightPostingSource(arg1,arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::DecreasingValueWeightPostingSource **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1DecreasingValueWeightPostingSource_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  Xapian::DecreasingValueWeightPostingSource *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  {
    try {
      result = (Xapian::DecreasingValueWeightPostingSource *)new Xapian::DecreasingValueWeightPostingSource(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::DecreasingValueWeightPostingSource **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_XapianJNI_DecreasingValueWeightPostingSource_1getWeight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::DecreasingValueWeightPostingSource *arg1 = (Xapian::DecreasingValueWeightPostingSource *) 0 ;
  Xapian::weight result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::DecreasingValueWeightPostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::weight)((Xapian::DecreasingValueWeightPostingSource const *)arg1)->get_weight();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_DecreasingValueWeightPostingSource_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::DecreasingValueWeightPostingSource *arg1 = (Xapian::DecreasingValueWeightPostingSource *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::DecreasingValueWeightPostingSource **)&jarg1; 
  {
    try {
      result = ((Xapian::DecreasingValueWeightPostingSource const *)arg1)->name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_DecreasingValueWeightPostingSource_1init(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::DecreasingValueWeightPostingSource *arg1 = (Xapian::DecreasingValueWeightPostingSource *) 0 ;
  Xapian::Database *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::DecreasingValueWeightPostingSource **)&jarg1; 
  arg2 = *(Xapian::Database **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Database const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->init((Xapian::Database const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_DecreasingValueWeightPostingSource_1next(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  Xapian::DecreasingValueWeightPostingSource *arg1 = (Xapian::DecreasingValueWeightPostingSource *) 0 ;
  Xapian::weight arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::DecreasingValueWeightPostingSource **)&jarg1; 
  arg2 = (Xapian::weight)jarg2; 
  {
    try {
      (arg1)->next(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_DecreasingValueWeightPostingSource_1skipTo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jdouble jarg3) {
  Xapian::DecreasingValueWeightPostingSource *arg1 = (Xapian::DecreasingValueWeightPostingSource *) 0 ;
  Xapian::docid arg2 ;
  Xapian::weight arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::DecreasingValueWeightPostingSource **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  arg3 = (Xapian::weight)jarg3; 
  {
    try {
      (arg1)->skip_to(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_XapianJNI_DecreasingValueWeightPostingSource_1check(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jdouble jarg3) {
  jboolean jresult = 0 ;
  Xapian::DecreasingValueWeightPostingSource *arg1 = (Xapian::DecreasingValueWeightPostingSource *) 0 ;
  Xapian::docid arg2 ;
  Xapian::weight arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::DecreasingValueWeightPostingSource **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  arg3 = (Xapian::weight)jarg3; 
  {
    try {
      result = (bool)(arg1)->check(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_DecreasingValueWeightPostingSource_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::DecreasingValueWeightPostingSource *arg1 = (Xapian::DecreasingValueWeightPostingSource *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::DecreasingValueWeightPostingSource **)&jarg1; 
  {
    try {
      result = ((Xapian::DecreasingValueWeightPostingSource const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1DecreasingValueWeightPostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::DecreasingValueWeightPostingSource *arg1 = (Xapian::DecreasingValueWeightPostingSource *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::DecreasingValueWeightPostingSource **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1ValueMapPostingSource(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  Xapian::ValueMapPostingSource *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  {
    try {
      result = (Xapian::ValueMapPostingSource *)new Xapian::ValueMapPostingSource(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::ValueMapPostingSource **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_ValueMapPostingSource_1addMapping(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jdouble jarg3) {
  Xapian::ValueMapPostingSource *arg1 = (Xapian::ValueMapPostingSource *) 0 ;
  std::string *arg2 = 0 ;
  double arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueMapPostingSource **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (double)jarg3; 
  {
    try {
      (arg1)->add_mapping((std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_ValueMapPostingSource_1clearMappings(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Xapian::ValueMapPostingSource *arg1 = (Xapian::ValueMapPostingSource *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueMapPostingSource **)&jarg1; 
  {
    try {
      (arg1)->clear_mappings();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_ValueMapPostingSource_1setDefaultWeight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  Xapian::ValueMapPostingSource *arg1 = (Xapian::ValueMapPostingSource *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueMapPostingSource **)&jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      (arg1)->set_default_weight(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jdouble JNICALL Java_XapianJNI_ValueMapPostingSource_1getWeight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::ValueMapPostingSource *arg1 = (Xapian::ValueMapPostingSource *) 0 ;
  Xapian::weight result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueMapPostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::weight)((Xapian::ValueMapPostingSource const *)arg1)->get_weight();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_ValueMapPostingSource_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::ValueMapPostingSource *arg1 = (Xapian::ValueMapPostingSource *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueMapPostingSource **)&jarg1; 
  {
    try {
      result = ((Xapian::ValueMapPostingSource const *)arg1)->name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_ValueMapPostingSource_1init(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::ValueMapPostingSource *arg1 = (Xapian::ValueMapPostingSource *) 0 ;
  Xapian::Database *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::ValueMapPostingSource **)&jarg1; 
  arg2 = *(Xapian::Database **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Database const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->init((Xapian::Database const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_ValueMapPostingSource_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::ValueMapPostingSource *arg1 = (Xapian::ValueMapPostingSource *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueMapPostingSource **)&jarg1; 
  {
    try {
      result = ((Xapian::ValueMapPostingSource const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1ValueMapPostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::ValueMapPostingSource *arg1 = (Xapian::ValueMapPostingSource *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::ValueMapPostingSource **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1FixedWeightPostingSource(JNIEnv *jenv, jclass jcls, jdouble jarg1) {
  jlong jresult = 0 ;
  Xapian::weight arg1 ;
  Xapian::FixedWeightPostingSource *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::weight)jarg1; 
  {
    try {
      result = (Xapian::FixedWeightPostingSource *)new Xapian::FixedWeightPostingSource(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::FixedWeightPostingSource **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_FixedWeightPostingSource_1getTermfreqMin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::FixedWeightPostingSource *arg1 = (Xapian::FixedWeightPostingSource *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::FixedWeightPostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::FixedWeightPostingSource const *)arg1)->get_termfreq_min();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_FixedWeightPostingSource_1getTermfreqEst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::FixedWeightPostingSource *arg1 = (Xapian::FixedWeightPostingSource *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::FixedWeightPostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::FixedWeightPostingSource const *)arg1)->get_termfreq_est();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_FixedWeightPostingSource_1getTermfreqMax(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::FixedWeightPostingSource *arg1 = (Xapian::FixedWeightPostingSource *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::FixedWeightPostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::FixedWeightPostingSource const *)arg1)->get_termfreq_max();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_XapianJNI_FixedWeightPostingSource_1getWeight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::FixedWeightPostingSource *arg1 = (Xapian::FixedWeightPostingSource *) 0 ;
  Xapian::weight result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::FixedWeightPostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::weight)((Xapian::FixedWeightPostingSource const *)arg1)->get_weight();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_FixedWeightPostingSource_1next(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  Xapian::FixedWeightPostingSource *arg1 = (Xapian::FixedWeightPostingSource *) 0 ;
  Xapian::weight arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::FixedWeightPostingSource **)&jarg1; 
  arg2 = (Xapian::weight)jarg2; 
  {
    try {
      (arg1)->next(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_FixedWeightPostingSource_1skipTo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jdouble jarg3) {
  Xapian::FixedWeightPostingSource *arg1 = (Xapian::FixedWeightPostingSource *) 0 ;
  Xapian::docid arg2 ;
  Xapian::weight arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::FixedWeightPostingSource **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  arg3 = (Xapian::weight)jarg3; 
  {
    try {
      (arg1)->skip_to(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_XapianJNI_FixedWeightPostingSource_1check(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jdouble jarg3) {
  jboolean jresult = 0 ;
  Xapian::FixedWeightPostingSource *arg1 = (Xapian::FixedWeightPostingSource *) 0 ;
  Xapian::docid arg2 ;
  Xapian::weight arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::FixedWeightPostingSource **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  arg3 = (Xapian::weight)jarg3; 
  {
    try {
      result = (bool)(arg1)->check(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_XapianJNI_FixedWeightPostingSource_1atEnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Xapian::FixedWeightPostingSource *arg1 = (Xapian::FixedWeightPostingSource *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::FixedWeightPostingSource **)&jarg1; 
  {
    try {
      result = (bool)((Xapian::FixedWeightPostingSource const *)arg1)->at_end();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_FixedWeightPostingSource_1getDocId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::FixedWeightPostingSource *arg1 = (Xapian::FixedWeightPostingSource *) 0 ;
  Xapian::docid result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::FixedWeightPostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::docid)((Xapian::FixedWeightPostingSource const *)arg1)->get_docid();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_FixedWeightPostingSource_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::FixedWeightPostingSource *arg1 = (Xapian::FixedWeightPostingSource *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::FixedWeightPostingSource **)&jarg1; 
  {
    try {
      result = ((Xapian::FixedWeightPostingSource const *)arg1)->name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_FixedWeightPostingSource_1init(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::FixedWeightPostingSource *arg1 = (Xapian::FixedWeightPostingSource *) 0 ;
  Xapian::Database *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::FixedWeightPostingSource **)&jarg1; 
  arg2 = *(Xapian::Database **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Database const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->init((Xapian::Database const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_FixedWeightPostingSource_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::FixedWeightPostingSource *arg1 = (Xapian::FixedWeightPostingSource *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::FixedWeightPostingSource **)&jarg1; 
  {
    try {
      result = ((Xapian::FixedWeightPostingSource const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1FixedWeightPostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::FixedWeightPostingSource *arg1 = (Xapian::FixedWeightPostingSource *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::FixedWeightPostingSource **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1MSet_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::MSet *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::MSet *)new Xapian::MSet();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::MSet **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1MSet_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MSet *arg1 = 0 ;
  Xapian::MSet *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::MSet const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::MSet *)new Xapian::MSet((Xapian::MSet const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::MSet **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1MSet(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::MSet **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_MSet_1fetch_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::MSetIterator *arg2 = 0 ;
  Xapian::MSetIterator *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  arg2 = *(Xapian::MSetIterator **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::MSetIterator & reference is null");
    return ;
  } 
  arg3 = *(Xapian::MSetIterator **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::MSetIterator & reference is null");
    return ;
  } 
  {
    try {
      ((Xapian::MSet const *)arg1)->fetch(*arg2,*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_MSet_1fetch_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::MSetIterator *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  arg2 = *(Xapian::MSetIterator **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::MSetIterator & reference is null");
    return ;
  } 
  {
    try {
      ((Xapian::MSet const *)arg1)->fetch(*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_MSet_1fetch_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  {
    try {
      ((Xapian::MSet const *)arg1)->fetch();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jint JNICALL Java_XapianJNI_MSet_1convertToPercent_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jint jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::weight arg2 ;
  Xapian::percent result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  arg2 = (Xapian::weight)jarg2; 
  {
    try {
      result = (Xapian::percent)((Xapian::MSet const *)arg1)->convert_to_percent(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_XapianJNI_MSet_1convertToPercent_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::MSetIterator *arg2 = 0 ;
  Xapian::percent result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  arg2 = *(Xapian::MSetIterator **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::MSetIterator const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::percent)((Xapian::MSet const *)arg1)->convert_to_percent((Xapian::MSetIterator const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_MSet_1getTermFreq(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  std::string arg2 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  } 
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (Xapian::doccount)((Xapian::MSet const *)arg1)->get_termfreq(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_XapianJNI_MSet_1getTermWeight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jdouble jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  std::string arg2 ;
  Xapian::weight result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  } 
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (Xapian::weight)((Xapian::MSet const *)arg1)->get_termweight(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_MSet_1getFirstItem(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::MSet const *)arg1)->get_firstitem();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_MSet_1getMatchesLowerBound(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::MSet const *)arg1)->get_matches_lower_bound();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_MSet_1getMatchesEstimated(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::MSet const *)arg1)->get_matches_estimated();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_MSet_1getMatchesUpperBound(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::MSet const *)arg1)->get_matches_upper_bound();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_MSet_1getUncollapsedMatchesLowerBound(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::MSet const *)arg1)->get_uncollapsed_matches_lower_bound();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_MSet_1getUncollapsedMatchesEstimated(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::MSet const *)arg1)->get_uncollapsed_matches_estimated();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_MSet_1getUncollapsedMatchesUpperBound(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::MSet const *)arg1)->get_uncollapsed_matches_upper_bound();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_XapianJNI_MSet_1getMaxPossible(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::weight result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  {
    try {
      result = (Xapian::weight)(arg1)->get_max_possible();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_XapianJNI_MSet_1getMaxAttained(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::weight result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  {
    try {
      result = (Xapian::weight)(arg1)->get_max_attained();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_MSet_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::MSet const *)arg1)->size();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_XapianJNI_MSet_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  {
    try {
      result = (bool)((Xapian::MSet const *)arg1)->empty();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_MSet_1begin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::MSetIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  {
    try {
      result = ((Xapian::MSet const *)arg1)->begin();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::MSetIterator **)&jresult = new Xapian::MSetIterator((const Xapian::MSetIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_MSet_1end(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::MSetIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  {
    try {
      result = ((Xapian::MSet const *)arg1)->end();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::MSetIterator **)&jresult = new Xapian::MSetIterator((const Xapian::MSetIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_MSet_1back(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::MSetIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  {
    try {
      result = ((Xapian::MSet const *)arg1)->back();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::MSetIterator **)&jresult = new Xapian::MSetIterator((const Xapian::MSetIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_MSet_1getHit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::doccount arg2 ;
  Xapian::MSetIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  arg2 = (Xapian::doccount)jarg2; 
  {
    try {
      result = Xapian_MSet_get_hit((Xapian::MSet const *)arg1,arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::MSetIterator **)&jresult = new Xapian::MSetIterator((const Xapian::MSetIterator &)result); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_XapianJNI_MSet_1getDocumentPercentage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jint jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::doccount arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  arg2 = (Xapian::doccount)jarg2; 
  {
    try {
      result = (int)Xapian_MSet_get_document_percentage((Xapian::MSet const *)arg1,arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_MSet_1getDocument(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::doccount arg2 ;
  Xapian::Document result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  arg2 = (Xapian::doccount)jarg2; 
  {
    try {
      result = Xapian_MSet_get_document((Xapian::MSet const *)arg1,arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Document **)&jresult = new Xapian::Document((const Xapian::Document &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_MSet_1getDocId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::doccount arg2 ;
  Xapian::docid result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  arg2 = (Xapian::doccount)jarg2; 
  {
    try {
      result = (Xapian::docid)Xapian_MSet_get_docid((Xapian::MSet const *)arg1,arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_MSet_1getElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::doccount arg2 ;
  Xapian::MSetIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  arg2 = (Xapian::doccount)jarg2; 
  {
    try {
      result = Xapian_MSet_getElement((Xapian::MSet const *)arg1,arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::MSetIterator **)&jresult = new Xapian::MSetIterator((const Xapian::MSetIterator &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_MSet_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  {
    try {
      result = ((Xapian::MSet const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1MSetIterator_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::MSetIterator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::MSetIterator *)new Xapian::MSetIterator();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::MSetIterator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1MSetIterator_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MSetIterator *arg1 = 0 ;
  Xapian::MSetIterator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSetIterator **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::MSetIterator const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::MSetIterator *)new Xapian::MSetIterator((Xapian::MSetIterator const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::MSetIterator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1MSetIterator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::MSetIterator *arg1 = (Xapian::MSetIterator *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::MSetIterator **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_MSetIterator_1getDocId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MSetIterator *arg1 = (Xapian::MSetIterator *) 0 ;
  Xapian::docid result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSetIterator **)&jarg1; 
  {
    try {
      result = (Xapian::docid)Xapian_MSetIterator_get_docid((Xapian::MSetIterator const *)arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_MSetIterator_1next(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MSetIterator *arg1 = (Xapian::MSetIterator *) 0 ;
  Xapian::docid result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSetIterator **)&jarg1; 
  {
    try {
      result = (Xapian::docid)Xapian_MSetIterator_next(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_MSetIterator_1prev(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MSetIterator *arg1 = (Xapian::MSetIterator *) 0 ;
  Xapian::docid result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSetIterator **)&jarg1; 
  {
    try {
      result = (Xapian::docid)Xapian_MSetIterator_prev(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_XapianJNI_MSetIterator_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Xapian::MSetIterator *arg1 = (Xapian::MSetIterator *) 0 ;
  Xapian::MSetIterator *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::MSetIterator **)&jarg1; 
  arg2 = *(Xapian::MSetIterator **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::MSetIterator const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)Xapian_MSetIterator_equals((Xapian::MSetIterator const *)arg1,(Xapian::MSetIterator const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_MSetIterator_1getDocument(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MSetIterator *arg1 = (Xapian::MSetIterator *) 0 ;
  Xapian::Document result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSetIterator **)&jarg1; 
  {
    try {
      result = ((Xapian::MSetIterator const *)arg1)->get_document();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Document **)&jresult = new Xapian::Document((const Xapian::Document &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_MSetIterator_1getRank(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MSetIterator *arg1 = (Xapian::MSetIterator *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSetIterator **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::MSetIterator const *)arg1)->get_rank();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_XapianJNI_MSetIterator_1getWeight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::MSetIterator *arg1 = (Xapian::MSetIterator *) 0 ;
  Xapian::weight result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSetIterator **)&jarg1; 
  {
    try {
      result = (Xapian::weight)((Xapian::MSetIterator const *)arg1)->get_weight();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_MSetIterator_1getCollapseKey(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::MSetIterator *arg1 = (Xapian::MSetIterator *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSetIterator **)&jarg1; 
  {
    try {
      result = ((Xapian::MSetIterator const *)arg1)->get_collapse_key();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_MSetIterator_1getCollapseCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MSetIterator *arg1 = (Xapian::MSetIterator *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSetIterator **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::MSetIterator const *)arg1)->get_collapse_count();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_XapianJNI_MSetIterator_1getPercent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Xapian::MSetIterator *arg1 = (Xapian::MSetIterator *) 0 ;
  Xapian::percent result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSetIterator **)&jarg1; 
  {
    try {
      result = (Xapian::percent)((Xapian::MSetIterator const *)arg1)->get_percent();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_MSetIterator_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::MSetIterator *arg1 = (Xapian::MSetIterator *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSetIterator **)&jarg1; 
  {
    try {
      result = ((Xapian::MSetIterator const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1ESet_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::ESet *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::ESet *)new Xapian::ESet();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::ESet **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1ESet_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ESet *arg1 = 0 ;
  Xapian::ESet *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ESet **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::ESet const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::ESet *)new Xapian::ESet((Xapian::ESet const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::ESet **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1ESet(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::ESet *arg1 = (Xapian::ESet *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::ESet **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_ESet_1getEbound(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ESet *arg1 = (Xapian::ESet *) 0 ;
  Xapian::termcount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ESet **)&jarg1; 
  {
    try {
      result = (Xapian::termcount)((Xapian::ESet const *)arg1)->get_ebound();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_ESet_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ESet *arg1 = (Xapian::ESet *) 0 ;
  Xapian::termcount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ESet **)&jarg1; 
  {
    try {
      result = (Xapian::termcount)((Xapian::ESet const *)arg1)->size();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_XapianJNI_ESet_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Xapian::ESet *arg1 = (Xapian::ESet *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ESet **)&jarg1; 
  {
    try {
      result = (bool)((Xapian::ESet const *)arg1)->empty();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_ESet_1begin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ESet *arg1 = (Xapian::ESet *) 0 ;
  Xapian::ESetIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ESet **)&jarg1; 
  {
    try {
      result = ((Xapian::ESet const *)arg1)->begin();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::ESetIterator **)&jresult = new Xapian::ESetIterator((const Xapian::ESetIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_ESet_1end(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ESet *arg1 = (Xapian::ESet *) 0 ;
  Xapian::ESetIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ESet **)&jarg1; 
  {
    try {
      result = ((Xapian::ESet const *)arg1)->end();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::ESetIterator **)&jresult = new Xapian::ESetIterator((const Xapian::ESetIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_ESet_1back(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ESet *arg1 = (Xapian::ESet *) 0 ;
  Xapian::ESetIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ESet **)&jarg1; 
  {
    try {
      result = ((Xapian::ESet const *)arg1)->back();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::ESetIterator **)&jresult = new Xapian::ESetIterator((const Xapian::ESetIterator &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_ESet_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::ESet *arg1 = (Xapian::ESet *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ESet **)&jarg1; 
  {
    try {
      result = ((Xapian::ESet const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1ESetIterator_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::ESetIterator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::ESetIterator *)new Xapian::ESetIterator();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::ESetIterator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1ESetIterator_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ESetIterator *arg1 = 0 ;
  Xapian::ESetIterator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ESetIterator **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::ESetIterator const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::ESetIterator *)new Xapian::ESetIterator((Xapian::ESetIterator const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::ESetIterator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1ESetIterator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::ESetIterator *arg1 = (Xapian::ESetIterator *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::ESetIterator **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_ESetIterator_1getTerm(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::ESetIterator *arg1 = (Xapian::ESetIterator *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ESetIterator **)&jarg1; 
  {
    try {
      result = Xapian_ESetIterator_get_term((Xapian::ESetIterator const *)arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_ESetIterator_1next(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::ESetIterator *arg1 = (Xapian::ESetIterator *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ESetIterator **)&jarg1; 
  {
    try {
      result = Xapian_ESetIterator_next(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_ESetIterator_1prev(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::ESetIterator *arg1 = (Xapian::ESetIterator *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ESetIterator **)&jarg1; 
  {
    try {
      result = Xapian_ESetIterator_prev(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_XapianJNI_ESetIterator_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Xapian::ESetIterator *arg1 = (Xapian::ESetIterator *) 0 ;
  Xapian::ESetIterator *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::ESetIterator **)&jarg1; 
  arg2 = *(Xapian::ESetIterator **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::ESetIterator const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)Xapian_ESetIterator_equals((Xapian::ESetIterator const *)arg1,(Xapian::ESetIterator const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_XapianJNI_ESetIterator_1getWeight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::ESetIterator *arg1 = (Xapian::ESetIterator *) 0 ;
  Xapian::weight result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ESetIterator **)&jarg1; 
  {
    try {
      result = (Xapian::weight)((Xapian::ESetIterator const *)arg1)->get_weight();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_ESetIterator_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::ESetIterator *arg1 = (Xapian::ESetIterator *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ESetIterator **)&jarg1; 
  {
    try {
      result = ((Xapian::ESetIterator const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1RSet_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::RSet *arg1 = 0 ;
  Xapian::RSet *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::RSet **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::RSet const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::RSet *)new Xapian::RSet((Xapian::RSet const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::RSet **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1RSet_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::RSet *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::RSet *)new Xapian::RSet();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::RSet **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1RSet(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::RSet *arg1 = (Xapian::RSet *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::RSet **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_RSet_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::RSet *arg1 = (Xapian::RSet *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::RSet **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::RSet const *)arg1)->size();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_XapianJNI_RSet_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Xapian::RSet *arg1 = (Xapian::RSet *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::RSet **)&jarg1; 
  {
    try {
      result = (bool)((Xapian::RSet const *)arg1)->empty();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_RSet_1addDocument_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  Xapian::RSet *arg1 = (Xapian::RSet *) 0 ;
  Xapian::docid arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::RSet **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  {
    try {
      (arg1)->add_document(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_RSet_1addDocument_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::RSet *arg1 = (Xapian::RSet *) 0 ;
  Xapian::MSetIterator *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::RSet **)&jarg1; 
  arg2 = *(Xapian::MSetIterator **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::MSetIterator & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->add_document(*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_RSet_1removeDocument_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  Xapian::RSet *arg1 = (Xapian::RSet *) 0 ;
  Xapian::docid arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::RSet **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  {
    try {
      (arg1)->remove_document(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_RSet_1removeDocument_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::RSet *arg1 = (Xapian::RSet *) 0 ;
  Xapian::MSetIterator *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::RSet **)&jarg1; 
  arg2 = *(Xapian::MSetIterator **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::MSetIterator & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->remove_document(*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_XapianJNI_RSet_1contains_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jboolean jresult = 0 ;
  Xapian::RSet *arg1 = (Xapian::RSet *) 0 ;
  Xapian::docid arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::RSet **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  {
    try {
      result = (bool)(arg1)->contains(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_XapianJNI_RSet_1contains_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Xapian::RSet *arg1 = (Xapian::RSet *) 0 ;
  Xapian::MSetIterator *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::RSet **)&jarg1; 
  arg2 = *(Xapian::MSetIterator **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::MSetIterator & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)(arg1)->contains(*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_RSet_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::RSet *arg1 = (Xapian::RSet *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::RSet **)&jarg1; 
  {
    try {
      result = ((Xapian::RSet const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_XapianJNI_MatchDecider_1accept(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Xapian::MatchDecider *arg1 = (Xapian::MatchDecider *) 0 ;
  Xapian::Document *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::MatchDecider **)&jarg1; 
  arg2 = *(Xapian::Document **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Document const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)((Xapian::MatchDecider const *)arg1)->operator ()((Xapian::Document const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1MatchDecider(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::MatchDecider *arg1 = (Xapian::MatchDecider *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::MatchDecider **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1MatchDecider(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::MatchDecider *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::MatchDecider *)new SwigDirector_MatchDecider(jenv);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::MatchDecider **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_MatchDecider_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  Xapian::MatchDecider *obj = *((Xapian::MatchDecider **)&objarg);
  (void)jcls;
  SwigDirector_MatchDecider *director = dynamic_cast<SwigDirector_MatchDecider *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_MatchDecider_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  Xapian::MatchDecider *obj = *((Xapian::MatchDecider **)&objarg);
  SwigDirector_MatchDecider *director = dynamic_cast<SwigDirector_MatchDecider *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jboolean JNICALL Java_XapianJNI_ExpandDecider_1accept(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  Xapian::ExpandDecider *arg1 = (Xapian::ExpandDecider *) 0 ;
  std::string *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ExpandDecider **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (bool)((Xapian::ExpandDecider const *)arg1)->operator ()((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1ExpandDecider(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::ExpandDecider *arg1 = (Xapian::ExpandDecider *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::ExpandDecider **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1ExpandDecider(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::ExpandDecider *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::ExpandDecider *)new SwigDirector_ExpandDecider(jenv);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::ExpandDecider **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_ExpandDecider_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  Xapian::ExpandDecider *obj = *((Xapian::ExpandDecider **)&objarg);
  (void)jcls;
  SwigDirector_ExpandDecider *director = dynamic_cast<SwigDirector_ExpandDecider *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_ExpandDecider_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  Xapian::ExpandDecider *obj = *((Xapian::ExpandDecider **)&objarg);
  SwigDirector_ExpandDecider *director = dynamic_cast<SwigDirector_ExpandDecider *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1Enquire(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = 0 ;
  Xapian::Enquire *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Database const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::Enquire *)new Xapian::Enquire((Xapian::Database const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Enquire **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1Enquire(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_Enquire_1setQuery_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::Query *arg2 = 0 ;
  Xapian::termcount arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = *(Xapian::Query **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Query const & reference is null");
    return ;
  } 
  arg3 = (Xapian::termcount)jarg3; 
  {
    try {
      (arg1)->set_query((Xapian::Query const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_Enquire_1setQuery_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::Query *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = *(Xapian::Query **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Query const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->set_query((Xapian::Query const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Enquire_1getQuery(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::Query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  {
    try {
      result = (Xapian::Query *) &(arg1)->get_query();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Query **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_Enquire_1addMatchspy(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::MatchSpy *arg2 = (Xapian::MatchSpy *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = *(Xapian::MatchSpy **)&jarg2; 
  {
    try {
      (arg1)->add_matchspy(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_Enquire_1clearMatchspies(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  {
    try {
      (arg1)->clear_matchspies();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_Enquire_1setWeightingScheme(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::Weight *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = *(Xapian::Weight **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Weight const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->set_weighting_scheme((Xapian::Weight const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_Enquire_1setCollapseKey_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::valueno arg2 ;
  Xapian::doccount arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  arg3 = (Xapian::doccount)jarg3; 
  {
    try {
      (arg1)->set_collapse_key(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_Enquire_1setCollapseKey_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::valueno arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  {
    try {
      (arg1)->set_collapse_key(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jint JNICALL Java_XapianJNI_Enquire_1ASCENDING_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::Enquire::docid_order result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::Enquire::docid_order)Xapian::Enquire::ASCENDING;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_XapianJNI_Enquire_1DESCENDING_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::Enquire::docid_order result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::Enquire::docid_order)Xapian::Enquire::DESCENDING;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_XapianJNI_Enquire_1DONT_1CARE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::Enquire::docid_order result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::Enquire::docid_order)Xapian::Enquire::DONT_CARE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_Enquire_1setDocidOrder(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::Enquire::docid_order arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::Enquire::docid_order)jarg2; 
  {
    try {
      (arg1)->set_docid_order(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_Enquire_1setCutoff_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jdouble jarg3) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  int arg2 ;
  Xapian::weight arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (Xapian::weight)jarg3; 
  {
    try {
      (arg1)->set_cutoff(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_Enquire_1setCutoff_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      (arg1)->set_cutoff(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_Enquire_1setSortByRelevance(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  {
    try {
      (arg1)->set_sort_by_relevance();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_Enquire_1setSortByValue_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jboolean jarg3) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::valueno arg2 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      (arg1)->set_sort_by_value(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_Enquire_1setSortByValue_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::valueno arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  {
    try {
      (arg1)->set_sort_by_value(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_Enquire_1setSortByValueThenRelevance_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jboolean jarg3) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::valueno arg2 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      (arg1)->set_sort_by_value_then_relevance(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_Enquire_1setSortByValueThenRelevance_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::valueno arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  {
    try {
      (arg1)->set_sort_by_value_then_relevance(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_Enquire_1setSortByRelevanceThenValue_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jboolean jarg3) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::valueno arg2 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      (arg1)->set_sort_by_relevance_then_value(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_Enquire_1setSortByRelevanceThenValue_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::valueno arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  {
    try {
      (arg1)->set_sort_by_relevance_then_value(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_Enquire_1setSortByKey_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jboolean jarg3) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::KeyMaker *arg2 = (Xapian::KeyMaker *) 0 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = *(Xapian::KeyMaker **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      (arg1)->set_sort_by_key(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_Enquire_1setSortByKey_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::Sorter *arg2 = (Xapian::Sorter *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = *(Xapian::Sorter **)&jarg2; 
  {
    try {
      (arg1)->set_sort_by_key(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_Enquire_1setSortByKeyThenRelevance_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jboolean jarg3) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::KeyMaker *arg2 = (Xapian::KeyMaker *) 0 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = *(Xapian::KeyMaker **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      (arg1)->set_sort_by_key_then_relevance(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_Enquire_1setSortByKeyThenRelevance_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::Sorter *arg2 = (Xapian::Sorter *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = *(Xapian::Sorter **)&jarg2; 
  {
    try {
      (arg1)->set_sort_by_key_then_relevance(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_Enquire_1setSortByRelevanceThenKey_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jboolean jarg3) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::KeyMaker *arg2 = (Xapian::KeyMaker *) 0 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = *(Xapian::KeyMaker **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      (arg1)->set_sort_by_relevance_then_key(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_Enquire_1setSortByRelevanceThenKey_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::Sorter *arg2 = (Xapian::Sorter *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = *(Xapian::Sorter **)&jarg2; 
  {
    try {
      (arg1)->set_sort_by_relevance_then_key(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jint JNICALL Java_XapianJNI_Enquire_1INCLUDE_1QUERY_1TERMS_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)Xapian::Enquire::INCLUDE_QUERY_TERMS;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_XapianJNI_Enquire_1USE_1EXACT_1TERMFREQ_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)Xapian::Enquire::USE_EXACT_TERMFREQ;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Enquire_1getMSet_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jobject jarg5_, jlong jarg6, jobject jarg6_, jlong jarg7, jobject jarg7_) {
  jlong jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::doccount arg2 ;
  Xapian::doccount arg3 ;
  Xapian::doccount arg4 ;
  Xapian::RSet *arg5 = (Xapian::RSet *) 0 ;
  Xapian::MatchDecider *arg6 = (Xapian::MatchDecider *) 0 ;
  Xapian::MatchDecider *arg7 = (Xapian::MatchDecider *) 0 ;
  Xapian::MSet result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  (void)jarg6_;
  (void)jarg7_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::doccount)jarg2; 
  arg3 = (Xapian::doccount)jarg3; 
  arg4 = (Xapian::doccount)jarg4; 
  arg5 = *(Xapian::RSet **)&jarg5; 
  arg6 = *(Xapian::MatchDecider **)&jarg6; 
  arg7 = *(Xapian::MatchDecider **)&jarg7; 
  {
    try {
      result = ((Xapian::Enquire const *)arg1)->get_mset(arg2,arg3,arg4,(Xapian::RSet const *)arg5,(Xapian::MatchDecider const *)arg6,(Xapian::MatchDecider const *)arg7);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::MSet **)&jresult = new Xapian::MSet((const Xapian::MSet &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Enquire_1getMSet_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jobject jarg5_, jlong jarg6, jobject jarg6_) {
  jlong jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::doccount arg2 ;
  Xapian::doccount arg3 ;
  Xapian::doccount arg4 ;
  Xapian::RSet *arg5 = (Xapian::RSet *) 0 ;
  Xapian::MatchDecider *arg6 = (Xapian::MatchDecider *) 0 ;
  Xapian::MSet result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  (void)jarg6_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::doccount)jarg2; 
  arg3 = (Xapian::doccount)jarg3; 
  arg4 = (Xapian::doccount)jarg4; 
  arg5 = *(Xapian::RSet **)&jarg5; 
  arg6 = *(Xapian::MatchDecider **)&jarg6; 
  {
    try {
      result = ((Xapian::Enquire const *)arg1)->get_mset(arg2,arg3,arg4,(Xapian::RSet const *)arg5,(Xapian::MatchDecider const *)arg6);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::MSet **)&jresult = new Xapian::MSet((const Xapian::MSet &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Enquire_1getMSet_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jobject jarg5_) {
  jlong jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::doccount arg2 ;
  Xapian::doccount arg3 ;
  Xapian::doccount arg4 ;
  Xapian::RSet *arg5 = (Xapian::RSet *) 0 ;
  Xapian::MSet result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::doccount)jarg2; 
  arg3 = (Xapian::doccount)jarg3; 
  arg4 = (Xapian::doccount)jarg4; 
  arg5 = *(Xapian::RSet **)&jarg5; 
  {
    try {
      result = ((Xapian::Enquire const *)arg1)->get_mset(arg2,arg3,arg4,(Xapian::RSet const *)arg5);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::MSet **)&jresult = new Xapian::MSet((const Xapian::MSet &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Enquire_1getMSet_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::doccount arg2 ;
  Xapian::doccount arg3 ;
  Xapian::doccount arg4 ;
  Xapian::MSet result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::doccount)jarg2; 
  arg3 = (Xapian::doccount)jarg3; 
  arg4 = (Xapian::doccount)jarg4; 
  {
    try {
      result = ((Xapian::Enquire const *)arg1)->get_mset(arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::MSet **)&jresult = new Xapian::MSet((const Xapian::MSet &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Enquire_1getMSet_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::doccount arg2 ;
  Xapian::doccount arg3 ;
  Xapian::MSet result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::doccount)jarg2; 
  arg3 = (Xapian::doccount)jarg3; 
  {
    try {
      result = ((Xapian::Enquire const *)arg1)->get_mset(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::MSet **)&jresult = new Xapian::MSet((const Xapian::MSet &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Enquire_1getMSet_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  jlong jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::doccount arg2 ;
  Xapian::doccount arg3 ;
  Xapian::RSet *arg4 = (Xapian::RSet *) 0 ;
  Xapian::MatchDecider *arg5 = (Xapian::MatchDecider *) 0 ;
  Xapian::MSet result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::doccount)jarg2; 
  arg3 = (Xapian::doccount)jarg3; 
  arg4 = *(Xapian::RSet **)&jarg4; 
  arg5 = *(Xapian::MatchDecider **)&jarg5; 
  {
    try {
      result = ((Xapian::Enquire const *)arg1)->get_mset(arg2,arg3,(Xapian::RSet const *)arg4,(Xapian::MatchDecider const *)arg5);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::MSet **)&jresult = new Xapian::MSet((const Xapian::MSet &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Enquire_1getMSet_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::doccount arg2 ;
  Xapian::doccount arg3 ;
  Xapian::RSet *arg4 = (Xapian::RSet *) 0 ;
  Xapian::MSet result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::doccount)jarg2; 
  arg3 = (Xapian::doccount)jarg3; 
  arg4 = *(Xapian::RSet **)&jarg4; 
  {
    try {
      result = ((Xapian::Enquire const *)arg1)->get_mset(arg2,arg3,(Xapian::RSet const *)arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::MSet **)&jresult = new Xapian::MSet((const Xapian::MSet &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Enquire_1getESet_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jobject jarg3_, jint jarg4, jdouble jarg5, jlong jarg6, jobject jarg6_) {
  jlong jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::RSet *arg3 = 0 ;
  int arg4 ;
  double arg5 ;
  Xapian::ExpandDecider *arg6 = (Xapian::ExpandDecider *) 0 ;
  Xapian::ESet result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  (void)jarg6_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = *(Xapian::RSet **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::RSet const & reference is null");
    return 0;
  } 
  arg4 = (int)jarg4; 
  arg5 = (double)jarg5; 
  arg6 = *(Xapian::ExpandDecider **)&jarg6; 
  {
    try {
      result = ((Xapian::Enquire const *)arg1)->get_eset(arg2,(Xapian::RSet const &)*arg3,arg4,arg5,(Xapian::ExpandDecider const *)arg6);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::ESet **)&jresult = new Xapian::ESet((const Xapian::ESet &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Enquire_1getESet_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jobject jarg3_, jint jarg4, jdouble jarg5) {
  jlong jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::RSet *arg3 = 0 ;
  int arg4 ;
  double arg5 ;
  Xapian::ESet result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = *(Xapian::RSet **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::RSet const & reference is null");
    return 0;
  } 
  arg4 = (int)jarg4; 
  arg5 = (double)jarg5; 
  {
    try {
      result = ((Xapian::Enquire const *)arg1)->get_eset(arg2,(Xapian::RSet const &)*arg3,arg4,arg5);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::ESet **)&jresult = new Xapian::ESet((const Xapian::ESet &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Enquire_1getESet_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jobject jarg3_, jint jarg4) {
  jlong jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::RSet *arg3 = 0 ;
  int arg4 ;
  Xapian::ESet result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = *(Xapian::RSet **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::RSet const & reference is null");
    return 0;
  } 
  arg4 = (int)jarg4; 
  {
    try {
      result = ((Xapian::Enquire const *)arg1)->get_eset(arg2,(Xapian::RSet const &)*arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::ESet **)&jresult = new Xapian::ESet((const Xapian::ESet &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Enquire_1getESet_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::RSet *arg3 = 0 ;
  Xapian::ESet result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = *(Xapian::RSet **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::RSet const & reference is null");
    return 0;
  } 
  {
    try {
      result = ((Xapian::Enquire const *)arg1)->get_eset(arg2,(Xapian::RSet const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::ESet **)&jresult = new Xapian::ESet((const Xapian::ESet &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Enquire_1getESet_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::RSet *arg3 = 0 ;
  Xapian::ExpandDecider *arg4 = (Xapian::ExpandDecider *) 0 ;
  Xapian::ESet result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = *(Xapian::RSet **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::RSet const & reference is null");
    return 0;
  } 
  arg4 = *(Xapian::ExpandDecider **)&jarg4; 
  {
    try {
      result = ((Xapian::Enquire const *)arg1)->get_eset(arg2,(Xapian::RSet const &)*arg3,(Xapian::ExpandDecider const *)arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::ESet **)&jresult = new Xapian::ESet((const Xapian::ESet &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Enquire_1getMatchingTermsBegin_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::docid arg2 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  {
    try {
      result = ((Xapian::Enquire const *)arg1)->get_matching_terms_begin(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Enquire_1getMatchingTermsEnd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::docid arg2 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  {
    try {
      result = ((Xapian::Enquire const *)arg1)->get_matching_terms_end(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Enquire_1getMatchingTermsBegin_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::MSetIterator *arg2 = 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = *(Xapian::MSetIterator **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::MSetIterator const & reference is null");
    return 0;
  } 
  {
    try {
      result = ((Xapian::Enquire const *)arg1)->get_matching_terms_begin((Xapian::MSetIterator const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Enquire_1getMatchingTermsEnd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::MSetIterator *arg2 = 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = *(Xapian::MSetIterator **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::MSetIterator const & reference is null");
    return 0;
  } 
  {
    try {
      result = ((Xapian::Enquire const *)arg1)->get_matching_terms_end((Xapian::MSetIterator const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_Enquire_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  {
    try {
      result = ((Xapian::Enquire const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1Registry_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Registry *arg1 = 0 ;
  Xapian::Registry *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Registry **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Registry const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::Registry *)new Xapian::Registry((Xapian::Registry const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Registry **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1Registry_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::Registry *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::Registry *)new Xapian::Registry();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Registry **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1Registry(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::Registry *arg1 = (Xapian::Registry *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::Registry **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_Registry_1registerWeightingScheme(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::Registry *arg1 = (Xapian::Registry *) 0 ;
  Xapian::Weight *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::Registry **)&jarg1; 
  arg2 = *(Xapian::Weight **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Weight const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->register_weighting_scheme((Xapian::Weight const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Registry_1getWeightingScheme(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::Registry *arg1 = (Xapian::Registry *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::Weight *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Registry **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (Xapian::Weight *)((Xapian::Registry const *)arg1)->get_weighting_scheme((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Weight **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_Registry_1registerPostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::Registry *arg1 = (Xapian::Registry *) 0 ;
  Xapian::PostingSource *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::Registry **)&jarg1; 
  arg2 = *(Xapian::PostingSource **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::PostingSource const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->register_posting_source((Xapian::PostingSource const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Registry_1getPostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::Registry *arg1 = (Xapian::Registry *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::PostingSource *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Registry **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (Xapian::PostingSource *)((Xapian::Registry const *)arg1)->get_posting_source((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::PostingSource **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_Registry_1registerMatchSpy(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::Registry *arg1 = (Xapian::Registry *) 0 ;
  Xapian::MatchSpy *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::Registry **)&jarg1; 
  arg2 = *(Xapian::MatchSpy **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::MatchSpy const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->register_match_spy((Xapian::MatchSpy const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Registry_1getMatchSpy(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::Registry *arg1 = (Xapian::Registry *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::MatchSpy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Registry **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (Xapian::MatchSpy *)((Xapian::Registry const *)arg1)->get_match_spy((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::MatchSpy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1Weight(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::Weight *arg1 = (Xapian::Weight *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::Weight **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_Weight_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::Weight *arg1 = (Xapian::Weight *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Weight **)&jarg1; 
  {
    try {
      result = ((Xapian::Weight const *)arg1)->name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_XapianJNI_Weight_1getSumPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jdouble jresult = 0 ;
  Xapian::Weight *arg1 = (Xapian::Weight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::termcount arg3 ;
  Xapian::weight result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Weight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (Xapian::termcount)jarg3; 
  {
    try {
      result = (Xapian::weight)((Xapian::Weight const *)arg1)->get_sumpart(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_XapianJNI_Weight_1getMaxPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::Weight *arg1 = (Xapian::Weight *) 0 ;
  Xapian::weight result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Weight **)&jarg1; 
  {
    try {
      result = (Xapian::weight)((Xapian::Weight const *)arg1)->get_maxpart();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_XapianJNI_Weight_1getSumExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jdouble jresult = 0 ;
  Xapian::Weight *arg1 = (Xapian::Weight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::weight result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Weight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  {
    try {
      result = (Xapian::weight)((Xapian::Weight const *)arg1)->get_sumextra(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_XapianJNI_Weight_1getMaxExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::Weight *arg1 = (Xapian::Weight *) 0 ;
  Xapian::weight result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Weight **)&jarg1; 
  {
    try {
      result = (Xapian::weight)((Xapian::Weight const *)arg1)->get_maxextra();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_XapianJNI_Weight_1getSumpartNeedsDoclength(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Xapian::Weight *arg1 = (Xapian::Weight *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Weight **)&jarg1; 
  {
    try {
      result = (bool)((Xapian::Weight const *)arg1)->get_sumpart_needs_doclength_();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_XapianJNI_Weight_1getSumpartNeedsWdf(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Xapian::Weight *arg1 = (Xapian::Weight *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Weight **)&jarg1; 
  {
    try {
      result = (bool)((Xapian::Weight const *)arg1)->get_sumpart_needs_wdf_();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1BoolWeight(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::BoolWeight *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::BoolWeight *)new Xapian::BoolWeight();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::BoolWeight **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_BoolWeight_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::BoolWeight *arg1 = (Xapian::BoolWeight *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::BoolWeight **)&jarg1; 
  {
    try {
      result = ((Xapian::BoolWeight const *)arg1)->name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_XapianJNI_BoolWeight_1getSumPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jdouble jresult = 0 ;
  Xapian::BoolWeight *arg1 = (Xapian::BoolWeight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::termcount arg3 ;
  Xapian::weight result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::BoolWeight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (Xapian::termcount)jarg3; 
  {
    try {
      result = (Xapian::weight)((Xapian::BoolWeight const *)arg1)->get_sumpart(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_XapianJNI_BoolWeight_1getMaxPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::BoolWeight *arg1 = (Xapian::BoolWeight *) 0 ;
  Xapian::weight result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::BoolWeight **)&jarg1; 
  {
    try {
      result = (Xapian::weight)((Xapian::BoolWeight const *)arg1)->get_maxpart();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_XapianJNI_BoolWeight_1getSumExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jdouble jresult = 0 ;
  Xapian::BoolWeight *arg1 = (Xapian::BoolWeight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::weight result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::BoolWeight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  {
    try {
      result = (Xapian::weight)((Xapian::BoolWeight const *)arg1)->get_sumextra(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_XapianJNI_BoolWeight_1getMaxExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::BoolWeight *arg1 = (Xapian::BoolWeight *) 0 ;
  Xapian::weight result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::BoolWeight **)&jarg1; 
  {
    try {
      result = (Xapian::weight)((Xapian::BoolWeight const *)arg1)->get_maxextra();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1BoolWeight(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::BoolWeight *arg1 = (Xapian::BoolWeight *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::BoolWeight **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1BM25Weight_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5) {
  jlong jresult = 0 ;
  double arg1 ;
  double arg2 ;
  double arg3 ;
  double arg4 ;
  double arg5 ;
  Xapian::BM25Weight *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (double)jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = (double)jarg5; 
  {
    try {
      result = (Xapian::BM25Weight *)new Xapian::BM25Weight(arg1,arg2,arg3,arg4,arg5);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::BM25Weight **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1BM25Weight_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::BM25Weight *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::BM25Weight *)new Xapian::BM25Weight();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::BM25Weight **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_BM25Weight_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::BM25Weight *arg1 = (Xapian::BM25Weight *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::BM25Weight **)&jarg1; 
  {
    try {
      result = ((Xapian::BM25Weight const *)arg1)->name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_XapianJNI_BM25Weight_1getSumPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jdouble jresult = 0 ;
  Xapian::BM25Weight *arg1 = (Xapian::BM25Weight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::termcount arg3 ;
  Xapian::weight result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::BM25Weight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (Xapian::termcount)jarg3; 
  {
    try {
      result = (Xapian::weight)((Xapian::BM25Weight const *)arg1)->get_sumpart(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_XapianJNI_BM25Weight_1getMaxPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::BM25Weight *arg1 = (Xapian::BM25Weight *) 0 ;
  Xapian::weight result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::BM25Weight **)&jarg1; 
  {
    try {
      result = (Xapian::weight)((Xapian::BM25Weight const *)arg1)->get_maxpart();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_XapianJNI_BM25Weight_1getSumExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jdouble jresult = 0 ;
  Xapian::BM25Weight *arg1 = (Xapian::BM25Weight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::weight result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::BM25Weight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  {
    try {
      result = (Xapian::weight)((Xapian::BM25Weight const *)arg1)->get_sumextra(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_XapianJNI_BM25Weight_1getMaxExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::BM25Weight *arg1 = (Xapian::BM25Weight *) 0 ;
  Xapian::weight result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::BM25Weight **)&jarg1; 
  {
    try {
      result = (Xapian::weight)((Xapian::BM25Weight const *)arg1)->get_maxextra();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1BM25Weight(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::BM25Weight *arg1 = (Xapian::BM25Weight *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::BM25Weight **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1TradWeight_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jdouble jarg1) {
  jlong jresult = 0 ;
  double arg1 ;
  Xapian::TradWeight *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (double)jarg1; 
  {
    try {
      result = (Xapian::TradWeight *)new Xapian::TradWeight(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TradWeight **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1TradWeight_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::TradWeight *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::TradWeight *)new Xapian::TradWeight();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TradWeight **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_TradWeight_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::TradWeight *arg1 = (Xapian::TradWeight *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TradWeight **)&jarg1; 
  {
    try {
      result = ((Xapian::TradWeight const *)arg1)->name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_XapianJNI_TradWeight_1getSumPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jdouble jresult = 0 ;
  Xapian::TradWeight *arg1 = (Xapian::TradWeight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::termcount arg3 ;
  Xapian::weight result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TradWeight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (Xapian::termcount)jarg3; 
  {
    try {
      result = (Xapian::weight)((Xapian::TradWeight const *)arg1)->get_sumpart(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_XapianJNI_TradWeight_1getMaxPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::TradWeight *arg1 = (Xapian::TradWeight *) 0 ;
  Xapian::weight result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TradWeight **)&jarg1; 
  {
    try {
      result = (Xapian::weight)((Xapian::TradWeight const *)arg1)->get_maxpart();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_XapianJNI_TradWeight_1getSumExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jdouble jresult = 0 ;
  Xapian::TradWeight *arg1 = (Xapian::TradWeight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::weight result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TradWeight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  {
    try {
      result = (Xapian::weight)((Xapian::TradWeight const *)arg1)->get_sumextra(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_XapianJNI_TradWeight_1getMaxExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::TradWeight *arg1 = (Xapian::TradWeight *) 0 ;
  Xapian::weight result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TradWeight **)&jarg1; 
  {
    try {
      result = (Xapian::weight)((Xapian::TradWeight const *)arg1)->get_maxextra();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1TradWeight(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::TradWeight *arg1 = (Xapian::TradWeight *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::TradWeight **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1MatchSpy(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::MatchSpy *arg1 = (Xapian::MatchSpy *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::MatchSpy **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_MatchSpy_1apply(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jdouble jarg3) {
  Xapian::MatchSpy *arg1 = (Xapian::MatchSpy *) 0 ;
  Xapian::Document *arg2 = 0 ;
  Xapian::weight arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::MatchSpy **)&jarg1; 
  arg2 = *(Xapian::Document **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Document const & reference is null");
    return ;
  } 
  arg3 = (Xapian::weight)jarg3; 
  {
    try {
      (arg1)->operator ()((Xapian::Document const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_MatchSpy_1cloneWeight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MatchSpy *arg1 = (Xapian::MatchSpy *) 0 ;
  Xapian::MatchSpy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MatchSpy **)&jarg1; 
  {
    try {
      result = (Xapian::MatchSpy *)((Xapian::MatchSpy const *)arg1)->clone();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::MatchSpy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_MatchSpy_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::MatchSpy *arg1 = (Xapian::MatchSpy *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MatchSpy **)&jarg1; 
  {
    try {
      result = ((Xapian::MatchSpy const *)arg1)->name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_MatchSpy_1serialise(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::MatchSpy *arg1 = (Xapian::MatchSpy *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MatchSpy **)&jarg1; 
  {
    try {
      result = ((Xapian::MatchSpy const *)arg1)->serialise();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_MatchSpy_1unserialise(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  Xapian::MatchSpy *arg1 = (Xapian::MatchSpy *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::Registry *arg3 = 0 ;
  Xapian::MatchSpy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(Xapian::MatchSpy **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = *(Xapian::Registry **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Registry const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::MatchSpy *)((Xapian::MatchSpy const *)arg1)->unserialise((std::string const &)*arg2,(Xapian::Registry const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::MatchSpy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_MatchSpy_1serialiseResults(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::MatchSpy *arg1 = (Xapian::MatchSpy *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MatchSpy **)&jarg1; 
  {
    try {
      result = ((Xapian::MatchSpy const *)arg1)->serialise_results();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_MatchSpy_1mergeResults(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Xapian::MatchSpy *arg1 = (Xapian::MatchSpy *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MatchSpy **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      (arg1)->merge_results((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_MatchSpy_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::MatchSpy *arg1 = (Xapian::MatchSpy *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MatchSpy **)&jarg1; 
  {
    try {
      result = ((Xapian::MatchSpy const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1ValueCountMatchSpy_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::ValueCountMatchSpy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::ValueCountMatchSpy *)new Xapian::ValueCountMatchSpy();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::ValueCountMatchSpy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1ValueCountMatchSpy_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  Xapian::ValueCountMatchSpy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  {
    try {
      result = (Xapian::ValueCountMatchSpy *)new Xapian::ValueCountMatchSpy(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::ValueCountMatchSpy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_ValueCountMatchSpy_1getTotal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ValueCountMatchSpy *arg1 = (Xapian::ValueCountMatchSpy *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueCountMatchSpy **)&jarg1; 
  {
    try {
      result = ((Xapian::ValueCountMatchSpy const *)arg1)->get_total();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_ValueCountMatchSpy_1valuesBegin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ValueCountMatchSpy *arg1 = (Xapian::ValueCountMatchSpy *) 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueCountMatchSpy **)&jarg1; 
  {
    try {
      result = ((Xapian::ValueCountMatchSpy const *)arg1)->values_begin();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_ValueCountMatchSpy_1valuesEnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ValueCountMatchSpy *arg1 = (Xapian::ValueCountMatchSpy *) 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueCountMatchSpy **)&jarg1; 
  {
    try {
      result = ((Xapian::ValueCountMatchSpy const *)arg1)->values_end();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_ValueCountMatchSpy_1topValuesBegin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  Xapian::ValueCountMatchSpy *arg1 = (Xapian::ValueCountMatchSpy *) 0 ;
  size_t arg2 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueCountMatchSpy **)&jarg1; 
  arg2 = (size_t)jarg2; 
  {
    try {
      result = ((Xapian::ValueCountMatchSpy const *)arg1)->top_values_begin(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_ValueCountMatchSpy_1topValuesEnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  Xapian::ValueCountMatchSpy *arg1 = (Xapian::ValueCountMatchSpy *) 0 ;
  size_t arg2 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueCountMatchSpy **)&jarg1; 
  arg2 = (size_t)jarg2; 
  {
    try {
      result = ((Xapian::ValueCountMatchSpy const *)arg1)->top_values_end(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_ValueCountMatchSpy_1apply(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jdouble jarg3) {
  Xapian::ValueCountMatchSpy *arg1 = (Xapian::ValueCountMatchSpy *) 0 ;
  Xapian::Document *arg2 = 0 ;
  Xapian::weight arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::ValueCountMatchSpy **)&jarg1; 
  arg2 = *(Xapian::Document **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Document const & reference is null");
    return ;
  } 
  arg3 = (Xapian::weight)jarg3; 
  {
    try {
      (arg1)->operator ()((Xapian::Document const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_ValueCountMatchSpy_1cloneWeight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ValueCountMatchSpy *arg1 = (Xapian::ValueCountMatchSpy *) 0 ;
  Xapian::MatchSpy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueCountMatchSpy **)&jarg1; 
  {
    try {
      result = (Xapian::MatchSpy *)((Xapian::ValueCountMatchSpy const *)arg1)->clone();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::MatchSpy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_ValueCountMatchSpy_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::ValueCountMatchSpy *arg1 = (Xapian::ValueCountMatchSpy *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueCountMatchSpy **)&jarg1; 
  {
    try {
      result = ((Xapian::ValueCountMatchSpy const *)arg1)->name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_ValueCountMatchSpy_1serialise(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::ValueCountMatchSpy *arg1 = (Xapian::ValueCountMatchSpy *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueCountMatchSpy **)&jarg1; 
  {
    try {
      result = ((Xapian::ValueCountMatchSpy const *)arg1)->serialise();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_ValueCountMatchSpy_1unserialise(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  Xapian::ValueCountMatchSpy *arg1 = (Xapian::ValueCountMatchSpy *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::Registry *arg3 = 0 ;
  Xapian::MatchSpy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(Xapian::ValueCountMatchSpy **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = *(Xapian::Registry **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Registry const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::MatchSpy *)((Xapian::ValueCountMatchSpy const *)arg1)->unserialise((std::string const &)*arg2,(Xapian::Registry const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::MatchSpy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_ValueCountMatchSpy_1serialiseResults(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::ValueCountMatchSpy *arg1 = (Xapian::ValueCountMatchSpy *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueCountMatchSpy **)&jarg1; 
  {
    try {
      result = ((Xapian::ValueCountMatchSpy const *)arg1)->serialise_results();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_ValueCountMatchSpy_1mergeResults(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Xapian::ValueCountMatchSpy *arg1 = (Xapian::ValueCountMatchSpy *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueCountMatchSpy **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      (arg1)->merge_results((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_ValueCountMatchSpy_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::ValueCountMatchSpy *arg1 = (Xapian::ValueCountMatchSpy *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueCountMatchSpy **)&jarg1; 
  {
    try {
      result = ((Xapian::ValueCountMatchSpy const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1ValueCountMatchSpy(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::ValueCountMatchSpy *arg1 = (Xapian::ValueCountMatchSpy *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::ValueCountMatchSpy **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_Database_1addDatabase(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::Database *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::Database **)&jarg1; 
  arg2 = *(Xapian::Database **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Database const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->add_database((Xapian::Database const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1Database_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::Database *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::Database *)new Xapian::Database();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Database **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1Database_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Xapian::Database *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = (Xapian::Database *)new Xapian::Database((std::string const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Database **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1Database(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::Database **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1Database_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = 0 ;
  Xapian::Database *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Database const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::Database *)new Xapian::Database((Xapian::Database const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Database **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_Database_1reopen(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  {
    try {
      (arg1)->reopen();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_Database_1close(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  {
    try {
      (arg1)->close();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_Database_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  {
    try {
      result = ((Xapian::Database const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Database_1postListBegin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::PostingIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = ((Xapian::Database const *)arg1)->postlist_begin((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::PostingIterator **)&jresult = new Xapian::PostingIterator((const Xapian::PostingIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Database_1postListEnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::PostingIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = ((Xapian::Database const *)arg1)->postlist_end((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::PostingIterator **)&jresult = new Xapian::PostingIterator((const Xapian::PostingIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Database_1termListBegin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::docid arg2 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  {
    try {
      result = ((Xapian::Database const *)arg1)->termlist_begin(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Database_1termListEnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::docid arg2 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  {
    try {
      result = ((Xapian::Database const *)arg1)->termlist_end(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Database_1positionListBegin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jstring jarg3) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::docid arg2 ;
  std::string *arg3 = 0 ;
  Xapian::PositionIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try {
      result = ((Xapian::Database const *)arg1)->positionlist_begin(arg2,(std::string const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::PositionIterator **)&jresult = new Xapian::PositionIterator((const Xapian::PositionIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Database_1positionListEnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jstring jarg3) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::docid arg2 ;
  std::string *arg3 = 0 ;
  Xapian::PositionIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try {
      result = ((Xapian::Database const *)arg1)->positionlist_end(arg2,(std::string const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::PositionIterator **)&jresult = new Xapian::PositionIterator((const Xapian::PositionIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Database_1allTermsBegin_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  {
    try {
      result = ((Xapian::Database const *)arg1)->allterms_begin();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Database_1allTermsEnd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  {
    try {
      result = ((Xapian::Database const *)arg1)->allterms_end();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Database_1allTermsBegin_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = ((Xapian::Database const *)arg1)->allterms_begin((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Database_1allTermsEnd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = ((Xapian::Database const *)arg1)->allterms_end((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Database_1getDocCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::Database const *)arg1)->get_doccount();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Database_1getLastDocId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::docid result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  {
    try {
      result = (Xapian::docid)((Xapian::Database const *)arg1)->get_lastdocid();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_XapianJNI_Database_1getAvLength(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::doclength result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  {
    try {
      result = (Xapian::doclength)((Xapian::Database const *)arg1)->get_avlength();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Database_1getTermFreq(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (Xapian::doccount)((Xapian::Database const *)arg1)->get_termfreq((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_XapianJNI_Database_1termExists(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (bool)((Xapian::Database const *)arg1)->term_exists((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Database_1getCollectionFreq(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::termcount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (Xapian::termcount)((Xapian::Database const *)arg1)->get_collection_freq((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Database_1getValueFreq(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::valueno arg2 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  {
    try {
      result = (Xapian::doccount)((Xapian::Database const *)arg1)->get_value_freq(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_Database_1getValueLowerBound(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jstring jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::valueno arg2 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  {
    try {
      result = ((Xapian::Database const *)arg1)->get_value_lower_bound(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_Database_1getValueUpperBound(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jstring jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::valueno arg2 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  {
    try {
      result = ((Xapian::Database const *)arg1)->get_value_upper_bound(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Database_1getDoclengthLowerBound(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::termcount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  {
    try {
      result = (Xapian::termcount)((Xapian::Database const *)arg1)->get_doclength_lower_bound();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Database_1getDoclengthUpperBound(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::termcount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  {
    try {
      result = (Xapian::termcount)((Xapian::Database const *)arg1)->get_doclength_upper_bound();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Database_1getWdfUpperBound(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::termcount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (Xapian::termcount)((Xapian::Database const *)arg1)->get_wdf_upper_bound((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Database_1valuestreamBegin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::valueno arg2 ;
  Xapian::ValueIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  {
    try {
      result = ((Xapian::Database const *)arg1)->valuestream_begin(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::ValueIterator **)&jresult = new Xapian::ValueIterator((const Xapian::ValueIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Database_1valuestreamEnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::valueno arg2 ;
  Xapian::ValueIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  {
    try {
      result = ((Xapian::Database const *)arg1)->valuestream_end(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::ValueIterator **)&jresult = new Xapian::ValueIterator((const Xapian::ValueIterator &)result); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_XapianJNI_Database_1getDocLength(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jdouble jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::docid arg2 ;
  Xapian::doclength result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  {
    try {
      result = (Xapian::doclength)((Xapian::Database const *)arg1)->get_doclength(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_Database_1keepAlive(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  {
    try {
      (arg1)->keep_alive();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Database_1getDocument(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::docid arg2 ;
  Xapian::Document result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  {
    try {
      result = (arg1)->get_document(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Document **)&jresult = new Xapian::Document((const Xapian::Document &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_Database_1getSpellingSuggestion_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  jstring jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string *arg2 = 0 ;
  unsigned int arg3 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (unsigned int)jarg3; 
  {
    try {
      result = ((Xapian::Database const *)arg1)->get_spelling_suggestion((std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_Database_1getSpellingSuggestion_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jstring jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string *arg2 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = ((Xapian::Database const *)arg1)->get_spelling_suggestion((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Database_1spellingsBegin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  {
    try {
      result = ((Xapian::Database const *)arg1)->spellings_begin();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Database_1spellingsEnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  {
    try {
      result = ((Xapian::Database const *)arg1)->spellings_end();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Database_1synonymsBegin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = ((Xapian::Database const *)arg1)->synonyms_begin((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Database_1synonymsEnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = ((Xapian::Database const *)arg1)->synonyms_end((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Database_1synonymKeysBegin_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = ((Xapian::Database const *)arg1)->synonym_keys_begin((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Database_1synonymKeysBegin_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  {
    try {
      result = ((Xapian::Database const *)arg1)->synonym_keys_begin();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Database_1synonymKeysEnd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = ((Xapian::Database const *)arg1)->synonym_keys_end((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Database_1synonymKeysEnd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  {
    try {
      result = ((Xapian::Database const *)arg1)->synonym_keys_end();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_Database_1getMetadata(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jstring jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string *arg2 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = ((Xapian::Database const *)arg1)->get_metadata((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Database_1metadataKeysBegin_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = ((Xapian::Database const *)arg1)->metadata_keys_begin((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Database_1metadataKeysBegin_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  {
    try {
      result = ((Xapian::Database const *)arg1)->metadata_keys_begin();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Database_1metadataKeysEnd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = ((Xapian::Database const *)arg1)->metadata_keys_end((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Database_1metadataKeysEnd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  {
    try {
      result = ((Xapian::Database const *)arg1)->metadata_keys_end();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_Database_1getUuid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  {
    try {
      result = ((Xapian::Database const *)arg1)->get_uuid();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1WritableDatabase(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1WritableDatabase_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::WritableDatabase *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::WritableDatabase *)new Xapian::WritableDatabase();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::WritableDatabase **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1WritableDatabase_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  int arg2 ;
  Xapian::WritableDatabase *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = (int)jarg2; 
  {
    try {
      result = (Xapian::WritableDatabase *)new Xapian::WritableDatabase((std::string const &)*arg1,arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::WritableDatabase **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1WritableDatabase_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::WritableDatabase *arg1 = 0 ;
  Xapian::WritableDatabase *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::WritableDatabase const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::WritableDatabase *)new Xapian::WritableDatabase((Xapian::WritableDatabase const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::WritableDatabase **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_WritableDatabase_1commit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  {
    try {
      (arg1)->commit();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_WritableDatabase_1flush(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  {
    try {
      (arg1)->flush();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_WritableDatabase_1beginTransaction_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  {
    try {
      (arg1)->begin_transaction(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_WritableDatabase_1beginTransaction_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  {
    try {
      (arg1)->begin_transaction();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_WritableDatabase_1commitTransaction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  {
    try {
      (arg1)->commit_transaction();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_WritableDatabase_1cancelTransaction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  {
    try {
      (arg1)->cancel_transaction();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_WritableDatabase_1addDocument(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  Xapian::Document *arg2 = 0 ;
  Xapian::docid result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  arg2 = *(Xapian::Document **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Document const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::docid)(arg1)->add_document((Xapian::Document const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_WritableDatabase_1deleteDocument_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  Xapian::docid arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  {
    try {
      (arg1)->delete_document(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_WritableDatabase_1replaceDocument_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jobject jarg3_) {
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  Xapian::docid arg2 ;
  Xapian::Document *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  arg3 = *(Xapian::Document **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Document const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->replace_document(arg2,(Xapian::Document const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_WritableDatabase_1deleteDocument_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      (arg1)->delete_document((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_WritableDatabase_1replaceDocument_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::Document *arg3 = 0 ;
  Xapian::docid result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = *(Xapian::Document **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Document const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::docid)(arg1)->replace_document((std::string const &)*arg2,(Xapian::Document const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_WritableDatabase_1addSpelling_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::termcount arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (Xapian::termcount)jarg3; 
  {
    try {
      ((Xapian::WritableDatabase const *)arg1)->add_spelling((std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_WritableDatabase_1addSpelling_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      ((Xapian::WritableDatabase const *)arg1)->add_spelling((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_WritableDatabase_1removeSpelling_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::termcount arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (Xapian::termcount)jarg3; 
  {
    try {
      ((Xapian::WritableDatabase const *)arg1)->remove_spelling((std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_WritableDatabase_1removeSpelling_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      ((Xapian::WritableDatabase const *)arg1)->remove_spelling((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_WritableDatabase_1addSynonym(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try {
      ((Xapian::WritableDatabase const *)arg1)->add_synonym((std::string const &)*arg2,(std::string const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_WritableDatabase_1removeSynonym(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try {
      ((Xapian::WritableDatabase const *)arg1)->remove_synonym((std::string const &)*arg2,(std::string const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_WritableDatabase_1clearSynonyms(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      ((Xapian::WritableDatabase const *)arg1)->clear_synonyms((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_WritableDatabase_1setMetadata(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try {
      (arg1)->set_metadata((std::string const &)*arg2,(std::string const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_WritableDatabase_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  {
    try {
      result = ((Xapian::WritableDatabase const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_XapianJNI_DB_1CREATE_1OR_1OPEN_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) Xapian::DB_CREATE_OR_OPEN;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_XapianJNI_DB_1CREATE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) Xapian::DB_CREATE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_XapianJNI_DB_1CREATE_1OR_1OVERWRITE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) Xapian::DB_CREATE_OR_OVERWRITE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_XapianJNI_DB_1OPEN_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) Xapian::DB_OPEN;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Auto_1openStub(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Xapian::Database result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = Xapian::Auto::open_stub((std::string const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Database **)&jresult = new Xapian::Database((const Xapian::Database &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Brass_1open_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Xapian::Database result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = Xapian::Brass::open((std::string const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Database **)&jresult = new Xapian::Database((const Xapian::Database &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Brass_1open_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2, jint jarg3) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  int arg2 ;
  int arg3 ;
  Xapian::WritableDatabase result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      result = Xapian::Brass::open((std::string const &)*arg1,arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::WritableDatabase **)&jresult = new Xapian::WritableDatabase((const Xapian::WritableDatabase &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Brass_1open_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  int arg2 ;
  Xapian::WritableDatabase result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = (int)jarg2; 
  {
    try {
      result = Xapian::Brass::open((std::string const &)*arg1,arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::WritableDatabase **)&jresult = new Xapian::WritableDatabase((const Xapian::WritableDatabase &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Chert_1open_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Xapian::Database result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = Xapian::Chert::open((std::string const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Database **)&jresult = new Xapian::Database((const Xapian::Database &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Chert_1open_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2, jint jarg3) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  int arg2 ;
  int arg3 ;
  Xapian::WritableDatabase result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      result = Xapian::Chert::open((std::string const &)*arg1,arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::WritableDatabase **)&jresult = new Xapian::WritableDatabase((const Xapian::WritableDatabase &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Chert_1open_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  int arg2 ;
  Xapian::WritableDatabase result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = (int)jarg2; 
  {
    try {
      result = Xapian::Chert::open((std::string const &)*arg1,arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::WritableDatabase **)&jresult = new Xapian::WritableDatabase((const Xapian::WritableDatabase &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Flint_1open_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Xapian::Database result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = Xapian::Flint::open((std::string const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Database **)&jresult = new Xapian::Database((const Xapian::Database &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Flint_1open_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2, jint jarg3) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  int arg2 ;
  int arg3 ;
  Xapian::WritableDatabase result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      result = Xapian::Flint::open((std::string const &)*arg1,arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::WritableDatabase **)&jresult = new Xapian::WritableDatabase((const Xapian::WritableDatabase &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Flint_1open_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  int arg2 ;
  Xapian::WritableDatabase result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = (int)jarg2; 
  {
    try {
      result = Xapian::Flint::open((std::string const &)*arg1,arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::WritableDatabase **)&jresult = new Xapian::WritableDatabase((const Xapian::WritableDatabase &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_InMemory_1open(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::WritableDatabase result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = Xapian::InMemory::open();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::WritableDatabase **)&jresult = new Xapian::WritableDatabase((const Xapian::WritableDatabase &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Remote_1open_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  unsigned int arg2 ;
  Xapian::timeout arg3 ;
  Xapian::timeout arg4 ;
  Xapian::Database result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = (unsigned int)jarg2; 
  arg3 = (Xapian::timeout)jarg3; 
  arg4 = (Xapian::timeout)jarg4; 
  {
    try {
      result = Xapian::Remote::open((std::string const &)*arg1,arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Database **)&jresult = new Xapian::Database((const Xapian::Database &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Remote_1open_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  unsigned int arg2 ;
  Xapian::timeout arg3 ;
  Xapian::Database result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = (unsigned int)jarg2; 
  arg3 = (Xapian::timeout)jarg3; 
  {
    try {
      result = Xapian::Remote::open((std::string const &)*arg1,arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Database **)&jresult = new Xapian::Database((const Xapian::Database &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Remote_1open_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  unsigned int arg2 ;
  Xapian::Database result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = (unsigned int)jarg2; 
  {
    try {
      result = Xapian::Remote::open((std::string const &)*arg1,arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Database **)&jresult = new Xapian::Database((const Xapian::Database &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Remote_1openWritable_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  unsigned int arg2 ;
  Xapian::timeout arg3 ;
  Xapian::timeout arg4 ;
  Xapian::WritableDatabase result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = (unsigned int)jarg2; 
  arg3 = (Xapian::timeout)jarg3; 
  arg4 = (Xapian::timeout)jarg4; 
  {
    try {
      result = Xapian::Remote::open_writable((std::string const &)*arg1,arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::WritableDatabase **)&jresult = new Xapian::WritableDatabase((const Xapian::WritableDatabase &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Remote_1openWritable_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  unsigned int arg2 ;
  Xapian::timeout arg3 ;
  Xapian::WritableDatabase result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = (unsigned int)jarg2; 
  arg3 = (Xapian::timeout)jarg3; 
  {
    try {
      result = Xapian::Remote::open_writable((std::string const &)*arg1,arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::WritableDatabase **)&jresult = new Xapian::WritableDatabase((const Xapian::WritableDatabase &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Remote_1openWritable_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  unsigned int arg2 ;
  Xapian::WritableDatabase result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = (unsigned int)jarg2; 
  {
    try {
      result = Xapian::Remote::open_writable((std::string const &)*arg1,arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::WritableDatabase **)&jresult = new Xapian::WritableDatabase((const Xapian::WritableDatabase &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Remote_1open_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  std::string *arg2 = 0 ;
  Xapian::timeout arg3 ;
  Xapian::Database result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (Xapian::timeout)jarg3; 
  {
    try {
      result = Xapian::Remote::open((std::string const &)*arg1,(std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Database **)&jresult = new Xapian::Database((const Xapian::Database &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Remote_1open_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  std::string *arg2 = 0 ;
  Xapian::Database result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = Xapian::Remote::open((std::string const &)*arg1,(std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Database **)&jresult = new Xapian::Database((const Xapian::Database &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Remote_1openWritable_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  std::string *arg2 = 0 ;
  Xapian::timeout arg3 ;
  Xapian::WritableDatabase result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (Xapian::timeout)jarg3; 
  {
    try {
      result = Xapian::Remote::open_writable((std::string const &)*arg1,(std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::WritableDatabase **)&jresult = new Xapian::WritableDatabase((const Xapian::WritableDatabase &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Remote_1openWritable_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  std::string *arg2 = 0 ;
  Xapian::WritableDatabase result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = Xapian::Remote::open_writable((std::string const &)*arg1,(std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::WritableDatabase **)&jresult = new Xapian::WritableDatabase((const Xapian::WritableDatabase &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1Query_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Query *arg1 = 0 ;
  Xapian::Query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Query **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Query const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::Query *)new Xapian::Query((Xapian::Query const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Query **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1Query_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::Query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::Query *)new Xapian::Query();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Query **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1Query(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::Query *arg1 = (Xapian::Query *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::Query **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1Query_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Xapian::termcount arg2 ;
  Xapian::termpos arg3 ;
  Xapian::Query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (Xapian::termpos)jarg3; 
  {
    try {
      result = (Xapian::Query *)new Xapian::Query((std::string const &)*arg1,arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Query **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1Query_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Xapian::termcount arg2 ;
  Xapian::Query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = (Xapian::termcount)jarg2; 
  {
    try {
      result = (Xapian::Query *)new Xapian::Query((std::string const &)*arg1,arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Query **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1Query_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Xapian::Query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = (Xapian::Query *)new Xapian::Query((std::string const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Query **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1Query_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  Xapian::Query::op arg1 ;
  Xapian::Query *arg2 = 0 ;
  Xapian::Query *arg3 = 0 ;
  Xapian::Query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = (Xapian::Query::op)jarg1; 
  arg2 = *(Xapian::Query **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Query const & reference is null");
    return 0;
  } 
  arg3 = *(Xapian::Query **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Query const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::Query *)new Xapian::Query(arg1,(Xapian::Query const &)*arg2,(Xapian::Query const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Query **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1Query_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2, jstring jarg3) {
  jlong jresult = 0 ;
  Xapian::Query::op arg1 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  Xapian::Query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::Query::op)jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try {
      result = (Xapian::Query *)new Xapian::Query(arg1,(std::string const &)*arg2,(std::string const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Query **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1Query_1_1SWIG_19(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_, jdouble jarg3) {
  jlong jresult = 0 ;
  Xapian::Query::op arg1 ;
  Xapian::Query arg2 ;
  double arg3 ;
  Xapian::Query *argp2 ;
  Xapian::Query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = (Xapian::Query::op)jarg1; 
  argp2 = *(Xapian::Query **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null Xapian::Query");
    return 0;
  }
  arg2 = *argp2; 
  arg3 = (double)jarg3; 
  {
    try {
      result = (Xapian::Query *)new Xapian::Query(arg1,arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Query **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1Query_1_1SWIG_110(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jstring jarg3, jstring jarg4) {
  jlong jresult = 0 ;
  Xapian::Query::op arg1 ;
  Xapian::valueno arg2 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  Xapian::Query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::Query::op)jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  if(!jarg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0); 
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  jenv->ReleaseStringUTFChars(jarg4, arg4_pstr); 
  {
    try {
      result = (Xapian::Query *)new Xapian::Query(arg1,arg2,(std::string const &)*arg3,(std::string const &)*arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Query **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1Query_1_1SWIG_111(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jstring jarg3) {
  jlong jresult = 0 ;
  Xapian::Query::op arg1 ;
  Xapian::valueno arg2 ;
  std::string *arg3 = 0 ;
  Xapian::Query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::Query::op)jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try {
      result = (Xapian::Query *)new Xapian::Query(arg1,arg2,(std::string const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Query **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1Query_1_1SWIG_112(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  Xapian::Query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::Query *)new Xapian::Query(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Query **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Query_1getLength(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Query *arg1 = (Xapian::Query *) 0 ;
  Xapian::termcount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Query **)&jarg1; 
  {
    try {
      result = (Xapian::termcount)((Xapian::Query const *)arg1)->get_length();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Query_1getTermsBegin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Query *arg1 = (Xapian::Query *) 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Query **)&jarg1; 
  {
    try {
      result = ((Xapian::Query const *)arg1)->get_terms_begin();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Query_1getTermsEnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Query *arg1 = (Xapian::Query *) 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Query **)&jarg1; 
  {
    try {
      result = ((Xapian::Query const *)arg1)->get_terms_end();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_XapianJNI_Query_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Xapian::Query *arg1 = (Xapian::Query *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Query **)&jarg1; 
  {
    try {
      result = (bool)((Xapian::Query const *)arg1)->empty();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_Query_1serialise(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::Query *arg1 = (Xapian::Query *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Query **)&jarg1; 
  {
    try {
      result = ((Xapian::Query const *)arg1)->serialise();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Query_1unserialise_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Xapian::Query result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = Xapian::Query::unserialise((std::string const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Query **)&jresult = new Xapian::Query((const Xapian::Query &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_Query_1unserialise_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Xapian::Registry *arg2 = 0 ;
  Xapian::Query result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = *(Xapian::Registry **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Registry const & reference is null");
    return 0;
  } 
  {
    try {
      result = Xapian::Query::unserialise((std::string const &)*arg1,(Xapian::Registry const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Query **)&jresult = new Xapian::Query((const Xapian::Query &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_Query_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::Query *arg1 = (Xapian::Query *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Query **)&jarg1; 
  {
    try {
      result = ((Xapian::Query const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1Query_1_1SWIG_113(JNIEnv *jenv, jclass jcls, jint jarg1, jobjectArray jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  Xapian::Query::op arg1 ;
  std::vector< std::string > *arg2 = 0 ;
  Xapian::termcount arg3 ;
  vector< string > v2 ;
  jsize len2 ;
  Xapian::Query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::Query::op)jarg1; 
  {
    len2 = jenv->GetArrayLength(jarg2);
    v2.reserve(len2);
    for (int i = 0; i < len2; ++i) {
      jstring term = (jstring)jenv->GetObjectArrayElement(jarg2, i);
      const char *c_term = jenv->GetStringUTFChars(term, 0);
      v2.push_back(c_term);
      jenv->ReleaseStringUTFChars(term, c_term);
      jenv->DeleteLocalRef(term);
    }
    arg2 = &v2;
  }
  arg3 = (Xapian::termcount)jarg3; 
  {
    try {
      result = (Xapian::Query *)new_Xapian_Query__SWIG_13(arg1,(std::vector< std::string > const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Query **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1Query_1_1SWIG_114(JNIEnv *jenv, jclass jcls, jint jarg1, jobjectArray jarg2) {
  jlong jresult = 0 ;
  Xapian::Query::op arg1 ;
  std::vector< std::string > *arg2 = 0 ;
  vector< string > v2 ;
  jsize len2 ;
  Xapian::Query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::Query::op)jarg1; 
  {
    len2 = jenv->GetArrayLength(jarg2);
    v2.reserve(len2);
    for (int i = 0; i < len2; ++i) {
      jstring term = (jstring)jenv->GetObjectArrayElement(jarg2, i);
      const char *c_term = jenv->GetStringUTFChars(term, 0);
      v2.push_back(c_term);
      jenv->ReleaseStringUTFChars(term, c_term);
      jenv->DeleteLocalRef(term);
    }
    arg2 = &v2;
  }
  {
    try {
      result = (Xapian::Query *)new_Xapian_Query__SWIG_13(arg1,(std::vector< std::string > const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Query **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1Query_1_1SWIG_115(JNIEnv *jenv, jclass jcls, jint jarg1, jlongArray jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  Xapian::Query::op arg1 ;
  std::vector< Xapian::Query > *arg2 = 0 ;
  Xapian::termcount arg3 ;
  vector< Xapian::Query > v2 ;
  jlong *jarr2 ;
  jsize len2 ;
  Xapian::Query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::Query::op)jarg1; 
  {
    if (!jarg2)
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    len2 = jenv->GetArrayLength(jarg2);
    v2.reserve(len2);
    jarr2 = jenv->GetLongArrayElements(jarg2, NULL);
    if (!jarr2) return 0;
    for (int i = 0; i < len2; ++i) {
      Xapian::Query * query = *(Xapian::Query **)&jarr2[i];
      v2.push_back(*query);
    }
    /* We don't change the array so use JNI_ABORT to avoid any work
         * copying back non-existent changes if the JVM gave us a copy
         * of the array data. */
    jenv->ReleaseLongArrayElements(jarg2, jarr2, JNI_ABORT);
    arg2 = &v2;
  }
  arg3 = (Xapian::termcount)jarg3; 
  {
    try {
      result = (Xapian::Query *)new_Xapian_Query__SWIG_15(arg1,(std::vector< Xapian::Query > const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Query **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1Query_1_1SWIG_116(JNIEnv *jenv, jclass jcls, jint jarg1, jlongArray jarg2) {
  jlong jresult = 0 ;
  Xapian::Query::op arg1 ;
  std::vector< Xapian::Query > *arg2 = 0 ;
  vector< Xapian::Query > v2 ;
  jlong *jarr2 ;
  jsize len2 ;
  Xapian::Query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::Query::op)jarg1; 
  {
    if (!jarg2)
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    len2 = jenv->GetArrayLength(jarg2);
    v2.reserve(len2);
    jarr2 = jenv->GetLongArrayElements(jarg2, NULL);
    if (!jarr2) return 0;
    for (int i = 0; i < len2; ++i) {
      Xapian::Query * query = *(Xapian::Query **)&jarr2[i];
      v2.push_back(*query);
    }
    /* We don't change the array so use JNI_ABORT to avoid any work
         * copying back non-existent changes if the JVM gave us a copy
         * of the array data. */
    jenv->ReleaseLongArrayElements(jarg2, jarr2, JNI_ABORT);
    arg2 = &v2;
  }
  {
    try {
      result = (Xapian::Query *)new_Xapian_Query__SWIG_15(arg1,(std::vector< Xapian::Query > const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Query **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_XapianJNI_Stopper_1apply(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  Xapian::Stopper *arg1 = (Xapian::Stopper *) 0 ;
  std::string *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Stopper **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (bool)((Xapian::Stopper const *)arg1)->operator ()((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1Stopper(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::Stopper *arg1 = (Xapian::Stopper *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::Stopper **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_Stopper_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::Stopper *arg1 = (Xapian::Stopper *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Stopper **)&jarg1; 
  {
    try {
      result = ((Xapian::Stopper const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_Stopper_1toStringSwigExplicitStopper(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::Stopper *arg1 = (Xapian::Stopper *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Stopper **)&jarg1; 
  {
    try {
      result = ((Xapian::Stopper const *)arg1)->Xapian::Stopper::get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1Stopper(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::Stopper *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::Stopper *)new SwigDirector_Stopper(jenv);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Stopper **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_Stopper_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  Xapian::Stopper *obj = *((Xapian::Stopper **)&objarg);
  (void)jcls;
  SwigDirector_Stopper *director = dynamic_cast<SwigDirector_Stopper *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_Stopper_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  Xapian::Stopper *obj = *((Xapian::Stopper **)&objarg);
  SwigDirector_Stopper *director = dynamic_cast<SwigDirector_Stopper *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1SimpleStopper(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::SimpleStopper *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::SimpleStopper *)new Xapian::SimpleStopper();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::SimpleStopper **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_SimpleStopper_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Xapian::SimpleStopper *arg1 = (Xapian::SimpleStopper *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::SimpleStopper **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      (arg1)->add((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_XapianJNI_SimpleStopper_1apply(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  Xapian::SimpleStopper *arg1 = (Xapian::SimpleStopper *) 0 ;
  std::string *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::SimpleStopper **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (bool)((Xapian::SimpleStopper const *)arg1)->operator ()((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_SimpleStopper_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::SimpleStopper *arg1 = (Xapian::SimpleStopper *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::SimpleStopper **)&jarg1; 
  {
    try {
      result = ((Xapian::SimpleStopper const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1SimpleStopper(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::SimpleStopper *arg1 = (Xapian::SimpleStopper *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::SimpleStopper **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1ValueRangeProcessor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::ValueRangeProcessor *arg1 = (Xapian::ValueRangeProcessor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::ValueRangeProcessor **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jint JNICALL Java_XapianJNI_ValueRangeProcessor_1apply(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  Xapian::ValueRangeProcessor *arg1 = (Xapian::ValueRangeProcessor *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  Xapian::valueno result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueRangeProcessor **)&jarg1; 
  arg2 = *(std::string **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string & reference is null");
    return 0;
  } 
  arg3 = *(std::string **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::valueno)(arg1)->operator ()(*arg2,*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1ValueRangeProcessor(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::ValueRangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::ValueRangeProcessor *)new SwigDirector_ValueRangeProcessor(jenv);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::ValueRangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_ValueRangeProcessor_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  Xapian::ValueRangeProcessor *obj = *((Xapian::ValueRangeProcessor **)&objarg);
  (void)jcls;
  SwigDirector_ValueRangeProcessor *director = dynamic_cast<SwigDirector_ValueRangeProcessor *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_ValueRangeProcessor_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  Xapian::ValueRangeProcessor *obj = *((Xapian::ValueRangeProcessor **)&objarg);
  SwigDirector_ValueRangeProcessor *director = dynamic_cast<SwigDirector_ValueRangeProcessor *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1StringValueRangeProcessor_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  Xapian::StringValueRangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  {
    try {
      result = (Xapian::StringValueRangeProcessor *)new Xapian::StringValueRangeProcessor(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::StringValueRangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1StringValueRangeProcessor_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2, jboolean jarg3) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  std::string *arg2 = 0 ;
  bool arg3 ;
  Xapian::StringValueRangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (Xapian::StringValueRangeProcessor *)new Xapian::StringValueRangeProcessor(arg1,(std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::StringValueRangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1StringValueRangeProcessor_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  std::string *arg2 = 0 ;
  Xapian::StringValueRangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (Xapian::StringValueRangeProcessor *)new Xapian::StringValueRangeProcessor(arg1,(std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::StringValueRangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_XapianJNI_StringValueRangeProcessor_1apply(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  Xapian::StringValueRangeProcessor *arg1 = (Xapian::StringValueRangeProcessor *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  Xapian::valueno result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::StringValueRangeProcessor **)&jarg1; 
  arg2 = *(std::string **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string & reference is null");
    return 0;
  } 
  arg3 = *(std::string **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::valueno)(arg1)->operator ()(*arg2,*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1StringValueRangeProcessor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::StringValueRangeProcessor *arg1 = (Xapian::StringValueRangeProcessor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::StringValueRangeProcessor **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1DateValueRangeProcessor_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jboolean jarg2, jint jarg3) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  bool arg2 ;
  int arg3 ;
  Xapian::DateValueRangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  arg2 = jarg2 ? true : false; 
  arg3 = (int)jarg3; 
  {
    try {
      result = (Xapian::DateValueRangeProcessor *)new Xapian::DateValueRangeProcessor(arg1,arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::DateValueRangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1DateValueRangeProcessor_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jboolean jarg2) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  bool arg2 ;
  Xapian::DateValueRangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = (Xapian::DateValueRangeProcessor *)new Xapian::DateValueRangeProcessor(arg1,arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::DateValueRangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1DateValueRangeProcessor_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  Xapian::DateValueRangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  {
    try {
      result = (Xapian::DateValueRangeProcessor *)new Xapian::DateValueRangeProcessor(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::DateValueRangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1DateValueRangeProcessor_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2, jboolean jarg3, jboolean jarg4, jint jarg5) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  std::string *arg2 = 0 ;
  bool arg3 ;
  bool arg4 ;
  int arg5 ;
  Xapian::DateValueRangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = jarg3 ? true : false; 
  arg4 = jarg4 ? true : false; 
  arg5 = (int)jarg5; 
  {
    try {
      result = (Xapian::DateValueRangeProcessor *)new Xapian::DateValueRangeProcessor(arg1,(std::string const &)*arg2,arg3,arg4,arg5);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::DateValueRangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1DateValueRangeProcessor_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2, jboolean jarg3, jboolean jarg4) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  std::string *arg2 = 0 ;
  bool arg3 ;
  bool arg4 ;
  Xapian::DateValueRangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = jarg3 ? true : false; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (Xapian::DateValueRangeProcessor *)new Xapian::DateValueRangeProcessor(arg1,(std::string const &)*arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::DateValueRangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1DateValueRangeProcessor_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2, jboolean jarg3) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  std::string *arg2 = 0 ;
  bool arg3 ;
  Xapian::DateValueRangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (Xapian::DateValueRangeProcessor *)new Xapian::DateValueRangeProcessor(arg1,(std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::DateValueRangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1DateValueRangeProcessor_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  std::string *arg2 = 0 ;
  Xapian::DateValueRangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (Xapian::DateValueRangeProcessor *)new Xapian::DateValueRangeProcessor(arg1,(std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::DateValueRangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_XapianJNI_DateValueRangeProcessor_1apply(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  Xapian::DateValueRangeProcessor *arg1 = (Xapian::DateValueRangeProcessor *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  Xapian::valueno result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::DateValueRangeProcessor **)&jarg1; 
  arg2 = *(std::string **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string & reference is null");
    return 0;
  } 
  arg3 = *(std::string **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::valueno)(arg1)->operator ()(*arg2,*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1DateValueRangeProcessor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::DateValueRangeProcessor *arg1 = (Xapian::DateValueRangeProcessor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::DateValueRangeProcessor **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1NumberValueRangeProcessor_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  Xapian::NumberValueRangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  {
    try {
      result = (Xapian::NumberValueRangeProcessor *)new Xapian::NumberValueRangeProcessor(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::NumberValueRangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1NumberValueRangeProcessor_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2, jboolean jarg3) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  std::string *arg2 = 0 ;
  bool arg3 ;
  Xapian::NumberValueRangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (Xapian::NumberValueRangeProcessor *)new Xapian::NumberValueRangeProcessor(arg1,(std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::NumberValueRangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1NumberValueRangeProcessor_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  std::string *arg2 = 0 ;
  Xapian::NumberValueRangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (Xapian::NumberValueRangeProcessor *)new Xapian::NumberValueRangeProcessor(arg1,(std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::NumberValueRangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_XapianJNI_NumberValueRangeProcessor_1apply(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  Xapian::NumberValueRangeProcessor *arg1 = (Xapian::NumberValueRangeProcessor *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  Xapian::valueno result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::NumberValueRangeProcessor **)&jarg1; 
  arg2 = *(std::string **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string & reference is null");
    return 0;
  } 
  arg3 = *(std::string **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::valueno)(arg1)->operator ()(*arg2,*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1NumberValueRangeProcessor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::NumberValueRangeProcessor *arg1 = (Xapian::NumberValueRangeProcessor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::NumberValueRangeProcessor **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jint JNICALL Java_XapianJNI_QueryParser_1FLAG_1BOOLEAN_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::QueryParser::feature_flag result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::QueryParser::feature_flag)Xapian::QueryParser::FLAG_BOOLEAN;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_XapianJNI_QueryParser_1FLAG_1PHRASE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::QueryParser::feature_flag result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::QueryParser::feature_flag)Xapian::QueryParser::FLAG_PHRASE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_XapianJNI_QueryParser_1FLAG_1LOVEHATE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::QueryParser::feature_flag result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::QueryParser::feature_flag)Xapian::QueryParser::FLAG_LOVEHATE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_XapianJNI_QueryParser_1FLAG_1BOOLEAN_1ANY_1CASE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::QueryParser::feature_flag result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::QueryParser::feature_flag)Xapian::QueryParser::FLAG_BOOLEAN_ANY_CASE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_XapianJNI_QueryParser_1FLAG_1WILDCARD_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::QueryParser::feature_flag result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::QueryParser::feature_flag)Xapian::QueryParser::FLAG_WILDCARD;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_XapianJNI_QueryParser_1FLAG_1PURE_1NOT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::QueryParser::feature_flag result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::QueryParser::feature_flag)Xapian::QueryParser::FLAG_PURE_NOT;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_XapianJNI_QueryParser_1FLAG_1PARTIAL_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::QueryParser::feature_flag result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::QueryParser::feature_flag)Xapian::QueryParser::FLAG_PARTIAL;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_XapianJNI_QueryParser_1FLAG_1SPELLING_1CORRECTION_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::QueryParser::feature_flag result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::QueryParser::feature_flag)Xapian::QueryParser::FLAG_SPELLING_CORRECTION;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_XapianJNI_QueryParser_1FLAG_1SYNONYM_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::QueryParser::feature_flag result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::QueryParser::feature_flag)Xapian::QueryParser::FLAG_SYNONYM;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_XapianJNI_QueryParser_1FLAG_1AUTO_1SYNONYMS_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::QueryParser::feature_flag result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::QueryParser::feature_flag)Xapian::QueryParser::FLAG_AUTO_SYNONYMS;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_XapianJNI_QueryParser_1FLAG_1AUTO_1MULTIWORD_1SYNONYMS_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::QueryParser::feature_flag result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::QueryParser::feature_flag)Xapian::QueryParser::FLAG_AUTO_MULTIWORD_SYNONYMS;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_XapianJNI_QueryParser_1FLAG_1DEFAULT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::QueryParser::feature_flag result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::QueryParser::feature_flag)Xapian::QueryParser::FLAG_DEFAULT;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1QueryParser(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::QueryParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::QueryParser *)new Xapian::QueryParser();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::QueryParser **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1QueryParser(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_QueryParser_1setStemmer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  Xapian::Stem *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  arg2 = *(Xapian::Stem **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Stem const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->set_stemmer((Xapian::Stem const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_QueryParser_1setStemmingStrategy(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  Xapian::QueryParser::stem_strategy arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  arg2 = (Xapian::QueryParser::stem_strategy)jarg2; 
  {
    try {
      (arg1)->set_stemming_strategy(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_QueryParser_1setStopper_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  Xapian::Stopper *arg2 = (Xapian::Stopper *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  arg2 = *(Xapian::Stopper **)&jarg2; 
  {
    try {
      (arg1)->set_stopper((Xapian::Stopper const *)arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_QueryParser_1setStopper_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  {
    try {
      (arg1)->set_stopper();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_QueryParser_1setDefaultOp(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  Xapian::Query::op arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  arg2 = (Xapian::Query::op)jarg2; 
  {
    try {
      (arg1)->set_default_op(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jint JNICALL Java_XapianJNI_QueryParser_1getDefaultOp(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  Xapian::Query::op result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  {
    try {
      result = (Xapian::Query::op)((Xapian::QueryParser const *)arg1)->get_default_op();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_QueryParser_1setDatabase(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  Xapian::Database *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  arg2 = *(Xapian::Database **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Database const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->set_database((Xapian::Database const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_QueryParser_1parseQuery_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jstring jarg4) {
  jlong jresult = 0 ;
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  std::string *arg2 = 0 ;
  unsigned int arg3 ;
  std::string *arg4 = 0 ;
  Xapian::Query result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (unsigned int)jarg3; 
  if(!jarg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0); 
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  jenv->ReleaseStringUTFChars(jarg4, arg4_pstr); 
  {
    try {
      result = (arg1)->parse_query((std::string const &)*arg2,arg3,(std::string const &)*arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Query **)&jresult = new Xapian::Query((const Xapian::Query &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_QueryParser_1parseQuery_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  std::string *arg2 = 0 ;
  unsigned int arg3 ;
  Xapian::Query result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (unsigned int)jarg3; 
  {
    try {
      result = (arg1)->parse_query((std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Query **)&jresult = new Xapian::Query((const Xapian::Query &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_QueryParser_1parseQuery_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::Query result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (arg1)->parse_query((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Query **)&jresult = new Xapian::Query((const Xapian::Query &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_QueryParser_1addPrefix(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try {
      (arg1)->add_prefix((std::string const &)*arg2,(std::string const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_QueryParser_1addBooleanPrefix_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jboolean jarg4) {
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  bool arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  arg4 = jarg4 ? true : false; 
  {
    try {
      (arg1)->add_boolean_prefix((std::string const &)*arg2,(std::string const &)*arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_QueryParser_1addBooleanPrefix_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try {
      (arg1)->add_boolean_prefix((std::string const &)*arg2,(std::string const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_QueryParser_1stopListBegin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  {
    try {
      result = ((Xapian::QueryParser const *)arg1)->stoplist_begin();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_QueryParser_1stopListEnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  {
    try {
      result = ((Xapian::QueryParser const *)arg1)->stoplist_end();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_QueryParser_1unstemBegin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = ((Xapian::QueryParser const *)arg1)->unstem_begin((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_QueryParser_1unstemEnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = ((Xapian::QueryParser const *)arg1)->unstem_end((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_QueryParser_1addValuerangeprocessor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  Xapian::ValueRangeProcessor *arg2 = (Xapian::ValueRangeProcessor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  arg2 = *(Xapian::ValueRangeProcessor **)&jarg2; 
  {
    try {
      (arg1)->add_valuerangeprocessor(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_QueryParser_1getCorrectedQueryString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  {
    try {
      result = ((Xapian::QueryParser const *)arg1)->get_corrected_query_string();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_QueryParser_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  {
    try {
      result = ((Xapian::QueryParser const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_sortableSerialise(JNIEnv *jenv, jclass jcls, jdouble jarg1) {
  jstring jresult = 0 ;
  double arg1 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (double)jarg1; 
  {
    try {
      result = Xapian::sortable_serialise(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_XapianJNI_sortableUnserialise(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jdouble jresult = 0 ;
  std::string *arg1 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = (double)Xapian::sortable_unserialise((std::string const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1StemImplementation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::StemImplementation *arg1 = (Xapian::StemImplementation *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::StemImplementation **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_StemImplementation_1apply(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jstring jresult = 0 ;
  Xapian::StemImplementation *arg1 = (Xapian::StemImplementation *) 0 ;
  std::string *arg2 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::StemImplementation **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (arg1)->operator ()((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_StemImplementation_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::StemImplementation *arg1 = (Xapian::StemImplementation *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::StemImplementation **)&jarg1; 
  {
    try {
      result = ((Xapian::StemImplementation const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1StemImplementation(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::StemImplementation *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::StemImplementation *)new SwigDirector_StemImplementation(jenv);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::StemImplementation **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_StemImplementation_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  Xapian::StemImplementation *obj = *((Xapian::StemImplementation **)&objarg);
  (void)jcls;
  SwigDirector_StemImplementation *director = dynamic_cast<SwigDirector_StemImplementation *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_StemImplementation_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  Xapian::StemImplementation *obj = *((Xapian::StemImplementation **)&objarg);
  SwigDirector_StemImplementation *director = dynamic_cast<SwigDirector_StemImplementation *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1Stem_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Xapian::Stem *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = (Xapian::Stem *)new Xapian::Stem((std::string const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Stem **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1Stem_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::StemImplementation *arg1 = (Xapian::StemImplementation *) 0 ;
  Xapian::Stem *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::StemImplementation **)&jarg1; 
  {
    try {
      result = (Xapian::Stem *)new Xapian::Stem(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Stem **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1Stem(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::Stem *arg1 = (Xapian::Stem *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::Stem **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_Stem_1apply(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jstring jresult = 0 ;
  Xapian::Stem *arg1 = (Xapian::Stem *) 0 ;
  std::string *arg2 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Stem **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = ((Xapian::Stem const *)arg1)->operator ()((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_Stem_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::Stem *arg1 = (Xapian::Stem *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Stem **)&jarg1; 
  {
    try {
      result = ((Xapian::Stem const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_Stem_1getAvailableLanguages(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = Xapian::Stem::get_available_languages();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1TermGenerator(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::TermGenerator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::TermGenerator *)new Xapian::TermGenerator();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::TermGenerator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1TermGenerator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_TermGenerator_1setStemmer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  Xapian::Stem *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  arg2 = *(Xapian::Stem **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Stem const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->set_stemmer((Xapian::Stem const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_TermGenerator_1setStopper_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  Xapian::Stopper *arg2 = (Xapian::Stopper *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  arg2 = *(Xapian::Stopper **)&jarg2; 
  {
    try {
      (arg1)->set_stopper((Xapian::Stopper const *)arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_TermGenerator_1setStopper_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  {
    try {
      (arg1)->set_stopper();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_TermGenerator_1setDocument(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  Xapian::Document *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  arg2 = *(Xapian::Document **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Document const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->set_document((Xapian::Document const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_TermGenerator_1getDocument(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  Xapian::Document *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  {
    try {
      result = (Xapian::Document *) &((Xapian::TermGenerator const *)arg1)->get_document();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::Document **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_TermGenerator_1setDatabase(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  Xapian::WritableDatabase *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  arg2 = *(Xapian::WritableDatabase **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::WritableDatabase const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->set_database((Xapian::WritableDatabase const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jint JNICALL Java_XapianJNI_TermGenerator_1FLAG_1SPELLING_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::TermGenerator::flags result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::TermGenerator::flags)Xapian::TermGenerator::FLAG_SPELLING;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_XapianJNI_TermGenerator_1setFlags_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  jint jresult = 0 ;
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  Xapian::TermGenerator::flags arg2 ;
  Xapian::TermGenerator::flags arg3 ;
  Xapian::TermGenerator::flags result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  arg2 = (Xapian::TermGenerator::flags)jarg2; 
  arg3 = (Xapian::TermGenerator::flags)jarg3; 
  {
    try {
      result = (Xapian::TermGenerator::flags)(arg1)->set_flags(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_XapianJNI_TermGenerator_1setFlags_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  Xapian::TermGenerator::flags arg2 ;
  Xapian::TermGenerator::flags result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  arg2 = (Xapian::TermGenerator::flags)jarg2; 
  {
    try {
      result = (Xapian::TermGenerator::flags)(arg1)->set_flags(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_TermGenerator_1indexText_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jstring jarg4) {
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::termcount arg3 ;
  std::string *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (Xapian::termcount)jarg3; 
  if(!jarg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0); 
  if (!arg4_pstr) return ;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  jenv->ReleaseStringUTFChars(jarg4, arg4_pstr); 
  {
    try {
      (arg1)->index_text((std::string const &)*arg2,arg3,(std::string const &)*arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_TermGenerator_1indexText_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::termcount arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (Xapian::termcount)jarg3; 
  {
    try {
      (arg1)->index_text((std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_TermGenerator_1indexText_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      (arg1)->index_text((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_TermGenerator_1indexTextWithoutPositions_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jstring jarg4) {
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::termcount arg3 ;
  std::string *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (Xapian::termcount)jarg3; 
  if(!jarg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0); 
  if (!arg4_pstr) return ;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  jenv->ReleaseStringUTFChars(jarg4, arg4_pstr); 
  {
    try {
      (arg1)->index_text_without_positions((std::string const &)*arg2,arg3,(std::string const &)*arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_TermGenerator_1indexTextWithoutPositions_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::termcount arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (Xapian::termcount)jarg3; 
  {
    try {
      (arg1)->index_text_without_positions((std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_TermGenerator_1indexTextWithoutPositions_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      (arg1)->index_text_without_positions((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_TermGenerator_1increaseTermpos_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  Xapian::termcount arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  {
    try {
      (arg1)->increase_termpos(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_TermGenerator_1increaseTermpos_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  {
    try {
      (arg1)->increase_termpos();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_TermGenerator_1getTermPos(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  Xapian::termcount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  {
    try {
      result = (Xapian::termcount)((Xapian::TermGenerator const *)arg1)->get_termpos();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_TermGenerator_1setTermpos(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  Xapian::termcount arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  {
    try {
      (arg1)->set_termpos(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_TermGenerator_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  {
    try {
      result = ((Xapian::TermGenerator const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_KeyMaker_1apply(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jstring jresult = 0 ;
  Xapian::KeyMaker *arg1 = (Xapian::KeyMaker *) 0 ;
  Xapian::Document *arg2 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::KeyMaker **)&jarg1; 
  arg2 = *(Xapian::Document **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Document const & reference is null");
    return 0;
  } 
  {
    try {
      result = ((Xapian::KeyMaker const *)arg1)->operator ()((Xapian::Document const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1KeyMaker(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::KeyMaker *arg1 = (Xapian::KeyMaker *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::KeyMaker **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1KeyMaker(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::KeyMaker *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::KeyMaker *)new SwigDirector_KeyMaker(jenv);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::KeyMaker **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_KeyMaker_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  Xapian::KeyMaker *obj = *((Xapian::KeyMaker **)&objarg);
  (void)jcls;
  SwigDirector_KeyMaker *director = dynamic_cast<SwigDirector_KeyMaker *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_KeyMaker_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  Xapian::KeyMaker *obj = *((Xapian::KeyMaker **)&objarg);
  SwigDirector_KeyMaker *director = dynamic_cast<SwigDirector_KeyMaker *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1MultiValueKeyMaker(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::MultiValueKeyMaker *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::MultiValueKeyMaker *)new Xapian::MultiValueKeyMaker();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::MultiValueKeyMaker **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_MultiValueKeyMaker_1apply(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jstring jresult = 0 ;
  Xapian::MultiValueKeyMaker *arg1 = (Xapian::MultiValueKeyMaker *) 0 ;
  Xapian::Document *arg2 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::MultiValueKeyMaker **)&jarg1; 
  arg2 = *(Xapian::Document **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Document const & reference is null");
    return 0;
  } 
  {
    try {
      result = ((Xapian::MultiValueKeyMaker const *)arg1)->operator ()((Xapian::Document const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_MultiValueKeyMaker_1addValue_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jboolean jarg3) {
  Xapian::MultiValueKeyMaker *arg1 = (Xapian::MultiValueKeyMaker *) 0 ;
  Xapian::valueno arg2 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MultiValueKeyMaker **)&jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      (arg1)->add_value(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_MultiValueKeyMaker_1addValue_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  Xapian::MultiValueKeyMaker *arg1 = (Xapian::MultiValueKeyMaker *) 0 ;
  Xapian::valueno arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MultiValueKeyMaker **)&jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  {
    try {
      (arg1)->add_value(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1MultiValueKeyMaker(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::MultiValueKeyMaker *arg1 = (Xapian::MultiValueKeyMaker *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::MultiValueKeyMaker **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1Sorter(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::Sorter *arg1 = (Xapian::Sorter *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::Sorter **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1MultiValueSorter(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::MultiValueSorter *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::MultiValueSorter *)new Xapian::MultiValueSorter();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::MultiValueSorter **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_XapianJNI_MultiValueSorter_1apply(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jstring jresult = 0 ;
  Xapian::MultiValueSorter *arg1 = (Xapian::MultiValueSorter *) 0 ;
  Xapian::Document *arg2 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::MultiValueSorter **)&jarg1; 
  arg2 = *(Xapian::Document **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Document const & reference is null");
    return 0;
  } 
  {
    try {
      result = ((Xapian::MultiValueSorter const *)arg1)->operator ()((Xapian::Document const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_MultiValueSorter_1add_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jboolean jarg3) {
  Xapian::MultiValueSorter *arg1 = (Xapian::MultiValueSorter *) 0 ;
  Xapian::valueno arg2 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MultiValueSorter **)&jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      (arg1)->add(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_MultiValueSorter_1add_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  Xapian::MultiValueSorter *arg1 = (Xapian::MultiValueSorter *) 0 ;
  Xapian::valueno arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MultiValueSorter **)&jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  {
    try {
      (arg1)->add(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1MultiValueSorter(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::MultiValueSorter *arg1 = (Xapian::MultiValueSorter *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::MultiValueSorter **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_new_1ValueSetMatchDecider(JNIEnv *jenv, jclass jcls, jint jarg1, jboolean jarg2) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  bool arg2 ;
  Xapian::ValueSetMatchDecider *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = (Xapian::ValueSetMatchDecider *)new Xapian::ValueSetMatchDecider(arg1,arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  *(Xapian::ValueSetMatchDecider **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_ValueSetMatchDecider_1addValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Xapian::ValueSetMatchDecider *arg1 = (Xapian::ValueSetMatchDecider *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueSetMatchDecider **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      (arg1)->add_value((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT void JNICALL Java_XapianJNI_ValueSetMatchDecider_1removeValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Xapian::ValueSetMatchDecider *arg1 = (Xapian::ValueSetMatchDecider *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueSetMatchDecider **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      (arg1)->remove_value((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_XapianJNI_ValueSetMatchDecider_1accept(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Xapian::ValueSetMatchDecider *arg1 = (Xapian::ValueSetMatchDecider *) 0 ;
  Xapian::Document *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::ValueSetMatchDecider **)&jarg1; 
  arg2 = *(Xapian::Document **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Document const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)((Xapian::ValueSetMatchDecider const *)arg1)->operator ()((Xapian::Document const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_XapianJNI_delete_1ValueSetMatchDecider(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::ValueSetMatchDecider *arg1 = (Xapian::ValueSetMatchDecider *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::ValueSetMatchDecider **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      XapianException(code, msg);
    }
  }
}


SWIGEXPORT jlong JNICALL Java_XapianJNI_SWIGValuePostingSourceUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::PostingSource **)&baseptr = *(Xapian::ValuePostingSource **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_XapianJNI_SWIGValueWeightPostingSourceUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::ValuePostingSource **)&baseptr = *(Xapian::ValueWeightPostingSource **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_XapianJNI_SWIGDecreasingValueWeightPostingSourceUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::ValueWeightPostingSource **)&baseptr = *(Xapian::DecreasingValueWeightPostingSource **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_XapianJNI_SWIGValueMapPostingSourceUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::ValuePostingSource **)&baseptr = *(Xapian::ValueMapPostingSource **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_XapianJNI_SWIGFixedWeightPostingSourceUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::PostingSource **)&baseptr = *(Xapian::FixedWeightPostingSource **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_XapianJNI_SWIGBoolWeightUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::Weight **)&baseptr = *(Xapian::BoolWeight **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_XapianJNI_SWIGBM25WeightUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::Weight **)&baseptr = *(Xapian::BM25Weight **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_XapianJNI_SWIGTradWeightUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::Weight **)&baseptr = *(Xapian::TradWeight **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_XapianJNI_SWIGValueCountMatchSpyUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::MatchSpy **)&baseptr = *(Xapian::ValueCountMatchSpy **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_XapianJNI_SWIGWritableDatabaseUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::Database **)&baseptr = *(Xapian::WritableDatabase **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_XapianJNI_SWIGSimpleStopperUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::Stopper **)&baseptr = *(Xapian::SimpleStopper **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_XapianJNI_SWIGStringValueRangeProcessorUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::ValueRangeProcessor **)&baseptr = *(Xapian::StringValueRangeProcessor **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_XapianJNI_SWIGDateValueRangeProcessorUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::StringValueRangeProcessor **)&baseptr = *(Xapian::DateValueRangeProcessor **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_XapianJNI_SWIGNumberValueRangeProcessorUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::StringValueRangeProcessor **)&baseptr = *(Xapian::NumberValueRangeProcessor **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_XapianJNI_SWIGMultiValueKeyMakerUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::KeyMaker **)&baseptr = *(Xapian::MultiValueKeyMaker **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_XapianJNI_SWIGSorterUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::KeyMaker **)&baseptr = *(Xapian::Sorter **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_XapianJNI_SWIGMultiValueSorterUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::Sorter **)&baseptr = *(Xapian::MultiValueSorter **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_XapianJNI_SWIGValueSetMatchDeciderUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::MatchDecider **)&baseptr = *(Xapian::ValueSetMatchDecider **)&jarg1;
    return baseptr;
}

SWIGEXPORT void JNICALL Java_XapianJNI_swig_1module_1init(JNIEnv *jenv, jclass jcls) {
  int i;
  
  static struct {
    const char *method;
    const char *signature;
  } methods[20] = {
    {
      "SwigDirector_PostingSource_getTermfreqMin", "(LPostingSource;)J" 
    },
    {
      "SwigDirector_PostingSource_getTermfreqEst", "(LPostingSource;)J" 
    },
    {
      "SwigDirector_PostingSource_getTermfreqMax", "(LPostingSource;)J" 
    },
    {
      "SwigDirector_PostingSource_getWeight", "(LPostingSource;)D" 
    },
    {
      "SwigDirector_PostingSource_getDocId", "(LPostingSource;)J" 
    },
    {
      "SwigDirector_PostingSource_next", "(LPostingSource;D)V" 
    },
    {
      "SwigDirector_PostingSource_skipTo", "(LPostingSource;JD)V" 
    },
    {
      "SwigDirector_PostingSource_check", "(LPostingSource;JD)Z" 
    },
    {
      "SwigDirector_PostingSource_atEnd", "(LPostingSource;)Z" 
    },
    {
      "SwigDirector_PostingSource_name", "(LPostingSource;)Ljava/lang/String;" 
    },
    {
      "SwigDirector_PostingSource_init", "(LPostingSource;J)V" 
    },
    {
      "SwigDirector_PostingSource_toString", "(LPostingSource;)Ljava/lang/String;" 
    },
    {
      "SwigDirector_MatchDecider_accept", "(LMatchDecider;J)Z" 
    },
    {
      "SwigDirector_ExpandDecider_accept", "(LExpandDecider;Ljava/lang/String;)Z" 
    },
    {
      "SwigDirector_Stopper_apply", "(LStopper;Ljava/lang/String;)Z" 
    },
    {
      "SwigDirector_Stopper_toString", "(LStopper;)Ljava/lang/String;" 
    },
    {
      "SwigDirector_ValueRangeProcessor_apply", "(LValueRangeProcessor;JJ)I" 
    },
    {
      "SwigDirector_StemImplementation_apply", "(LStemImplementation;Ljava/lang/String;)Ljava/lang/String;" 
    },
    {
      "SwigDirector_StemImplementation_toString", "(LStemImplementation;)Ljava/lang/String;" 
    },
    {
      "SwigDirector_KeyMaker_apply", "(LKeyMaker;J)Ljava/lang/String;" 
    }
  };
  Swig::jclass_XapianJNI = (jclass) jenv->NewGlobalRef(jcls);
  if (!Swig::jclass_XapianJNI) return;
  for (i = 0; i < (int) (sizeof(methods)/sizeof(methods[0])); ++i) {
    Swig::director_methids[i] = jenv->GetStaticMethodID(jcls, methods[i].method, methods[i].signature);
    if (!Swig::director_methids[i]) return;
  }
}


#ifdef __cplusplus
}
#endif

