/*
 * $Id: util.h,v 1.16 2001/05/01 14:33:46 kg4ijb Exp $
 *
 * XASTIR, Amateur Station Tracking and Information Reporting
 * Copyright (C) 1999,2000  Frank Giannandrea
 * Copyright (C) 2000,2001  The Xastir Group
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Look at the README for more information on the program.
 */


#ifndef __XASTIR_UTIL_H
#define __XASTIR_UTIL_H

#include "db.h"
#include <pthread.h>

extern int  position_amb_chars;
extern char *output_lat(char *in_lat, int comp_pos);
extern char *output_long(char *in_long, int comp_pos);
extern double distance_from_my_station(char *call_sign, char *course_deg);
extern double phg_range(char p, char h, char g);
extern char *get_line(FILE *f, char *linedata, int maxline);
extern time_t time_from_aprsstring(char *timestamp);
extern char *compress_posit(const char *lat, const char group, const char *lon, const char symbol,
                const int course, const int speed, const char *phg);

extern int  position_defined(long lat, long lon, int strict);
extern void convert_lat_l2s(long lat, char *str, int type);
extern void convert_lon_l2s(long lon, char *str, int type);
extern long convert_lat_s2l(char *lat);
extern long convert_lon_s2l(char *lon);

extern double calc_distance_course(long pos1_lat, long pos1_lon, long pos2_lat, long pos2_lon, char *course_deg);
extern int  filethere(char *fn);
extern int  filecreate(char *fn);
extern time_t file_time(char *fn);
extern void log_data(char *file, char *line);
extern time_t sec_now(void);
extern char *get_time(char *time_here);

extern void substr(char *dest, char *src, int size);
extern int  valid_path(char *path);
extern int  valid_call(char *call);
extern int  valid_object(char *name);
extern int  valid_inet_name(char *name, char *info, char *origin);

extern char *to_upper(char *data);
extern int  is_num_chr(char ch);
extern int  is_num_or_sp(char ch);
extern int  is_xnum_or_dash(char *data, int max);
extern void removeCtrlCodes(char *cp);
extern void makePrintable(char *cp);

typedef struct
{
    pthread_mutex_t lock;
    pthread_t threadID;
} xastir_mutex;

extern void init_critical_section(xastir_mutex *lock);
extern int begin_critical_section(xastir_mutex *lock, char *text);
extern int end_critical_section(xastir_mutex *lock, char *text);

#endif // __XASTIR_UTIL_H
