#ifndef _BOARD_H
#define _BOARD_H

#include "cell.h"
#include "data.h"
#include "sprite.h"

typedef struct _Board * Board;

#define CANON_ANGLE_MAX      33
#define NB_ANGLES            ( 2*CANON_ANGLE_MAX+1 )
#define ANGLE_STEP           ( 1.32 / CANON_ANGLE_MAX ) /* approx. 75 deg */
#define CANON_ROTATING_SPEED ( 1/30.0 )

#define DEAD_ZONE_HEIGHT     2.0
#define BOARD_WIDTH          COLS
#define BOARD_HEIGHT         ( ROWS*ROW_HEIGHT + DEAD_ZONE_HEIGHT )
#define OFFSET_X             ( 1.0*BORDER_WIDTH/MAX_SCALE )
#define OFFSET_Y             ( 1.0*BORDER_HEIGHT/MAX_SCALE )

#define scale_x(X,S)         (( X + OFFSET_X )*(S) )
#define scale_y(Y,S)         (( Y + OFFSET_Y )*(S) )
#define board_win_width(S)   scale_x( OFFSET_X + BOARD_WIDTH, S ) 
#define board_win_height(S)  scale_y( BOARD_HEIGHT, S )

Board new_board( int period, int handicap, int moving_ceiling );
void delete_board( Board board );
void reset_board( Board board );

void animate_board( Board board , int dt );
SpritePool get_board_sprite_pool( Board board );

void explode_board( Board board );
void send_bubble( Board board, int color );
int receive_bubble( Board board );
int board_overflow( Board board );
int board_quiet( Board board );
int board_empty( Board board );

void rotate_canon_left( Board board );
void rotate_canon_right( Board board );
void canon_stop( Board board );
void fire_board_canon( Board board );
void move_board_canon( Board board, int dt );

int get_canon_angle( Board board );
int ready_to_fire( Board board );
int board_was_lowered( Board board );
void load_bubbles( Board board, int *colors );

int get_last_fire_delay( Board board );
CellArray get_board_array( Board board );
void get_board_info( Board board, double *cx, double *cy, double **vx, 
		     double **vy, int *color, int *next_color,
		     int *launch_count, int *period );

#endif /* _BOARD_H */
