/* Definitions of functions visible to interfaces in Xconq.
   Copyright (C) 1996, 1997, 1998 Stanley T. Shebs.

Xconq is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.  See the file COPYING.  */

/* (should doublecheck that all of the decls in this file either have
   impls or are removed) */

extern int net_maybe_react_to_move PARAMS ((Unit *unit, int ox, int oy));
extern void net_consume_move_supplies PARAMS ((Unit *unit));

#undef  DEF_ACTION
#define DEF_ACTION(name,code,args,prepfn,NETPREPFN,dofn,checkfn,ARGDECL,doc)  \
  extern int NETPREPFN PARAMS (ARGDECL);

#include "action.def"

extern int net_run_game PARAMS ((int maxactions));
extern void net_finish_turn PARAMS ((Side *side));
extern void net_resign_game PARAMS ((Side *side, Side *side2));

extern void net_set_side_ai PARAMS ((Side *side, char *typename));

extern void net_set_side_name PARAMS ((Side *side, Side *side2,
				       char *newname));
extern void net_set_side_longname PARAMS ((Side *side, Side *side2,
					   char *newname));
extern void net_set_side_shortname PARAMS ((Side *side, Side *side2,
					    char *newname));
extern void net_set_side_noun PARAMS ((Side *side, Side *side2,
				       char *newname));
extern void net_set_side_pluralnoun PARAMS ((Side *side, Side *side2,
					     char *newname));
extern void net_set_side_adjective PARAMS ((Side *side, Side *side2,
					    char *newname));
extern void net_set_side_emblemname PARAMS ((Side *side, Side *side2,
					     char *newname));
extern void net_set_side_colorscheme PARAMS ((Side *side, Side *side2,
					      char *newname));
extern void net_become_designer PARAMS ((Side *side));
extern void net_become_nondesigner PARAMS ((Side *side));
extern void net_set_trust PARAMS ((Side *side, Side *side2, int val));
extern void net_set_mutual_trust PARAMS ((Side *side, Side *side2, int val));
extern void net_set_autofinish PARAMS ((Side *side, int value));
extern void net_set_willing_to_save PARAMS ((Side *side, int flag));
extern void net_set_willing_to_draw PARAMS ((Side *side, int flag));
extern void net_send_message PARAMS ((Side *side, SideMask sidemask,
				      char *str));
extern void net_set_side_self_unit PARAMS ((Side *side, struct a_unit *unit));
extern void net_set_doctrine PARAMS ((Side *side, char *spec));
extern void net_set_controlled_by PARAMS ((Side *side, Side *side2, int val));

#ifdef DESIGNERS
extern void net_paint_view PARAMS ((Side *side, int x, int y, int r,
				    int tview, int uview));
#endif /* DESIGNERS */

extern void net_change_unit_side PARAMS ((Unit *unit, Side *newside,
					  int reason, Unit *agent));
extern int net_set_unit_side PARAMS ((Unit *unit, Side *side));
extern int net_set_unit_origside PARAMS ((Unit *unit, Side *side));
extern void net_set_unit_plan_type PARAMS ((Side *side, Unit *unit, int type));
extern void net_set_unit_asleep PARAMS ((Side *side, Unit *unit, int flag,
					 int recurse));
extern void net_set_unit_reserve PARAMS ((Side *side, Unit *unit, int flag, 
					  int recurse));
extern void net_set_unit_ai_control PARAMS ((Side *side, Unit *unit, int flag,
					     int recurse));
extern void net_set_unit_main_goal PARAMS ((Side *side, Unit *unit,
					    Goal *goal));
extern void net_set_unit_waiting_for_transport PARAMS ((Side *side, Unit *unit,
							int flag));
extern void net_set_unit_name PARAMS ((Side *side, Unit *unit, char *newname));
extern int net_disband_unit PARAMS ((Side *side, Unit *unit));
extern void net_set_unit_position PARAMS ((Unit *unit, int x, int y, int z));

#ifdef DESIGNERS
extern Unit *net_designer_create_unit PARAMS ((Side *side, int u, int s,
					       int x, int y));
extern int net_designer_teleport PARAMS ((Unit *unit, int x, int y,
					  Unit *other));
extern int net_designer_change_side PARAMS ((Unit *unit, Side *side));
extern int net_designer_disband PARAMS ((Unit *unit));
#endif /* DESIGNERS */

extern void net_reserve_unit PARAMS ((Side *side, Unit *unit));
extern void net_wake_unit PARAMS ((Side *side, Unit *unit, int wakeocc));
extern void net_wake_area PARAMS ((Side *side, int x, int y, int n, int occs));
extern void net_set_formation PARAMS ((Unit *unit, Unit *leader, int x, int y,
				       int dist, int flex));
extern void net_delay_unit PARAMS ((Unit *unit, int flag));
extern int net_clear_task_agenda PARAMS ((Side *side, Unit *unit));
extern void net_force_replan PARAMS ((Side *side, Unit *unit,
				      int passive_only));

extern void net_add_task PARAMS ((Unit *unit, int pos, Task *task));
extern void net_push_move_to_task PARAMS ((Unit *unit, int x, int y));
extern void net_set_move_to_task PARAMS ((Unit *unit, int x, int y));
extern void net_set_move_near_task PARAMS ((Unit *unit, int x, int y,
					    int dist));
extern void net_push_move_near_task PARAMS ((Unit *unit, int x, int y,
					     int dist));
extern void net_set_move_dir_task PARAMS ((Unit *unit, int dir, int n));
extern void net_set_build_task PARAMS ((Unit *unit, int u2, int run));
extern void net_push_build_task PARAMS ((Unit *unit, int u2, int run));
extern void net_push_research_task PARAMS ((Unit *unit, int u2, int n));
extern void net_set_hit_task PARAMS ((Unit *unit, int x, int y));
extern void net_push_specific_hit_task PARAMS ((Unit *unit, int x, int y,
						int u, int s));
extern void net_set_specific_hit_task PARAMS ((Unit *unit, int x, int y,
					       int u, int s));
extern void net_push_hit_task PARAMS ((Unit *unit, int x, int y));
extern void net_set_capture_task PARAMS ((Unit *unit, int x, int y));
extern void net_push_capture_task PARAMS ((Unit *unit, int x, int y));
extern void net_set_disband_task PARAMS ((Unit *unit));
extern void net_set_resupply_task PARAMS ((Unit *unit, int m));
extern void net_push_occupy_task PARAMS ((Unit *unit, Unit *transport));
extern void net_push_pickup_task PARAMS ((Unit *unit, Unit *occ));
extern void net_push_produce_task PARAMS ((Unit *unit, int m, int n));
extern void net_set_sentry_task PARAMS ((Unit *unit, int n));

extern Feature *net_create_feature PARAMS ((char *typename, char *name));
extern void net_set_feature_type_name PARAMS ((Feature *feature, char *typename));
extern void net_set_feature_name PARAMS ((Feature *feature, char *name));
extern void net_destroy_feature PARAMS ((Feature *feature));
extern void net_renumber_features PARAMS ((void));

#ifdef DESIGNERS
extern void net_paint_cell PARAMS ((Side *side, int x, int y, int r, int t));
extern void net_paint_border PARAMS ((Side *side, int x, int y, int dir,
				  int t, int mode));
extern void net_paint_connection PARAMS ((Side *side, int x, int y, int dir,
				      int t, int mode));
extern void net_paint_coating PARAMS ((Side *side, int x, int y, int r,
				   int t, int depth));
extern void net_paint_people PARAMS ((Side *side, int x, int y, int r, int s));
extern void net_paint_control PARAMS ((Side *side, int x, int y, int r, int s));
extern void net_paint_feature PARAMS ((Side *side, int x, int y, int r, int f));
extern void net_paint_elevation PARAMS ((Side *side, int x, int y, int r,
				     int elev));
extern void net_paint_temperature PARAMS ((Side *side, int x, int y, int r,
				       int temp));
extern void net_paint_material PARAMS ((Side *side, int x, int y, int r,
				    int m, int amt));
extern void net_paint_clouds PARAMS ((Side *side, int x, int y, int r,
				  int cloudtype, int bot, int hgt));
extern void net_paint_winds PARAMS ((Side *side, int x, int y, int r,
				 int dir, int force));
#endif /* DESIGNERS */

extern void net_request_additional_side PARAMS ((char *playerspec));
