/*
 *  Euklides  version 0.3.4
 *  Copyright (c) Christian Obrecht 2000-2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <math.h>
#include "types.h"
#include "geometry.h"
#include "parser.tab.h"

double X1, Y1, X2, Y2, Unit;

int undefined = 1;

void frame(double x1, double y1, double x2, double y2, double unit)
{
  X1=x1; Y1=y1; X2=x2; Y2=y2; Unit=unit; undefined = 0;
  printf("%% Generated by euklides version 0.3.4\n");
  printf("\\psset{unit=%.4fcm}\n\\psset{linewidth=.5pt}\n\\psset{arrowsize=2pt 4}\n\\pspicture*(%.4f,%.4f)(%.4f,%.4f)\n", unit, x1, y1, x2, y2);
}

void default_frame(void)
{
  if (undefined) frame(-2, -2, 8, 6, 1);
}

void setcolor_string(char * col)
{
  printf("\\psset{linecolor=%s}\n", col);
}

void setcolor_flag(int flag)
{
  char * col;
  
  switch(flag) {
    case BLACK 		: col = "black"; break;
    case DARKGRAY	: col = "darkgray"; break;
    case GRAY		: col = "gray"; break;
    case LIGHTGRAY	: col = "lightgray"; break;
    case RED		: col = "red"; break;
    case GREEN		: col = "green"; break;
    case BLUE		: col = "blue"; break;
    case CYAN		: col = "cyan"; break;
    case MAGENTA	: col = "magenta"; break;
    case YELLOW		: col = "yellow";
  } 
  printf("\\psset{linecolor=%s}\n", col);
}

void puttricks(char * t)
{
  printf("\\%s\n", t);
}

void draw_point(_point* A, int flag)
{
  char * opt;
  
  default_frame();
  switch(flag) {
    case DOT : opt = "[dotstyle=*]"; break;
    case BOX : opt = "[dotstyle=square*]"; break;
    case CROSS : opt = "[dotstyle=x]"; break;
    case PLUS : opt = "[dotstyle=+]";
  }
  printf("\\psdots%s(%.4f,%.4f)\n", opt, A->x, A->y);
}

char * d_flag(int flag)
{
  switch(flag) {
    case FULL : return "";
    case DOTTED : return "[linestyle=dotted]";
    case DASHED : return "[linestyle=dashed]";
  }
}

void draw_vector(_vector* v, _point* A, int flag)
{
  default_frame();
  printf("\\psline%s{->}(%.4f,%.4f)(%.4f,%.4f)\n", d_flag(flag), A->x, A->y, A->x+v->x, A->y+v->y);
}

void draw_line(_line* l, int flag1, int flag2)
{
  double x1, y1, x2, y2, m;

  default_frame();
  if (ZERO(Sin(l->angle))) {
    x1 = X1; y1 = l->y; x2 = X2; y2 = l->y;
  } 
  else if (ZERO(Cos(l->angle))) {
    x1 = l->x ; y1 = Y1; x2 = l->x; y2 = Y2;
  }
  else {
    m = Tan(l->angle);
    x1 = (Y1-l->y)/m+l->x; y1 = Y1;
    if (x1 < X1) {
      x1 = X1; y1 = m*(X1-l->x)+l->y;
    }
    if (x1 > X2) {
      x1 = X2; y1 = m*(X2-l->x)+l->y;
    }
    x2 = (Y2-l->y)/m+l->x; y2 = Y2;
    if (x2 < X1) {
      x2 = X1; y2 = m*(X1-l->x)+l->y;
    }
    if (x2 > X2) {
      x2 = X2; y2 = m*(X2-l->x)+l->y;
    }
  }
  switch(flag2) {
    case HALFLINE :
      if (l->angle>=0) {
        x1 = l->x; y1 = l->y;
      }
      else {
	  x2 = l->x; y2 = l->y;
      }
      break;
    case BACKHALFLINE :
      if (l->angle>=0) {
        x2 = l->x; y2 = l->y;
      }
      else {
	  x1 = l->x; y1 = l->y;
      }      
  }
  if ((x1>=X1) && (x2<=X2) && (y1>=Y1) && (y2<=Y2)) printf("\\psline%s(%.4f,%.4f)(%.4f,%.4f)\n", d_flag(flag1), x1, y1, x2, y2);
}

char * s_flag(int flag)
{
  switch(flag) {
    case NOARROW : return "";
    case ARROW : return "{->}";
    case BACKARROW : return  "{<-}";
    case DOUBLEARROW : return "{<->}";
  }
}

void draw_segment(_segment* s, int flag1, int flag2)
{
  default_frame();
  printf("\\psline%s%s(%.4f,%.4f)(%.4f,%.4f)\n", d_flag(flag1), s_flag(flag2), s->x1, s->y1, s->x2, s->y2);
}

void draw_circle(_circle* c, int flag)
{
  default_frame();
  printf("\\pscircle%s(%.4f,%.4f){%.4f}\n", d_flag(flag), c->x, c->y, c->radius);
}

void draw_arc(_circle* c, double a1, double a2, int flag1, int flag2)
{
  default_frame();
  printf("\\psarc%s%s(%.4f,%.4f){%.4f}{%.4f}{%.4f}\n", d_flag(flag1), s_flag(flag2), c->x, c->y, c->radius, a1, a2);
}

void draw_triangle(_point* A, _point* B, _point* C, int flag)
{
  default_frame();
  printf("\\psline%s(%.4f,%.4f)(%.4f,%.4f)(%.4f,%.4f)(%.4f,%.4f)\n", 
  	d_flag(flag), A->x, A->y, B->x, B->y, C->x, C->y, A->x, A->y);
}

void draw_quadrilateral(_point* A, _point* B, _point* C, _point* D, int flag)
{
  default_frame();
  printf("\\psline%s(%.4f,%.4f)(%.4f,%.4f)(%.4f,%.4f)(%.4f,%.4f)(%.4f,%.4f)\n",
  	d_flag(flag), A->x, A->y, B->x, B->y, C->x, C->y, D->x, D->y, A->x, A->y);
}

void draw_pentagon(_point* A, _point* B, _point* C, _point* D, _point* E, int flag)
{
  default_frame();
  printf("\\psline%s(%.4f,%.4f)(%.4f,%.4f)(%.4f,%.4f)(%.4f,%.4f)(%.4f,%.4f)(%.4f,%.4f)\n",
  	d_flag(flag), A->x, A->y, B->x, B->y, C->x, C->y, D->x, D->y, E->x, E->y, A->x, A->y);
}

void draw_hexagon(_point* A, _point* B, _point* C, _point* D, _point* E, _point* F, int flag)
{
  default_frame();
  printf("\\psline%s(%.4f,%.4f)(%.4f,%.4f)(%.4f,%.4f)(%.4f,%.4f)(%.4f,%.4f)(%.4f,%.4f)(%.4f,%.4f)\n",
  	d_flag(flag), A->x, A->y, B->x, B->y, C->x, C->y, D->x, D->y, E->x, E->y, F->x, F->y, A->x, A->y);
}

void draw_P_label(char* s, _point* A, double l, double a)
{
  default_frame();
  printf("\\uput{%.4f}[%.4f](%.4f,%.4f){%s}\n", l, a, A->x, A->y, s);
}

void draw_S_label(char* s, _segment* sg, double l, double a)
{
  default_frame();
  printf("\\uput{%.4f}[%.4f](%.4f,%.4f){%s}\n", l, a, (sg->x1+sg->x2)/2, (sg->y1+sg->y2)/2, s);
}

void draw_P_N(double v, char* s, _point* A, double l, double a)
{
  char* fmt;
  
  default_frame();
  fmt = (char *)malloc(40+strlen(s));
  sprintf(fmt, "\\uput{%%.4f}[%%.4f](%%.4f,%%.4f){%s}\n", s);
  printf(fmt, l, a, A->x, A->y, v);
  free(fmt);
}

void draw_S_N(double v, char* s, _segment* sg, double l, double a)
{
  char* fmt;
  
  default_frame();
  fmt = (char *)malloc(40+strlen(s));
  sprintf(fmt, "\\uput{%%.4f}[%%.4f](%%.4f,%%.4f){%s}\n", s);
  printf(fmt, l, a, (sg->x1+sg->x2)/2, (sg->y1+sg->y2)/2, v);
  free(fmt);
}

void draw_P_NN(double v1, double v2, char* s, _point* A, double l, double a)
{
  char* fmt;
  
  default_frame();
  fmt = (char *)malloc(40+strlen(s));
  sprintf(fmt, "\\uput{%%.4f}[%%.4f](%%.4f,%%.4f){%s}\n", s);
  printf(fmt, l, a, A->x, A->y, v1, v2);
  free(fmt);
}

void draw_S_NN(double v1, double v2, char* s, _segment* sg, double l, double a)
{
  char* fmt;
  
  default_frame();
  fmt = (char *)malloc(40+strlen(s));
  sprintf(fmt, "\\uput{%%.4f}[%%.4f](%%.4f,%%.4f){%s}\n", s);
  printf(fmt, l, a, (sg->x1+sg->x2)/2, (sg->y1+sg->y2)/2, v1, v2);
  free(fmt);
}

void mark_S(_segment* sg, int flag)
{
  double x, y, a, c, s;
  
  default_frame();
  x = (sg->x1+sg->x2)/2; y = (sg->y1+sg->y2)/2; a = S_angle(sg); s = .15*Sin(a); c = .15*Cos(a);
  switch (flag) {
    case SIMPLE : printf("\\psline(%.4f,%.4f)(%.4f,%.4f)\n", x-s, y+c, x+s, y-c); break;
    case DOUBLE : printf("\\psline(%.4f,%.4f)(%.4f,%.4f)\n", x-s-.2*c, y+c-.2*s, x+s-.2*c, y-c-.2*s);
      		  printf("\\psline(%.4f,%.4f)(%.4f,%.4f)\n", x-s+.2*c, y+c+.2*s, x+s+.2*c, y-c+.2*s);
		  break;
    case TRIPLE : printf("\\psline(%.4f,%.4f)(%.4f,%.4f)\n", x-s-.4*c, y+c-.4*s, x+s-.4*c, y-c-.4*s);
      		  printf("\\psline(%.4f,%.4f)(%.4f,%.4f)\n", x-s, y+c, x+s, y-c);
      		  printf("\\psline(%.4f,%.4f)(%.4f,%.4f)\n", x-s+.4*c, y+c+.4*s, x+s+.4*c, y-c+.4*s);
		  break;
    case CROSS  : printf("\\psline(%.4f,%.4f)(%.4f,%.4f)\n", x-.7*(s+c), y+.7*(c-s), x+.7*(s+c), y-.7*(c-s));
    		  printf("\\psline(%.4f,%.4f)(%.4f,%.4f)\n", x-.7*(s-c), y+.7*(c+s), x+.7*(s-c), y-.7*(c+s));
  }
}

void mark_A(_point* A, _point* B, _point* C, int flag)
{
  double a1, a2, a;
  
  default_frame();
  a1 = angle(A->x-B->x,A->y-B->y); a2 = angle(C->x-B->x,C->y-B->y); a = (a1+a2)/2;
  switch (flag) {
    case SIMPLE     : printf("\\psarc(%.4f,%.4f){%.4f}{%.4f}{%.4f}\n", B->x, B->y, .5, a1, a2); break;
    case DOUBLE     : printf("\\psarc(%.4f,%.4f){%.4f}{%.4f}{%.4f}\n", B->x, B->y, .45, a1, a2); 
                      printf("\\psarc(%.4f,%.4f){%.4f}{%.4f}{%.4f}\n", B->x, B->y, .55, a1, a2); break;
    case TRIPLE     : printf("\\psarc(%.4f,%.4f){%.4f}{%.4f}{%.4f}\n", B->x, B->y, .42, a1, a2);
		      printf("\\psarc(%.4f,%.4f){%.4f}{%.4f}{%.4f}\n", B->x, B->y, .50, a1, a2);
                      printf("\\psarc(%.4f,%.4f){%.4f}{%.4f}{%.4f}\n", B->x, B->y, .58, a1, a2); break;
    case ARROW      : printf("\\psarc{->}(%.4f,%.4f){%.4f}{%.4f}{%.4f}\n", B->x, B->y, .5, a1, a2); break;
    case BACKARROW  : printf("\\psarc{<-}(%.4f,%.4f){%.4f}{%.4f}{%.4f}\n", B->x, B->y, .5, a1, a2); break;
    case DASH       : printf("\\psarc(%.4f,%.4f){%.4f}{%.4f}{%.4f}\n", B->x, B->y, .5, a1, a2); 
                      printf("\\psline(%.4f,%.4f)(%.4f,%.4f)\n", B->x+.425*Cos(a), B->y+.425*Sin(a),  B->x+.575*Cos(a), B->y+.575*Sin(a));
    		      break;
    case RIGHT      : printf("\\psline(%.4f,%.4f)(%.4f,%.4f)(%.4f,%.4f)\n",
                         B->x+.3*Cos(a1), B->y+.3*Sin(a1),  B->x+.3*(Cos(a1)+Cos(a2)), B->y+.3*(Sin(a1)+Sin(a2)),
    			 B->x+.3*Cos(a2), B->y+.3*Sin(a2));

    }
}
