/* hf2gsk.c
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*               COPYRIGHT, 1990, FORD MOTOR COMPANY                     *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
*  Package -    Hershey Font to GKS font translator 
*
*  Description -
*
*  Change history -
*
*  Author       Date        Change
*  Curtiss    91/05/16      Created.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
#include <stdio.h>


#if BSD
#include <strings.h>
#define strchr index
#endif

#if SYSV
#include <string.h>
#endif

typedef struct _FontStruct {
    char  name[256];
    int   scx, scy;
    int   xtran, ytran;
    float spacing;
} FontStruct;

typedef struct _CharStruct {
  char type;
  int  x, y;
} CharStruct;

#define MAX_FONTS 15 
#define MAX_CHARS 256
#define MAX_POINTS 200
#define ENDCHAR -999

typedef struct _HersheyMap {
   char *name;
   int  code[MAX_CHARS];
} HersheyMap;

/* temp array used for a character */
static CharStruct chartemp[MAX_POINTS];

/*

1     sp       !     "     #     $     %     &     '
2      (       )     *     +     ,     -     .     /
3      0       1     2     3     4     5     6     7
4      8       9     :     ;     <     =     >     ?
5      @       A     B     C     D     E     F     G
6      H       I     J     K     L     M     N     O
7      P       Q     R     S     T     U     V     W
8      X       Y     Z     [     \     ]     ^     _
9      `       a     b     c     d     e     f     g
10     h       i     j     k     l     m     n     o
11     p       q     r     s     t     u     v     w
12     x       y     z     {     |     }     ~    del

*/

static HersheyMap CharMap[] = {

    { "complex_italic",
      0000, 1214, 1217, 1275, 1274, 0000, 1272, 1216,
      1221, 1222, 1219, 1232, 1211, 1231, 1210, 1220,
      1200, 1201, 1202, 1203, 1204, 1205, 1206, 1207,
      1208, 1209, 1212, 1213, 1227, 1238, 1228, 1215,
      1273, 1051, 1052, 1053, 1054, 1055, 1056, 1057,
      1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065,
      1066, 1067, 1068, 1069, 1070, 1071, 1072, 1073,
      1074, 1075, 1076, 1223, 0000, 1224, 0000, 0000,
      1249, 1151, 1152, 1153, 1154, 1155, 1156, 1157,
      1158, 1159, 1160, 1161, 1162, 1163, 1164, 1165,
      1166, 1167, 1168, 1169, 1170, 1171, 1172, 1173,
      1174, 1175, 1176, 1225, 1229, 1226, 0000, ENDCHAR 
    },

    { "triplex_italic",
      0000, 3264, 3278, 0000, 3265, 0000, 3268, 3277,
      3271, 3272, 3273, 3275, 3261, 3274, 3260, 3270,
      3250, 3251, 3252, 3253, 3254, 3255, 3256, 3257,
      3258, 3259, 3262, 3263, 0000, 3276, 0000, 3265,
      0000, 2051, 2052, 2053, 2054, 2055, 2056, 2057,
      2058, 2059, 2060, 2061, 2062, 2063, 2064, 2065,
      2066, 2067, 2068, 2069, 2070, 2071, 2072, 2073, 
      2074, 2075, 2076, 0000, 0000, 0000, 0000, 0000,
      3216, 3151, 3152, 3153, 3154, 3155, 3156, 3157,
      3158, 3159, 3160, 3161, 3162, 3163, 3164, 3165,
      3166, 3167, 3168, 3169, 3170, 3171, 3172, 3173,
      3174, 3175, 3176, 0000, 0000, 0000, 0000, ENDCHAR  
    }, 

    { "simplex_script",
      0000,  714,  717,  733,  719, 0000,  734,  731,
       721,  722,  728,  725,  711,  724,  710,  720,
       700,  701,  702,  703,  704,  705,  706,  707,
       708,  709,  712,  713, 0000,  726, 0000, 0000,
      0000,  551,  552,  553,  554,  555,  556,  557,
       558,  559,  560,  561,  562,  563,  564,  565,
       566,  567,  568,  569,  570,  571,  572,  573,
       574,  575,  576, 0000, 0000, 0000, 0000, 0000,
      0000,  651,  652,  653,  654,  655,  656,  657,
       658,  659,  660,  661,  662,  663,  664,  665,
       666,  667,  668,  669,  670,  671,  672,  673,
       674,  675,  676, 0000,  723, 0000, 0000,  ENDCHAR
    },
    
    { "complex_script",
      0000, 2764, 2778, 0000, 2769, 0000, 2768, 2777,
      2771, 2772, 2773, 2775, 2761, 2774, 2760, 2770,
      2750, 2751, 2752, 2753, 2754, 2755, 2756, 2757,
      2758, 2759, 2762, 2763, 0000, 2776, 0000, 2765,
      0000, 2551, 2552, 2553, 2554, 2555, 2556, 2557,
      2558, 2559, 2560, 2561, 2562, 2563, 2564, 2565,
      2566, 2567, 2568, 2569, 2570, 2571, 2572, 2573,
      2574, 2575, 2576, 0000, 0000, 0000, 0000, 0000,
      2766, 2651, 2652, 2653, 2654, 2655, 2656, 2657,
      2658, 2659, 2660, 2661, 2662, 2663, 2664, 2665,
      2666, 2667, 2668, 2669, 2670, 2671, 2672, 2673,
      2674, 2675, 2676, 0000, 0000, 0000, 0000, ENDCHAR 
    },

    { "simplex_roman",
      0000,  714,  717,  733,  719, 0000,  734,  731,
       721,  722,  728,  725,  711,  724,  710,  720,
       700,  701,  702,  703,  704,  705,  706,  707,
       708,  709,  712,  713, 0000,  726, 0000, 0000,
      0000,  501,  502,  503,  504,  505,  506,  507,
       508,  509,  510,  511,  512,  513,  514,  515,
       516,  517,  518,  519,  520,  521,  522,  523,
       524,  525,  526, 0000, 0000, 0000, 0000, 0000,
      0000,  601,  602,  603,  604,  605,  606,  607,
       608,  609,  610,  611,  612,  613,  614,  615,
       616,  617,  618,  619,  620,  621,  622,  623,
       624,  625,  626, 0000,  723, 0000, 0000,  ENDCHAR
    },                                

    { "complex_roman",
      0000, 1214, 1217, 1275, 1274, 0000, 1272, 1216,
      1221, 1222, 1219, 1232, 1211, 1231, 1210, 1220, 
      1200, 1201, 1202, 1203, 1204, 1205, 1206, 1207,
      1208, 1209, 1212, 1213, 1227, 1238, 1228, 1215,
      1273, 1001, 1002, 1003, 1004, 1005, 1006, 1007,
      1008, 1009, 1010, 1011, 1012, 1013, 1014, 1015,
      1016, 1017, 1018, 1019, 1020, 1021, 1022, 1023,
      1024, 1025, 1026, 1223, 0000, 1224, 0000, 0000,
      1253, 1101, 1102, 1103, 1104, 1105, 1106, 1107,
      1108, 1109, 1110, 1111, 1112, 1113, 1114, 1115,
      1116, 1117, 1118, 1119, 1120, 1121, 1122, 1123,
      1124, 1125, 1126, 1225, 1229, 1226, 1246, ENDCHAR
    }, 

    { "duplex_roman",
      0000, 2714, 2728, 0000, 2719, 0000, 2718, 2727,
      2721, 2722, 2723, 2725, 2711, 2724, 2710, 2720,
      2700, 2701, 2702, 2703, 2704, 2705, 2706, 2707,
      2708, 2709, 2712, 2713, 0000, 2726, 0000, 2715,
      0000, 2501, 2502, 2503, 2504, 2505, 2506, 2507,
      2508, 2509, 2510, 2511, 2512, 2513, 2514, 2515,
      2516, 2517, 2518, 2519, 2520, 2521, 2522, 2523,
      2524, 2525, 2526, 0000, 0000, 0000, 0000, 0000,
      2716, 2601, 2602, 2603, 2604, 2605, 2606, 2607,
      2608, 2609, 2610, 2611, 2612, 2613, 2614, 2615,
      2616, 2617, 2618, 2619, 2620, 2621, 2622, 2623,
      2624, 2625, 2626, 0000, 0000, 0000, 0000, ENDCHAR
    },

    { "triplex_roman",
      0000, 3214, 3228, 0000, 3219, 0000, 3218, 3227,
      3221, 3222, 3223, 3225, 3211, 3224, 3210, 3220,
      3200, 3201, 3202, 3203, 3204, 3205, 3206, 3207,
      3208, 3209, 3212, 3213, 0000, 3226, 0000, 3215,
      0000, 3001, 3002, 3003, 3004, 3005, 3006, 3007,
      3008, 3009, 3010, 3011, 3012, 3013, 3014, 3015,
      3016, 3017, 3018, 3019, 3020, 3021, 3022, 3023,
      3024, 3025, 3026, 0000, 0000, 0000, 0000, 0000,
      3216, 3101, 3102, 3103, 3104, 3105, 3106, 3107,
      3108, 3109, 3110, 3111, 3112, 3113, 3114, 3115,
      3116, 3117, 3118, 3119, 3120, 3121, 3122, 3123,
      3124, 3125, 3126, 0000, 0000, 0000, 0000, ENDCHAR
    },
 
    { "simplex_greek",
      0000,  714,  717,  733,  719, 0000,  734,  731,
       721,  722,  727,  725,  711,  724,  710,  720,
       700,  701,  702,  703,  704,  705,  706,  707,
       708,  709,  712,  713, 0000,  726, 0000, 0000,
      0000,  527,  528,  529,  530,  531,  532,  533,
       534,  535,  536,  537,  538,  539,  540,  541,
       542,  543,  544,  545,  546,  547,  548,  549,
       550, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000,  627,  628,  629,  630,  631,  632,  633,
       634,  635,  636,  637,  638,  639,  640,  641,
       642,  643,  644,  645,  646,  647,  648,  649,
       650, 0000, 0000, 0000,  723, 0000, 0000,  ENDCHAR 
    },

    { "complex_greek",
      0000, 1214, 1217, 1275, 1274, 0000, 1272, 1216,
      1221, 1222, 1219, 1232, 1211, 1231, 1210, 1220,
      1200, 1201, 1202, 1203, 1204, 1205, 1206, 1207,
      1208, 1209, 1212, 1213, 1227, 1238, 1228, 1215,
      1273, 1027, 1028, 1029, 1030, 1031, 1032, 1033,
      1034, 1035, 1036, 1037, 1038, 1039, 1040, 1041,
      1042, 1043, 1044, 1045, 1046, 1047, 1048, 1049,
      1050, 0000, 0000, 1223, 0000, 1224, 0000, 0000,
      1253, 1127, 1128, 1129, 1130, 1131, 1132, 1133,
      1134, 1135, 1136, 1137, 1138, 1139, 1140, 1141,
      1142, 1143, 1144, 1145, 1146, 1147, 1148, 1149,
      1150, 1125, 1126, 1225, 1229, 1226, 1246, ENDCHAR
    },

    { "complex_cyrillic",
      0000, 3214, 3228, 0000, 3219, 0000, 3218, 3227,
      3221, 3222, 3223, 3225, 3211, 3224, 3210, 3220,
      3200, 3201, 3202, 3203, 3204, 3205, 3206, 3207,
      3208, 3209, 3212, 3213, 0000, 3226, 0000, 3215,
      0000, 2801, 2802, 2803, 2804, 2805, 2806, 2807,
      2808, 2809, 2810, 2811, 2812, 2813, 2814, 2815,
      2816, 2817, 2818, 2819, 2820, 2821, 2822, 2823,
      2824, 2825, 2826, 0000, 0000, 0000, 0000, 0000,
      3216, 2901, 2902, 2903, 2904, 2905, 2906, 2907,
      2908, 2909, 2910, 2911, 2912, 2913, 2914, 2915,
      2916, 2917, 2918, 2919, 2920, 2921, 2922, 2923,
      2924, 2925, 2926, 0000, 0000, 0000, 0000, ENDCHAR
    },

    { "gothic_english",
      0000, 3214, 3228, 0000, 3219, 0000, 3218, 3227,
      3221, 3222, 3223, 3225, 3211, 3224, 3210, 3220,
      3200, 3201, 3202, 3203, 3204, 3205, 3206, 3207,
      3208, 3209, 3212, 3213, 0000, 3226, 0000, 3215,
      0000, 3501, 3502, 3503, 3504, 3505, 3506, 3507,
      3508, 3509, 3510, 3511, 3512, 3513, 3514, 3515,
      3516, 3517, 3518, 3519, 3520, 3521, 3522, 3523,
      3524, 3525, 3526, 0000, 0000, 0000, 0000, 0000,
      3216, 3601, 3602, 3603, 3604, 3605, 3606, 3607,
      3608, 3609, 3610, 3611, 3612, 3613, 3614, 3615,
      3616, 3617, 3618, 3619, 3620, 3621, 3622, 3623,
      3624, 3625, 3626, 0000, 0000, 0000, 0000, ENDCHAR
    },

    { "gothic_german",
      0000, 3214, 3228, 0000, 3219, 0000, 3218, 3227,
      3221, 3222, 3223, 3225, 3211, 3224, 3210, 3220,
      3200, 3201, 3202, 3203, 3204, 3205, 3206, 3207,
      3208, 3209, 3212, 3213, 0000, 3226, 0000, 3215,
      0000, 3301, 3302, 3303, 3304, 3305, 3306, 3307,
      3308, 3309, 3310, 3311, 3312, 3313, 3314, 3315,
      3316, 3317, 3318, 3319, 3320, 3321, 3322, 3323,
      3324, 3325, 3326, 0000, 0000, 0000, 0000, 0000,
      3216, 3401, 3402, 3403, 3404, 3405, 3406, 3407,
      3408, 3409, 3410, 3411, 3412, 3413, 3414, 3415,
      3416, 3417, 3418, 3419, 3420, 3421, 3422, 3423,
      3424, 3425, 3426, 0000, 0000, 0000, 0000, ENDCHAR 
    },

    { "gothic_italian",
      0000, 3714, 3728, 0000, 3719, 0000, 3718, 3727,
      3721, 3722, 3723, 3725, 3711, 3724, 3710, 3720,
      3700, 3701, 3702, 3703, 3704, 3705, 3706, 3707,
      3708, 3709, 3712, 3713, 0000, 3726, 0000, 3715,
      0000, 3801, 3802, 3803, 3804, 3805, 3806, 3807,
      3808, 3809, 3810, 3811, 3812, 3813, 3814, 3815, 
      3816, 3817, 3818, 3819, 3820, 3821, 3822, 3823, 
      3824, 3825, 3826, 0000, 0000, 0000, 0000, 0000,
      3716, 3901, 3902, 3903, 3904, 3905, 3906, 3907,
      3908, 3909, 3910, 3911, 3912, 3913, 3914, 3915,
      3916, 3917, 3918, 3919, 3920, 3921, 3922, 3923,
      3924, 3925, 3926, 0000, 0000, 0000, 0000, ENDCHAR
    },

    { "math",
      0000, 2241, 2217, 2240,  740, 2227, 2228, 2251,
      2221, 2222, 2235, 2233, 0000, 2234, 2210, 2237,
      2223, 2224, 2405, 2406, 2225, 2226, 2407, 2408,
      2403, 2404, 2409, 2410, 2243, 2239, 2244, 0000,
      2247, 2259, 2257, 2256, 2258, 2260, 2279, 2284,
      2281, 2268, 2269, 2412, 2230, 2401, 2245, 2270,
      2246, 2265, 2266, 2402, 2261, 2262, 2263, 2264,
      2255, 2411, 2229, 2223, 0000, 2224, 2247, 0000,
      2252, 2273, 2274, 2275, 2278, 2277, 2278, 2248,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
      0000, 0000, 0000, 0000, 0000, 0000, 0000, ENDCHAR
    },

};

#ifdef __STDC__
   void WriteChar();
#else
   void WriteChar();
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
*  Routine -
*
*  Description - Searches for hershey code in HersheyMap structure
*     for the specified font name and returns the ascii character
*     mapping for the hershey character code. 
*
*  Input variables - name -name of font
*     code -hershey code
*
*  Output variables - none
*
*  Returns - char
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
char MapChars(name,code)
    char *name; int code;
{
    int  i,j, found;
    char ret_char;

    ret_char = '\0';

    if(code <= 0) 
      {
      fprintf(stderr,"* * Error: Invalid hershey code %d\n", code);
      return(ret_char); 
      }
    /* 
      Search Hershey characterm map for code
    */
    for(i=0; strcmp(name,CharMap[i].name) != 0; i++) ;

    found = 0;
    for(j=0; !found && CharMap[i].code[j] != ENDCHAR; j++) 
      {
      if(CharMap[i].code[j] == code) 
        {
        found = 1;
        }
      }

    if(found)
      ret_char = (j-1) + 32; /* char map starts with ascii space char */

    return(ret_char);
}


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
*  Routine -
*
*  Description - 
*
*  Input variables -
*
*  Output variables -
*
*  Returns -
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
void ParseCommandLine(argc, argv, infont, outfont, font, use_width)
    int argc;
    char **argv;
    char *infont, *outfont;
    FontStruct *font;
    int  *use_width;
{
    int  i;


    i=1;
    while (i < argc)
      {
      if((strcmp(argv[i],"-o") ==0) || (strcmp(argv[i],"-output")==0))
         {
         (void)strcpy(outfont,argv[++i]);
         }
      else if((strcmp(argv[i],"-sc") ==0) || (strcmp(argv[i],"-scale")==0))
         {
         (void)sscanf(argv[++i],"%d",&font->scx);
         (void)sscanf(argv[++i],"%d",&font->scy); 
         }
      else if((strcmp(argv[i],"-fn") ==0) || (strcmp(argv[i],"-fontname")==0))
         {
         int found,j;

         (void)strcpy(font->name,argv[++i]);

         /* check if valid font name */
         for(found=0, j=0; j < MAX_FONTS && !found; j++)
            {
            if(!strcmp(font->name,CharMap[j].name)) found = 1;
            }

         if(!found)
           {
           fprintf(stderr,"* * Error: Unknown font name: %s\n", font->name);
           printf("Valid font names are:\n");
           for(j=0; j < MAX_FONTS; j++)
              printf("    %s\n", CharMap[j].name);

           exit(1);
           }
         }
      else if((strcmp(argv[i],"-sp") ==0) || (strcmp(argv[i],"-spacing")==0))
         {
         /* this option will add the specified value to the with of each char */
         (void)sscanf(argv[++i],"%f", &font->spacing);
         }
      else if(strcmp(argv[i],"-use_width")==0)
         {
         *use_width = 1;
         }
      else if((strcmp(argv[i],"-t") ==0) || (strcmp(argv[i],"-trans")==0))
         {
         (void)sscanf(argv[++i],"%d",&font->xtran);
         (void)sscanf(argv[++i],"%d",&font->ytran);
         } 
      else
         {
         (void)strcpy(infont,argv[i]);
         }
      i++;
      }
}


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
*  Routine -
*
*  Description - 
*
*  Input variables -
*
*  Output variables -
*
*  Returns -
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
void ReadHershey(infile, outfile, font, use_width) 
    char       *infile;
    char       *outfile;
    FontStruct *font;
    int         use_width;
{
    int  x, y;
    int  left, right;
    int  count;
    float width;
    char name, cmd, prevcmd, *ptr,*bufp;
    char buf[1024];
    char hershey_code[256];
    char temp[256];
    FILE *fileptr, *outptr; 


    if((fileptr=fopen(infile,"r")) == NULL)
      {
      (void)fprintf(stderr,"Couldn't open %s\n",infile);
      return;
      }

    if(outfile[0]=='\0')
      {
      outptr = stdout; 
      }
    else if((outptr=fopen(outfile,"w")) == NULL)
      {
      (void)fprintf(stderr,"Couldn't open %s\n",infile);
      (void)fclose(fileptr);
      exit(1);
      }

    (void)fprintf(outptr,"# %s\n", font->name); 

    /* First number is hershey font identifier.
       2nd field read is the left and right bounds in raster units.
       The rest of the line is the individual x,y coordinate pairs.
       A coordinate pair of -64,0 denotes a pen up 
       A coordinate pair of -64,-64 denotes the end of character.
    */
    while(fgets(buf,1024,fileptr) != NULL)
      {
      count = 0;
      bufp = buf;

      if((ptr=strchr(bufp,':'))!=NULL) /* get first field */
        {
        (void)strncpy(hershey_code,bufp,ptr-bufp);
        hershey_code[ptr-bufp] = '\0';

        bufp = &ptr[1]; /* skip ':' */

        /* 1st pair of numbers are left and right bounds in x */
        if((ptr=strchr(bufp,':'))!=NULL) 
          {
          (void)strncpy(temp,bufp,ptr-bufp);
          temp[ptr-bufp] = '\0';
          (void)sscanf(temp,"%d%d",&left,&right);

          chartemp[count].type = 'w';
          width = (float)(right - left);
          chartemp[count].x = font->scx * (int)(width+(width * font->spacing));
          count++;

          bufp = &ptr[1]; /* skip ':' */


          /* ok now loop and process x,y pairs and drawing directives */
          prevcmd = 'm';
          while((ptr=strchr(bufp,':'))!=NULL)
            {
            (void)strncpy(temp,bufp,ptr-bufp);
            temp[ptr-bufp] = '\0';
            (void)sscanf(temp,"%d%d",&x,&y);

            /* look for pen up */
            if(x == -64 && y == 0) cmd = 'm';
            else cmd = 'n';
           
            if(cmd == 'n')
              {
              /* store character points in temp array */
              chartemp[count].type = prevcmd;
              chartemp[count].x = font->scx * (x + font->xtran);
              chartemp[count].y = font->scy * (y + font->ytran);
              count++;
              } 

            prevcmd = cmd;
            bufp = &ptr[1]; /* skip ':' */
            } /* while */ 

          name = MapChars(font->name,atoi(hershey_code));
          if(name > 0)
            {
            WriteChar(outptr,name,&chartemp[0],count,use_width,font->spacing); 
            }
          }
        }      
      } /* while fgets */

    fclose(fileptr);
    fclose(outptr);
}


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
*  Routine -
*
*  Description - Returns minimum x value 
*
*  Input variables -
*     charp -array of structures with character stroke info
*     count -number of elements in array
*
*  Output variables - none
*
*  Returns -
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
int GetXMin(charp,count)
    CharStruct *charp;
    int        count;
{
    int  i,xmin;

    xmin = 5000;

    for(i=0; i < count; i++)
      {
      if(charp[i].type!='w' && charp[i].x < xmin)
        xmin = charp[i].x;
      }

    return(xmin);
}

int GetXMax(charp,count)
    CharStruct *charp;
    int        count;
{
    int  i,xmax;

    xmax = -5000;

    for(i=0; i < count; i++)
      {
      if(charp[i].type!='w' && charp[i].x > xmax)
        xmax = charp[i].x;
      }

    return(xmax);
}


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
*  Routine -
*
*  Description - 
*     Routine to translate hershey charcters which are
*     set up with centered about the x,y axis to gks characters that
*     are positioned in upper and lower right quadrants.
*
*     From:
*     |------|-------|
*     |      |       |
*     |   xxxxxxx    |
*     |   x  |  x    |
*     |---x-----x----|
*     |   x  |  x    |
*     |   xxxxxxx    |
*     |      |       |
*     |------|-------|
*
*     To:
*     |------|-------|
*     |      |       |
*     |      |xxxxxxx|
*     |      |x     x|
*     |------|x-----x|
*     |      |x     x|
*     |      |xxxxxxx|
*     |      |       |
*     |------|-------|
*
*
*  Input variables -
*
*  Output variables -
*
*  Returns -
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
void WriteChar(outptr,name,charp,count,use_width,spacing)
   FILE       *outptr;
   char        name;
   CharStruct *charp;
   int         count;
   int         use_width;
   float       spacing;
{
   int xmin,xmax;
   int i,width;


   fprintf(outptr,"#\n");
   fprintf(outptr,"C %c\n", name);

   if(use_width)
     {
     xmin = GetXMin(&charp[1],count);

     (void)fprintf(outptr,"%c %d\n", charp[0].type, charp[0].x); 
     }
   else
     {
     xmin = GetXMin(&charp[1],count);
     xmax = GetXMax(&charp[1],count);
     printf("xmin %d xmax %d\n", xmin, xmax);

     if(spacing > 0.0)
       {
       width = (xmax-xmin) + (int)((float)(xmax-xmin) * (float)spacing);
       printf("width %d\n", width);
       /* 
          fool gks on charcter width by writing out 
          mins and max in move commands
       */
/*       (void)fprintf(outptr,"m %d 0\n", xmin - (int)(width/2)); */
       (void)fprintf(outptr,"m %d 0\n", width);
       }
     }

   printf("making char %c\n",name);
   
   for(i=1; i < count; i++)
      {
      /* translate x coords to origin */
      charp[i].x = -xmin + charp[i].x;

      (void)fprintf(outptr,"%c %d %d\n", 
                    charp[i].type,charp[i].x,charp[i].y);
      }

   fprintf(outptr,"E\n");
}


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
*  Routine -
*
*  Description - 
*
*  Input variables -
*
*  Output variables -
*
*  Returns -
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
main(argc, argv)
int argc; char **argv;
{
  int        use_width;
  char       infile[512];
  char       outfile[512];
  FontStruct font;
    
  infile[0]='\0';
  outfile[0]='\0';

  font.xtran = 0; font.ytran = 0;
  font.scx = 1; font.scy = 1;
  font.spacing = 0.0;

  use_width = 0; 
  ParseCommandLine(argc,argv,infile,outfile,&font,&use_width);

  printf("font.spacing %f\n", font.spacing); 

  ReadHershey(infile,outfile,&font,use_width);
}
