
/* Various support functions for xlhtml. */

#include <stdio.h>
#include "support.h"

void print_version(void)
{
	printf("xlhtml \nCopyright (c) 1999-2002, Charles Wyble\n" 
	"Released under GPL.\n");
	exit(1);
}

void display_usage(void)
{
fprintf(stderr, "\nxlhtml  converts excel files (.xls) to Html.\n"
	"Copyright (c) 1999-2001, Charles Wyble. Released under GPL.\n"
"Usage: xlhtml [-xp:# -xc:#-# -xr:#-# -bc###### -bi???????? -tc######] <FILE>\n"
	"\t-a:  aggressive html optimization\n"
	"\t-asc ascii output for -dp & -x? options\n"
	"\t-csv comma separated value output for -dp & -x? options\n"
	"\t-xml XML output\n"
	"\t-bc: Set default background color - default white\n"
	"\t-bi: Set background image path\n"
	"\t-c:  Center justify tables\n"
	"\t-dp: Dumps page count and max rows & colums per page\n"
	"\t-v:  Prints program version number\n"
	"\t-fw: Suppress formula warnings\n"
	"\t-m:  No encoding for multibyte\n"
	"\t-nc: No Colors - black & white\n"
	"\t-nh: No Html Headers\n"
	"\t-tc: Set default text color - default black\n"
	"\t-te: Trims empty rows & columns at the edges of a worksheet\n"
	"\t-xc: Columns (separated by a dash) for extraction (zero based)\n"
	"\t-xp: Page extracted (zero based)\n"
	"\t-xr: Rows (separated by a dash) to be extracted (zero based)\n");
	fprintf(stderr, "\nReport bugs to jackshck@yahoo.com\n");
	exit (1);
}

void do_cr(void)
{
	extern int aggressive;
	if (!aggressive)
		putchar('\n');
}

U16 getShort(U8 *ptr)
{
	if (ptr == 0)
		return (U16)0;
	
	return (U16)((*(ptr+1)<<8)+*ptr);
}

/*! This is used in the RK number, so signedness counts */
S32 getLong(U8 *ptr)
{
	if (ptr == 0)
		return (S32)0;

	return (S32)(*(ptr+3)<<24)+(*(ptr+2)<<16)+(*(ptr+1)<<8)+*ptr;
}
