/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001 - 2005 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * gui_dialogsdialog.c - creation and destruction of the dialogs dialog
 *
 * show a dialog with 2 pages which will allow you to:
 * 1) select the fields in the "worked before" dialog. If the worked before
 *    dialog is active the fields are updated.
 * 2) set export options for save as ADIF and TSV (for glabels).
 */
#include <stdlib.h>
#include <gtk/gtk.h>

#include "gui_dialogsdialog.h"
#include "support.h"
#include "types.h"

extern GtkWidget *mainwindow;
extern GtkWidget *b4dialog;
extern preferencestype preferences;

void
on_menu_dialogs_activate(GtkMenuItem * menuitem, gpointer user_data)
{
	GtkWidget *dialogsdialog, *notebook, *vbox, *label,
		*frame, *framehbox, *leftvbox, *middlevbox, *rightvbox, *vbox2,
		*b40, *b41, *b42, *b43, *b44, *b45, *b46, *b47, *b48, *b49,
		*b410, *b411, *b412, *b413, *b414, *b415, *b416, *b417, *b418,
		*badif, *hsep, *bu1, *bu2, *bu3, *bu4, *bu5, *bu6, *bu7, *bu8,
		*bu9, *bu10, *bu11, *bu12, *bu13, *bu14, *bu15, *bu16, *bu17,
		*b4treeview, *tsvhbox;
	gchar **states, **split;
	gboolean check;
	GtkTreeViewColumn *column;
	gint i, response;

	split = g_strsplit(preferences.b4columns, ",", 0);
	dialogsdialog = gtk_dialog_new_with_buttons (_("xlog - dialogs"),
		GTK_WINDOW(mainwindow), GTK_DIALOG_DESTROY_WITH_PARENT,
		GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, 
		GTK_STOCK_OK, GTK_RESPONSE_OK, NULL);
	notebook = gtk_notebook_new ();
	gtk_container_add
		(GTK_CONTAINER (GTK_DIALOG (dialogsdialog)->vbox), notebook);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (notebook), vbox);
	label = gtk_label_new (_("Columns to show in the 'Worked Before' dialog"));
	gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 10);
	gtk_label_set_line_wrap (GTK_LABEL (label), TRUE);

	frame = gtk_frame_new (NULL);
	gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);
	framehbox = gtk_hbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (frame), framehbox);

	leftvbox = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (framehbox), leftvbox, FALSE, FALSE, 0);
	b40 = gtk_check_button_new_with_label (_("Logname"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b40), atoi(split[0]));
	gtk_box_pack_start (GTK_BOX (leftvbox), b40, FALSE, FALSE, 0);
	b41 = gtk_check_button_new_with_label (_("QSO Number"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b41), atoi(split[1]));
	gtk_box_pack_start (GTK_BOX (leftvbox), b41, FALSE, FALSE, 0);
	b42 = gtk_check_button_new_with_label (_("Date"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b42), atoi(split[2]));
	gtk_box_pack_start (GTK_BOX (leftvbox), b42, FALSE, FALSE, 0);
	b43 = gtk_check_button_new_with_label ("GMT");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b43), atoi(split[3]));
	gtk_box_pack_start (GTK_BOX (leftvbox), b43, FALSE, FALSE, 0);
	b44 = gtk_check_button_new_with_label (_("GMT - end"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b44), atoi(split[4]));
	gtk_box_pack_start (GTK_BOX (leftvbox), b44, FALSE, FALSE, 0);
	b45 = gtk_check_button_new_with_label (_("Call"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b45), atoi(split[5]));
	gtk_box_pack_start (GTK_BOX (leftvbox), b45, FALSE, FALSE, 0);
	b46 = gtk_check_button_new_with_label (_("Frequency"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b46), atoi(split[6]));
	gtk_box_pack_start (GTK_BOX (leftvbox), b46, FALSE, FALSE, 0);

	middlevbox = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (framehbox), middlevbox, FALSE, FALSE, 0);
	b47 = gtk_check_button_new_with_label (_("Mode"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b47), atoi(split[7]));
	gtk_box_pack_start (GTK_BOX (middlevbox), b47, FALSE, FALSE, 0);
	b48 = gtk_check_button_new_with_label ("TX(RST)");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b48), atoi(split[8]));
	gtk_box_pack_start (GTK_BOX (middlevbox), b48, FALSE, FALSE, 0);
	b49 = gtk_check_button_new_with_label ("RX(RST)");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b49), atoi(split[9]));
	gtk_box_pack_start (GTK_BOX (middlevbox), b49, FALSE, FALSE, 0);
	b410 = gtk_check_button_new_with_label (_("Qsl Out"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b410), atoi(split[10]));
	gtk_box_pack_start (GTK_BOX (middlevbox), b410, FALSE, FALSE, 0);
	b411 = gtk_check_button_new_with_label (_("Qsl In"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b411), atoi(split[11]));
	gtk_box_pack_start (GTK_BOX (middlevbox), b411, FALSE, FALSE, 0);
	b412 = gtk_check_button_new_with_label (_("Power"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b412), atoi(split[12]));
	gtk_box_pack_start (GTK_BOX (middlevbox), b412, FALSE, FALSE, 0);

	rightvbox = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (framehbox), rightvbox, FALSE, FALSE, 0);
	b413 = gtk_check_button_new_with_label (_("Name"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b413), atoi(split[13]));
	gtk_box_pack_start (GTK_BOX (rightvbox), b413, FALSE, FALSE, 0);
	b414 = gtk_check_button_new_with_label ("QTH");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b414), atoi(split[14]));
	gtk_box_pack_start (GTK_BOX (rightvbox), b414, FALSE, FALSE, 0);
	b415 = gtk_check_button_new_with_label (_("Locator"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b415), atoi(split[15]));
	gtk_box_pack_start (GTK_BOX (rightvbox), b415, FALSE, FALSE, 0);
	b416 = gtk_check_button_new_with_label (_("Freefield1"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b416), atoi(split[16]));
	gtk_box_pack_start (GTK_BOX (rightvbox), b416, FALSE, FALSE, 0);
	b417 = gtk_check_button_new_with_label (_("Freefield2"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b417), atoi(split[17]));
	gtk_box_pack_start (GTK_BOX (rightvbox), b417, FALSE, FALSE, 0);
	b418 = gtk_check_button_new_with_label (_("Remarks"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b418), atoi(split[18]));
	gtk_box_pack_start (GTK_BOX (rightvbox), b418, FALSE, FALSE, 0);

	g_strfreev(split);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (notebook), vbox);

	label = gtk_label_new (_("Export options for the 'Save As' dialog"));
	gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 10);
	gtk_label_set_line_wrap (GTK_LABEL (label), TRUE);

	frame = gtk_frame_new ("ADIF");
	gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);
	badif = gtk_check_button_new_with_label
		(_("When saving as ADIF convert frequency to band"));
	if (preferences.saveasadif == 1)
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (badif), TRUE);
	gtk_container_add (GTK_CONTAINER (frame), badif);
	gtk_label_set_line_wrap	(GTK_LABEL (GTK_BIN (badif)->child), TRUE);

	frame = gtk_frame_new ("TSV");
	gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);
	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (frame), vbox2);
	label = gtk_label_new
("Fields to export when saving as TSV (Tab Separated Value) for glabels");
	gtk_container_add (GTK_CONTAINER (vbox2), label);
	gtk_label_set_line_wrap (GTK_LABEL (label), TRUE);
	hsep = gtk_hseparator_new ();
	gtk_container_add (GTK_CONTAINER (vbox2), hsep);
	tsvhbox = gtk_hbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (vbox2), tsvhbox);

	split = g_strsplit(preferences.saveastsv, ",", 0);
	leftvbox = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (tsvhbox), leftvbox, FALSE, FALSE, 0);
	bu1 = gtk_check_button_new_with_label (_("Date"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu1), atoi(split[0]));
	gtk_box_pack_start (GTK_BOX (leftvbox), bu1, FALSE, FALSE, 0);
	bu2 = gtk_check_button_new_with_label ("GMT");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu2), atoi(split[1]));
	gtk_box_pack_start (GTK_BOX (leftvbox), bu2, FALSE, FALSE, 0);
	bu3 = gtk_check_button_new_with_label (_("GMT - end"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu3), atoi(split[2]));
	gtk_box_pack_start (GTK_BOX (leftvbox), bu3, FALSE, FALSE, 0);
	bu4 = gtk_check_button_new_with_label (_("Call"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu4), atoi(split[3]));
	gtk_box_pack_start (GTK_BOX (leftvbox), bu4, FALSE, FALSE, 0);
	bu5 = gtk_check_button_new_with_label (_("Frequency"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu5), atoi(split[4]));
	gtk_box_pack_start (GTK_BOX (leftvbox), bu5, FALSE, FALSE, 0);
	bu6 = gtk_check_button_new_with_label (_("Mode"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu6), atoi(split[5]));
	gtk_box_pack_start (GTK_BOX (leftvbox), bu6, FALSE, FALSE, 0);

	middlevbox = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (tsvhbox), middlevbox, FALSE, FALSE, 0);
	bu7 = gtk_check_button_new_with_label ("TX(RST)");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu7), atoi(split[6]));
	gtk_box_pack_start (GTK_BOX (middlevbox), bu7, FALSE, FALSE, 0);
	bu8 = gtk_check_button_new_with_label ("RX(RST)");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu8), atoi(split[7]));
	gtk_box_pack_start (GTK_BOX (middlevbox), bu8, FALSE, FALSE, 0);
	bu9 = gtk_check_button_new_with_label (_("Qsl Out"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu9), atoi(split[8]));
	gtk_box_pack_start (GTK_BOX (middlevbox), bu9, FALSE, FALSE, 0);
	bu10 = gtk_check_button_new_with_label (_("Qsl In"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu10), atoi(split[9]));
	gtk_box_pack_start (GTK_BOX (middlevbox), bu10, FALSE, FALSE, 0);
	bu11 = gtk_check_button_new_with_label (_("Power"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu11), atoi(split[10]));
	gtk_box_pack_start (GTK_BOX (middlevbox), bu11, FALSE, FALSE, 0);
	bu12 = gtk_check_button_new_with_label (_("Name"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu12), atoi(split[11]));
	gtk_box_pack_start (GTK_BOX (middlevbox), bu12, FALSE, FALSE, 0);

	rightvbox = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (tsvhbox), rightvbox, FALSE, FALSE, 0);
	bu13 = gtk_check_button_new_with_label ("QTH");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu13), atoi(split[12]));
	gtk_box_pack_start (GTK_BOX (rightvbox), bu13, FALSE, FALSE, 0);
	bu14 = gtk_check_button_new_with_label (_("Locator"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu14), atoi(split[13]));
	gtk_box_pack_start (GTK_BOX (rightvbox), bu14, FALSE, FALSE, 0);
	bu15 = gtk_check_button_new_with_label (_("Freefield1"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu15), atoi(split[14]));
	gtk_box_pack_start (GTK_BOX (rightvbox), bu15, FALSE, FALSE, 0);
	bu16 = gtk_check_button_new_with_label (_("Freefield2"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu16), atoi(split[15]));
	gtk_box_pack_start (GTK_BOX (rightvbox), bu16, FALSE, FALSE, 0);
	bu17 = gtk_check_button_new_with_label (_("Remarks"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu17), atoi(split[16]));
	gtk_box_pack_start (GTK_BOX (rightvbox), bu17, FALSE, FALSE, 0);

	g_strfreev(split);

	label = gtk_label_new (_("Worked Before"));
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook),
		gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), 0), label);
	label = gtk_label_new (_("Save As"));
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook),
		gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), 1), label);

	gtk_button_set_label (GTK_BUTTON (b416), preferences.freefield1);
	gtk_button_set_label (GTK_BUTTON (b417), preferences.freefield2);
	gtk_button_set_label (GTK_BUTTON (bu15), preferences.freefield1);
	gtk_button_set_label (GTK_BUTTON (bu16), preferences.freefield2);

	gtk_widget_show_all (dialogsdialog);	
	response = gtk_dialog_run (GTK_DIALOG(dialogsdialog));
	if (response == GTK_RESPONSE_OK)
	{
		states = g_new0 (gchar *, 20);
		b4treeview = lookup_widget (b4dialog, "b4treeview");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b40));
		if (b4dialog && GTK_WIDGET_VISIBLE (b4dialog))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 0);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[0] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b41));
		if (b4dialog && GTK_WIDGET_VISIBLE (b4dialog))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 1);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[1] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b42));
		if (b4dialog && GTK_WIDGET_VISIBLE (b4dialog))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 2);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[2] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b43));
		if (b4dialog && GTK_WIDGET_VISIBLE (b4dialog))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 3);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[3] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b44));
		if (b4dialog && GTK_WIDGET_VISIBLE (b4dialog))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 4);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[4] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b45));
		if (b4dialog && GTK_WIDGET_VISIBLE (b4dialog))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 5);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[5] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b46));
		if (b4dialog && GTK_WIDGET_VISIBLE (b4dialog))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 6);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[6] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b47));
		if (b4dialog && GTK_WIDGET_VISIBLE (b4dialog))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 7);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[7] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b48));
		if (b4dialog && GTK_WIDGET_VISIBLE (b4dialog))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 8);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[8] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b49));
		if (b4dialog && GTK_WIDGET_VISIBLE (b4dialog))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 9);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[9] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b410));
		if (b4dialog && GTK_WIDGET_VISIBLE (b4dialog))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 10);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[10] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b411));
		if (b4dialog && GTK_WIDGET_VISIBLE (b4dialog))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 11);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[11] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b412));
		if (b4dialog && GTK_WIDGET_VISIBLE (b4dialog))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 12);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[12] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b413));
		if (b4dialog && GTK_WIDGET_VISIBLE (b4dialog))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 13);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[13] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b414));
		if (b4dialog && GTK_WIDGET_VISIBLE (b4dialog))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 14);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[14] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b415));
		if (b4dialog && GTK_WIDGET_VISIBLE (b4dialog))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 15);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[15] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b416));
		if (b4dialog && GTK_WIDGET_VISIBLE (b4dialog))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 16);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[16] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b417));
		if (b4dialog && GTK_WIDGET_VISIBLE (b4dialog))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 17);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[17] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b418));
		if (b4dialog && GTK_WIDGET_VISIBLE (b4dialog))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 18);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[18] = g_strdup (check ? "1" : "0");

		states[19] = NULL;	/* terminator for g_strjoinv */
		preferences.b4columns = g_strjoinv (",", states);

		for (i = 0; i < 19; i++)
			g_free (states[i]);
		g_free (states);

		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(badif));
		if (check)
			preferences.saveasadif = 1;
		else
			preferences.saveasadif = 0;

		states = g_new0 (gchar *, 18);
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bu1));
		states[0] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bu2));
		states[1] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bu3));
		states[2] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bu4));
		states[3] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bu5));
		states[4] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bu6));
		states[5] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bu7));
		states[6] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bu8));
		states[7] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bu9));
		states[8] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bu10));
		states[9] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bu11));
		states[10] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bu12));
		states[11] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bu13));
		states[12] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bu14));
		states[13] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bu15));
		states[14] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bu16));
		states[15] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bu17));
		states[16] = g_strdup (check ? "1" : "0");

		states[17] = NULL;	/* terminator for g_strjoinv */
		preferences.saveastsv = g_strjoinv (",", states);

		for (i = 0; i < 17; i++)
			g_free (states[i]);
		g_free (states);
	}
	gtk_widget_destroy (dialogsdialog);
}
