
if ($#ARGV < 0)
{
    print STDERR
	" $$: $0  @ARGV
 DESCRIPTION
  write the input into two streams, always use 1 - standard output <stdout>.
  if no opion is given, the other is 2 - standard error stream <stderr>.
  -o=file ... use this as the output file to write to.
  -a=file ... use this as the output file to append to.
  <input> is taken from the files given, '-' is <stdin>
";
    exit;
}


my $T = "";
my %o;
for (@ARGV)
{
    if (/^-$/) { $T .= join ("",<STDIN>); }
    elsif (/^-([\w-]+)=(.*)/) { $o{$1} = $2; }
    elsif (/^-([\w-]+)/) { $o{$1} = ""; }
    else {
	my $F = $_; 
	if (open F, "<$F") { $T .= join("",<F>); close F; }
	else { die "could not open $F", $1; }
    }
}

if (length $T)
{ 
    print $T;

#   and the tee....

    if (not defined $o{o} and not defined $o{a}) {
	print STDERR $T;
    }else{
	if (defined $o{o}) {
	    my $F = $o{o}; 
	    if (open F,">$F") {
		print F $T;
		close F;
	    }
	}

	if (defined $o{a}) {
	    my $F = $o{a}; 
	    if (open F,">>$F") {
		print F $T;
		close F;
	    }
	}
    }
}

