
/*
 *
 *
 */

#include "defs.h"

Prototype VNode *MakeVNode(List *list, const char *vname);
Prototype void CommitVNode(VNode *vn);
Prototype int VNodeStrSize(VNode *vn);
Prototype DNode *MakeDNode(const char *vname);
Prototype Depend *MakeDepend(const char *dname, Node *rhsn, List *rhsl, List *xlist);
Prototype List *FindVar(char c, Depend *dep, const char *vname);

VNode *
MakeVNode(List *list, const char *vname)
{
    VNode *vn = (VNode *)MakeNode(vname, sizeof(VNode), 0);
    vn->vn_Node.no_Type = TYPE_VARTMP;
    InitList(&vn->vn_List);
    AddTail(list, &vn->vn_Node);
    return(vn);
}

void
CommitVNode(VNode *vn)
{
    vn->vn_Node.no_Type = TYPE_VAR;
}

int
VNodeStrSize(VNode *vn)
{
    Node *node;
    int l = 1;

    for (node = GetHead(&vn->vn_List); node; node = GetNext(node)) {
	l += strlen(node->no_Name) + 1;
    }
    return(l);
}

DNode *
MakeDNode(const char *dname)
{
    DNode *dn;
    char buf[256];
    const char *ptr = dname;

    if (*dname == '\"') {
	int l = strlen(dname + 1) - 1;
	char *p = buf;

	if (l + 1 >= sizeof(buf)) {
	    p = malloc(l + 1);
	}
	strncpy(p, dname + 1, l);
	p[l] = 0;
	ptr = p;
    }
    dn = (DNode *)MakeNode(ptr, sizeof(DNode), 0);
    dn->dn_Depend = MakeDepend(ptr, NULL, NULL, NULL);

    if (ptr != dname && ptr != buf)
	free((char *)ptr);

    return(dn);
}

Depend *
MakeDepend(const char *dname, Node *rhsn, List *rhsl, List *xlist)
{
    Depend *dbase;
    Depend *dep;

    /*
     * See if dependancy exists, create it if it does not
     */

    for (dbase = GetHead(&DependList); dbase; dbase = GetNext(&dbase->de_Node)) {
	if (strcmp(dname, dbase->de_Node.no_Name) == 0)
	    break;
    }
    if (dbase == NULL || dbase->de_Rhs != NULL || dbase->de_XList != NULL) {
	Node *no;

	dep = MakeNode(dname, sizeof(Depend), 0);
	dep->de_Node.no_Value = DEPEND_NOTRUN;

	if (dbase == NULL) {		/* XXX */
	    AddTail(&DependList, &dep->de_Node);
	    dbase = dep;
	} else {
	    Depend *dn = dbase;

	    while (dn->de_Chain)
		dn = dn->de_Chain;
	    dn->de_Chain = dep;
	}

	InitList(&dep->de_Lhs);

	/*
	 * dummy node used for %(left) extraction
	 */
	no = MakeNode(dname, sizeof(Node), 0);
	AddTail(&dep->de_Lhs, no);
    } else {
	dep = dbase;
    }

    /*
     * Apply rhsn - right hand side DNode
     */

    if (rhsn) {
	dep->de_Rhs = malloc(sizeof(List));
	InitList(dep->de_Rhs);
	AddTail(dep->de_Rhs, rhsn);
    }

    /*
     * Apply rhsl - right hand side list of DNode's
     */

    if (rhsl) {
	if (dep->de_Rhs == NULL) {
	    dep->de_Rhs = rhsl;
	} else {
	    Node *node;

	    for (node = GetHead(rhsl); node; node = GetNext(node)) {
		Node *n2 = CopyNode(node);
		AddTail(dep->de_Rhs, n2);
	    }
	}
    }

    /*
     * Apply xlist
     */

    dep->de_XList = xlist;

    return(dbase);
}

List *
FindVar(char c, Depend *dep, const char *vname)
{
    List *list = NULL;

    if (c == '$') {
	VNode *vn;

	for (vn = GetTail(&VarList); vn; vn = GetPrev(&vn->vn_Node)) {
	    if (vn->vn_Node.no_Type == TYPE_VAR && 
		strcmp(vn->vn_Node.no_Name, vname) == 0
	    ) {
		list = &vn->vn_List;
		break;
	    }
	}
    } else if (c == '%') {
	if (dep == NULL) {
	    fatal(NULL, "variable outside of execution list:: %%%s\n", vname);
	} else {
	    if (strcmp(vname, "left") == 0) {
		list = &dep->de_Lhs;
	    } else if (strcmp(vname, "right") == 0) {
		list = dep->de_Rhs;
	    } else {
		fatal(NULL, "Illegal special name '%s'\n", vname);
	    }
	}
    } else {
	fatal(NULL, "Illegal variable special '%c'\n", c);
    }
    return(list);
}

