/* 
 *  XMMS Crossfade Plugin
 *  Copyright (C) 2000-2001  Peter Eisenlohr <p.eisenlohr@gmx.net>
 *
 *  based on the original OSS Output Plugin
 *  Copyright (C) 1998-2000  Peter Alm, Mikael Alm, Olle Hallnas, Thomas Nilsson and 4Front Technologies
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */

#ifndef _OSS_H_
#define _OSS_H_

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "crossfade.h"

#ifdef HAVE_SYS_SOUNDCARD_H
#  include <sys/soundcard.h>
#elif defined(HAVE_MACHINE_SOUNDCARD_H)
#  include <machine/soundcard.h>
#endif

/* device buffer size: 22*2048 ~= 250 ms */
#define OSS_FRAGMENT    0x0016000b
#define OSS_MAXFRAGMENT 0xffff000b
#define OSS_FRAGMENT_SIZE 2048
#define OSS_FRAGMENT_UTIME (OSS_FRAGMENT_SIZE*1000000/OUTPUT_BPS)

#define MIN_BUFFER_SIZE 2048

/* get plugin info */
OutputPlugin *xfade_get_builtin_oss_oplugin_info(void);

#endif  /* _OSS_H_ */
