/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __SINGIT_KARAOKE_WIDGET_H__
#define __SINGIT_KARAOKE_WIDGET_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "singit_song.h"

#define TYPE_SINGIT_KARAOKE_WIDGET            (singit_karaoke_widget_get_type ())
#define SINGIT_KARAOKE_WIDGET(obj)            (GTK_CHECK_CAST ((obj), TYPE_SINGIT_KARAOKE_WIDGET, SingitKaraokeWidget))
#define SINGIT_KARAOKE_WIDGET_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), TYPE_SINGIT_KARAOKE_WIDGET, SingitKaraokeWidget))
#define IS_SINGIT_KARAOKE_WIDGET(obj)         (GTK_CHECK_TYPE ((obj), TYPE_SINGIT_KARAOKE_WIDGET))
#define IS_SINGIT_KARAOKE_WIDGET_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_SINGIT_KARAOKE_WIDGET))

typedef struct _SingitKaraokeWidget       SingitKaraokeWidget;
typedef struct _SingitKaraokeWidgetClass  SingitKaraokeWidgetClass;

typedef enum {
	skwm_line_scroll,
	skwm_site_per_freeline
}
SingitWidgetMode;

typedef enum {
	skwc_text = 0,
	skwc_background,
	skwc_active
}
SingitKaraokeWidgetColor;

struct _SingitKaraokeWidget
{
	GtkDrawingArea    area;

	GdkFont          *private_font;
	gchar            *private_font_name;

	GdkColormap      *private_colormap;
	GdkColor          private_color[3];
	GdkPixmap        *double_buffer_pixmap;
	GdkPixmap        *ball_pixmap;

	guint             pbp_start, pbp_offset, pbp_offset_max;  // Progress Bar Positions
	guint             pbp_start_last, pbp_offset_last;

	guint            *word_pos;
	guint             ball_y_pos, ball_y_pos_last;
	guint             ball_start, ball_offset_max;

	gint             *sizes;        // Array of internal size vaules (see enums in .c)

	GList            *current;	// Represents the current token
	LSong            *song;		// Attached current song

	gdouble           fps;          // Frames per second
	gint              frames;
	GTimeVal          last_rtc_time, new_rtc_time;
	gint              last_time;

	guint             line_seperator_high;
	guint             active_line_seperator_high;

	// Widget behaviour
	SingitWidgetMode  mode;
	guint             lines;
	guint             top_lines;
	gboolean          use_ball;
	gboolean          show_empty_lines;
	gint              freezers;
	gboolean          maxLineWidth;
	gboolean          maxRows;
};

struct _SingitKaraokeWidgetClass
{
	GtkDrawingAreaClass parent_class;
};

GtkType    singit_karaoke_widget_get_type   (void);
GtkWidget *singit_karaoke_widget_new        (void);

void       singit_karaoke_widget_set_song   (SingitKaraokeWidget *skw, LSong *new_song);


void       singit_karaoke_widget_freeze     (SingitKaraokeWidget *skw);
void       singit_karaoke_widget_thaw       (SingitKaraokeWidget *skw);

void       singit_karaoke_widget_set_time   (SingitKaraokeWidget *skw, guint time);

void       singit_karaoke_widget_set_lines  (SingitKaraokeWidget *skw, guint value);
guint      singit_karaoke_widget_get_lines  (SingitKaraokeWidget *skw);

void       singit_karaoke_widget_set_toplines  (SingitKaraokeWidget *skw, guint value);
guint      singit_karaoke_widget_get_toplines  (SingitKaraokeWidget *skw);

void       singit_karaoke_widget_set_color  (SingitKaraokeWidget *skw, SingitKaraokeWidgetColor item, gchar *color);
void       singit_karaoke_widget_set_font   (SingitKaraokeWidget *skw, const gchar *font);
void       singit_karaoke_widget_set_show_empty_lines (SingitKaraokeWidget *skw, const gboolean value);
void       singit_karaoke_widget_set_jumping_ball (SingitKaraokeWidget *skw, const gboolean value);

void       singit_karaoke_widget_set_optimal_font (SingitKaraokeWidget *skw);

gdouble    singit_karaoke_widget_get_frames_per_second (SingitKaraokeWidget *skw);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif  // __SINGIT_KARAOKE_WIDGET_H__
