/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <glib.h>
#include <gtk/gtk.h>
#include <sys/types.h>
#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>

#include <xmms/configfile.h>

#include "singit/macros.h"
#include "singit/wgt_colorbutton.h"

#include "displayer_clist_status.h"
#include "displayer_clist_config.h"
#include "displayer_clist_config_dlg.h"

static GtkWidget *displayer_clist_config_win = NULL;
static GtkWidget
	*displayer_clist_config_vbox,
		*displayer_clist_config_force_globals_frame,
			*displayer_clist_config_force_globals_check_button,
		*displayer_clist_config_notebook,
		*displayer_clist_config_displayer_vbox, *displayer_clist_config_displayer_label,
			*displayer_clist_config_font_frame,
				*displayer_clist_config_font_hbox,
				*displayer_clist_config_font_entry,
				*displayer_clist_config_font_browse_button,
				*displayer_clist_config_fontsel,
			*displayer_clist_config_color_frame,
				*displayer_clist_config_color_vbox,
				*displayer_clist_config_color_background_hbox_widget,
				*displayer_clist_config_color_background_label,
				*displayer_clist_config_color_background_button,
				*displayer_clist_config_color_normal_text_hbox_widget,
				*displayer_clist_config_color_normal_text_label,
				*displayer_clist_config_color_normal_text_button,
				*displayer_clist_config_color_normal_bar_hbox_widget,
				*displayer_clist_config_color_normal_bar_label,
				*displayer_clist_config_color_normal_bar_button,
				*displayer_clist_config_color_progress_text_hbox_widget,
				*displayer_clist_config_color_progress_text_label,
				*displayer_clist_config_color_progress_text_button,
				*displayer_clist_config_color_progress_bar_hbox_widget,
				*displayer_clist_config_color_progress_bar_label,
				*displayer_clist_config_color_progress_bar_button,
		*displayer_clist_config_displayer_toggle_vbox, *displayer_clist_config_displayer_toggle_label,
			*displayer_clist_config_hide_if_not_found_check_button,
			*displayer_clist_config_auto_resize_check_button,
#ifdef CODEDEBUG
			*displayer_clist_config_enable_debug_check_button,
#endif
			*displayer_clist_config_1_hsep,
			*displayer_clist_config_show_on_text_check_button,
		*bottom_button_hbox,
			*bottom_button_ok,
			*bottom_button_cancel,
			*bottom_button_apply;

// static GtkWidget *font_select_dialog = NULL;
/*
static GtkTooltips
		*plugin_clist_tooltips = NULL;
*/
typedef struct {

	guchar *color_array;
//	guint exporter_selection;

	gboolean updating_displayer_list;

	SingitConfigGen *cscg;

} ConfigStatus;

ConfigStatus displayer_clist_config_status;

static void displayer_clist_config_font_browse_ok(GtkWidget * w, gpointer data)
{
        gtk_entry_set_text(GTK_ENTRY(displayer_clist_config_font_entry),
		gtk_font_selection_dialog_get_font_name(GTK_FONT_SELECTION_DIALOG(displayer_clist_config_fontsel)));
        gtk_widget_destroy(displayer_clist_config_fontsel);
}

static void displayer_clist_config_font_browse_cb(GtkWidget * w, gpointer data)
{
	gchar *temp;

        if (!displayer_clist_config_fontsel)
        {
		temp = g_strconcat(_("Select lyric font"), ":", NULL);
                displayer_clist_config_fontsel = gtk_font_selection_dialog_new(temp);
		g_free(temp);
		gtk_window_set_modal(GTK_WINDOW(displayer_clist_config_fontsel), TRUE);
                gtk_font_selection_dialog_set_font_name(GTK_FONT_SELECTION_DIALOG(displayer_clist_config_fontsel),
			GET_DCC->lyricFontName);
                gtk_signal_connect(GTK_OBJECT(GTK_FONT_SELECTION_DIALOG(displayer_clist_config_fontsel)->ok_button), "clicked",
			GTK_SIGNAL_FUNC(displayer_clist_config_font_browse_ok), NULL);
                gtk_signal_connect_object(GTK_OBJECT(GTK_FONT_SELECTION_DIALOG(displayer_clist_config_fontsel)->cancel_button),
			"clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(displayer_clist_config_fontsel));
                gtk_signal_connect(GTK_OBJECT(displayer_clist_config_fontsel), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed),
			&displayer_clist_config_fontsel);
                gtk_widget_show(displayer_clist_config_fontsel);
        }
}

static void displayer_clist_config_force_globals_toggle_event(GtkToggleButton *toggleButton,  gpointer data)
{
	gboolean state = !gtk_toggle_button_get_active(toggleButton);

	gtk_widget_set_sensitive(displayer_clist_config_font_entry, state);
	gtk_widget_set_sensitive(displayer_clist_config_font_browse_button, state);

	gtk_widget_set_sensitive(displayer_clist_config_color_background_button, state);
	gtk_widget_set_sensitive(displayer_clist_config_color_normal_text_button, state);
	gtk_widget_set_sensitive(displayer_clist_config_color_normal_bar_button, state);
	gtk_widget_set_sensitive(displayer_clist_config_color_progress_text_button, state);
	gtk_widget_set_sensitive(displayer_clist_config_color_progress_bar_button, state);

	gtk_widget_set_sensitive(displayer_clist_config_hide_if_not_found_check_button, state);
	gtk_widget_set_sensitive(displayer_clist_config_auto_resize_check_button, state);
#ifdef CODEDEBUG
	gtk_widget_set_sensitive(displayer_clist_config_enable_debug_check_button, state);
#endif
}

static void displayer_clist_config_cleanup()
{
	CListConfigData *ccd = GET_DCC;

#ifdef CODEDEBUG
	DEBUG(("dlg_singit_config.c [displayer_clist_config_cleanup]\n"));
#endif

	if (displayer_clist_config_win && displayer_clist_config_win->window && ccd) {
		gdk_window_get_position(displayer_clist_config_win->window,
			&(ccd->winPosX), &(ccd->winPosY));
//		displayer_clist_config_save_positions();
	}

	g_free(displayer_clist_config_status.color_array);

	clist_status_unref(NULL);
}

static void displayer_clist_config_apply_clicked(GtkButton *button, gpointer user_data)
{
	gchar tmp[13];
	CListConfigData *ccd;

#ifdef CODEDEBUG
	DEBUG(("dlg_singit_config.c [displayer_clist_config_apply_clicked]\n"));
#endif

	g_return_if_fail(displayer_clist_config_win != NULL);
	g_return_if_fail(GTK_WIDGET_REALIZED(displayer_clist_config_win));
	g_return_if_fail(STATUS != NULL);
	g_return_if_fail(STATUS->config != NULL);

	ccd = GET_DCC;

	tmp[12] = '\0';

	g_free(ccd->lyricFontName);
	g_free(ccd->backgroundColor);
	g_free(ccd->normalTextColor);
	g_free(ccd->normalBarColor);
	g_free(ccd->progressTextColor);
	g_free(ccd->progressBarColor);

	/* set new values */

	ccd->forceGlobals = GTK_TOGGLE_BUTTON(displayer_clist_config_force_globals_check_button)->active;

	ccd->lyricFontName = gtk_editable_get_chars(GTK_EDITABLE(displayer_clist_config_font_entry), 0, -1);
	ccd->autoResize = GTK_TOGGLE_BUTTON(displayer_clist_config_auto_resize_check_button)->active;
	ccd->hideIfNotFound = GTK_TOGGLE_BUTTON(displayer_clist_config_hide_if_not_found_check_button)->active;
	ccd->showOnText = GTK_TOGGLE_BUTTON(displayer_clist_config_show_on_text_check_button)->active;

#ifdef CODEDEBUG
	ccd->debugEnable = GTK_TOGGLE_BUTTON(displayer_clist_config_enable_debug_check_button)->active;
#endif

#define GET_RGB_AS_STRING(a,b) { sprintf(tmp, "rgb:%.2x/%.2x/%.2x", \
		(gushort) ((guchar *) (COLOR_BUTTON(a)->color))[0], \
		(gushort) ((guchar *) (COLOR_BUTTON(a)->color))[1], \
		(gushort) ((guchar *) (COLOR_BUTTON(a)->color))[2]); \
		b = g_strdup(tmp); }

	GET_RGB_AS_STRING(displayer_clist_config_color_background_button, ccd->backgroundColor);
	GET_RGB_AS_STRING(displayer_clist_config_color_normal_text_button, ccd->normalTextColor);
	GET_RGB_AS_STRING(displayer_clist_config_color_normal_bar_button, ccd->normalBarColor);
	GET_RGB_AS_STRING(displayer_clist_config_color_progress_text_button, ccd->progressTextColor);
	GET_RGB_AS_STRING(displayer_clist_config_color_progress_bar_button, ccd->progressBarColor);

#undef GET_RGB_AS_STRING

	ccd->lyricFontName = gtk_editable_get_chars(GTK_EDITABLE(displayer_clist_config_font_entry), 0, -1);

#ifdef CODEDEBUG
	DEBUG(("Ok\n"));
#endif

	singit_config_gen_emit_update(STATUS->config);
	singit_config_gen_save(STATUS->config);
}

static void displayer_clist_config_ok_clicked(GtkButton *button, gpointer user_data)
{
	/* apply and save config */
	displayer_clist_config_apply_clicked(NULL, NULL);
	displayer_clist_config_cleanup();

	/* close and destroy window */
	gtk_widget_destroy(displayer_clist_config_win);
}

static void displayer_clist_config_cancel_clicked(GtkButton *button, gpointer user_data)
{
	displayer_clist_config_cleanup();

	/* close and destroy window */
	gtk_widget_destroy(displayer_clist_config_win);
}

static gint dlg_displayer_clist_config_delete_event( GtkWidget *widget, GdkEvent  *event, gpointer data )
{
	displayer_clist_config_cleanup();

	/* close and destroy window */
	gtk_widget_destroy(displayer_clist_config_win);

	return (FALSE);
}

static void add_color_button(gchar *trans_label, gchar *color_str, gint col_arr_offset,
	GtkWidget **col_hbox, GtkWidget **col_label, GtkWidget **col_button)
{
	GdkColor color;

	gdk_color_parse(color_str, &color);
	displayer_clist_config_status.color_array[col_arr_offset] = color.red;
	displayer_clist_config_status.color_array[col_arr_offset + 1] = color.green;
	displayer_clist_config_status.color_array[col_arr_offset + 2] = color.blue;

	*col_hbox = gtk_hbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(displayer_clist_config_color_vbox), *col_hbox);
	*col_label = gtk_label_new(trans_label);
	gtk_box_pack_start(GTK_BOX(*col_hbox), *col_label, TRUE, TRUE, 0);
	*col_button = color_button_new(trans_label, 60, 20,
		&displayer_clist_config_status.color_array[col_arr_offset], 3);
	gtk_box_pack_start(GTK_BOX(*col_hbox), *col_button, FALSE, TRUE, 0);
	gtk_widget_show(*col_hbox);
	gtk_widget_show(*col_label);
	gtk_widget_show(*col_button);
}

void displayer_clist_config_show(void)
{
	CListConfigData *ccd;

#ifdef CODEDEBUG
	DEBUG(("dlg_singit_config.c [displayer_clist_config_show]\n"));
#endif

	if (displayer_clist_config_win) {
		gdk_window_raise(displayer_clist_config_win->window);
		return;
	}

	g_return_if_fail(clist_status_ref() != NULL);

	ccd = GET_DCC;

	displayer_clist_config_status.color_array = g_malloc(sizeof(guchar) * 3 * 5);
	displayer_clist_config_status.updating_displayer_list = FALSE;

//	plugin_clist_tooltips = gtk_tooltips_new ();

	displayer_clist_config_win = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_signal_connect(GTK_OBJECT(displayer_clist_config_win), "delete_event",
		GTK_SIGNAL_FUNC(dlg_displayer_clist_config_delete_event), NULL);

	/* update displayer_clist_config_win when window is destroyed */
	gtk_signal_connect(GTK_OBJECT(displayer_clist_config_win), "destroy",
		       GTK_SIGNAL_FUNC(gtk_widget_destroyed), &displayer_clist_config_win);

	gtk_window_set_title(GTK_WINDOW(displayer_clist_config_win), _("Navigation displayer config"));
	gtk_window_set_policy(GTK_WINDOW(displayer_clist_config_win), FALSE, FALSE, FALSE);
	gtk_container_border_width(GTK_CONTAINER(displayer_clist_config_win), 5);
//	gtk_object_set_data (GTK_OBJECT(displayer_clist_config_win), "tooltips", plugin_clist_tooltips);

	displayer_clist_config_vbox = gtk_vbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(displayer_clist_config_win), displayer_clist_config_vbox);
	gtk_widget_show(displayer_clist_config_vbox);

	displayer_clist_config_force_globals_frame = gtk_frame_new("Force globals");
	gtk_box_pack_start(GTK_BOX(displayer_clist_config_vbox), displayer_clist_config_force_globals_frame, FALSE, FALSE, 0);
	gtk_widget_show(displayer_clist_config_force_globals_frame);

	displayer_clist_config_force_globals_check_button = gtk_check_button_new_with_label(_("Force global settings"));
	gtk_container_add(GTK_CONTAINER(displayer_clist_config_force_globals_frame), displayer_clist_config_force_globals_check_button);
//	gtk_widget_set_sensitive(displayer_clist_config_force_globals_check_button, FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(displayer_clist_config_force_globals_check_button),
		ccd->forceGlobals);
	gtk_signal_connect(GTK_OBJECT(displayer_clist_config_force_globals_check_button),
		"toggled", GTK_SIGNAL_FUNC(displayer_clist_config_force_globals_toggle_event), NULL);
	gtk_widget_show(displayer_clist_config_force_globals_check_button);


	displayer_clist_config_notebook = gtk_notebook_new();
	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(displayer_clist_config_notebook), GTK_POS_TOP);
	gtk_box_pack_start(GTK_BOX(displayer_clist_config_vbox), displayer_clist_config_notebook, FALSE, FALSE, 0);
	gtk_widget_show(displayer_clist_config_notebook);

	/* lyrics displayer config page */
	displayer_clist_config_displayer_vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(displayer_clist_config_displayer_vbox), 2);
	gtk_widget_show (displayer_clist_config_displayer_vbox);
	displayer_clist_config_displayer_label = gtk_label_new(_("Colors / Font"));
	gtk_widget_show(displayer_clist_config_displayer_label);
	gtk_notebook_append_page(GTK_NOTEBOOK(displayer_clist_config_notebook), displayer_clist_config_displayer_vbox, displayer_clist_config_displayer_label);

	/* font selection box (from XMMS) */
        displayer_clist_config_font_frame = gtk_frame_new(_("Lyrics font"));
        gtk_box_pack_start(GTK_BOX(displayer_clist_config_displayer_vbox), displayer_clist_config_font_frame, FALSE, FALSE, 2);
	gtk_widget_show(displayer_clist_config_font_frame);

        displayer_clist_config_font_hbox = gtk_hbox_new(FALSE, 5);
        gtk_container_border_width(GTK_CONTAINER(displayer_clist_config_font_hbox), 5);
        gtk_container_add(GTK_CONTAINER(displayer_clist_config_font_frame), displayer_clist_config_font_hbox);
	gtk_widget_show(displayer_clist_config_font_hbox);

        displayer_clist_config_font_entry = gtk_entry_new();
        gtk_box_pack_start(GTK_BOX(displayer_clist_config_font_hbox), displayer_clist_config_font_entry, TRUE, TRUE, 0);
	gtk_entry_set_text(GTK_ENTRY(displayer_clist_config_font_entry), ccd->lyricFontName);
	gtk_widget_show(displayer_clist_config_font_entry);

        displayer_clist_config_font_browse_button = gtk_button_new_with_label(_("Browse"));
        gtk_signal_connect(GTK_OBJECT(displayer_clist_config_font_browse_button), "clicked",
		GTK_SIGNAL_FUNC(displayer_clist_config_font_browse_cb), NULL);
        gtk_widget_set_usize(displayer_clist_config_font_browse_button, 85, 17);
        gtk_box_pack_start(GTK_BOX(displayer_clist_config_font_hbox),
		displayer_clist_config_font_browse_button, FALSE, TRUE, 0);
	gtk_widget_show(displayer_clist_config_font_browse_button);

	/* color selection frame */
	displayer_clist_config_color_frame = gtk_frame_new(_("Colors"));
	gtk_box_pack_start(GTK_BOX(displayer_clist_config_displayer_vbox), displayer_clist_config_color_frame, TRUE, TRUE, 0);
	gtk_widget_show(displayer_clist_config_color_frame);

	displayer_clist_config_color_vbox = gtk_vbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(displayer_clist_config_color_frame), displayer_clist_config_color_vbox);
	gtk_container_set_border_width(GTK_CONTAINER(displayer_clist_config_color_vbox), 5);
	gtk_widget_show(displayer_clist_config_color_vbox);

	add_color_button(_("Background Color"), ccd->backgroundColor, 0,
		&displayer_clist_config_color_background_hbox_widget,
		&displayer_clist_config_color_background_label,
		&displayer_clist_config_color_background_button);

	add_color_button(_("Normal Text Color"), ccd->normalTextColor, 3,
		&displayer_clist_config_color_normal_text_hbox_widget,
		&displayer_clist_config_color_normal_text_label,
		&displayer_clist_config_color_normal_text_button);

	add_color_button(_("Normal Bar Color"), ccd->normalBarColor, 6,
		&displayer_clist_config_color_normal_bar_hbox_widget,
		&displayer_clist_config_color_normal_bar_label,
		&displayer_clist_config_color_normal_bar_button);

	add_color_button(_("Progress Text Color"), ccd->progressTextColor, 9,
		&displayer_clist_config_color_progress_text_hbox_widget,
		&displayer_clist_config_color_progress_text_label,
		&displayer_clist_config_color_progress_text_button);

	add_color_button(_("Progress Bar Color"), ccd->progressBarColor, 12,
		&displayer_clist_config_color_progress_bar_hbox_widget,
		&displayer_clist_config_color_progress_bar_label,
		&displayer_clist_config_color_progress_bar_button);

/*
	lyrics displayer checkboxes config page
*/
	displayer_clist_config_displayer_toggle_vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(displayer_clist_config_displayer_toggle_vbox), 2);
	gtk_widget_show (displayer_clist_config_displayer_toggle_vbox);
	displayer_clist_config_displayer_toggle_label = gtk_label_new(_("Options"));
	gtk_widget_show(displayer_clist_config_displayer_toggle_label);
	gtk_notebook_append_page(GTK_NOTEBOOK(displayer_clist_config_notebook),
		displayer_clist_config_displayer_toggle_vbox, displayer_clist_config_displayer_toggle_label);

	displayer_clist_config_auto_resize_check_button = gtk_check_button_new_with_label(_("Automagically resize lyric displayer"));
	gtk_box_pack_start(GTK_BOX(displayer_clist_config_displayer_toggle_vbox), displayer_clist_config_auto_resize_check_button, FALSE, FALSE, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(displayer_clist_config_auto_resize_check_button),
		ccd->autoResize);
	gtk_widget_show(displayer_clist_config_auto_resize_check_button);

	displayer_clist_config_hide_if_not_found_check_button = gtk_check_button_new_with_label(_("Hide displayer if no lyrics were found"));
	gtk_box_pack_start(GTK_BOX(displayer_clist_config_displayer_toggle_vbox), displayer_clist_config_hide_if_not_found_check_button, FALSE, FALSE, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(displayer_clist_config_hide_if_not_found_check_button),
		ccd->hideIfNotFound);
	gtk_widget_show(displayer_clist_config_hide_if_not_found_check_button);

#ifdef CODEDEBUG
	displayer_clist_config_enable_debug_check_button = gtk_check_button_new_with_label(_("Enable console debug output"));
	gtk_box_pack_start(GTK_BOX(displayer_clist_config_displayer_toggle_vbox), displayer_clist_config_enable_debug_check_button, FALSE, FALSE, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(displayer_clist_config_enable_debug_check_button),
		ccd->debugEnable);
	gtk_widget_show(displayer_clist_config_enable_debug_check_button);
#endif

	displayer_clist_config_1_hsep = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(displayer_clist_config_displayer_toggle_vbox), displayer_clist_config_1_hsep, FALSE, FALSE, 3);
	gtk_widget_show(displayer_clist_config_1_hsep);

	displayer_clist_config_show_on_text_check_button = gtk_check_button_new_with_label(_("Show lyrics without tags"));
	gtk_box_pack_start(GTK_BOX(displayer_clist_config_displayer_toggle_vbox), displayer_clist_config_show_on_text_check_button, FALSE, FALSE, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(displayer_clist_config_show_on_text_check_button),
		ccd->showOnText);
	gtk_widget_show(displayer_clist_config_show_on_text_check_button);

/*
	Bottom button row ([Ok] [Cancel] [Apply])
*/
	bottom_button_hbox = gtk_hbutton_box_new();
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(bottom_button_hbox), 5);
	gtk_box_pack_start(GTK_BOX(displayer_clist_config_vbox), bottom_button_hbox, FALSE, FALSE, 0);
	gtk_widget_show(bottom_button_hbox);

	bottom_button_ok = gtk_button_new_with_label(_("Ok"));
	gtk_signal_connect_object(GTK_OBJECT(bottom_button_ok), "clicked", GTK_SIGNAL_FUNC(displayer_clist_config_ok_clicked), (GtkObject*) TRUE);
	GTK_WIDGET_SET_FLAGS(bottom_button_ok, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(bottom_button_hbox), bottom_button_ok, TRUE, TRUE, 0);
	gtk_widget_show(bottom_button_ok);

	bottom_button_cancel = gtk_button_new_with_label(_("Cancel"));
	gtk_signal_connect_object(GTK_OBJECT(bottom_button_cancel), "clicked", GTK_SIGNAL_FUNC(displayer_clist_config_cancel_clicked), NULL);
	GTK_WIDGET_SET_FLAGS(bottom_button_cancel, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(bottom_button_hbox), bottom_button_cancel, TRUE, TRUE, 0);
	gtk_widget_grab_default(bottom_button_cancel);
	gtk_widget_show(bottom_button_cancel);

	bottom_button_apply = gtk_button_new_with_label(_("Apply"));
	gtk_signal_connect_object(GTK_OBJECT(bottom_button_apply), "clicked", GTK_SIGNAL_FUNC(displayer_clist_config_apply_clicked), NULL);
	GTK_WIDGET_SET_FLAGS(bottom_button_apply, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(bottom_button_hbox), bottom_button_apply, TRUE, TRUE, 0);
	gtk_widget_show(bottom_button_apply);

	gtk_widget_show(displayer_clist_config_win);

/*
	We have to wait until every widget is created
	To set their state dependend on the globas toggle button
*/
	displayer_clist_config_force_globals_toggle_event
		(GTK_TOGGLE_BUTTON(displayer_clist_config_force_globals_check_button), NULL);

	if ((ccd->winPosX < 0) || (ccd->winPosY < 0)) {
		gtk_window_set_position(GTK_WINDOW(displayer_clist_config_win), GTK_WIN_POS_MOUSE);
	}
	else {
		gtk_widget_set_uposition(displayer_clist_config_win, ccd->winPosX, ccd->winPosY);
	}
}

void displayer_clist_config_hide(void)
{
#ifdef CODEDEBUG
	DEBUG(("dlg_singit_config.c [displayer_clist_config_hide]\n"));
#endif

	if (displayer_clist_config_win) {
		displayer_clist_config_cancel_clicked(NULL, NULL);
	}
}
