/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __CSCENE_H__
#define __CSCENE_H__

#include "ctexture.h"
#include "ccamera.h"
#include "clyrictextengine.h"

class CFrequencySphere {
private:
	void draw_pcm(void);

	void construct_ring(int elements, float ur, float dr, float h2, float *rgba_p);
	void build_world_rings(void);
	void draw_world_rings(bool animate);

	void draw_bg_mesh(void);
	void draw_xmms_logo(bool animate);

	void generate_pcm_texture();

protected:
	CTexture mesh_texture;
	CTexture logo_texture;
	CTexture pcm_texture;
	CTexture growbar_texture;
	CCamera camera;
	CLyricTextEngine lyric_text_engine;

	gint32 world_gl_list;

public:
	CFrequencySphere();
	virtual ~CFrequencySphere();

	void draw(guint time, bool animate);
	void set_song(LSong *song) { lyric_text_engine.set_song(song); }
};

#endif // __CSCENE_H__
