
#ifndef __WHITE_CAP_WORLD_H__
#define __WHITE_CAP_WORLD_H__

#if EG_MAC
#include <Quickdraw.h>
#endif

#include "Eg Common.h"
#include "XPtrList.h"
#include "WC_WaveShape.h"
#include "Camera.h"
#include "ExpressionDict.h"
#include "Sample.h"
#include "ArgList.h"
#include "CEgFileSpec.h"
#include "PixPort.h"

struct ScrnPt {
	long x, y;
	RGBColor color;
};

class WhiteCapWorld {

public:
	WhiteCapWorld( float* inTransition_I, Expression* inTransitionExpr );
	~WhiteCapWorld();

	void 			Init( const UtilStr* inConfig, float inT, long inNum_FFT_Bins, float inMorphDur );

	void			RecordSample( float inT, ExprUserFcn* inFFT, float inBass );

	void			Render( PixPort& inDest, Rect& outDirtyRect );

	void			SetPaneRect( const Rect& inRect );

	void			Refresh( Rect* inRect = NULL );

	const Rect*		PaneRect() const		{ return &mPaneRect; }

	void			ExpireSamples();

	void			CalcForeground( float inIntensity, RGBColor& outRGB );

	RGBColor*		GetForeColor()			{ return &mForeColorRGB; }

protected:
	WC_WaveShape		mWave1, mWave2;
	WC_WaveShape*		mNextWave, *mWave;

	float			mNextShapeChange;
	float			mTransitionEnd;
	float			mTransitionTime;

	float*			mTransition_I;
	Expression*		mTransitionExpr;

	Camera			mCamera;

	// The current colors
	RGBColor		mForeColorRGB;
	RGBColor		mBackColorRGB;
	long			mBackColor;

	Rect			mDirtyRect;		// The part in pane that's not background
	Rect			mPaneRect;

	ExprUserFcn*		mFFTPtr;
	float			mTransitionT;
	float			mDT, mST, mS, mBass, mPi;
	ExpressionDict		mDict;

	ScrnPt*			mPt;

	// Both of these hold copied values of the original so that a wave can access them via mDict
	float			mNum_S_Steps;
	float			mNum_FFT_Bins;

	// Stuff dealing with keeping track of the sample data
	float			mLastSampleTime;
	Sample*			mSamples;
	Sample*			mRecentSample;
	XPtrList		mFreeList;
	long			mMaxBinsRecorded;
	void			discardExpiredRows();

	// Scrap data for Render()
	static UtilStr			sPtBuf;
};

#endif // __WHITE_CAP_WORLD_H__
