#include "ImportedMovie.h"

#include "CEgFileSpec.h"
#include "EgOSUtils.h"


#ifdef WIN_QUICKTIME_PRESENT
#include <QTML.h>
#endif



ImportedMovie::ImportedMovie() {

	mMovie = NULL;
	mCurTimeIndex = -1;
	
}


ImportedMovie::~ImportedMovie() {

	#if EG_MAC || WIN_QUICKTIME_PRESENT
	if ( mMovie ) {
		::DisposeMovie( mMovie );
	}
	#endif
}



bool ImportedMovie::IsMovie( CEgFileSpec& inSpec ) {
	bool isMovie = false;
	
	#if EG_MAC || WIN_QUICKTIME_PRESENT
		OSErr			err;
		short			refNum = 0;

		if ( EgOSUtils::sQTAvailable ) {
						
			#if EG_MAC
			err = ::OpenMovieFile( (FSSpec*) inSpec.OSSpec(), &refNum, fsRdPerm ); 
			#elif EG_WIN
			FSSpec	mySpec;
			::NativePathNameToFSSpec( (char*) inSpec.OSSpec(), &mySpec, 0 );
			err = ::OpenMovieFile( &mySpec, &refNum, fsRdPerm ); 
			#endif
			
			if ( err == noErr ) {
				::CloseMovieFile( refNum );
				isMovie = true;
			}
		}
	#else
		#pragma unused( inSpec )
	#endif
	
	return isMovie;
}



bool ImportedMovie::OpenMovie( CEgFileSpec& inSpec, long inDepth ) {
	bool			ok = false;

	#if EG_MAC || WIN_QUICKTIME_PRESENT
	OSErr			err;
	short			refNum = 0;
	GDHandle		saveDev;
	GWorldPtr		savePort;
	PixPort 		tempPort;
	Rect			r;

	mMovie			= 0;
	
	if ( ! EgOSUtils::sQTAvailable )
		goto bail;

	::GetGWorld( &savePort, &saveDev );
		
	#if EG_MAC
	err = ::OpenMovieFile( (FSSpec*) inSpec.OSSpec(), &refNum, fsRdPerm ); 
	#elif EG_WIN
	FSSpec	mySpec;
	::NativePathNameToFSSpec( (char*) inSpec.OSSpec(), &mySpec, 0 );
	err = ::OpenMovieFile( &mySpec, &refNum, fsRdPerm ); 
	#endif
	
	if ( err == noErr ) {
		Boolean	wasChanged;
				
		// Init a dummy port w/ the same depth as our final desired depth
		tempPort.Init( 1, 1, inDepth );
		::SetGWorld( tempPort.GetGWorld(), NULL );
							
		err = ::NewMovieFromFile( &mMovie, refNum, 0, NULL, newMovieActive, &wasChanged );

		::CloseMovieFile( refNum );
	}
	
	if ( err == noErr ) {
		
		// Adjust the movie box values.
		::GetMovieBox( mMovie, &r ); 
		::OffsetRect( &r,  - r.left,  - r.top );
		::SetMovieBox( mMovie, &r ); 
		
		// Alloc and specify the Movie GWorld.
		mPort.Init( r.right, r.bottom, inDepth );
		::SetMovieGWorld( mMovie, mPort.GetGWorld(), NULL);
		err = GetMoviesError();
	}
	
	if ( err == noErr && mPort.GetX() > 1 && mPort.GetY() > 1 ) {
		
		// Change to millisecs
		::SetMovieTimeScale( mMovie, 1000 );

		::SetGWorld( mPort.GetGWorld(), NULL );
		PixPalEntry pal[ 256 ];
		for ( int i = 0; i < 256; i++ ) {
			#if EG_MAC
			long v = ( i ) << 8;
			pal[ i ].value = i;
			pal[ i ].rgb.red	= v;
			pal[ i ].rgb.green	= v;
			pal[ i ].rgb.blue	= v;
			#elif EG_WIN
			__SetRGBQUAD( &pal[ i ], i, i, i )
			#endif
		}
		mPort.SetPalette( pal ); 
		
		ok = true;
	}
	
	// Restore the graphics environment
	if ( savePort )
		::SetGWorld( savePort, saveDev );
	#else
	#pragma unused( inSpec, inDepth )
	#endif

bail:
	return ok;
}


	
const VFrameBuffer* ImportedMovie::GetFrame( long inT_MS ) {

	#if EG_MAC || WIN_QUICKTIME_PRESENT
	OSErr err = noErr;
	
	if ( inT_MS != mCurTimeIndex && mMovie ) {

		::SetMovieTimeValue( mMovie, inT_MS );
		err = ::GetMoviesError();
		
		if ( err == noErr ) {
			mCurTimeIndex = inT_MS;
			::UpdateMovie( mMovie );
			err = ::GetMoviesError();
		}
		
		if ( err == noErr ) {
			::MoviesTask( mMovie, 0 ); 
			err = ::GetMoviesError();
		}
	}
		
	if ( err == noErr )
		return &mPort;
	else 
		return NULL;
	#else
	
	
	#pragma unused( inT_MS )
	return NULL;
	
	#endif
}


long ImportedMovie::Duration() {
	long dur = 0;

	#if EG_MAC || WIN_QUICKTIME_PRESENT	
	if ( mMovie ) {
		dur = ::GetMovieDuration( mMovie );
	}
	#endif
	
	return dur;
}