
#ifndef __TEMP_MEM_H__
#define __TEMP_MEM_H__

#include "Eg Common.h"

#include "UtilStr.h"

/* This class allocs a chunk of the system/shared memory */

class TempMem {

public:
	TempMem();
	~TempMem();

	//	Returns a ptr a block inBytes big (from temporary memory)
	char*					Dim( long inBytes );

	long					size()					{ return mDimSize;		}

	void					Clear();

	char*					Assign( void* inPtr, long inBytes );

protected:
	long					mDimSize;
	char*					mPtr;

#if EG_WIN || EG_X
	UtilStr					mTemp;
#elif EG_MAC
	char**					mTempH;
#endif
};

#endif // __TEMP_MEM_H__
