
#ifndef __TOME_FILE_SYS_H__
#define __TOME_FILE_SYS_H__

#include "GeneralFileSys.h"

#include "CEgFileSpec.h"
#include "MemFileSys.h"
#include "TempMem.h"

class TomeFileCatEntry {

	public:
		long		mTomeAddr;
		long		mDataOffset;
		long		mResourceOffset;
		long		mTotalSize;
};


class TomeFileSys : public GeneralFileSys {

	public:
		TomeFileSys();
		~TomeFileSys();

		void						Init( long inTomeID );

		// See GeneralFileSys.h for the descriptions of all the fcns
		virtual FileResult			Catalog( FileObj inID, XLongList& outList )									{ return mCatalog.Catalog( inID, outList );					}
		virtual FileResult			GetItemID( FileObj inParentID, const UtilStr& inTitle, FileObj& outID )		{ return mCatalog.GetItemID( inParentID, inTitle, outID );	}
		virtual long				GetInfo( FileObj inID, long inParamID, FileResult* outRes = NULL )			{ return mCatalog.GetInfo( inID, inParamID, outRes );		}
		virtual FileResult			SetInfo( FileObj, long, long )												{ return ThrowUnimp();										}
		virtual FileResult			SetName( FileObj, const UtilStr& )											{ return ThrowUnimp();										}
		virtual const UtilStr*		GetName( FileObj inID )														{ return mCatalog.GetName( inID );							}
		virtual FileResult			WriteData( FileObj, void*, long )											{ return ThrowUnimp();										}
		virtual FileResult			Read( FileObj, UtilStr& )													{ return ThrowUnimp();										}
		virtual FileResult			Create( FileObj, const UtilStr&, FileObj&, long )							{ return ThrowUnimp();										}
		virtual FileResult			Delete( FileObj )															{ return ThrowUnimp();										}
		virtual FileResult			DeleteContents( FileObj )													{ return ThrowUnimp();										}
		virtual FileResult			GetParent( FileObj inID, FileObj& outParent )								{ return mCatalog.GetParent( inID, outParent );				}
		virtual FileResult			Move( FileObj, FileObj, bool )												{ return ThrowUnimp();										}

		// Creates/"reanimates" the archived file/folder as the destination spec
		FileResult					Inflate( FileObj inID, const CEgFileSpec& inDestFolder );
		FileResult					Inflate( FileObj inParentID, const UtilStr& inTitle, const CEgFileSpec& inDestFolder );

		FileResult					Archive( FileObj inParentID, CEgFileSpec& inSpec, FileObj& outID );


		// Call this when you're done with the tome (any changes will be flushed, etc)
		void						CloseTome();
		void						ClearTome();

	protected:

		MemFileSys					mCatalog;
		TempMem						mScrap;
		long						mTomeID;

		bool						mSaveNeeded;
		long						mTomeSize;

		FileResult					InflateFile( const CEgFileSpec& inDestSpec, FileObj inID );
		FileResult					InflateFolder( const CEgFileSpec& inDestSpec, FileObj inFolderID );

		FileResult					ArchiveFile( const CEgFileSpec& inSpec, FileObj inID );
		FileResult					ArchiveFolder( const CEgFileSpec& inSpec, FileObj inID );

		bool						LoadTomeBlock( long inOffset, char* inDest, long inBytes );
		char*						LoadTomeBlock( long inOffset, long inBytes );
		bool						WriteTomeBlock( long inOffset, char* inSrce, long inBytes );


};

#endif // __TOME_FILE_SYS_H__
