/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "singit_marshallers.h"

void gtk_marshal_POINTER__NONE(GtkObject* object,
	GtkSignalFunc func, gpointer func_data, GtkArg* args)
{
	GtkSignal_POINTER__NONE rfunc;
	gpointer *return_val;
	return_val = GTK_RETLOC_POINTER(args[0]);
	rfunc = (GtkSignal_POINTER__NONE) func;
	*return_val = (*rfunc)(object, func_data);
}

void gtk_marshal_INT__POINTER_POINTER(GtkObject* object,
	GtkSignalFunc func, gpointer func_data, GtkArg* args)
{
	GtkSignal_INT__POINTER_POINTER rfunc;
	gint *return_val;
	return_val = GTK_RETLOC_INT(args[2]);
	rfunc = (GtkSignal_INT__POINTER_POINTER) func;
	*return_val = (*rfunc)(object, GTK_VALUE_POINTER(args[0]),
		GTK_VALUE_POINTER(args[1]), func_data);
}

void gtk_marshal_BOOL__POINTER_INT_INT(GtkObject* object,
	GtkSignalFunc func, gpointer func_data, GtkArg* args)
{
	GtkSignal_BOOL__POINTER_INT_INT rfunc;
	gboolean *return_val;
	return_val = GTK_RETLOC_BOOL(args[3]);
	rfunc = (GtkSignal_BOOL__POINTER_INT_INT) func;
	*return_val = (*rfunc)(object, GTK_VALUE_POINTER(args[0]),
		GTK_VALUE_INT(args[1]), GTK_VALUE_INT(args[2]), func_data);
}

void gtk_marshal_NONE__POINTER_POINTER_INT(GtkObject* object,
	GtkSignalFunc func, gpointer func_data, GtkArg* args)
{
	GtkSignal_NONE__POINTER_POINTER_INT rfunc;
	rfunc = (GtkSignal_NONE__POINTER_POINTER_INT) func;
	(*rfunc)(object, GTK_VALUE_POINTER(args[0]),
		GTK_VALUE_POINTER(args[1]),
		GTK_VALUE_INT(args[2]), func_data);
}

void gtk_marshal_POINTER__POINTER(GtkObject* object,
	GtkSignalFunc func, gpointer func_data, GtkArg* args)
{
	GtkSignal_POINTER__POINTER rfunc;
	gpointer *return_val;
	return_val = GTK_RETLOC_POINTER(args[1]);
	rfunc = (GtkSignal_POINTER__POINTER) func;
	*return_val = (*rfunc)(object, GTK_VALUE_POINTER(args[0]), func_data);
}

void gtk_marshal_POINTER__INT_INT(GtkObject* object,
	GtkSignalFunc func, gpointer func_data, GtkArg* args)
{
	GtkSignal_POINTER__INT_INT rfunc;
	gpointer *return_val;
	return_val = GTK_RETLOC_POINTER(args[2]);
	rfunc = (GtkSignal_POINTER__INT_INT) func;
	*return_val = (*rfunc)(object, GTK_VALUE_INT(args[0]),
		GTK_VALUE_INT(args[1]), func_data);
}
