#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#ifdef USE_IMLIB
#include <gdk_imlib.h>
#else
#include <gdk-pixbuf/gdk-pixbuf.h>
#endif

#include "gtktopdata.h"
#include "gtksettings.h"

#include "settings.h"

//#include "callbacks.h"
//#include "interface.h"
#include "support.h"
#include "main.h"
#include "utils.h"



void
gtkmorph_settings_callback(GtkWidget* thismenu, gpointer userdata)
{
  int i,s;
/* if the meshes do not have the same sizes, something will crash */
  if (settings_get_value("mesh auto sync"))    
    promote_meshes();

  s=settings_get_value( "automatic mesh interpolation");
  i= MAX_WINS+1;
  if(sp->im_widget[i])
    {
      GtkWidget *m=
	gtk_widget_get_data_top(sp->im_widget[i],"button_interp_meshes");
      g_assert(m);
      if(s==0)
	gtk_widget_show(m);
      else
	gtk_widget_hide(m);
    }
}


gpointer *gtkmorph_settings=NULL,
  gtkmorph_template[] =
{ 
  //gtkmorph_settings_callback,

  /****** next*******/
  "no warnings", //name
  NULL,//integer value, stored in pointer
  NULL,//accels
  ("dont warn, just beep; warnings may be read with 'why the beep' in the 'help' menu"),
  NULL, //widget that is expressing this setting

  /****** next *****/
  "preserve aspect ratio", //name
  GUINT_TO_POINTER(1),//integer value, stored in pointer
  NULL,//accels NOW IGNORED
  "when loading an image, preserve aspect ratio", //tooltip (they are translated below)
  NULL, //widget that is expressing this setting

  /****** next *****/
  "mesh cant overlap", //name
  GUINT_TO_POINTER(1),//integer value, stored in pointer
  NULL,//accels NOW IGNORED
  "a mesh point cannot enter in a neighbouring cell", //tooltip (they are translated below)
  NULL, //widget that is expressing this setting

 /****** next *****/
  "mesh factors sum to 1", //name
  GUINT_TO_POINTER(1),//integer value, stored in pointer
  NULL,//accels NOW IGNORED
  ("the factors should sum to 1;\n\
if they dont, they are internally renormiized before using"), //tooltip 
  NULL, //widget that is expressing this setting

 /****** next *****/
  "image factors sum to 1", //name
  GUINT_TO_POINTER(1),//integer value, stored in pointer
  NULL,//accels NOW IGNORED
  ("the factors should sum to 1;\n\
if they dont, they are internally renormiized before using"), //tooltip 
  NULL, //widget that is expressing this setting

 /****** next *****/
  "automatic mesh interpolation", //name
  GUINT_TO_POINTER(1),//integer value, stored in pointer
  NULL,//accels NOW IGNORED
  ("automatically interpolates the resulting mesh when morphing\
(note that in this case you cant edit it)"), //tooltip 
  NULL, //widget that is expressing this setting

 /****** next *****/
  "mesh auto sync", //name
  GUINT_TO_POINTER(1),//integer value, stored in pointer
  NULL,//accels NOW IGNORED
  ("any change (add/del, label/unlabel) to a mesh is replicated"), //tooltip 
  NULL, //widget that is expressing this setting

  /****** next *****/
  "warped image in other win", //name
  GUINT_TO_POINTER(0),//integer value, stored in pointer
  NULL,//accels NOW IGNORED
  ("put warped images in another window"), //tooltip (they are translated below)
  NULL, //widget that is expressing this setting

  /****** next*******/
  /*      what is shown after a "warp" or "mix" or "morph"
     button is hit ?*/
  "show warp after warp",
  GUINT_TO_POINTER(EDITSHOW_SHOW),
  NULL,
  "switch the input window(s) to the warped image after a warp (overridden by the above)", //name
  NULL,

  /****** next*******/
  NULL};


GtkWidget*
create_gtkmorph_menuSettings ()
{

  g_assert(gtkmorph_settings==NULL);
  gtkmorph_settings=gtk_settings_alloc(gtkmorph_template);
  g_assert(gtkmorph_settings);
  return   gtk_settings_create(gtkmorph_template, gtkmorph_settings,
			       gtkmorph_settings_callback,NULL);
}



int
settings_get_value(char *name)
{
  return gtk_settings_get_value(name, gtkmorph_settings);
}






/***************************** image pane settings ******************/



void
gtkmorph_image_settings_callback(GtkWidget* thismenu, gpointer userdata)
{
  int i=
    GPOINTER_TO_UINT(userdata);
  //userdata==gtk_widget_get_data_top(thismenu,"userdata"));
  g_assert(i>0);
  gtk_widget_draw (sp->im_widget[i] , NULL);
}


gpointer image_settings_template[] =
{ 
  //gtkmorph_image_settings_callback,

  /****** next*******/
  "view original mesh", //name
  GUINT_TO_POINTER(1),//integer value, stored in pointer
  NULL,//accels
  "",
  NULL, //widget that is expressing this setting

  /****** next *****/
  "view original points", //name
  GUINT_TO_POINTER(1),//integer value, stored in pointer
  NULL,//accels NOW IGNORED
  "",
  NULL, //widget that is expressing this setting

  /****** next*******/
  "view warped mesh", //name
  GUINT_TO_POINTER(1),//integer value, stored in pointer
  NULL,//accels
  "",
  NULL, //widget that is expressing this setting

  /****** next *****/
  "view warped points", //name
  GUINT_TO_POINTER(1),//integer value, stored in pointer
  NULL,//accels NOW IGNORED
  "",
  NULL, //widget that is expressing this setting

  /****** next *****/ /* HACK FIXME : NOW IGNORED */
  "view .../loaded image/subimage/warped image/", //name
  GUINT_TO_POINTER(1),//integer value, stored in pointer
  NULL,//accels NOW IGNORED
  "view warped image instead of original image",
  NULL, //widget that is expressing this setting

  /****** next *****/
  "mesh is readonly", //name
  GUINT_TO_POINTER(1),//integer value, stored in pointer
  NULL,//accels NOW IGNORED
  "",
  NULL, //widget that is expressing this setting

  /****** next*******/
  NULL};


GtkWidget*
create_image_menu_settings (int i)
{

  sp->im_settings[i] = gtk_settings_alloc(image_settings_template);

  g_assert(sp->im_settings[i]);
  sp->im_menu_settings[i]=
    gtk_settings_create(image_settings_template,
			sp->im_settings[i],
			gtkmorph_image_settings_callback,GINT_TO_POINTER(i));
  g_assert(sp->im_menu_settings[i]); 
  return sp->im_menu_settings[i];
}



int
image_settings_get_value(char *name, int i)
{
  return gtk_settings_get_value(name, sp->im_settings[i]);
}

int
image_settings_set_value(char *name, int i, int value)
{
  return gtk_settings_set_value(name,sp->im_settings[i],value);
}
